<?php

	namespace App\Libraries;

	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\{ DB, Session, Cache, Validator, Auth };
	use App\Models\{ User_Prepaid_Credit, Affiliate_Earning, Transaction };

	class Credits
	{
		public $name = "credits";
		public $return_url;
		public $cancel_url;
		public $supported_currencies = [];
		public $currency_code;
		public $exchange_rate = 1;
		public $decimals;
		public $details = [];
		public $error_msg;
		public static $response = "json";


		public function __construct()
		{
				$this->return_url = route("home.checkout.order_completed");
				$this->cancel_url = config("checkout_cancel_url");

				exists_or_abort(config("payments_gateways.{$this->name}"), __(":payment_proc is not enabled", ["payment_proc" =>  mb_ucfirst($this->name)]));

				$this->currency_code = config("payments.currency_code");
				$this->decimals = config("payments.currencies.{$this->currency_code}.decimals");

				prepare_currency($this);

	      $this->details = [
		      	"items" => [],
			      "total_amount" => 0,
			      "currency" => $this->currency_code,
			      "exchange_rate" => $this->exchange_rate,
			      "custom_amount" => null,
			      "reference" => generate_transaction_ref(),
			      "transaction_id" => null,
						"order_id" => null,
						"available_credits" => user_credits(true)
		    ];
		}


		public function create_order(float $amount)
		{
				$amount = format_amount($amount * $this->exchange_rate, false, $this->decimals);

				$this->details['total_amount'] 	 = $amount;
	      $this->details['transaction_id'] = generate_transaction_ref();
	      $this->details['order_id'] 			 = generate_transaction_ref();

	      $total_available_credits = $this->details['available_credits']['total_available_credits'] ?? 0;

	      if($total_available_credits < $amount)
	      {
	      		$this->error_msg = ['user_message' => __('Your credits balance is not enough to complete this purchase.')];
	      }

	      return $this;
		}



		public function init_payment(float $amount)
		{
	      $this->create_order($amount);

	      return route('home.checkout.order_completed', ['processor' => $this->name, 'ref' => $this->details['reference']]);
		}



		public function complete_payment(Request $request)
		{
			if(stripos($request->processor, $this->name) !== false && $request->ref !== null)
      {
	      	$transaction_id = $request->ref;

	      	$transaction = 	Transaction::where(['processor' => $this->name])
									      	->where(function($builder) use($transaction_id)
									    		{
										    			$builder->where(['transaction_id' => $transaction_id])
										    							->orWhere(['order_id' 		=> $transaction_id])
										    							->orWhere(['reference_id' => $transaction_id]);
									    		})
									    		->first();

	      	if(!$transaction)
	      	{
		      		return [
			      			'status' => false, 
			      			'user_message' => __('Missing transaction database record [:transaction_id].', ['transaction_id' => $transaction_id])
		      		];
	      	}

	        $transaction->status = 'paid';
	        $transaction->confirmed = 1;

	        $transaction->save();

	        extract($this->details['available_credits']);

	        $user_credits_sources = explode(',', ($request->user()->credits_sources));
	        $user_credits_sources = array_combine(array_values($user_credits_sources), array_fill(0, count($user_credits_sources), 0));

	        $user_credits_sources = array_filter($user_credits_sources);

	        $credits_sources = [];

	        $user_credits_sources['prepaid_credits'] 	 = $this->details['available_credits']['prepaid_credits'] ?? [];
	        $user_credits_sources['affiliate_credits'] = $this->details['available_credits']['affiliate_credits'] ?? [];
					
	        if(!config('app.prepaid_credits.enabled'))
	        {
	        		unset($user_credits_sources['prepaid_credits']);	
	        }

	        if(!config('affiliate.enabled'))
	        {
	        		unset($user_credits_sources['affiliate_credits']);	
	        }

	        $transaction_amount = $transaction->amount;

					foreach($user_credits_sources as $credits_sources)
					{
							foreach($credits_sources as $src)
							{
									if(($src->credits - $transaction_amount) >= 0)
									{
											$src->credits -= $transaction_amount; 
											$transaction_amount = 0;
									}
									else
									{
											$transaction_amount -= $src->credits;
											$src->credits = 0;
									}

									if($src->type === 'affiliate')
									{
											$model = Affiliate_Earning::find($src->id);

											$model->commission_value = $src->credits;

											$model->save();
									}
									else
									{
											$model = User_Prepaid_Credit::find($src->id);

											$model->credits = $src->credits;

											$model->save();
									}

									if($transaction_amount == 0)
									{
											break 2;
									}
							}
					}
					      
	        return ['status' => true, 'user_message' => null, 'transaction' => $transaction];
      }
		}

	}