<?php

	namespace App\Libraries;

  use Illuminate\Support\Facades\{ DB, Session, Cache, Validator, Auth };
  use App\Models\Transaction;
  use Illuminate\Http\Request;

	class Offlinepayment 
	{
    public $name = "offlinepayment";
    public $return_url;
    public $cancel_url;
		public $currency_code;
		public $exchange_rate = 1;
		public $decimals;
		public $details = [];
    public $error_msg;
    public static $response = "default";


		public function create_payment(float $amount)
		{
  			exists_or_abort(config("payments_gateways.{$this->name}"), __("Offline payment is not enabled"));

  			$this->currency_code = config("payments.currency_code");
  			$this->decimals      = config("payments.currencies.{$this->currency_code}.decimals");

  			prepare_currency($this);

        $this->details = [
          	"items" => [], 
    	      "total_amount" => 0,
    	      "discount" => 0,
    	      "currency" => $this->currency_code, 
    	      "exchange_rate" => $this->exchange_rate,
    	      "reference_id" => uuid6(),
    	      "custom_amount" => null,
            "reference" => generate_transaction_ref()
  	    ];

        $this->details["total_amount"] = $amount;

        return $this;
		}


    public function init_payment(float $amount)
    {
        $this->create_payment($amount);

        return route('home.checkout.order_completed', ['processor' => $this->name, 'ref' => $this->details['reference']]);
    }


    public function complete_payment(Request $request)
    {
        if(stripos($request->processor, $this->name) !== false && $request->ref !== null)
        {
            $transaction_id = $request->ref;

            $transaction =  Transaction::where(['processor' => $this->name])
                            ->where(function($builder) use($transaction_id)
                            {
                                $builder->where(['transaction_id' => $transaction_id])
                                        ->orWhere(['order_id' => $transaction_id])
                                        ->orWhere(['reference_id' => $transaction_id]);
                            })
                            ->first();

            if(!$transaction)
            {
              return [
                  'status' => false, 
                  'user_message' => __('Missing transaction database record [:transaction_id].', ['transaction_id' => $transaction_id])
              ];
            }

            $transaction->status = 'pending';
            $transaction->confirmed = 1;

            $transaction->save();
          
            return ['status' => true, 'user_message' => null, 'transaction' => $transaction];
        }

        return ['status' => false, 'user_message' => __('Something wrong happened.')];
    }
	}