<?php

namespace App\Libraries;

use Illuminate\Support\Facades\{ DB, Session, Cache, Validator, Auth };
use Illuminate\Http\Request;
use App\Models\{ Transaction };
use GuzzleHttp\{ Client };

class Payhere 
{
    public $name = "payhere";
    public $return_url;
    public $cancel_url;
    public $notify_url;
    public $supported_currencies = ["LKR", "USD", "GBP", "EUR", "AUD"];
    public $currency_code;
    public $exchange_rate = 1;
    public $decimals;
    public $default_currency;
    public $details  = [];
    public $error_msg;
    public static $response = "default";


		public function __construct()
		{
  			if(!config("payments_gateways.{$this->name}"))
  			{
  				  return response()->json(["user_message" => __(":payment_proc is not enabled", ["payment_proc" =>  ucfirst($this->name)])]);
  			}
              
  			$this->currency_code = config("payments.currency_code");
  			$this->decimals = config("payments.currencies.{$this->currency_code}.decimals");

  			prepare_currency($this);

        $this->details = [
          	"items" => [],
    	      "total_amount" => 0,
    	      "currency" => $this->currency_code,
    	      "exchange_rate" => $this->exchange_rate,
    	      "custom_amount" => null,
    	      "reference" => generate_transaction_ref()
  	    ];

  	    $this->return_url = route('home.checkout.order_completed', ['processor' => $this->name, 'ref' => $this->details['reference']]);
  			$this->notify_url = route('home.checkout.webhook', ['processor' => $this->name, 'ref' => $this->details['reference']]);
        $this->cancel_url = route('home');
		}



		public function create_order(float $amount, array $buyerInf)
		{			
        $amount = format_amount($amount * $this->exchange_rate, false, $this->decimals);

        $this->details['total_amount'] = $amount;

        $payload = [
            "sandbox"     => config("payments_gateways.{$this->name}.mode") === "sandbox",
          	"merchant_id" => config("payments_gateways.{$this->name}.merchant_id"),
          	"return_url"  => $this->return_url,
          	"cancel_url"  => $this->cancel_url,
          	"notify_url"  => $this->notify_url,
          	"first_name"  => $buyerInf['firstname'],
          	"last_name"   => $buyerInf['lastname'],
          	"email"       => $buyerInf['email'],
    				"address"     => $buyerInf['address'],
            "phone"       => $buyerInf['phone'],
    				"city"        => $buyerInf['city'],
    				"country"     => $buyerInf['country'],
    				"order_id"    => $this->details['reference'],
    				"items"       => __("Purchase from :app_name", ["app_name" => mb_ucfirst(config("app.name"))]),
    				"currency"    => $this->currency_code,
    				"amount"      => $amount,
            //"iframe"      => true
        ];

        $hash = strtoupper(md5(config("payments_gateways.{$this->name}.merchant_id") . $payload['order_id'] . $amount . $this->currency_code . strtoupper(md5(config("payments_gateways.{$this->name}.merchant_secret")))));

        $payload['hash'] = $hash;

        $endpoint = "https://sandbox.payhere.lk/pay/checkoutJ";

        if(config("payments_gateways.{$this->name}.mode") === 'live')
        {
            $endpoint = "https://www.payhere.lk/pay/checkoutJ";
        }
        
        $client = new Client([
            'verify' => false,
            'http_errors' => false,
            'headers' => [
                'Content-Length' => strlen(http_build_query($payload)),
            ]
        ]);

        $response = $client->request("POST", $endpoint, ['form_params' => $payload]);

        $response = json_decode((string)$response->getBody(), true);

        $status = $response['status'] ?? null;

        if(!$status)
        {
            $this->error_msg = ['user_message' => $response['message']];

            return;
        }

        return $response;
		}



		public function init_payment(float $amount)
		{
        $request = request();

        $request->validate([
            'buyer.firstname' => 'string|required',
            'buyer.lastname'  => 'string|required',
            'buyer.city'      => 'string|required',
            'buyer.country'   => 'string|required',
            'buyer.address'   => 'string|required',
            'buyer.email'     => 'email|required'
        ]);

        $buyer = $request->input('buyer');

        $buyer['ip_address'] = $request->ip();

        $response = $this->create_order($amount, $buyer);

        if($this->error_msg)
        {
            return $this->error_msg;
        }

        $parsed_url = parse_url($response['url']);
        
        parse_str($parsed_url['query'], $query_params);

        $this->details['transaction_id'] = $query_params['rid'];
        $this->details['order_id']       = $query_params['rid'];

        return $response['url'];
		}



		public function complete_payment(Request $request)
    {
        if(stripos($request->processor, $this->name) !== false && $request->ref !== null)
        {
            $transaction_id = $request->ref;

            $transaction =  Transaction::where(['processor' => $this->name])
                            ->where(function($builder) use($transaction_id)
                            {
                                $builder->where(['transaction_id' => $transaction_id])
                                        ->orWhere(['order_id' => $transaction_id])
                                        ->orWhere(['reference_id' => $transaction_id]);
                            })
                            ->first();

            if(!$transaction)
            {
                return [
                    'status' => false, 
                    'user_message' => __('Missing transaction database record [:transaction_id].', ['transaction_id' => $transaction_id])
                ];
            }

            if($transaction->status !== 'paid')
            {
                $transaction->status = 'pending';
                $transaction->save();
            }

            return ['status' => true, 'user_message' => null, 'transaction' => $transaction];
        }

        return ['status' => false, 'user_message' => __('Something wrong happened.')];
    }



    public function handle_webhook_notif(Request $request)
    {
        $response = ['status' => 0, 'transaction' => null, 'valid' => 0];

        if(stripos($request->processor, $this->name) !== false && $request->input('data.id') !== null)
        {        
            $status['valid'] = 1;

            $paid				= $request->input('data.paid') === true;
            $authorized	= $request->input('data.authorized') === true;
            $capture		= $request->input('data.capture') === true;

            if($paid && $authorized && $capture)
            {
                $order_id = $request->input('data.id');

                $transaction =  Transaction::where(function($query) use($order_id)
                                {
                                    $query->where('order_id', $order_id)
                                          ->orWhere('transaction_id', $order_id)
                                          ->orWhere('reference_id', $order_id);
                                })
                                ->where(['processor' => $this->name, 'status' => 'pending'])
                                ->first();

                if($transaction)
                {
                    $transaction->status = 'paid';
                    $transaction->confirmed = 1;

                    $transaction->save();

                    $response['status'] = 1;
                    $response['transaction'] = $transaction;
                }
            }
        }

        return $response;
    }



    public function access_token()
    { 
        if(!$access_token = cache('payhere_access_token'))
        {
            $endpoint = "https://sandbox.payhere.lk/merchant/v1/oauth/token";

            if(config("payments_gateways.{$this->name}.mode") === 'live')
            {
                $endpoint = "https://www.payhere.lk/merchant/v1/oauth/token";
            }
              
            $payload = [
              'grant_type' => 'client_credentials'
            ];

            $client = new Client([
                'verify' => false,
                'http_errors' => false,
                'headers' => [
                    'Authorization' => 'Basic NE9WeGc0U0Y1dDI0SkVWaDI3ZmZsMjNMRzo0cDhLYVFJM3lwVzhoaGdMNW9xZUlPNHFCcGJXRktHRzg0a3FtUndGRkVUaw==',
                    'Content-Length' => strlen(http_build_query($payload)),
                ]
            ]);

            $response = $client->request('POST', $endpoint, ['form_params' => $payload]);

            $response = json_decode((string)$response->getBody(), true);

            if(isset($response['access_token']))
            {
                Cache::put('payhere_access_token', $response['access_token'], now()->addSeconds($response['expires_in']));
            }
        }

        return cache('payhere_access_token');

    }


}