<?php

	namespace App\Libraries;

	use Illuminate\Support\Facades\{ DB, Session, Cache, Validator, Auth };
	use Paymentwall_Config;
	use Paymentwall_Product;
	use Paymentwall_Widget;
	use Paymentwall_Base;
	use Paymentwall_Pingback;
	use Illuminate\Http\Request;
	use App\Models\{ Transaction };

	class Paymentwall 
	{
		public $name = "paymentwall";
		public static $static_name = "paymentwall";
		public $pingback_url;
		public $return_url;
		public $cancel_url;
		public $currency_code;
		public $exchange_rate = 1;
		public $default_currency;
		public $decimals;
		public $details  = [];
		public $error_msg;
		public static $response = "default";


		public function __construct()
		{
	      exists_or_abort(config("payments_gateways.{$this->name}.enabled"), __(":payment_proc is not enabled", ["payment_proc" =>  ucfirst($this->name)]));

	      $this->currency_code = config("payments.currency_code");
	      $this->decimals = config("payments.currencies.{$this->currency_code}.decimals");

	      prepare_currency($this);

	      $this->details = [
		        "items" => [],
		        "total_amount" => 0,
		        "currency" => $this->currency_code,
		        "exchange_rate" => $this->exchange_rate,
		        "custom_amount" => null,
		        "reference" => generate_transaction_ref(),
		        "transaction_id" => null,
		        "order_id" => null,
	      ];

	      $this->return_url 	= route('home.checkout.order_completed', ['processor' => $this->name, 'ref' => $this->details['reference']]);
				$this->pingback_url	= route('home.checkout.webhook', ['processor' => $this->name, 'ref' => $this->details['reference']]);
				$this->cancel_url 	= route('home');
		}



		public function create_order(float $amount)
		{
				$amount = format_amount($amount * $this->exchange_rate, false, $this->decimals);

				$this->details['total_amount'] = $amount;

	      Paymentwall_Config::getInstance()->set([
					  "api_type" 		=> Paymentwall_Config::API_GOODS,
					  "public_key"  => config("payments_gateways.{$this->name}.project_key"),
					  "private_key" => config("payments_gateways.{$this->name}.secret_key")
				]);

	      $user_id = Auth::check() ? Auth::id() : uuid6();

	      $extra_params = [
		      	"order_id"  		=> $this->details['reference'],
		      	"success_url" 	=> $this->return_url,
		      	"pingback_url"	=> $this->pingback_url,
		      	"failed_url" 		=> $this->cancel_url,
		      	"evaluation" 		=> config("payments_gateways.{$this->name}.mode") === "live" ? "0" : "1"
	      ];

	      $product      = [        
						new Paymentwall_Product(
								__("Purchase from :app_name", ["app_name" => mb_ucfirst(config("app.name"))]),
								$amount,
								$this->currency_code,
								__("Order :num", ["num" => generate_transaction_ref()]),
								Paymentwall_Product::TYPE_FIXED
						)
			  ];

				$widget = new Paymentwall_Widget($user_id, "pw", $product, $extra_params);

				return $widget->getUrl();
		}



		public function validate_webhook($request)
		{
				$expected_sig = $request->get('sig');

				$params = $_GET;

				unset($params['sig']);

				ksort($params);

				$base_hash = "";

				foreach($params as $k => $v)
				{
				  $base_hash .= "{$k}={$v}";
				}

				$base_hash .= config("payments_gateways.{$this->name}.secret_key");

				$calculated_sig  = md5($base_hash);

				if(hash_equals($expected_sig, $calculated_sig))
				{
						return $request->get('type') === "0";
				}

				return false;
		}



		public function init_payment(float $mount)
		{
	      $payment_url = $this->create_order($mount);

	      if($this->error_msg)
	      {
	        	return $this->error_msg;
	      }

	      $order_id = get_url_param($payment_url, 'order_id');
	     
	      $this->details['transaction_id'] = $order_id;

	      return $payment_url;
		}



		public function complete_payment(Request $request)
    {
	      if(stripos($request->processor, $this->name) !== false && $request->ref !== null)
	      {
		        $transaction_id = $request->ref;

		        $transaction =  Transaction::where(['processor' => $this->name])
		                        ->where(function($builder) use($transaction_id)
		                        {
			                          $builder->where(['transaction_id' => $transaction_id])
			                                  ->orWhere(['order_id' => $transaction_id])
			                                  ->orWhere(['reference_id' => $transaction_id]);
		                        })
		                        ->first();

		        if(!$transaction)
		        {
			          return [
				            'status' => false, 
				            'user_message' => __('Missing transaction database record [:transaction_id].', ['transaction_id' => $transaction_id])
			          ];
		        }

		        if($transaction->status !== 'paid')
		        {
			          $transaction->status = 'pending';
			          $transaction->save();
		        }

		        return ['status' => true, 'user_message' => null, 'transaction' => $transaction];
	      }

	      return ['status' => false, 'user_message' => __('Something wrong happened.')];
    }




    public function handle_webhook_notif(Request $request)
    {
      $response = ['status' => 0, 'transaction' => null, 'valid' => 0];

      if(stripos($request->processor, $this->name) !== false)
      { 
	        $status['valid'] = 1;

	        if($this->validate_webhook($request))
	        {
		          $order_id = $request->get('order_id');

		          $transaction =  Transaction::where(function($query) use($order_id)
		                          {
		                            $query->where('order_id', $order_id)
		                                  ->orWhere('transaction_id', $order_id)
		                                  ->orWhere('reference_id', $order_id);
		                          })
		                          ->where(['processor' => $this->name, 'status' => 'pending'])
		                          ->first();

		          if($transaction)
		          {
			          	$transaction->transaction_id = $request->get('ref');
			            $transaction->status = 'paid';
			            $transaction->confirmed = 1;

			            $transaction->save();

			            $response['status'] = 1;
			            $response['transaction'] = $transaction;
		          }
	        }
      }

      return $response;
    }
	}