<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Category extends Model
{
    protected $guarded = [];

    public static function parents(mixed $columns = '*')
    {
        $columns =  is_null($columns) 
                    ? "categories.id, categories.`name`, categories.slug, categories.parent, categories.`range`, categories.icon, categories.featured, IFNULL(categories.icon, 'default.webp') as icon" 
                    : $columns;

        return DB::select("SELECT {$columns} FROM categories WHERE parent IS NULL AND `for` = 1 ORDER BY `range` DESC");
    }


    public static function children(mixed $columns = '*')
    {
        $columns =  is_null($columns) 
                    ? "categories.id, categories.`name`, categories.slug, categories.parent, categories.`range`, categories.icon, categories.featured, IFNULL(categories.icon, 'default.webp') as icon" 
                    : $columns;

        return DB::select("SELECT {$columns} FROM categories WHERE parent IS NOT NULL AND `for` = 1 ORDER BY `range` DESC");
    }


    public static function posts(mixed $columns = '*')
    {
        $columns =  is_null($columns) 
                    ? "categories.id, categories.`name`, categories.slug, categories.parent, categories.`range`, categories.icon, categories.featured, IFNULL(categories.icon, 'default.webp') as icon" 
                    : $columns;

        $categories = DB::select("SELECT {$columns} FROM categories WHERE parent IS NULL AND `for` = 0 ORDER BY `range` DESC");

        return array_combine(array_column($categories, 'id'), $categories);
    }


    // Products categories
    public static function products()
    {
      $category_children = $category_parents = [];

      if($_category_parents = Self::parents(null))
      {        
        $category_parents_ids = array_column($_category_parents, 'id');

        $category_parents     = array_combine($category_parents_ids, array_values($_category_parents));

        if($_category_children = Self::children(null))
        {
          foreach($_category_children as $_category_child)
          {
            foreach($category_parents as $id => $category_parent)
            {
              if($id == $_category_child->parent)
              {
                $category_children[$id][] = $_category_child;
              }
            }
          }
        }
      }
      
      return compact('category_children', 'category_parents');
    }



    public static function popular(int $limit = 5)
    {
      return Self::useIndex('primary')
                  ->selectRaw('categories.name, categories.slug, categories.id')
                  ->where(['categories.parent' => null])
                  ->orderBy('views', 'desc')
                  ->limit($limit)
                  ->get();
    }
}
