<?php

return [
	"name" => "Omise",
	"url" => "https://omise.com/",
	"class" => "Omise",
	"slug" => "omise",
	"fields" => [
		"enabled" => [
			"type" => "toggler", 
			"validation" => "nullable|in:on", 
			"value" => ""
		],
		"icon" => [
      "type" => "hidden", 
      "validation" => "nullable|string", 
      "value" => "/assets/images/payment/omise_icon.png",
    ],
    "description" => [
			"type" => "hidden", 
			"validation" => "nullable|string", 
			"value" => "Credit/Debit card, Installment payments, Internet Banking, PromptPay, TrueMoney Wallet, Rabbit Line Pay, PayNow, OCBC Pay Anyone, Alipay, WeChat Pay, Bill payment, Pay-easy, FPX",
		],
		"order" => [
			"type" => "hidden", 
			"validation" => "nullable|numeric", 
			"value" => null,
		],
		"mode" => [
			"type" => "dropdown", 
			"validation" => "nullable|string|in:live,sandbox|required_with:gateways.omise.enabled", 
			"value" => "sandbox", 
			"multiple" => 0,
			"options" => ["sandbox" => "Sandbox", "live" => "Live"]
		],
		"public_key" => [
			"type" => "string", 
			"validation" => "nullable|string|max:255|required_with:gateways.omise.enabled", 
			"value" => null
		],
		"secret_key" => [
			"type" => "string", 
			"validation" => "nullable|string|max:255|required_with:gateways.omise.enabled", 
			"value" => null
		],
		"fee" => [
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"minimum" => [  // The minimum amount to pay to "Pay what you want"
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"auto_exchange_to" => [ // Auto-exchange Currency to This currency when using multiple currencies
			"type" => "string", 
			"validation" => "nullable|string|max:3", 
			"value" => null
		]
	],
	"form" => [
    "inputs" => [
      "omiseToken" => ["type" => "hidden", "label" => null, "value" => "", "class" => "hidden", "replace" => []],
      "omiseSource" => ["type" => "hidden", "label" => null, "value" => "", "class" => "hidden", "replace" => []],
    ],
    "note" => [],
    "checkout_buttons" => [
    	[
        "html" => '<button type="button" class="hidden" id="omiseCheckoutBtn">Checkout</button>',
        'id' => 'omiseCheckoutBtn',
      ]
    ]
  ],
	"methods_icons" => [
		"kbank.png" => "Kasikorn Bank",
		"ktc_card.jpg" => "Krungthai Card",
		"krungsri_first_choice.png" => "krungsri first choice",
		"scb.png" => "Siam Commercial Bank",
	],
	"assets" => [
		["type" => "js", "defer" => 0, "src" => "https://cdn.omise.co/omise.js"],
		["type" => "js_init", "defer" => 0, "code" => "window.omisePublicKey = '[PUBLIC_KEY]';", "replace" => [
				["src" => "config", "search" => "[PUBLIC_KEY]", "value" => "payments_gateways.omise.public_key"],
			]
		],
		["type" => "js_init", "defer" => 0, "code" => <<<SCRIPT
				$(() => 
				{
						OmiseCard.configure({
					    	publicKey: window.omisePublicKey
					  });
				})

			  $(document).on('click', '#omiseCheckoutBtn', function()
			  {	
					  let checkoutForm = document.querySelector('#checkout-form');

						let payload = queryString.parse($('#checkout-form').serialize());
						
						payload.prepare = true;

						$.post(window.props.routes.payment, payload, null, 'json')
						.done(data =>
						{	
								console.log(data)

								if(data.hasOwnProperty('user_message'))
								{
										console.log(data)

										return;
								}
								
								if(data.status)
								{	
										OmiseCard.open({
							      amount: data.amount,
							      currency: data.currency,
							      defaultPaymentMethod: "credit_card",
							      onCreateTokenSuccess: (nonce) => 
							      {
							          if(nonce.startsWith("tokn_")) 
							          {
							              checkoutForm.omiseToken.value = nonce;
							          }
							          else
							          {
							              checkoutForm.omiseSource.value = nonce;
							          }
							        	
							        	$(this).removeClass('has-checkout-button');

							        	checkoutForm.submit();
							      },
							      onFormClosed: () => 
							      {
							      		$(this).addClass('has-checkout-button');

										    console.log('Omise form closed')
									  }
						    });
								}	
						})
				})

		SCRIPT]
	],
	"guest_checkout" => 1,
	"async" => 1,
	"supports_recurrent" => 0,
	"webhook_responses" => ["success" => "200 OK", "failed" => "404 Not Found"],
	"payment_link" => 0,
];