window.canShare = () =>
{
	  try 
	  {
	    	return navigator.canShare();
	  }
	  catch(e)
	  {
	    	return false;
	  }
}

window.sleep = (ms) => 
{
    return new Promise(resolve => setTimeout(resolve, ms));
}


Number.prototype.formatSeconds = function()
{
	  let date = new Date(1970,0,1);
	      date.setSeconds(this);
	  
	  return date.toTimeString().replace(/.*(\d{2}:\d{2}:\d{2}).*/, "$1");
}


String.prototype.shorten = function(limit = 100)
{
  	return this.length > limit ? (this.slice(0, limit)+'...') : this;
}

function rating(rating)
{
	  let x = [];

	  for(let i = 0; i < Math.floor(rating); $i++)
	  {
	      x.push('star-full.png');
	  }

	  if(Math.floor(rating / 1) * 1)
	  {
	      x.push('star-half.png');
	  }

	  if(Math.floor(rating) < 5)
	  {
	      for($i=0; $i<5-Math.ceil(rating); $i++)
	      {
	          x.push('star-empty.png');
	      }
	  }

	  return x;
}


let app = Vue.createApp({
		data() {
				return {
						cartItems: {},
						cartUuid: '',
						cartReady: false,
						appName: props.appName || '',
						route: '',
						transactionMsg: props.transactionMsg || '',
						product: props.product || {},
						products: props.products || {},
						licenseId: props.licenseId || null,
						favorites: {},
						userCollectionIsReady: false,
						canShare: canShare(),
						deviceIsMobile: false,
						liveSearchItems: [],
						recentlyViewedItems: {},
						activeScreenshot: props.activeScreenshot,
						couponRes: {status: false},
						couponValue: 0,
						paymentProcessor: props.paymentProcessor || '',
						paymentFees: props.paymentFees,
						minimumPayments: props.minimumPayments,
						customAmount: '',
						minimumItemPrice: null,
						customItemPrice: null,
						totalAmount: 0,
						location: props.location,
						locale: 'en',
						subscriptionId: props.subscriptionId || null,
						subscriptionPrice: props.subscriptionPrice || null,
						paymentProcessors : props.paymentProcessors,
						subcategories: props.subcategories,
						categories: props.categories,
						countryNames: props.countryNames || [],
						pages: props.pages,
						itemId: props.itemId || null,
						itemPrices: props.itemPrices || null,
						itemPromoPrice: null,
						itemHasPromo: false,
						itemIsFree: false,
						itemFreeTime: null,
						currency: props.currency,
						folderFileName: null,
						folderClientFileName: null,
						usersReactions: {},
						usersReaction: '',
						userMessage: '',
						cookiesAccepted: false,
						replyTo: {userName: null, commentId: null},
						commentToEdit: {id: null, comment: null},
						reviewId: null,
						itemReviewed: props.itemReviewed || false,
						folderContent: null,
						parsedQueryString: {},
						translation: translation || {},
						userCurrency: props.userCurrency,
						currencyPos: props.currency.position,
						exchangeRate: props.exchangeRate,
						currencyDecimals: props.currencyDecimals,
						currencies: props.currencies,
						creditsOrder: {},
						couponFormVisible: false,
						guestItems: {},
						keycodes: props.keycodes || {},
						guestAccessToken: '',
						usersNotifRead: null,
						usersNotif: props.usersNotif || '',
						userNotifs: props.userNotifs || [],
						hasNotifPermission: false,
						previewIsPlaying: false,
						previewTrack: null,
						prepaidCreditsPackId: null,
						realtimeViews: {
							website: 0,
							product: 0
						},
						recentPurchase: {},
				}
		},
		methods: {
				__: function(key, params = {})
		    {
			    	var string = this.translation[key] || key;

			    	if(Object.keys(params).length)
			    	{
				    		for(var k in params)
				    		{
				    				string = string.replace(`:${k}`, params[k]);
				    		}
			    	}

			    	return string;
		    },
				getPaymentFee()
				{
						if(this.paymentFees.hasOwnProperty(this.paymentProcessor) && this.totalAmount > 0)
						{
								return Number(this.paymentFees[this.paymentProcessor]).toFixed(this.currencyDecimals);
						}

						return Number(0).toFixed(this.currencyDecimals);
				},
				getTotalAmount()
				{
						var paymentFee  = parseFloat(this.getPaymentFee());
						var grossAmount = 0

						if(!isNaN(this.subscriptionId) && this.subscriptionId !== null)
						{
								grossAmount += parseFloat(this.subscriptionPrice);
						}
						else
						{
								for(let item of this.cartItems)
								{
										grossAmount += parseFloat(item.price);
								}
						}

						if(grossAmount > 0)
						{
								var couponValue = Number.parseFloat(this.couponValue).toFixed(this.currencyDecimals);
									  grossAmount = Number.parseFloat(grossAmount + (parseFloat(!isNaN(paymentFee) ? paymentFee : 0)))
									  							.toFixed(this.currencyDecimals);

								return Number.parseFloat(grossAmount - couponValue).toFixed(this.currencyDecimals);
						}

						return grossAmount;
				},
				downloadItem: function(itemId, formSelector = '#download-form')
				{
						if(!itemId)
						{
								return;
						}

						this.itemId = itemId;

						this.$nextTick(function()
						{
								$(formSelector).submit();
						})
				},
				downloadInvoice: function(itemId)
				{
						$.post('/invoices', {"itemId": itemId, "_token": $('meta[name="csrf-token"]').attr('content')})
						.done(data =>
						{
								window.open(data.url);
						})
				},
				itemInCollection(id)
				{
						return Object.keys(this.favorites).indexOf(String(id)) >= 0;
				},
				setReplyTo: function(userName, commentId)
		    {	
		    		this.commentToEdit = {id: null, comment: null};

			      this.replyTo = {userName, commentId};

			      $('.comment-form textarea').focus()
			      .closest('.comment-form').get(0).scrollIntoView()
		    },
		    resetReplyTo: function()
		    {
		      	this.replyTo = {userName: null, commentId: null};
		    },
		    resetEditComment: function()
		    {
			    	this.commentToEdit = {id: null, comment: null};

			    	$('.comment-form textarea[name="comment"]').val('')
		    },
				lang(key, params = {})
				{
						var string = this.translation[key] || key;

						if(Object.keys(params).length)
						{
								for(var k in params)
								{
										string = string.replace(`:${k}`, params[k]);
								}
						}

						return string;
				},
				price(price, free = false, k = false)
				{
						k = props.showPricesInKFormat;

						if(!isNaN(price))
						{
								var currencyCode = this.userCurrency ? this.userCurrency : this.currency.code;
								var price 			 = Number(price).toFixed(this.currencyDecimals);

								price = (k && price > 1000) ? Number(price / 1000).toFixed(this.currencyDecimals)+'K' : price;

								return this.currencyPos === 'left' ? `${currencyCode} ${price}` : `${price} ${currencyCode}`;
						}
						
						return free ? this.translation['Free'] : price;
				},
				getFolderContent()
		    {
			    	var _this = this;

			    	if(this.folderContent === null)
			    	{
				    		$.post(props.routes.productFolder, {"slug": this.product['slug'], "id": this.product['id']}, null, 'json')
				    		.done(function(data)
				    		{
					    			if(data.hasOwnProperty('files'))
					    			{
					    					_this.folderContent = data.files;
					    			}
				    		})
			    	}
		    },
		    getFolderFileIcon(fileObj)
		    {
			    	var fileMimeType = fileObj.mimeType;

			    	if(/(text\/plain|txt)/i.test(fileMimeType))
			    	{
			    			return 'file alternate outline';
			    	}
			    	else if(/(image\/.+|\.(png|jpg|jpeg))/i.test(fileMimeType))
			    	{
			    			return 'file image outline';
			    	}
			    	else if(/zip|rar|archive|7z/i.test(fileMimeType))
			    	{
			    			return 'file archive outline';
			    	}
			    	else
			    	{
			    			return 'file outline';
			    	}
		    },
		    setLocale(locale)
		    {
			    	this.locale = locale;

			    	Vue.nextTick(function()
			    	{
			    			$('#set-locale').submit();
			    	})
		    },
		    applyPriceRange(e)
		    {
			    	var form 			= $(e.target).closest('.form'),
			    			minPrice  = form.find('input[name="min"]').val().trim(),
			    			maxPrice  = form.find('input[name="max"]').val().trim();

			    	if(minPrice < 0 || maxPrice < 0 || maxPrice < minPrice || minPrice === '' || maxPrice === '')
			    	{    		
				    		e.preventDefault();
				    		return;
			    	}

			    	this.parsedQueryString.price_range = `${minPrice},${maxPrice}`;

			    	this.location.href = queryString.stringifyUrl({url: this.location.href, query: this.parsedQueryString});
		    },
		    priceConverted(price)
		    {
			    	if(price > 0)
			    	{
			    			return Number(price * this.exchangeRate).toFixed(this.currencyDecimals);
			    	}
			    	
			    	return 0;
		    },
		    updatePrice(items)
		    {
			    	return $.post('/update_price', {items: items})
						.done(function(res)
						{
								return res.items;
						});
		    },
		    updateCartPrices()
		    {
			    	if(Object.keys(this.currencies).length)
						{
								this.updatePrice(this.cartItems).then(function(data)
								{
										app.cart = data.items;
								})
						}
		    },
		    downloadKey(itemId, itemSlug)
		    {	
			    	if(Object.keys(this.keycodes).indexOf(itemId.toString()) >= 0)
			    	{
				    		var blob = new Blob([this.keycodes[itemId]], {type: "text/plain;charset=utf-8"});

				    		saveAs(blob, `${itemSlug}.txt`);
			    	}
		    },
		    markUsersNotifAsRead()
		    {
						$('#users-notif').remove();

						if(this.usersNotif.length)
						{
								Cookies.set('user_notif_read', this.usersNotif, {expires: 365});
								
								this.usersNotifRead = this.usersNotif;
						}
		    },
		    loadUserNotifsAsync()
		    {
			    	Push.Permission.request(() =>
						{
								setInterval(function()
					    	{
						    		$.post('/user_notifs')
							    	.done(function(notifications)
							    	{		    		
								    		if(notifications.length)
								    		{
														for(var i = 0; i < notifications.length; i++)
														{
																setTimeout(function timer() 
																{
																		var userNotifsIds = store.get('userNotifsIds', []);

																		if(userNotifsIds.indexOf(notifications[i].id) < 0)
																		{
																				Push.create(app.appName, {
																				    body: app.__(notifications[i].text, {"product_name": notifications[i].name}),
																				    icon: `/storage/${notifications[i].for == '0' ? 'covers' : 'avatars'}/${notifications[i].image}`,
																				    timeout: 4000,
																				    onClick()
																				    {
																				    		$.post(props.routes.notifRead, {notif_id: notifications[i].id})
																						    .done(function()
																						    {
																						      window.location.href = `/item/${notifications[i].slug}`;
																						    })
																				    }
																				});

																				store.set('userNotifsIds', userNotifsIds.concat(notifications[i].id));
																		}
															  }, i * 5000);
														}
								    		}
							    	})
					    	}, 300000)
						})
		    },
		    itemHasPaidLicense()
		    {
		    		var prices = this.itemPrices || {};

						if(Object.keys(prices).length)
						{
								for(var i in prices)
								{
										if(prices[i].price != 0 || prices[i].promo_price != 0)
										{
												return true;
										}
								}
						}

						return false;
		    },
		    removeRecentViewedItem(key)
			  {
				  	if(Object.keys(this.recentlyViewedItems).indexOf(key.toString()) >= 0)
				  	{
					  		var recentlyViewedItems = {};

					  		for(var k of Object.keys(this.recentlyViewedItems))
					  		{
						  			if(k != key)
						  			{
						  					recentlyViewedItems[k] = this.recentlyViewedItems[k];
						  			}
					  		}

					  		this.recentlyViewedItems = recentlyViewedItems;

					  		store.set('recentlyViewedItems', this.recentlyViewedItems);
				  	}
			  },
			  refreshTopPanelCover(name = 'homepage')
			  {
				  	$.get(`/bricks_mask?refresh=1&name=${name}`)
				  	.done(() =>
				  	{
				  			$('#top-panel .cover').css('background-image', `url('/storage/images/${name}_bricks_cover.svg?t=${new Date().getTime()}')`);
				  	})
			  },
			  getLiveSale()
			  {
				  	if(props.recentPurchases.enabled == '1')
				  	{
					  		var route = /home\..+/i.test(this.route) ? this.route.split('.')[1] : 'home';

								if(!Object.keys(props.recentPurchases.pages).length || props.recentPurchases.pages.hasOwnProperty(route))
								{
										var payload = {
												_token: $('meta[name="csrf-token"]').attr('content'),
										};

										$.post(`${location.origin}/live_sales`, payload)
										.done(data => 
										{
												if(data.status)
												{
														this.recentPurchase = data.sale;

														Vue.nextTick(() => 
														{
																$('#recent-purchase-popup').transition('slide right').transition({
																	interval: 5000,
																	duration: 1000
																})
														})
												}
										})
								}
				  	}
			  },
		},
		created()
		{

		},
		mounted() 
		{
				if(!store.has('uuid'))
				{
						store.set('uuid', $('meta[name="uuid"]').attr('content'))
				}

				if(!store.has('favorites'))
				{
						store.set('favorites', {})
				}

				if(Cookies.get('cookies_accepted') === undefined)
				{
						$('#cookies-notif').show()
				}

				this.cartUuid = store.get('uuid');
				
				this.favorites = store.get('favorites');

				if(props.currentRouteName === 'user.collection')
				{
						$.post('/load-user-collection', {favorites: this.favorites})
						.done(data => 
						{
								if(!data.status)
								{
										return;
								}

								this.userCollectionIsReady = true;
								this.favorites = data.items;

								store.set('favorites', this.favorites)
						})
				}

				try
				{
						$.post('/load-cart-items', {uuid: store.get('uuid')})
						.done(data =>
						{
								this.cartItems = data.cart_items || {};
								this.cartReady = true;
						})
						.always(() =>
						{
								
						})

						if(props.recentPurchases.enabled == '1')
						{
								let i = Math.floor(Math.random() * (parseInt(props.recentPurchases.interval.max) - parseInt(props.recentPurchases.interval.min) + 1)) + parseInt(props.recentPurchases.interval.min);

								(async () => 
								{
										store.set('liveSaleHasOne', new Date().getTime())

										while(true)
										{
												await sleep(i*1000);

												this.getLiveSale();
										}
								})()
						}
				}
				catch(err)
				{

				}
		}
})
.mount('#app')


window.debounce = function(func, wait, immediate) 
{
	  var timeout;

	  return function() 
	  {
		    var context = this, args = arguments;
		    var later = function() 
		    {
		      timeout = null;
		      if (!immediate) func.apply(context, args);
		    };

		    var callNow = immediate && !timeout;

		    clearTimeout(timeout);

		    timeout = setTimeout(later, wait);

		    if (callNow) func.apply(context, args);
	  };
};



$(() =>
{
		$('#close-user-notification').on('click', function()
		{
				$(this).closest('div.fixed').addClass('hidden');
		})


		$('#close-user-message').on('click', function()
		{
				$('#user-message').removeClass('active')
		})


		$(window).on('click', function(e)
		{
				if($('#live-search-products').is(':visible') && ($('#live-search-products')[0] !== event.target && !$('#live-search-products')[0].contains(event.target)))
				{
						$('#live-search-products').hide();
			  }

			  if(e.target.classList.contains('video-player'))
			  {
			  		$(e.target).removeClass('active')
			  }

			  if(e.target.id === 'user-message')
			  {
			  		$('#user-message').removeClass('active')
			  }
		})


		$('#live-search input').on('keyup', debounce(function()
		{
				if($(this).val().trim().length >= 3)
				{
						$.post('/items/live_search', {q: $(this).val().trim()})
						.done(data =>
						{
								let products = [];

								if(data.products.length)
								{
										for(let i in data.products)
										{
												products.push(`
													<a href="/item/${data.products[i].id}/${data.products[i].slug}" class="flex items-start h-[50px] overflow-hidden gap-[1rem]">
														<div class="w-[50px] min-w-[50px] h-[50px] min-h-[50px] rounded-[.25rem] bg-cover bg-center" style="background-image: url('${data.products[i].cover}');"></div>
														<div class="">${data.products[i].name}</div>
													</a>
												`);
										}

										if(products.length)
										{
												$('#live-search-products').html(products.join('')).show()
										}
										else
										{
												$('#live-search-products').html(products.join('')).hide()
										}
								}
						})
				}
		}, 500))



		$('.categories-top-menu, #product-menu, #user-menu').kinetic({
				y: false,
				x: true,
		});


		$('#left-sidebar .main-menu-items, #left-sidebar .sub-menu-items, #screenshots').kinetic({
				y: true,
				x: false,
		});


		$('#screenshots > div').on('click', function()
		{	
			$('#screenshots-slider img').attr('src', $(this).data('img'))
			$('#screenshots-slider').removeClass('hidden')
		})


		$('#screenshots-slider').on('click', function(e)
		{
			if(e.target.id === 'screenshots-slider')
			{
				$('#screenshots-slider').toggleClass('hidden', true)
			}
		})


		$('#screenshots-slider div').on('click', function()
		{
			let imgs = [];

			$('#screenshots div').each(function()
			{
				imgs.push($(this).data('img'))
			})

			let currentImg = $('#screenshots-slider img').attr('src');
			let i = imgs.indexOf(currentImg)

			if($(this).hasClass('next'))
			{
				if(i < imgs.length)
				{
					$('#screenshots-slider img').attr('src', imgs[i+1])
				}
			}
			else
			{
				if(i > 0)
				{
					$('#screenshots-slider img').attr('src', imgs[i-1])
				}
			}
		})


		$('.categories-top-menu div').on('click', function()
		{
				location.href = $(this).data('url');
		})


		$('#left-sidebar .submenu-show').on('click', function()
		{
				$(`#left-sidebar div.sub-menu[data-menu="${$(this).data('menu')}"]`).removeClass('hidden')
		})


		$('#left-sidebar .submenu-hide').on('click', function()
		{
				$(`#left-sidebar div.sub-menu[data-menu]:visible`).addClass('hidden')
		})


		$('#left-sidebar-toggler').on('click', function()
		{
				$('#left-sidebar').transition('slide right', 200)
		})


		$('#filters-menu-toggler').on('click', function()
		{
				$('#product-filters').transition('slide left', 200)
		})


		$('#upload-avatar').on('click', function()
		{
				$('[data-tab="profile"] input[name="avatar"]').click();
		})


		$('[data-tab="profile"] input[name="avatar"]').on('change', function()
		{	
				let url = window.URL.createObjectURL(this.files[0]);

				$('#user-avatar')[0].src = url;
		})


		$(document).on('click', '.single-selection .default, .single-selection .text, .multiple-selection .default', function()
		{
				$('div.absolute:visible', this).not($(this).siblings('div.absolute')).hide();

				$(this).siblings('div.absolute').slideToggle(100);

				$('.single-selection .default, .single-selection .text, .multiple-selection .default').not($(this)).siblings('div.absolute').hide();
		})


		$(document).on('click', '.single-selection .option', function()
		{
				let container   = $(this).closest('.single-selection');
				let optionValue = $(this).data('value');
				let optionText  = $(this).data('html') || $(this).html();
				let menu    	= container.find('div.absolute');

				container.find('input[type="hidden"]').val(optionValue).change();

				try
				{
						container.find('.default').html(optionText)
				}
				catch(err){}

				if(menu.is(':visible'))
				{
					menu.slideToggle(100);
				}
		})


		$(document).on('click', '#accept-cookies', function()
		{
				Cookies.set('cookies_accepted', true, {expires: 365});

				$('#cookies-notif').remove();
		})



		$('input[name="cashout_method"]').on('change', function()
		{
				let opt = $(this).val().trim();

				$(`div[data-payout-method]`).removeClass('active').siblings(`div[data-payout-method="${opt}"]`).addClass('active')
		})


		$('.single-selection input[type="hidden"]').each(function()
		{
				let container      = $(this).closest('.single-selection');
				let selectedOption = $(this).val().trim();

				if(selectedOption.length)
				{
						container.find(`.option[data-value="${selectedOption}"]`).click()
				}
		})


		$('.read-user-notification').on('click', function()
		{
				let notifId  = $(this).data('id');
		    let url 		 = $(this).data('href');
		    let redirect = $(this).data('redirect');
		    	
		    if(isNaN(parseInt(notifId)))
		    {
		    		return;
		    }

		    $.post(props.routes.notifRead, {notif_id: notifId})
		    .done((data)=>
		    {
		    		if(data.status === 1)
		    		{
					    	if(redirect === 1)
					    	{
					      		location.href = url;
					      }
					      else
					      {
					      		$(this).closest('tr').removeClass('unread')
					      }
		    		}
		    })
		})


		$(document).on('click', '.copy-coupon', function()
		{
				navigator.clipboard.writeText($(this).siblings('span').text().trim())
		})


		$(document).on('click', '.copy-text', function()
		{
				navigator.clipboard.writeText($(this).data('text').trim())

				if($(this).find('.tooltip').length)
				{
						$(this).find('.tooltip').transition('slide up', function()
						{
								setTimeout(() => 
								{
										$(this).transition('slide up')
								}, 200)
						})
				}
		})


		$(document).on('click', '.add-to-collection', function()
		{
				let favorites = store.get('favorites');
				let productID = $(this).data('id');

				if(Object.keys(favorites).length === 20)
				{
						return;
				}

				if(!favorites.hasOwnProperty(productID))
				{
						favorites[productID] = {"id": productID};

						store.set('favorites', favorites);

						app.favorites = favorites;
				}
				else
				{
						delete favorites[productID];

						store.set('favorites', favorites);

						app.favorites = favorites;
				}
		})


		$(document).on('click', '.remove-from-collection', function()
		{
				let productID = $(this).data('id');

				let favorites = {};

				for(let k in app.favorites)
				{
					if(app.favorites[k].id != productID)
					{
						favorites[app.favorites[k].id] = app.favorites[k];
					}
				}

				store.set('favorites', favorites);

				app.favorites = favorites;
		})

		$('#user-menu div').on('click', function()
		{
				let url = $(this).data('href')

				if(url === null || url === undefined)
				{
						return;
				}

				location.href = url;
		})


		$('#product-menu button').on('click', function()
		{
				$(`#product div[data-tab="${$(this).data('tab')}"]`).addClass('active').siblings('div').removeClass('active')
				$(this).addClass('active').siblings('button').removeClass('active');
		})


		$('#filter-categories-show-more').on('click', function()
		{
				$('#filter-categories').css('overflow', 'auto')
				
				$(this).remove();
		})


		$('#filter-included-files-show-more').on('click', function()
		{
				$('#filter-included-files').css('overflow', 'auto')
				
				$(this).remove();
		})
		

		$('#categories div[data-href]').on('click', function()
		{
				location.href = $(this).data('href');
		})


		$('#products input[name="category[]"]').on('change', function()
		{
				location.href = $(this).data('route')
		})


		$('.player').each(function()
		{
				var type 	 = $(this).data('type');
				var player = $(this);

				$(type, this).on('loadeddata', function(e)
				{	
						player.attr('data-ready', true);
						player.attr('data-duration', $(this)[0].duration)

						var currentTime = $('.stream-player .controls .current-time');

						if(currentTime.length)
						{
								currentTime.text($(this)[0].duration.formatSeconds())
						}
				})

				$(type, this).on('timeupdate', function(e)
				{
						var progress = Number(($(this)[0].currentTime / parseFloat(player.data('duration'))) * 100);

						$(this).siblings('.controls').find('.time').css({width: `${progress}%`})

						if(progress >= 100)
						{
								$(this).closest('.player').find('.play.playing').click();		
						}
				})

				$(type, this).on('seeking', function(e)
				{
						$(this).closest('.image').find('.dimmer').addClass('active')
						$(this).closest(`.${type}-player`).find('.dimmer').addClass('active')
				})

				$(type, this).on('seeked', function(e)
				{
						$(this).closest('.image').find('.dimmer').removeClass('active')
						$(this).closest(`.${type}-player`).find('.dimmer').removeClass('active')
				})
		})


		$(document).on('click', `.player .play`, function()
		{
				try
				{
						if($(this).closest('.player').data('ready') == false)
						{
								return;
						}

						let type = $(this).closest('.player').data('type');

						$(this).closest('.play').addClass('playing');

						$(this).closest('.player').removeClass('stopped').find(type)[0].play();

						$(this).siblings('.wave').prop('mousedown', false);
				}
				catch(e){}
		})


		$(document).on('click', `.player .play.playing`, function()
		{
				try
				{
						if($(this).closest('.player').data('ready') == false)
						{
								return;
						}

						let type = $(this).closest('.player').data('type');

						$(this).closest('.play').removeClass('playing');

						$(this).closest('.player').find(type)[0].pause();

						$(this).siblings('.wave').prop('mousedown', false);
				}
				catch(e){}
		})


		$(document).on('click', `.player .stop`, function()
		{
				try 
				{
						if($(this).closest('.player').data('ready') == false)
						{
								return;
						}

						$(this).siblings('.play').removeClass('playing')

						var player = $(this).closest('.player');
						var type 	 = player.data('type');
						var track  = player.find(type)[0];

						player.addClass('stopped');

						track.currentTime = 0;
						track.pause();

						$(this).siblings('.wave').prop('mousedown', false);
				}
				catch(e){}
		})


		$(document).on('dblclick', `.player video`, function()
		{
				try 
				{
						if($(this).closest('.player').data('ready') == false)
						{
								return;
						}

						let video = $(this)[0];

						if(video.requestFullscreen) 
						{
						  	video.requestFullscreen();
						} 
						else if(video.mozRequestFullScreen) 
						{
						  	video.mozRequestFullScreen();
						} 
						else if(video.webkitRequestFullscreen) 
						{
						  	video.webkitRequestFullscreen();
						} 
						else if(video.msRequestFullscreen) 
						{ 
						  	video.msRequestFullscreen();
						}
				}
				catch(e){}
		})


		$('.player .wave')
		.on('mouseup', function() 
		{
				$(this).prop('mousedown', false);
		})
		.on('mousedown', function(e) 
		{
				let player = $(this).closest('.player');

				if(player.data('ready') == false)
				{
						return;
				}

				let progressPecent = (e.pageX - $(this).offset().left) / $(this).width();

				player.find(player.data('type'))[0].currentTime = Math.floor(Math.floor(player.data('duration')) * progressPecent);
				
				$(this).prop('mousedown', true);
		})
		.on('mousemove', function(e)
		{
				let player = $(this).closest('.player');

				if($(this).prop('mousedown'))
				{
						let progressPecent = (e.pageX - $(this).offset().left) / $(this).width();

						player.find(player.data('type'))[0].currentTime = Math.floor(Math.floor(player.data('duration')) * progressPecent);
				}
		})


		$('.video[data-url]').on('click', function()
		{
				$('.video-player').addClass('active')
		})


		$(`.stream-player .video`).on('wheel', function(e)
		{
				var vid = $(this).siblings('video')[0];

				if(event.deltaY < 0)
				{
						if((vid.volume + 0.1) <= 1)
							vid.volume += 0.1;
				}
				else
				{
						if((vid.volume - 0.1) >= 0)
							vid.volume -= 0.1;
				}

				e.preventDefault()
		})


		$(`.stream-player video`).on('volumechange', (e)=>
		{
				var volume = Math.floor($(e.target)[0].volume * 100);

				$(e.target).closest('.stream-player').find('.volume div > span span').css({height: `${volume}%`})
		})


		$(`.stream-player video`).on('timeupdate', function(e)
		{
				var currentTime = $(this)[0].currentTime.formatSeconds()
													.split(':').reduce((acc, time) => (60 * acc) + +time)
													.formatSeconds()

				$(this).siblings('.controls').find('.current-time').text(currentTime)
		})


		$('.stream-player .volume div > span')
		.on('mousedown', function(e) 
		{
				var progressPecent = 1 - ((e.pageY - $(this).offset().top) / $(this).height());
						progressPecent = Number(progressPecent).toFixed(2);

				$(this).closest('.stream-player').find('video')[0].volume = progressPecent > 1 ? 1 : progressPecent;

				$(this).toggleClass('mousedown', true);
		})
		.on('mousemove', function(e)
		{
				if($(this).hasClass('mousedown'))
				{
						var progressPecent = 1 - ((e.pageY - $(this).offset().top) / $(this).height());
								progressPecent = Number(progressPecent).toFixed(2);

						$(this).closest('.stream-player').find('video')[0].volume = progressPecent > 1 ? 1 : progressPecent;
				}
		})
		.on('mouseup', function(e)
		{
				$(this).toggleClass('mousedown', false);
		})


		$('.stream-player .maximize').on('click', function()
		{
				if(document.fullscreenElement == null)
				{
						document.querySelector('.stream-player').requestFullscreen()
				}
				else
				{
						document.exitFullscreen()	
				}
		})


		$('.stream-player .video').on('click', function()
		{
				var vid = $(this).siblings('video')[0];

				if(vid.paused)
					vid.play()
				else
					vid.pause()
		})


		$('.stream-player .video').on('dblclick', function()
		{
				if(document.fullscreenElement == null)
				{
						document.querySelector('.stream-player').requestFullscreen()
				}
				else
				{
						document.exitFullscreen()	
				}
		})


		$('#apply-products-filter').on('click', function()
		{
				let category 	  = $('input.category:checked').data('category');
				let subcategory   = $('input.subcategory:checked').data('subcategory');
				let includedFiles = $('input.included-file:checked');
				let priceRange    = [$('input[name="price[min]"]').val(), $('input[name="price[max]"]').val()];
				let rating        = $('input[name="rating"]').val();
				let parsedUrl     = queryString.parseUrl(location.href);

				let payload = {
					category,
					subcategory,
					includedFiles,
					priceRange,
					rating,
				};

				let requestUrl = location.origin;
				let queryStr   = [];

				try
				{
					if(category !== undefined && category.length)
					{
						requestUrl = `${requestUrl}/items/category/${category}`;

						if(subcategory !== undefined && subcategory.length)
						{
							requestUrl += `/${subcategory}`;
						}
					}

					priceRange = priceRange.filter(price => price.length);

					if(priceRange.length === 2)
					{
						queryStr.push(`price=[${priceRange.join(',')}]`);
					}

					if(rating !== undefined && rating.length)
					{
						queryStr.push(`rating=${rating}`);
					}

					if(includedFiles.length)
					{
						includedFileTypes = []

						includedFiles.each(function()
						{
							includedFileTypes.push($(this).val().trim())
						})

						if(includedFileTypes.length)
						{
							queryStr.push(`included-files=${includedFileTypes.join(',')}`);
						}
					}

					queryStr = queryStr.join('&');

					if(parsedUrl.query.q)
					{
						requestUrl = `${requestUrl}?q=${parsedUrl.query.q}&${queryStr}`;
					}
					else
					{
						requestUrl = `${requestUrl}?${queryStr}`;	
					}
					
					location.href = requestUrl.substr(-1) === '?' ? requestUrl.slice(0, -1) : requestUrl;
				}
				catch(err)
				{
					console.log(err)
				}
		})


		$('#filter-subcategories-show-more').on('click', function()
		{
				$('#filter-subcategories').css('overflow', 'auto')
				
				$(this).remove();
		})


		$('#extended-license').on('change', function()
		{
				$('.buy-now-action').toggleClass('extended', $(this).prop('checked'));

				$('#product-price .price').text(app.price($(this).prop('checked') ? $(this).data('extended-price') : $(this).data('price')))
		})
			

		$('#ratings div').on('click', function()
		{
				$('input[name="rating"]').val($(this).text().trim());

				$(this).addClass('active').siblings('div').removeClass('active');
		})


		$(document).on('click', '.buy-now', function()
		{
				if($(this).hasClass('download'))
				{
						return;
				}

				let payload = {
						id: 						 $(this).data('id'), 
						uuid: 					 store.get('uuid'), 
						custom_price: 	 $('input[name="custom_price"]').val(), 
						extended_price:  $('#extended-license').is(':checked') ? 1 : 0,
						buy_now:  			 1
				};

				let defaultIcon = $(this).html();

				$(this).prop('disabled', true)

				let loaderIcon = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><g><circle cx="3" cy="12" r="2" fill="currentColor"/><circle cx="21" cy="12" r="2" fill="currentColor"/><circle cx="12" cy="21" r="2" fill="currentColor"/><circle cx="12" cy="3" r="2" fill="currentColor"/><circle cx="5.64" cy="5.64" r="2" fill="currentColor"/><circle cx="18.36" cy="18.36" r="2" fill="currentColor"/><circle cx="5.64" cy="18.36" r="2" fill="currentColor"/><circle cx="18.36" cy="5.64" r="2" fill="currentColor"/><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12"/></g></svg>`;

				if($('span', this).length)
				{
						$('span:first-child', this).html(loaderIcon)		
				}
				else
				{
						$(this).html(loaderIcon)
				}

				

				$.post('/add_to_cart', payload)
				.done(res =>
				{
						if(!res.status)
						{
								$('#user-message .message').text(res.message).closest('#user-message').removeClass('hidden');
								
								$(this).html(defaultIcon);

								$(this).prop('disabled', false)
						}
						else
						{
								location.href = res.checkout_url;
						}
				})
		})


		$(document).on('click', '.add-to-cart', function()
		{
				let payload = {
						id: 						$(this).data('id'), 
						uuid: 					store.get('uuid'), 
						custom_price: 	$('input[name="custom_price"]').val(), 
						extended_price: $('#extended-license').is(':checked') ? 1 : 0,
				};

				let defaultIcon = $(this).html();

				$(this).prop('disabled', true)

				$(this).html(`<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><g><circle cx="3" cy="12" r="2" fill="currentColor"/><circle cx="21" cy="12" r="2" fill="currentColor"/><circle cx="12" cy="21" r="2" fill="currentColor"/><circle cx="12" cy="3" r="2" fill="currentColor"/><circle cx="5.64" cy="5.64" r="2" fill="currentColor"/><circle cx="18.36" cy="18.36" r="2" fill="currentColor"/><circle cx="5.64" cy="18.36" r="2" fill="currentColor"/><circle cx="18.36" cy="5.64" r="2" fill="currentColor"/><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12"/></g></svg>`)

				$.post('/add_to_cart', payload)
				.done(res =>
				{
						if(!res.status)
						{
								$('#user-message .message').text(res.message).closest('#user-message').addClass('active');
								
								$(this).html(defaultIcon);

								$(this).prop('disabled', false)
						}
						else
						{
								location.reload()
						}
				})
		})


		$(document).on('click', '.remove-from-cart', function()
		{
				$('#ckeckout-mask').removeClass('hidden');

				$(this).html(`<g><circle cx="3" cy="12" r="2" fill="currentColor"/><circle cx="21" cy="12" r="2" fill="currentColor"/><circle cx="12" cy="21" r="2" fill="currentColor"/><circle cx="12" cy="3" r="2" fill="currentColor"/><circle cx="5.64" cy="5.64" r="2" fill="currentColor"/><circle cx="18.36" cy="18.36" r="2" fill="currentColor"/><circle cx="5.64" cy="18.36" r="2" fill="currentColor"/><circle cx="18.36" cy="5.64" r="2" fill="currentColor"/><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12"/></g>`).prop('disabled', true);

				$.post('/remove_from_cart', {id: $(this).data('id'), uuid: store.get('uuid')})
				.done(() =>
				{
						location.reload()
				})
		})


		$(document).on('click', '.reactions a', function()
	  {
	  	var $this     = $(this);
	  	var reaction  = $(this).data('reaction');
	  	var groups  	= location.href.match(/.+\/item\/(?<id>\d+)\/.+/).groups;
	  	var item_id   =  $(this).closest('.reactions').data('item_id');
	  	var item_type = $(this).closest('.reactions').data('item_type');

	  	$.post('/save_reaction', {reaction, product_id: groups.id || null, item_id, item_type})
	  	.done(function(res)
	  	{
	  		let zIndexes = {1:6,2:5,3:4,4:3,5:2,6:1};

	  		if(res.status)
	  		{
	  			let reactionsHtml = [];
	  			let k = 1;

	  			for(var i in res.reactions)
	  			{
		  				reactionsHtml.push(`<div class="reaction relative block border-[2px] border-[#fff] rounded-full bg-cover bg-center w-[25px] h-[25px]" data-reaction="${i}" title="${res.reactions[i]}" style="background-image: url('/assets/images/reactions/${i}.webp'); z-index:${zIndexes[k]}"></div>`);

		  				k++;
	  			}  			

	  			if($(`#C${item_id} .saved-reactions`).length)
	  			{
							$(`#C${item_id} .saved-reactions`).html(reactionsHtml.join(''));
	  			}
	  			else
	  			{
	  					$(`#C${item_id} .saved-reactions-container`).html(`<div class="saved-reactions flex items-center saved-reactions [&>div:not(:first-child)]:ml-[-8px] flex-nowrap py-[.2rem] ml-[-2px] mt-[.75rem]" data-item_id="${item_id}" data-item_type="comment">${reactionsHtml.join('')}</div>`)
	  			}
	  		}
	  	})
	  })


		$(document).on('click', 'div[data-edit-comment]', function()
		{
				app.replyTo = {userName: null, commentId: null};

				let commentID 	 = $(this).data('edit-comment');
				
				app.commentToEdit  = JSON.parse(Base64.decode($(`#C${commentID} .json`).data('content').trim()));

				$('.comment-form textarea').focus().closest('.comment-form').get(0).scrollIntoView()
		})


		$(document).on('click', '#payment-methods .method', function()
		{
				$('#payment-methods .method').removeClass('selected');

				$(this).toggleClass('selected', !$(this).hasClass('selected'))

				$('input[name="gateway"]', this).prop('checked', true).change();
		})


		$('#coupon button').on('click', function()
		{
				let coupon = $('#coupon input[name="coupon"]').val().trim();

				let parsedUrl = queryString.parseUrl(location.href);

				let queryStr = parsedUrl.query;

				let payload = {
						gateway: parsedUrl.query.gateway || '',
						type: parsedUrl.query.type,
						id: parsedUrl.query.id,
						coupon: coupon || parsedUrl.query.coupon || '',
				};

				for(let k in payload)
				{
					if(payload[k] === '')
					{
						 delete payload[k];
					}
				}

				$('#ckeckout-mask').removeClass('hidden');

				location.href = `${parsedUrl.url}?${new URLSearchParams(payload).toString()}`;
		})


		$('input[name="gateway"]').on('change', function()
		{
				let parsedUrl = queryString.parseUrl(location.href);

				let payload = {
						gateway: $('input[name="gateway"]:checked').val().trim(),
						type: parsedUrl.query.type,
						id: parsedUrl.query.id,
						coupon: parsedUrl.query.coupon || '',
				};

				for(let k in payload)
				{
					if(payload[k] === '')
					{
						 delete payload[k];
					}
				}

				$('#ckeckout-mask').removeClass('hidden');

				location.href = `${parsedUrl.url}?${new URLSearchParams(payload).toString()}`;
		})


		$('#checkout-form').on('submit', function(e)
		{	
				let parsedUrl = queryString.parseUrl(location.href);

				if(!$('input[name="gateway"]:checked').length)
				{
						$('#user-message .message').text(app.__('Please select a payment method')).closest('#user-message').addClass('active');

						e.preventDefault();
				}

				if($(this).hasClass('has-checkout-button'))
				{
						e.preventDefault();

						let btnID = $(this).data('checkout-button');

						$(`#${btnID}`).click();

						try
						{

						}
						catch(err)
						{

						}
				}
		})

		$('#verify-email').on('click', function()
		{	
				if(!$(this).hasClass('disabled'))
				{
						let defaultIcon = $('.icon', this).html();

						$(this).addClass('disabled');

						$('.icon', this).html('<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><g><circle cx="3" cy="12" r="2" fill="currentColor"/><circle cx="21" cy="12" r="2" fill="currentColor"/><circle cx="12" cy="21" r="2" fill="currentColor"/><circle cx="12" cy="3" r="2" fill="currentColor"/><circle cx="5.64" cy="5.64" r="2" fill="currentColor"/><circle cx="18.36" cy="18.36" r="2" fill="currentColor"/><circle cx="5.64" cy="18.36" r="2" fill="currentColor"/><circle cx="18.36" cy="5.64" r="2" fill="currentColor"/><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12"/></g></svg>');

						$.post('/send_email_verification_link')
			    	.done((data)=>
			    	{
				    		if(data.status)
				    		{
				    				$('#user-message .message').text(data.message).closest('#user-message').addClass('active');
				    		}
			    	})
			    	.always(()=>
			    	{
			    			$('.icon', this).html(defaultIcon);

			    			$(this).removeClass('disabled');
			    	})
	    	}
		})


		$('#user-rating div').on('click', function()
		{
				$(this).css('background', '#fcc153').nextAll('div').css('background', '#cfcfcf')

				$(this).prevAll('div').css('background', '#fcc153')

				$('#product input[name="rating"]').val($(this).index()+1)
		})

		if(/item\/\d+\/.+\?tab=.+/i.test(location.href))
		{	
				try
				{
						let tab = location.href.split('?')[1].split('=')[1].split('#')[0];

						$(`#product button[data-tab="${tab}"]`).click()
				}
				catch(err)
				{

				}
		}


		$('#faq-toggler').on('click', function()
		{
				$(this).siblings('div').slideToggle()
		})

		$('[v-cloak]').removeClass('v-cloak')
})
