@extends("doc.master")

@section("page")
<div class="content" id="products">
  <div class="header">
    <div class="main">Products</div>
    <div class="sub">
      Create & edit products, promotional price, table of contents, permalink, premium content, fake reviews, fake commments ... etc.
    </div>
  </div>

  <div class="sections">
    <div class="section" id="create-edit">
      <div class="header"><a href="#create-edit">#</a>Creating & Editing products</div>
      <div class="subheader">Admin > Products</div>
      <div class="description">
        <p>Creating & Editing products is simply done by filling the prodcut form and clicking on save button. Some fields are required while others are optional</p>
      </div>
    </div>

    <div class="section" id="fake-reviews">
      <div class="header"><a href="#fake-reviews">#</a>Fake reviews</div>
      <div class="description">
        <p>It is possible to create as many reviews as needed for each product, we enter a fake username, a date, a review and rating and save the changes. Click on "+" sign to add, or "-" to delete or "Reset" to empty to rest a review</p>
        <p>Fake reviews are shown on the single product page on the reviews section.</p>
      </div>
    </div>

    <div class="section" id="fake-comments">
      <div class="header"><a href="#fake-comments">#</a>Fake comments</div>
      <div class="description">
        <p>Same as reviews, it is possible to create as many comments as needed for each product, we enter a fake username, a date, a comment and save the changes. Click on "+" sign to add, or "-" to delete or "Reset" to empty to rest a review</p>
        <p>Fake comments are shown on the single product page on the comments section.</p>
      </div>
    </div>

    <div class="section" id="table-of-contents">
      <div class="header"><a href="">#</a>Table of contents</div>
      <div class="description">
        <p>The table of content is useful for products of type document, user who are selling PDFs or other doc formats.</p>
      </div>
    </div>

    <div class="section" id="permalink">
      <div class="header"><a href="#permalink">#</a>Permalink</div>
      <div class="description">
        <p>First we set a unique permalink url identifier in general settings and then we enter a permalink for our product in the product form. The permalink identifier serves to distinguish permalinks from the other pages. (https://www.example.com/p/our-product-name)</p>
      </div>
    </div>

    <div class="section" id="affiliate-link">
      <div class="header"><a href="#affiliate-link">#</a>Affiliate link</div>
      <div class="description">
        You can sell products of another website with your affiliate links, users or buyers who click on "Buy now" button will be redirected to the other website referred with your link.
      </div>
    </div>

    <div class="section" id="enable-licenss">
      <div class="header"><a href="#enable-licenss">#</a>Enable licenses</div>
      <div class="description">
        By enabling licenses for a product, users will obtain a license key in addition to the main product file, you can use this license key later to validate user purchases it they ask for support or other attached services.
      </div>
    </div>

    <div class="section" id="available-via-subscription-only">
      <div class="header"><a href="#available-via-subscription-only">#</a>Available via subscription only</div>
      <div class="description">
        This option makes products accessible with subscriptions only, users cannot purchase them individually.
      </div>
    </div>

     <div class="section" id="hidden-content">
      <div class="header"><a href="#hidden-content">#</a>Hidden content</div>
      <div class="description">
        This is a premium content to show for users who purchased a product or have a valid subscription.
      </div>
    </div>

     <div class="section" id="pricing-promo">
      <div class="header"><a href="#pricing-promo">#</a>Pricing & Promo</div>
      <div class="description">
        <p>Products pricing is done based on the available licenses, the script comes with two licenses created by default, "Regular license" and "Extended license", you can create more licenses if needed or use just one.</p>
        <p>Prices shown for users / visitors are taken from the regular license prices, it's mandatory to have one license "Marked as regular".</p>
        <p>Products can have a promo price for each license with an optional expiration time, can be offered for free with an optional expiration time too.</p>
        <p>There is an option on "General Settings > Products" to force users creating and account to download free items. When "Add to cart" is disabled, users can download free items directly without going through the checkout process.</p>
      </div>
    </div>
  </div>
</div>

<div class="map">
  <div class="content">
    <div class="header">On this page</div>
    <div class="items">
      <a href="/doc/products#create-edit" class="item">Create & Edit</a>
      <a href="/doc/products#fake-reviews" class="item">Fake reviews</a>
      <a href="/doc/products#fake-comments" class="item">Fake comments</a>
      <a href="/doc/products#permalink" class="item">Permalink</a>
      <a href="/doc/products#affiliate-link" class="item">Affiliate link</a>
      <a href="/doc/products#enable-license" class="item">Enable license</a>
      <a href="/doc/products#available-via-subscription-only" class="item">Available via subscription only</a>
      <a href="/doc/products#hidden-content" class="item">Hidden content</a>
      <a href="/doc/products#pricing-promo" class="item">Pricing & Promo</a>
      <a href="/doc/products#table-of-contents" class="item">Table of contents</a>
    </div>
  </div>
</div>
@endsection