<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>{{ __('Order success') }}</title>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link rel="stylesheet" href="{{ src("assets/axies.css") }}">
		<style>
			html {
				font-size: 1rem;
			}

			{!! load_font() !!}
		</style>
	</head>
	<body>
		<div class="m-0 text-[1.1rem] max-w-[1600px] w-full mx-auto bg-[radial-gradient(whitesmoke,#fff)] flex items-center justify-center min-h-[100vh] p-[2rem_1.5rem]">
			<div class="max-w-[450px] w-full rounded-[.25rem] overflow-hidden m-auto bg-[#fff]">
				<div class="p-[1.5rem] pt-[2rem] flex items-end gap-[1rem]">
					<div class="">
						<svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 24 24"><g fill="none" stroke="#00cce2" stroke-linecap="round" stroke-linejoin="round"  color="currentColor"><path d="M14.262 3.6C13.196 2.532 12.662 2 12 2s-1.196.533-2.262 1.6c-.64.64-1.274.936-2.186.936c-.796 0-1.93-.154-2.552.473c-.618.623-.464 1.752-.464 2.543c0 .912-.297 1.546-.937 2.186C2.533 10.804 2 11.338 2 12s.533 1.196 1.6 2.262c.716.717.936 1.18.936 2.186c0 .796-.154 1.93.473 2.552c.623.617 1.752.464 2.543.464c.971 0 1.44.19 2.133.883c.59.59 1.381 1.653 2.315 1.653s1.725-1.063 2.315-1.653c.694-.693 1.162-.883 2.133-.883c.791 0 1.92.154 2.543-.464m1.41-9.262C21.467 10.804 22 11.338 22 12s-.533 1.196-1.6 2.262c-.716.717-.936 1.18-.936 2.186c0 .796.154 1.93-.473 2.552m0 0H19"/><path d="M8 10.308S10.25 10 12 14c0 0 5.059-10 10-12"/></g></svg>
					</div>
					<div class="flex-1">
						<div class="mb-[1rem] flex items-end">
							<span class="font-[600] uppercase text-[1.3rem] leading-[1]">{{ __('Order completed') }}</span>
						</div>
						<div class="text-[1.2rem] mt-[.5rem] opacity-75">{{ __('Thank you for shopping with us') }}</div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600] flex-1">{{ __('Reference number') }}</div>
						<div class="ml-auto">{{ $transaction->reference_id }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600] flex-1">{{ __('Date') }}</div>
						<div class="ml-auto">{{ $transaction->created_at->format('Y-m-d') }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600] flex-1">{{ __('Payment method') }}</div>
						<div class="ml-auto">{{ __($transaction->processor) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600] flex-1">{{ __('Buyer email') }}</div>
						<div class="ml-auto">{{ $transaction->guest_email ?? $transaction->user->email }}</div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600] flex-1">{{ __('Amount') }}</div>
						<div class="ml-auto">{{ currency('code') }} {{ price(price:$transaction->amount, free:false, currency:false) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600] flex-1">{{ __('Payment status') }}</div>
						<div class="ml-auto">
							<div class="min-w-[80px] {{ $transaction->status }} relative text-center justify-center flex gap-[.5rem] p-[.35rem_.75rem] pb-[.15rem] rounded-[.35rem] [&.pending]:bg-[#ffbf0030] [&.pending]:text-[#6f5a1d] [&.paid]:bg-[#E9F6F0] [&.paid]:text-[#129C62] font-[600] group">
								@if($transaction->status === 'pending')
								<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><g fill="currentColor"><path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/><path d="m8.93 6.588l-2.29.287l-.082.38l.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319c.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246c-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0a1 1 0 0 1 2 0"/></g></svg>
								<span class="absolute bottom-[calc(100%+1rem)] p-[.5rem_.75rem] text-left right-0 bg-[#000] text-[#fff] rounded-[.25rem] hidden group-hover:block text-[.9rem] font-[500] w-[250px]">{{ __('Your payment must be confirmed before you can download files') }}</span>
								@endif
								{{ __(mb_ucfirst($transaction->status)) }}
							</div>

						</div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem]">
					@if($transaction->type == 'product')
					<div class="font-[500] text-[#aa6100] bg-[#ffe4495e] p-[.75rem_1rem] rounded-[.5rem] mb-[1rem] leading-[1.8]">{!! __('We sent you download links to your email address :email', ['email' => '<span class="text-[#000] font-[600] opacity-75">' . ($transaction->guest_email ?? $transaction->user->email) . '</span>']) !!}</div>
					@endif

					@if($transaction->guest_email)
					<a href="{{ route('home') }}" class="uppercase p-[.75rem_1rem] border-[1px] border-[#00cce2] hover:bg-[#1d4044] text-[#00cce2] font-[600] block text-center rounded-[.5rem]">
						{{ __('Retrun to homepage') }}
					</a>
					@else
						@if($transaction->type == 'product')
						<a href="{{ route('user.purchases') }}" class="capitalize p-[.75rem_1rem] bg-[#00cce2] text-[#fff] font-[600] block text-center rounded-[.5rem]">{{ __('My purchases') }}</a>
						@elseif($transaction->type == 'subscription')
						<a href="{{ route('user.subscriptions') }}" class="capitalize p-[.75rem_1rem] bg-[#00cce2] text-[#fff] font-[600] block text-center rounded-[.5rem]">{{ __('My subscriptions') }}</a>
						@else
						<a href="{{ route('user.prepaid_credits') }}" class="capitalize p-[.75rem_1rem] bg-[#00cce2] text-[#fff] font-[600] block text-center rounded-[.5rem]">{{ __('My credits') }}</a>
						@endif
					@endif
				</div>
			</div>
		</div>
	</body>
</html>