<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
	<meta charset="UTF-8">
	<meta name="language" content="{{ str_replace('_', '-', app()->getLocale()) }}">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="uuid" content="{{ \Str::uuid() }}">

	<link rel="icon" href="{{ asset_("storage/images/".config('app.favicon'))}}">

	{{-- <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests"> --}}
	
	{!! config('app.analytics_code') !!}
	{!! place_ad('popup_ad') !!}
	{!! place_ad('auto_ad') !!}

	{{-- Search engines verification --}}
	@if(config('app.site_verification'))
	{!! config('app.site_verification') !!}
	@endif

	<title>{!! config('meta_data.title') !!}</title>

	<link rel="canonical" href="{{ config('meta_data.url') }}">

	<meta name="route" content="{{ \Route::currentRouteName() }}">

	<meta property="og:site_name" name="site_name" content="{{ config('meta_data.name') }}">
	<meta property="og:title" name="title" itemprop="title" content="{!! config('meta_data.title') !!}">
	<meta property="og:type" name="type" itemprop="type" content="Website">
	<meta property="og:url" name="url" itemprop="url" content="{{ config('meta_data.url') }}">
	<meta property="og:description" name="description" itemprop="description" content="{!! config('meta_data.description') !!}">
	<meta property="og:image" name="og:image" itemprop="image" content="{{ config('meta_data.image') }}">

	<meta property="fb:app_id" content="{{ config('app.fb_app_id') }}">
	<meta name="og:image:width" content="590">
	<meta name="og:image:height" content="auto">

	@if(config('app.json_ld'))
	<script type="application/ld+json">
	{!! @json_encode(config('json_ld', []), JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE) !!}
	</script>
	@endif

	<meta name="csrf-token" content="{{ csrf_token() }}">

	<script type="application/javascript" src="/assets/base64.min.js"></script>

	<script type="application/javascript" src="/translations.js"></script>

	<script type="application/javascript" src="/assets/query-string.min.js"></script>
	
	<link rel="stylesheet" href="{{ src("assets/axies.css") }}">

	<script src="/assets/store.min.js"></script>

	<script src="/assets/js.cookie.min.js"></script>

	<script src="/assets/vue.global_3.5.8.js"></script>

	<script src="/props.js?t={{ time() }}"></script>

	<script>
		'use strict';

		props['currentRouteName'] = '{{ \Route::currentRouteName() }}';
	</script>

	<style>
		html {
			font-size: 1rem;
		}

		{!! load_font() !!}
	</style>

	@if(config('app.js_css_code.frontend'))
		{!! config('app.js_css_code.frontend')!!}
	@endif

	<script src="/assets/jquery-3.7.1.min.js"></script>
	<script src="/assets/jquery.kinetic.min.js"></script>

	<link rel="stylesheet" href="/assets/transition.min.css">
	<script src="/assets/transition.min.js"></script>

	@yield('head_tags')
</head>

<body class="m-0 text-[1rem] font-[500] text-[#000] overflow-hidden">
	<div id="app" class="max-w-[1600px] relative mx-auto overflow-hidden">
		<div class="">
			<div class="flex items-start">
				{{-- LEFT SIDEBAR --}}
				<div id="left-sidebar" class="max-[1200px]:absolute max-w-[320px] max-[1200px]:hidden min-w-[320px] w-full h-[100vh] overflow-hidden bg-[#fff] relative border-r-[1px] border-[#f1f1f1] z-[1]">
					<a href="{{ route('home') }}" class="px-[1.5rem] flex items-center h-[100px]"><img src="{{ src("storage/images/".config('app.logo')) }}" class="w-[200px]"></a>

					<div class="p-[1.5rem] sub-menu hidden" data-menu="categories">
						<div class="flex justify-end border-b-[1px] pb-[1rem] submenu-hide">
							<div class="mr-auto uppercase p-[.5rem_.75rem] font-[600] pb-[.35rem] bg-[#f8f8f8] rounded-[.25rem] text-[.9rem]">{{ __('Categories') }}</div>
							<button class=""><svg xmlns="http://www.w3.org/2000/svg" transform="scale(-1,1)" width="25" height="25" viewBox="0 0 512 512"><path fill="currentColor" d="M296.007 56h-38.632v120h-144v160h144v120H296l200-199.8Zm-6.632 361.384V304h-144v-96h144V94.639l161.37 161.535ZM17.375 56h32v400h-32z"/></svg></button>
						</div>
						
						<div class="py-[1rem] overflow-auto sub-menu-items scrollbar-width-[none] h-[calc(100vh-210px)]">
							<div class="capitalize font-[400]" id="categories">
								@foreach(config('categories.category_parents', []) as $category)
								<div data-href="{{ route('home.products.category', ['category_slug' => $category['slug']]) }}" class="block select-none pb-[.75rem] cursor-pointer">{{ $category['name'] }}</div>
								@endforeach
							</div>
						</div>
					</div>
					
					<div class="p-[1.5rem] main-menu">
						<form action="{{ route('home.products.q') }}" method="get" class="flex items-center bg-[#fcfcfc] border-[1px] border-[#f5f5f5] rounded-[.25rem] overflow-hidden mb-[1.5rem]">
							<input type="text" name="q" required class="outline-0 bg-transparent h-[45px] px-[.75rem]" placeholder="{{ __('Enter a title') }} ....">
							<button class="h-[45px] opacity-50"><svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" d="M15.5 14h-.79l-.28-.27a6.5 6.5 0 0 0 1.48-5.34c-.47-2.78-2.79-5-5.59-5.34a6.505 6.505 0 0 0-7.27 7.27c.34 2.8 2.56 5.12 5.34 5.59a6.5 6.5 0 0 0 5.34-1.48l.27.28v.79l4.25 4.25c.41.41 1.08.41 1.49 0s.41-1.08 0-1.49zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14"/></svg></button>
						</form>

						<div class="crollbar-width-[none] main-menu-items overflow-auto scrollbar-width-[none] h-[calc(100vh-225px)] [&_svg]:opacity-80 relative">
							<div class="[&>a]:flex [&>div]:flex [&>a]:items-center [&>div]:items-center [&>a]:gap-[1rem] [&>div]:gap-[1rem] [&>a]:py-[.65rem] [&>div]:py-[.65rem] [&>a_span]:block">
								@guest
								<a href="{{ route('login') }}" class="">
									<div class="w-[44px] h-[44px] rounded-[.25rem] flex items-center justify-center bg-[#f8f8f8]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 14 14"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><circle cx="7" cy="3.75" r="3.25"/><path d="M13.18 13.5a6.49 6.49 0 0 0-12.36 0Z"/></g></svg>
									</div>
									<div>
										<div class="max-[480px]:hidden">{{ __('Profile') }}</div>
										<div class="hidden max-[480px]:block">{{ __('Account') }}</div>
										<div class="text-[.8rem] mt-[.25rem] opacity-75">{{ __('User settings') }}</div>
									</div>
								</a>
								@else
								<a href="{{ route('user.profile') }}" class="">
									<div class="w-[44px] h-[44px] rounded-[.25rem] flex items-center justify-center bg-[#f8f8f8]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 14 14"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><circle cx="7" cy="3.75" r="3.25"/><path d="M13.18 13.5a6.49 6.49 0 0 0-12.36 0Z"/></g></svg>
									</div>
									<div>
										<div class="">{{ __('Account') }}</div>
										<div class="text-[.8rem] mt-[.25rem] opacity-75">{{ __('User settings') }}</div>
									</div>
								</a>
								@endif
								<div class="cursor-pointer submenu-show" data-menu="categories">
									<div class="w-[44px] h-[44px] rounded-[.25rem] flex items-center justify-center bg-[#f8f8f8]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" d="M7 12H6c-1.886 0-2.828 0-3.414.586c-.472.471-.564 1.174-.582 2.414M12 17v1c0 1.886 0 2.828-.586 3.414C10.83 22 9.886 22 8 22H6c-1.886 0-2.828 0-3.414-.586c-.472-.471-.564-1.174-.582-2.414"/><path d="M12 7h-1c-1.886 0-2.828 0-3.414.586S7 9.114 7 11v2c0 1.886 0 2.828.586 3.414S9.114 17 11 17h2c1.886 0 2.828 0 3.414-.586S17 14.886 17 13v-1"/><path stroke-linecap="round" d="M15 2.004c-1.24.018-1.943.11-2.414.582C12 3.172 12 4.114 12 6v2c0 1.886 0 2.829.586 3.414C13.172 12 14.114 12 16 12h2c1.886 0 2.828 0 3.414-.586C22 10.83 22 9.886 22 8V6c0-1.886 0-2.828-.586-3.414c-.471-.472-1.174-.564-2.414-.582"/></g></svg>
									</div>
									<div>
										<div class="">{{ __('Categories') }}</div>
										<div class="text-[.8rem] mt-[.25rem] opacity-75">{{ __('Categories list') }}</div>
									</div>
								</div>
								@if(config('app.subscriptions.enabled'))
								<a href="{{ route('home.subscriptions') }}" class="">
									<div class="w-[44px] h-[44px] rounded-[.25rem] flex items-center justify-center bg-[#f8f8f8]">
										<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 256 256"><path fill="currentColor" d="M230.9 73.6a15.85 15.85 0 0 0-18.9 3.79l-33.67 36.29l-35.8-80.29a1 1 0 0 1 0-.1a16 16 0 0 0-29.06 0a1 1 0 0 1 0 .1l-35.8 80.29L44 77.39a16 16 0 0 0-27.75 13.42c0 .11 0 .21.07.32L39 195a16 16 0 0 0 15.72 13h146.57A16 16 0 0 0 217 195l22.68-103.87c0-.11 0-.21.07-.32a15.85 15.85 0 0 0-8.85-17.21m-29.55 118.08l-.06.32H54.71l-.06-.32L32 88l.14.16l42 45.24a8 8 0 0 0 13.18-2.18L128 40l40.69 91.25a8 8 0 0 0 13.18 2.18l42-45.24l.13-.19Z"/></svg>
									</div>
									<div>
										<div class="">{{ __('Pricing') }}</div>
										<div class="text-[.8rem] mt-[.25rem] opacity-75">{{ __('Explore our pricing plans') }}</div>
									</div>
								</a>
								@endif
								@if(config('app.prepaid_credits.enabled'))
								<a href="{{ route('home.prepaid_credits') }}" class="">
									<div class="w-[44px] h-[44px] rounded-[.25rem] flex items-center justify-center bg-[#f8f8f8]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="M16 14a1.5 1.5 0 1 0 3 0a1.5 1.5 0 0 0-3 0m2.9-6q.1-.486.1-1a5 5 0 1 0-9.9 1"/><path d="M7 7.993h9c2.828 0 4.243 0 5.121.88c.879.878.879 2.293.879 5.123v2.001c0 2.83 0 4.245-.879 5.124C20.243 22 18.828 22 16 22h-6c-3.771 0-5.657 0-6.828-1.172S2 17.769 2 13.996v-2c0-3.774 0-5.66 1.172-6.833C4.115 4.22 5.52 4.036 8 4h2"/></g></svg>
									</div>
									<div>
										<div class="">{{ __('Prepaid credits') }}</div>
										<div class="text-[.8rem] mt-[.25rem] opacity-75">{{ __('Topup your account') }}</div>
									</div>
								</a>
								@endif
								@if(intval(config('app.blog.enabled')))
								<a href="{{ route('home.blog') }}" class="">
									<div class="w-[44px] h-[44px] rounded-[.25rem] flex items-center justify-center bg-[#f8f8f8]">
										<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 28 28"><path fill="currentColor" d="M6.75 3A3.75 3.75 0 0 0 3 6.75v14.5A3.75 3.75 0 0 0 6.75 25h8.507a3.75 3.75 0 0 0 2.652-1.098l5.993-5.993A3.75 3.75 0 0 0 25 15.257V6.75A3.75 3.75 0 0 0 21.25 3zM4.5 6.75A2.25 2.25 0 0 1 6.75 4.5h14.5a2.25 2.25 0 0 1 2.25 2.25V15h-4.75A3.75 3.75 0 0 0 15 18.75v4.75H6.75a2.25 2.25 0 0 1-2.25-2.25zm12 16.376V18.75a2.25 2.25 0 0 1 2.25-2.25h4.376a2.3 2.3 0 0 1-.285.348l-5.993 5.993a2.3 2.3 0 0 1-.348.285"/></svg>
									</div>
									<div>
										<div class="">{{ __('Blog') }}</div>
										<div class="text-[.8rem] mt-[.25rem] opacity-75">{{ __('Explore our articles') }}</div>
									</div>
								</a>
								@endif
								<a href="{{ route('home.support') }}">
									<div class="w-[44px] h-[44px] rounded-[.25rem] flex items-center justify-center bg-[#f8f8f8]">
										<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 14 14"><g fill="none" opacity="0.9" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><path d="M1.5 6h1a.5.5 0 0 1 .5.5V9a.5.5 0 0 1-.5.5h-1a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1Zm11 3.5h-1A.5.5 0 0 1 11 9V6.5a.5.5 0 0 1 .5-.5h1a1 1 0 0 1 1 1v1.5a1 1 0 0 1-1 1Zm-3 2.75a2 2 0 0 0 2-2h0V9.5"/><path d="M8.25 11a1.25 1.25 0 0 1 0 2.5h-1.5a1.25 1.25 0 0 1 0-2.5ZM2.5 6V5a4.5 4.5 0 0 1 9 0v1m-6-2v1.5m3-1.5v1.5m-3 2c0 1.33 3 1.33 3 0"/></g></svg>
									</div>
									<div>
										<div class="">{{ __('Support') }}</div>
										<div class="text-[.8rem] mt-[.25rem] opacity-75">{{ __('Contact & FAQ') }}</div>
									</div>
								</a>
							</div>
						</div>
					</div>
					<div class="h-[8px] bg-[#765fff] fixed w-[320px] bottom-0"></div>
				</div>

				{{-- RIGHT SIDEBAR --}}
				<div class="overflow-auto h-[100vh] flex-1 relative" id="r-section">
					{{-- TOP MENU --}}
					<div class="p-[1.5rem] h-[100px] flex gap-x-[1rem] items-center">
						<a href="{{ route('home') }}" class="max-[600px]:hidden hidden items-center mr-[1.5rem] max-[1200px]:flex"><img src="{{ src("storage/images/".config('app.logo')) }}" class="w-full max-w-[200px] h-auto max-[576px]:w-[160px]"></a>

						<a href="{{ route('home') }}" class="hidden max-[600px]:flex items-center"><img src="{{ src('storage/images/'.config('app.favicon')) }}" class="w-full w-[55px] min-w-[55px] h-[55px]"></a>

						<div class="max-w-[400px] w-full relative" id="live-search">
							<form action="{{ route('home.products.q') }}" method="GET" class="hidden items-center bg-[#fff] rounded-[.25rem] overflow-hidden max-w-[400px] w-full border-[1px] min-[864px]:flex">
								<input type="text" name="q" required class="outline-0 bg-transparent h-[45px] px-[.75rem] flex-1" placeholder="Enter a title ....">
								<button class="h-[45px] w-[45px] opacity-50"><svg xmlns="http://www.w3.org/2000/svg" class="mx-auto" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" d="M15.5 14h-.79l-.28-.27a6.5 6.5 0 0 0 1.48-5.34c-.47-2.78-2.79-5-5.59-5.34a6.505 6.505 0 0 0-7.27 7.27c.34 2.8 2.56 5.12 5.34 5.59a6.5 6.5 0 0 0 5.34-1.48l.27.28v.79l4.25 4.25c.41.41 1.08.41 1.49 0s.41-1.08 0-1.49zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14"></path></svg></button>
							</form>
							<div class="absolute hidden z-[9] shadow-[0_-5px_30px_-20px_#00000069] text-[.9rem] left-0 top-[65px] w-full h-[347px] rounded-[.25rem] bg-[#fff] p-[1rem] text-[1rem] [&>a:not(:last-child)]:mb-[1rem]" id="live-search-products"></div>
						</div>

						@if(intval(config('app.blog.enabled')))
						<a href="{{ route('home.blog') }}" class="p-[.5rem_.75rem] border-[1px] rounded-[.25rem] h-[45px] hidden items-center border-[#67528c] text-[#67528c] relative min-[1024px]:flex">{{ __('Blog') }}</a>
						@endif

						@if(intval(config('app.subscriptions.enabled')))
						<a href="{{ route('home.subscriptions') }}" class="p-[.5rem_.75rem] border-[1px] rounded-[.25rem] h-[45px] hidden items-center border-[#67528c] text-[#67528c] relative min-[1024px]:flex">{{ __('Pricing') }}</a>
						@endif

						<div class="group relative ml-auto">
							<div class="p-[.5rem_.75rem] border-[1px] rounded-[.25rem] h-[45px] flex items-center ml-auto border-[#67528c] text-[#67528c] relative cursor-default menu-text">
								<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 24 24"><path fill="currentColor" d="M5.5 18.77q-.213 0-.356-.145T5 18.268t.144-.356t.356-.143h1.116V9.846q0-1.96 1.24-3.447T11 4.546V4q0-.417.291-.708q.291-.292.707-.292t.709.292T13 4v.546q1.904.365 3.144 1.853t1.24 3.447v7.923H18.5q.213 0 .356.144q.144.144.144.357t-.144.356t-.356.143zm6.497 2.615q-.668 0-1.14-.475t-.472-1.14h3.23q0 .67-.475 1.142q-.476.472-1.143.472M7.616 17.77h8.769V9.846q0-1.823-1.281-3.104T12 5.462t-3.104 1.28t-1.28 3.104zM3.74 9.827q-.224 0-.367-.162q-.143-.161-.132-.394q.104-1.587.743-2.997q.638-1.41 1.675-2.495q.17-.16.381-.183t.365.144q.154.168.142.375q-.011.208-.182.373q-.899.945-1.447 2.16T4.267 9.25q-.03.233-.167.405q-.136.172-.36.172m16.53 0q-.234 0-.37-.172t-.167-.405q-.104-1.387-.643-2.592q-.538-1.206-1.436-2.15q-.178-.164-.206-.382t.127-.386t.374-.134t.391.192q1.037 1.085 1.675 2.486q.639 1.4.743 2.987q.011.233-.133.394q-.143.162-.356.162"/></svg>
								@if(count(config('notifications', [])))
								<span class="absolute bottom-[-.75rem] left-[-.75rem] text-[.7rem] font-[600] text-[#fff] justify-center p-[.25rem] leading-[0] rounded-[.25rem] bg-[#67528c] w-[22px] h-[22px] flex items-center font-[arial]">{{ count(config('notifications', [])) }}</span>
								@endif
							</div>
							@if(count(config('notifications', [])))
							<div class="hidden absolute group-hover:block top-[100%] z-[9] right-[-1rem] max-[560px]:right-[-180px] max-[480px]:right-[-120px]">
								<div class="font-[400] text-[#000] text-[1rem] bg-[#fff] mt-[27px] w-[300px] shadow-[0_50px_30px_-40px_#00000069] border-[#f5f5f5] border-t-[3px] border-[#ffb837] rounded-b-[.25rem]">
									@foreach(array_slice(config('notifications', []), 0, 5) as $notification)
									<div class="h-[] text-[.9rem] p-[1rem] flex gap-[1rem] items-center min-w-0 overflow-hidden" data-redirect="1" data-id="{{ $notification->id }}" data-href="{{ route('home.product', ['id' => $notification->product_id, 'slug' => $notification->slug . ($notification->for == 1 ? '?tab=comments' : ($notification->for == 2 ? '?tab=reviews' : ''))]) }}">
										<div class="flex bg-cover bg-center rounded-[.25rem] w-[50px] min-w-[50px] h-[50px]" style="background-image: url('{{ $notification->image }}';"></div>
										<div class="min-w-0 w-full">
											<div class="block mb-[.5rem] font-[500] whitespace-nowrap overflow-hidden w-full">{{ limit($notification->name, 60) }}</div>
											<div class="text-[.8rem] font-[500] w-full flex justify-between">
												<div class="mr-[1rem] flex-1 opacity-50">{{ format_date($notification->updated_at, 'd M, Y') }}</div>
												<div class="ml-auto font-[500]">{{ format_date($notification->updated_at, 'H:i') }}</div>
											</div>
										</div>
									</div>
									@if(!$loop->last)
									<div class="border-t-[1px] mx-[1rem]"></div>
									@endif
									@endforeach
									<a href="{{ route('user.notifications') }}" class="p-[.75rem_1rem] text-[#fff] bg-[#ff8e34] block text-[.9rem] font-[600] text-center uppercase text rounded-b-[.25rem]">{{ __('Notifications') }}</a>
								</div>
							</div>
							@endif
						</div>
						
						@if(config('payments.enable_add_to_cart'))
						<div class="group relative">
							<div class="p-[.5rem_.75rem] border-[1px] rounded-[.25rem] h-[45px] flex items-center ml-auto border-[#67528c] text-[#67528c] relative cursor-default menu-text">
								<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 24 24"><path fill="currentColor" d="M6.616 21q-.691 0-1.153-.462T5 19.385V8.615q0-.69.463-1.152T6.616 7H8.5v-.5q0-1.458 1.021-2.479T12 3t2.479 1.021T15.5 6.5V7h1.885q.69 0 1.152.463T19 8.616v10.769q0 .69-.463 1.153T17.385 21zM9.5 7h5v-.5q0-1.056-.722-1.778T12 4t-1.778.722T9.5 6.5zm5.5 4q.214 0 .357-.143t.143-.357V8h-1v2.5q0 .214.143.357T15 11m-6 0q.214 0 .357-.143T9.5 10.5V8h-1v2.5q0 .214.143.357T9 11"/></svg>
								<span class="absolute bottom-[-.75rem] left-[-.75rem] text-[.7rem] font-[600] text-[#fff] justify-center p-[.25rem] leading-[0] rounded-[.25rem] bg-[#67528c] w-[22px] h-[22px] flex items-center font-[arial]">
									<p class="" v-if="!cartReady">
										<svg class="opacity-75" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24"><path fill="currentColor" d="M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,19a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z" opacity=".25"/><path fill="currentColor" d="M10.14,1.16a11,11,0,0,0-9,8.92A1.59,1.59,0,0,0,2.46,12,1.52,1.52,0,0,0,4.11,10.7a8,8,0,0,1,6.66-6.61A1.42,1.42,0,0,0,12,2.69h0A1.57,1.57,0,0,0,10.14,1.16Z"><animateTransform attributeName="transform" dur="0.75s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12"/></path></svg>
									</p>
									<p v-else>@{{ Object.keys(cartItems).length }}</p>
								</span>
							</div>

							<div v-if="Object.keys(cartItems).length > 0" class="hidden absolute group-hover:block top-[100%] z-[9] right-[-1rem] max-[560px]:right-[-120px] max-[480px]:right-[-60px]">
								<div class="font-[400] text-[#000] text-[1rem] bg-[#fff] mt-[27px] w-[300px] shadow-[0_50px_30px_-40px_#00000069] border-t-[3px] border-[#ffb837] rounded-b-[.25rem]">
									<div v-for="item, k in cartItems" class="h-[112px] text-[.9rem] p-[1rem] flex gap-[1rem] items-center min-w-0 overflow-hidden">
										<a href="" class="flex bg-cover bg-center rounded-[.25rem] w-[80px] min-w-[80px] h-[80px]" :style="'background-image: url('+ item.cover +');'"></a>
										<div class="flex flex-col justify-center h-full">
											<a href="" class="block h-[42px] overflow-hidden mb-[.5rem] font-[500]">@{{ item.name }}</a>
											<div class="flex gap-[1rem] items-center justify-between mt-auto">
												<div class="mr-auto text-[.7rem] p-[.35rem] pb-[.15rem] font-[500] rounded-[.25rem] bg-[#000] text-[#fff]">@{{ item.price }}</div>
												<svg class="ml-auto cursor-pointer remove-from-cart [&[disabled]:opacity-50]" :data-id="item.id" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" d="M20.5 6h-17m6 5l.5 5m4.5-5l-.5 5"></path><path d="M6.5 6h.11a2 2 0 0 0 1.83-1.32l.034-.103l.097-.291c.083-.249.125-.373.18-.479a1.5 1.5 0 0 1 1.094-.788C9.962 3 10.093 3 10.355 3h3.29c.262 0 .393 0 .51.019a1.5 1.5 0 0 1 1.094.788c.055.106.097.23.18.479l.097.291A2 2 0 0 0 17.5 6"></path><path stroke-linecap="round" d="M18.374 15.4c-.177 2.654-.266 3.981-1.131 4.79s-2.195.81-4.856.81h-.774c-2.66 0-3.99 0-4.856-.81c-.865-.809-.953-2.136-1.13-4.79l-.46-6.9m13.666 0l-.2 3"></path></g></svg>
											</div>
										</div>
									</div>
									<div class="border-t-[1px] mx-[1rem]"></div>
									<a :href="'{{ route('home.checkout', ['type' => 'items']) }}&id=' + cartUuid" class="p-[.75rem_1rem] text-[#fff] bg-[#ff8e34] block text-[.9rem] font-[600] text-center uppercase text rounded-b-[.25rem]">{{ __('Shopping cart') }}</a>
								</div>
							</div>
						</div>
						@endif

						@guest
						<a href="{{ route('login') }}" class="p-[.5rem_.75rem] border-[1px] rounded-[.25rem] h-[45px] flex items-center bg-[#67528c] text-[#fff] border-[#67528c]">
							<svg class="max-[479px]:block hidden" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" d="M6.196 17.485q1.275-.918 2.706-1.451Q10.332 15.5 12 15.5t3.098.534t2.706 1.45q.99-1.025 1.593-2.42Q20 13.667 20 12q0-3.325-2.337-5.663T12 4T6.337 6.338T4 12q0 1.667.603 3.064q.603 1.396 1.593 2.42m5.805-4.984q-1.264 0-2.133-.868T9 9.501t.868-2.133T12 6.5t2.132.868T15 9.5t-.868 2.132t-2.131.868M12 21q-1.883 0-3.525-.701t-2.858-1.916t-1.916-2.858T3 12t.701-3.525t1.916-2.858q1.216-1.215 2.858-1.916T12 3t3.525.701t2.858 1.916t1.916 2.858T21 12t-.701 3.525t-1.916 2.858q-1.216 1.215-2.858 1.916T12 21m0-1q1.383 0 2.721-.484q1.338-.483 2.313-1.324q-.974-.783-2.255-1.237T12 16.5t-2.789.445t-2.246 1.247q.975.84 2.314 1.324T12 20m0-8.5q.842 0 1.421-.579T14 9.5t-.579-1.421T12 7.5t-1.421.579T10 9.5t.579 1.421T12 11.5m0 6.75"/></svg>
							<span class="max-[479px]:hidden">{{ __('Account') }}</span>
						</a>
						@else
						<div class="group relative max-[480px]:hidden">
							<div class="rounded-[.25rem] h-[45px] flex items-center cursor-default menu-text">
								<img src="{{ src("storage/avatars/".(\Auth::check() ? request()->user()->avatar : 'default.webp')) }}" class="w-[45px] h-[45px] rounded-[.25rem] min-w-[45px] min-h-[45px]">
							</div>
							<div class="hidden absolute group-hover:block top-[100%] z-[9] right-0">
								<div class="font-[400] text-[#000] text-[1rem] bg-[#fff] mt-[27px] w-[240px] shadow-[0_50px_30px_-40px_#00000069] border-[#f5f5f5] border-t-[3px] border-[#ffb837] py-[.25rem] rounded-b-[.25rem]">
									@if(config('affiliate.enabled'))
									<div class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem] font-[500] justify-center">
										{{ __('Credits : :value', ['value' => price(user_credits(true, 'total_available_credits'), false)]) }}
									</div>
									@endif

									@if(auth_is_admin())
									<a href="{{ route('admin') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="12" cy="12" r="3"/><path d="M13.765 2.152C13.398 2 12.932 2 12 2s-1.398 0-1.765.152a2 2 0 0 0-1.083 1.083c-.092.223-.129.484-.143.863a1.62 1.62 0 0 1-.79 1.353a1.62 1.62 0 0 1-1.567.008c-.336-.178-.579-.276-.82-.308a2 2 0 0 0-1.478.396C4.04 5.79 3.806 6.193 3.34 7s-.7 1.21-.751 1.605a2 2 0 0 0 .396 1.479c.148.192.355.353.676.555c.473.297.777.803.777 1.361s-.304 1.064-.777 1.36c-.321.203-.529.364-.676.556a2 2 0 0 0-.396 1.479c.052.394.285.798.75 1.605c.467.807.7 1.21 1.015 1.453a2 2 0 0 0 1.479.396c.24-.032.483-.13.819-.308a1.62 1.62 0 0 1 1.567.008c.483.28.77.795.79 1.353c.014.38.05.64.143.863a2 2 0 0 0 1.083 1.083C10.602 22 11.068 22 12 22s1.398 0 1.765-.152a2 2 0 0 0 1.083-1.083c.092-.223.129-.483.143-.863c.02-.558.307-1.074.79-1.353a1.62 1.62 0 0 1 1.567-.008c.336.178.579.276.819.308a2 2 0 0 0 1.479-.396c.315-.242.548-.646 1.014-1.453s.7-1.21.751-1.605a2 2 0 0 0-.396-1.479c-.148-.192-.355-.353-.676-.555A1.62 1.62 0 0 1 19.562 12c0-.558.304-1.064.777-1.36c.321-.203.529-.364.676-.556a2 2 0 0 0 .396-1.479c-.052-.394-.285-.798-.75-1.605c-.467-.807-.7-1.21-1.015-1.453a2 2 0 0 0-1.479-.396c-.24.032-.483.13-.82.308a1.62 1.62 0 0 1-1.566-.008a1.62 1.62 0 0 1-.79-1.353c-.014-.38-.05-.64-.143-.863a2 2 0 0 0-1.083-1.083Z"/></g></svg>
										<span>{{ __('Administration') }}</span>
									</a>
									@endif

									<a href="{{ route('user.dashboard') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M17.293 2.293C17 2.586 17 3.057 17 4v13c0 .943 0 1.414.293 1.707S18.057 19 19 19s1.414 0 1.707-.293S21 17.943 21 17V4c0-.943 0-1.414-.293-1.707S19.943 2 19 2s-1.414 0-1.707.293M10 7c0-.943 0-1.414.293-1.707S11.057 5 12 5s1.414 0 1.707.293S14 6.057 14 7v10c0 .943 0 1.414-.293 1.707S12.943 19 12 19s-1.414 0-1.707-.293S10 17.943 10 17zM3.293 9.293C3 9.586 3 10.057 3 11v6c0 .943 0 1.414.293 1.707S4.057 19 5 19s1.414 0 1.707-.293S7 17.943 7 17v-6c0-.943 0-1.414-.293-1.707S5.943 9 5 9s-1.414 0-1.707.293M3 21.25a.75.75 0 0 0 0 1.5h18a.75.75 0 0 0 0-1.5z"/></svg>
										<span>{{ __('Dashboard') }}</span>
									</a>

									<a href="{{ route('user.profile') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 256 256"><path fill="currentColor" d="M128 24a104 104 0 1 0 104 104A104.11 104.11 0 0 0 128 24M74.08 197.5a64 64 0 0 1 107.84 0a87.83 87.83 0 0 1-107.84 0M96 120a32 32 0 1 1 32 32a32 32 0 0 1-32-32m97.76 66.41a79.66 79.66 0 0 0-36.06-28.75a48 48 0 1 0-59.4 0a79.66 79.66 0 0 0-36.06 28.75a88 88 0 1 1 131.52 0"/></svg>
										<span class="">{{ __('Profile') }}</span>
									</a>

									<a href="{{ route('user.purchases') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><rect width="10" height="10" x="12" y="2" fill="currentColor" rx="2"/><path fill="currentColor" d="M12 7h-1c-1.886 0-2.828 0-3.414.586S7 9.114 7 11v2c0 1.886 0 2.828.586 3.414S9.114 17 11 17h2c1.886 0 2.828 0 3.414-.586S17 14.886 17 13v-1h-1c-1.886 0-2.828 0-3.414-.586S12 9.886 12 8z" opacity=".7"/><path fill="currentColor" d="M7 12v1c0 1.886 0 2.828.586 3.414S9.114 17 11 17h1v1c0 1.886 0 2.828-.586 3.414S9.886 22 8 22H6c-1.886 0-2.828 0-3.414-.586S2 19.886 2 18v-2c0-1.886 0-2.828.586-3.414S4.114 12 6 12z" opacity=".4"/></svg>
										<span class="">{{ __('Purchases') }}</span>
									</a>

									<a href="{{ route('user.invoices') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"><path d="M21.25 6.861v6.342a2.06 2.06 0 0 1-.606 1.459l-5.982 5.982a2.06 2.06 0 0 1-1.46.606h-6.34a4.11 4.11 0 0 1-4.112-4.111V6.86a4.11 4.11 0 0 1 4.111-4.11H17.14a4.11 4.11 0 0 1 4.111 4.111"/><path d="m14.056 21.075l-.514-4.11a3.082 3.082 0 0 1 3.443-3.444l4.11.514M6.861 7.889h9.25M6.861 12h4.111m-4.111 4.111h3.083"/></g></svg>
										<span class="">{{ __('Invoices') }}</span>
									</a>

									<a href="{{ route('user.notifications') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 256 256"><path fill="currentColor" d="M221.8 175.94c-5.55-9.56-13.8-36.61-13.8-71.94a80 80 0 1 0-160 0c0 35.34-8.26 62.38-13.81 71.94A16 16 0 0 0 48 200h40.81a40 40 0 0 0 78.38 0H208a16 16 0 0 0 13.8-24.06M128 216a24 24 0 0 1-22.62-16h45.24A24 24 0 0 1 128 216m-80-32c7.7-13.24 16-43.92 16-80a64 64 0 1 1 128 0c0 36.05 8.28 66.73 16 80Z"/></svg>
										<span class="">{{ __('Notifications') }}</span>
									</a>

									@if(config('app.prepaid_credits.enabled'))
									<a href="{{ route('user.prepaid_credits') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 32 32"><path fill="currentColor" d="M18.963 4.188a.5.5 0 0 1 .705-.08l1.08.866L16.799 10h2.544l2.968-3.776l2.504 2.006a.5.5 0 0 1 .066.717L23.973 10h2.614a2.5 2.5 0 0 0-.522-3.331l-5.147-4.122a2.5 2.5 0 0 0-3.522.399L11.809 10h2.551zM21 19a1 1 0 1 0 0 2h3a1 1 0 1 0 0-2zM6 7a3 3 0 0 0-3 3v14.5A4.5 4.5 0 0 0 7.5 29h17a4.5 4.5 0 0 0 4.5-4.5v-9a4.5 4.5 0 0 0-4.5-4.5H6a1 1 0 1 1 0-2h4.58l1.596-2zM5 24.5V12.83c.313.11.65.17 1 .17h18.5a2.5 2.5 0 0 1 2.5 2.5v9a2.5 2.5 0 0 1-2.5 2.5h-17A2.5 2.5 0 0 1 5 24.5"/></svg>
										<span class="">{{ __('Prepaid credits') }}</span>
									</a>
									@endif

									@if(config('app.subscriptions.enabled'))
									<a href="{{ route('user.subscriptions') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="1.5" d="M21.838 11.126c.18-1.912.27-2.869-.057-3.264a1 1 0 0 0-.675-.367c-.476-.042-1.073.638-2.268 1.998c-.618.704-.927 1.055-1.271 1.11a.92.92 0 0 1-.562-.09c-.319-.16-.53-.595-.955-1.464l-2.237-4.584C13.011 2.822 12.61 2 12 2s-1.011.822-1.813 2.465L7.95 9.049c-.424.87-.636 1.304-.955 1.464a.93.93 0 0 1-.562.09c-.344-.055-.653-.406-1.271-1.11c-1.195-1.36-1.792-2.04-2.268-1.998a1 1 0 0 0-.675.367c-.327.395-.237 1.352-.057 3.264l.229 2.436c.378 4.012.566 6.019 1.75 7.228C5.322 22 7.094 22 10.64 22h2.719c3.545 0 5.317 0 6.5-1.21c.914-.935 1.234-2.345 1.507-4.79M9 18h6"/></svg>
										<span class="">{{ __('Memberships') }}</span>
									</a>
									@endif
									@if(intval(config('app.user_coupons_page')))
									<a href="{{ route('user.coupons') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.464 9.344c-.248 0-.475-.202-.464-.465c.067-1.542.255-2.546.78-3.34a4.7 4.7 0 0 1 1.11-1.174C5.055 3.5 6.7 3.5 9.992 3.5h4.014c3.292 0 4.937 0 6.104.865c.431.32.807.717 1.109 1.174c.525.794.713 1.798.78 3.34c.011.263-.216.465-.465.465c-1.386 0-2.51 1.189-2.51 2.656s1.124 2.656 2.51 2.656c.249 0 .476.202.465.466c-.067 1.541-.255 2.545-.78 3.34a4.7 4.7 0 0 1-1.11 1.173c-1.166.865-2.811.865-6.103.865H9.993c-3.292 0-4.937 0-6.104-.865a4.7 4.7 0 0 1-1.109-1.174c-.525-.794-.713-1.798-.78-3.34c-.011-.263.216-.465.464-.465c1.386 0 2.51-1.189 2.51-2.656S3.85 9.344 2.464 9.344M9.5 14.5l5-5m-5 0h.011m4.978 5h.011" color="currentColor"/></svg>
										<span class="">{{ __('Coupons') }}</span>
									</a>
									@endif

									<a href="{{ route('user.security') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 24 24"><path fill="currentColor" d="M13.995 11a2 2 0 0 1-1.245 1.852v2.398a.75.75 0 0 1-1.5 0v-2.394A2 2 0 1 1 13.995 11M3.75 5a.75.75 0 0 0-.75.75V11c0 5.001 2.958 8.676 8.725 10.948a.75.75 0 0 0 .55 0C18.042 19.676 21 16 21 11V5.75a.75.75 0 0 0-.75-.75c-2.663 0-5.258-.943-7.8-2.85a.75.75 0 0 0-.9 0C9.008 4.057 6.413 5 3.75 5m.75 6V6.478c2.577-.152 5.08-1.09 7.5-2.8c2.42 1.71 4.923 2.648 7.5 2.8V11c0 4.256-2.453 7.379-7.5 9.442C6.953 18.379 4.5 15.256 4.5 11"/></svg>
										<span class="">{{ __('Security') }}</span>
									</a>
									
									<a href="{{ route('logout') }}" class="flex p-[.5rem_.75rem] pb-[.35rem] gap-[.5rem]">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 12h9m0 0l-3.333-4M22 12l-3.333 4M14 7V5.174a2 2 0 0 0-2.166-1.993l-8 .666A2 2 0 0 0 2 5.84v12.32a2 2 0 0 0 1.834 1.993l8 .667A2 2 0 0 0 14 18.826V17"/></svg>
										<span class="">{{ __('Logout') }}</span>
									</a>
								</div>
							</div>
						</div>
						@endif
						<button id="left-sidebar-toggler" class="max-[1200px]:flex p-[.5rem_.75rem] border-[1px] rounded-[.25rem] h-[45px] hidden items-center bg-[#fff] text-[#67528c] border-[#67528c]">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path fill="currentColor" fill-rule="evenodd" d="M1.25 3.25A.75.75 0 0 1 2 2.5h12A.75.75 0 0 1 14 4H2a.75.75 0 0 1-.75-.75m0 4.75A.75.75 0 0 1 2 7.25h12a.75.75 0 0 1 0 1.5H2A.75.75 0 0 1 1.25 8M2 12a.75.75 0 0 0 0 1.5h12a.75.75 0 0 0 0-1.5z" clip-rule="evenodd"/></svg>
						</button>
					</div>
					
					{{-- BODY --}}
					<div class="body">
						@yield('body')
					</div>
					
					{{-- NEWSLETTER FORM --}}
					<div class="p-[1.5rem]" id="newsletter">
						<div class="w-full mx-auto max-[800px]:items-center max-[768px]:flex-wrap p-[2rem] bg-[#fafafa] rounded-[.25rem] flex justify-between border-[#ffffff21 gap-[1.5rem]">
							<div class="flex-1 max-[768px]:w-full">
								<div class="text-[1.5rem] font-[600]">{{ __('Sign up to our newsletter') }}</div>
								<div class="mt-[.5rem] opacity-75">{{ __('Stay updated! Subscribe to our newsletter for the latest digital products, exclusive offers, and free downloads') }}.</div>
							</div>
							<div class="w-[400px] max-[900px]:w-[350px] max-[768px]:w-full">
								<form class="flex items-center rounded-[.25rem] overflow-hidden" action="{{ route('home.newsletter') }}" method="POST">
									<input type="email" name="email" required class="w-full h-[65px] bg-[#5c46a7] px-[1rem] text-[#fff] border-0 focus:outline-none placeholder-[#cbd5e0]" placeholder="Enter your email address">
									<button class="p-[.5rem_1.5rem] h-[65px] bg-[#e6513d] text-[#fff] flex items-center font-[600]" type="submit">
										{{ __('Subscribe') }}
									</button>
								</form>
							</div>
						</div>
					</div>
					
					{{-- FOOTER --}}
					<div class="bg-[#5c46a7] text-[#fff] text-[1rem] " id="footer">
						<div class="grid grid-cols-3 max-[768px]:grid-cols-2 gap-[1.5rem] [&>div]:p-[2.5rem]">
							<div class="max-[768px]:hidden">
								<div class="text-[2.5rem] font-[600] mb-[.5rem]">{{ config('app.name') }}</div>
								<div class="text-[#b4b5c8]">{{ config('app.description') }}</div>
							</div>

							<div class="">
								<div class="font-[600] text-[1.3rem] mb-[1rem]">{{ __('Additional resources') }}</div>
								<div class="mb-[1rem] h-[.25rem] w-[30px] bg-[#ff9718] rounded-[.5rem]"></div>
								<div class="font-[400]">
									@foreach(config('pages', []) as $page)
									<a href="{{ route('home.page', ['slug' => $page['slug']]) }}" class="block mb-[.5rem]">{{ $page['name'] }}</a>
									@endforeach
								</div>
							</div>

							<div class="">
								<div class="font-[600] text-[1.3rem] mb-[1rem]">{{ __('Featured categories') }}</div>
								<div class="mb-[1rem] h-[.25rem] w-[30px] bg-[#ff9718] rounded-[.5rem]"></div>
								<div class="font-[400]">
									@foreach(array_slice(config('categories.category_parents', []), 0, 5) as $category)
									<a href="{{ category_url($category['slug']) }}" class="block mb-[.5rem]">{{ $category['name'] }}</a>
									@endforeach
								</div>
							</div>
						</div>

						<div class="flex items-end max-[768px]:grid max-[768px]:text-center max-[768px]:grid-cols-1 max-[768px]:gap-[1.5rem] px-[1.5rem] py-[1rem] bg-[#353652]">
							<div class="capitalize leading-[1]">{{ config('app.name') }} @ {{ date('Y') }} {{ __('All rights reserved') }}.</div>
							<div class="ml-auto max-[768px]:mx-auto flex items-center gap-[.5rem]">
								<div class="flex items-center gap-[.5rem] [&_img]:grayscale [&_img]:w-[30px]">
									@if(config('app.instagram'))
									<a href="{{ config('app.instagram') }}" class=""><img src="/assets/images/social/instagram.png"></a>
									@endif

									@if(config('app.vkontakte'))
									<a href="{{ config('app.vkontakte') }}" class=""><img src="/assets/images/social/vkontakte.png"></a>
									@endif

									@if(config('app.youtube'))
									<a href="{{ config('app.youtube') }}" class=""><img src="/assets/images/social/youtube.png"></a>
									@endif

									@if(config('app.twitter'))
									<a href="{{ config('app.twitter') }}" class=""><img src="/assets/images/social/twitter.png"></a>
									@endif

									@if(config('app.pinterest'))
									<a href="{{ config('app.pinterest') }}" class=""><img src="/assets/images/social/pinterest.png"></a>
									@endif
									
									@if(config('app.tiktok'))
									<a href="{{ config('app.tiktok') }}" class=""><img src="/assets/images/social/tiktok.png"></a>
									@endif

									@if(config('app.linkedin'))
									<a href="{{ config('app.linkedin') }}" class=""><img src="/assets/images/social/linkedin.png"></a>
									@endif

									@if(config('app.reddit'))
									<a href="{{ config('app.reddit') }}" class=""><img src="/assets/images/social/reddit.png"></a>
									@endif

									@if(config('app.whatsapp'))
									<a href="{{ config('app.whatsapp') }}" class=""><img src="/assets/images/social/whatsapp.png"></a>
									@endif

									@if(config('app.tumblr'))
									<a href="{{ config('app.tumblr') }}" class=""><img src="/assets/images/social/tumblr.png"></a>
									@endif

									@if(config('app.telegram'))
									<a href="{{ config('app.telegram') }}" class=""><img src="/assets/images/social/telegram.png"></a>
									@endif
								</div>
							</div>	
						</div>
					</div>
					
					{{-- COOKIE --}}
					@if(strlen(config('app.cookie.text', '')))
					<div class="hidden w-full fixed bottom-0 left-0 bg-[rgb(42_46_60/92%)] backdrop-blur-[5px] text-[#fff] text-[1rem] z-[9]" style="{{ config('app.cookie.background') ? ("background:".config('app.cookie.background')) : '' }}; {{ config('app.cookie.color') ? ("color:".config('app.cookie.color')) : '' }}">
						<button class="absolute right-[1rem] top-[1rem] rounded-full bg-[#ff8a18] hover:bg-[#ff6718] transition-all p-[.5rem] w-[30px] h-[30px] flex items-center justify-center font-[system-ui] text-[#fff] font-[500]">✕</button>

						<div class="max-w-[1200px] flex items-center mx-auto">
							<div class="p-[1.5rem]">
								<img src="/assets/images/cookie-2.svg" class="w-[80px] h-[80px]">
							</div>
							<div class="p-[1.5rem] pl-0 flex-1 font-[400]">
								{!! config('app.cookie.text') !!}
							</div> 
						</div>
					</div>
					@endif
					
					@if(intval(config('app.fake_purchases.enabled')) === 1)
					{{-- SALES NOTIFICATION --}}
					<div id="recent-purchase-popup" v-if="Object.keys(recentPurchase).length" class="hidden fixed bottom-[1rem] left-[1rem] overflow-hidden bg-[#fff] rounded-b-[.5rem] border-t-[.25rem] border-t-[#ff8938] flex z-[10] max-w-[380px] w-full text-[1rem] shadow-[0_0_30px_-20px_#00000070] p-[1rem]">
						<a :href="recentPurchase.url" class="w-[120px] bg-cover bg-center flex rounded-[.25rem]" :style="'background-image: url(' + recentPurchase.cover + ')'">
						</a>

						<div class="pl-[1rem] flex-1 text-[.9rem]">
							<div class="flex items-end gap-[.5rem]">
								<div class="font-[600] leading-[1] whitespace-nowrap">@{{ recentPurchase.name.shorten(10) }}</div>
								<div class="flex items-center gap-[.15rem] ml-auto" v-html="recentPurchase.html_rating"></div>
							</div>

							<div class="my-[1rem]"></div>

							<div class="">
								<div class="font-[600] mb-[.25rem]">{{ __('Recently purchased') }}</div>
								<a :href="recentPurchase.url" class="block">@{{ recentPurchase.item_name.shorten(40) }}</a>
							</div>

							<div class="mt-[.75rem] text-[#004e43]">
								<div class="flex items-end justify-end gap-[.25rem]">
									<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 256 256"><path fill="currentColor" d="M225.86 102.82c-3.77-3.94-7.67-8-9.14-11.57c-1.36-3.27-1.44-8.69-1.52-13.94c-.15-9.76-.31-20.82-8-28.51s-18.75-7.85-28.51-8c-5.25-.08-10.67-.16-13.94-1.52c-3.56-1.47-7.63-5.37-11.57-9.14C146.28 23.51 138.44 16 128 16s-18.27 7.51-25.18 14.14c-3.94 3.77-8 7.67-11.57 9.14c-3.25 1.36-8.69 1.44-13.94 1.52c-9.76.15-20.82.31-28.51 8s-7.8 18.75-8 28.51c-.08 5.25-.16 10.67-1.52 13.94c-1.47 3.56-5.37 7.63-9.14 11.57C23.51 109.72 16 117.56 16 128s7.51 18.27 14.14 25.18c3.77 3.94 7.67 8 9.14 11.57c1.36 3.27 1.44 8.69 1.52 13.94c.15 9.76.31 20.82 8 28.51s18.75 7.85 28.51 8c5.25.08 10.67.16 13.94 1.52c3.56 1.47 7.63 5.37 11.57 9.14c6.9 6.63 14.74 14.14 25.18 14.14s18.27-7.51 25.18-14.14c3.94-3.77 8-7.67 11.57-9.14c3.27-1.36 8.69-1.44 13.94-1.52c9.76-.15 20.82-.31 28.51-8s7.85-18.75 8-28.51c.08-5.25.16-10.67 1.52-13.94c1.47-3.56 5.37-7.63 9.14-11.57c6.63-6.9 14.14-14.74 14.14-25.18s-7.51-18.27-14.14-25.18m-52.2 6.84l-56 56a8 8 0 0 1-11.32 0l-24-24a8 8 0 0 1 11.32-11.32L112 148.69l50.34-50.35a8 8 0 0 1 11.32 11.32"/></svg>
									<span class="font-[600] tracking-[.2px]">{{ __('Verified') }}</span>
								</div>
							</div>
						</div>
					</div>
					</div>
					@endif

					{{-- USER MESSAGE --}}
					<div class="hidden [&.active]:flex fixed z-[9] top-0 bg-[#00000078] backdrop-blur-[10px] left-0 w-full h-full overflow-hidden items-center justify-center {{ session('user_message') ? 'active' : '' }}" id="user-message">
						<div class="text-[#000] rounded-b-[.25rem] border-t-[.25rem] border-[#ff985a] bg-[#fff] overflow-hidden relative max-w-[400px] w-full text-[1rem]">
							<div class="p-[1rem] flex items-baseline justify-between">
								<div class="font-[600] text-[1.1rem]">{{ __('Notification') }}</div>
								<div class="bg-[#ffd68b] rounded-[.5rem] p-[.25rem] w-[30px] h-[30px] flex justify-center items-center ml-auto">
									<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><g fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M13.253 5.98L12 13.5l-1.253-7.52a1.27 1.27 0 1 1 2.506 0"/><circle cx="12" cy="19" r="1" stroke-width="2"/></g></svg>
								</div>
							</div>
							<div class="p-[1rem] py-[1.5rem] min-h-[150px] border-y-[1px] border-[#f4f4f4]">
								<div class="text-[#676767] font-[500] message">{!! session('user_message') !!}</div>
							</div>
							<div class="p-[1rem]">
								<button id="close-user-message" class="p-[.5rem_1rem] flex items-center text-[#fff] gap-[1rem] max-w-[120px] w-full items-center justify-center bg-[#00a0bd] rounded-[.25rem]">
									<div class="">{{ __('Close') }}</div>
								</button>
							</div>
						</div>
					</div>

					{{-- VIDEO PLAYER --}}
					<div class="video-player fixed h-full w-full top-0 left-0 z-[9] bg-[#000000d9] hidden [&.active]:flex items-center justify-center p-[2rem]">
						<div class="max-w-[900px] w-full">
							<div class="player bg-[#252525] pb-[55px] relative" data-type="video" data-ready="false" data-full="false">
								<video class="flex h-auto object-fit w-full" src="https://previews.customer.envatousercontent.com/h264-video-previews/2a2aab99-5ec8-4836-85c8-e5004e9e8ffb/46925833.mp4" type="video/mp4"></video>
								<div class="controls flex gap-[.75rem] h-[55px] flex items-center justify-between bg-[#232323] backdrop-blur-[15px] p-[.5rem_1rem] w-full absolute bottom-0 left-0 z-[2]">
									<div class="play flex items-center justify-center w-[30px] h-[30px] invert cursor-pointer"><img src="/assets/images/pause.png"></div>
									<div class="wave bg-[#fff] relative w-full h-[40px]" style="-webkit-mask-image: url(/assets/images/waves.svg); -webkit-mask-position: center; -webkit-mask-repeat: no-repeat; -webkit-mask-size: contain;"><span class="time bg-[#ff9e22] absolute w-0 top-0 left-0 h-full"></span></div>
									<div class="stop flex items-center justify-center w-[30px] h-[30px] invert cursor-pointer"><img src="/assets/images/stop.png"></div>
								</div>
							</div>
						</div>	
					</div>
				</div>
			</div>
		</div>

		@yield('footer_tags')

		<script src="{{ src('assets/axies.js') }}"></script>
	</div>
</body>
</html>