@extends('front.axies.master')

@section('body')
<div class="p-[1.5rem]" id="pricing">
	<div class="uppercase bg-[#fff] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem] mb-[1rem]">
		@foreach(config('categories.category_parents') as $category)
		<a href="{{ category_url($category['slug']) }}" class="whitespace-nowrap py-[.5rem] leading-[1]">{{ $category['name'] }}</a>
		@if(!$loop->last)
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@endif
		@endforeach
	</div>

	<div class="text-center mb-[2rem] min-h-[300px] flex flex-col justify-center items-center p-[2rem_1.5rem] bg-[#655fff0f] text-[#000] border-b-[.25rem] border-[#655fff] mb-[3rem] rounded-t-[.25rem]">
		<div class="">
			<div class="text-[2.5rem] font-[700] capitalize mb-[1.5rem]">{{ __('FAQ & Support') }}</div>
			<div class="text-[1.2rem] leading-[1.8] max-w-[700px] mx-auto">{{ __("Dedicated Support for Your Digital Marketplace: Always Here to Help with Quick Solutions, Expert Guidance, and 24/7 Assistance to Ensure Your Success") }}</div>
		</div>
	</div>

	<div class="flex gap-[2rem] flex-wrap max-[1200px]:grid max-[1200px]:grid-cols-1">
		<div class="flex-1">
			{{-- FAQ --}}
			@if($faqs->count())
			<div class="">
				<div class="uppercase cursor-pointer text-[.9rem] font-[600] bg-[#f6f5ff] flex items-center justify-between gap-[1rem] rounded-[.25rem] p-[1.5rem]" id="faq-toggler">
					{{ __('Frequently asked questions') }}
					<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 9l-7 7l-7-7"/></svg>
				</div>
				<div class="mt-[2rem] hidden">
					@foreach($faqs as $faq)
					<div class="{{ !$loop->last ? 'mb-[2rem]' : '' }}">
						<div class="mb-[1rem] font-[600]">{{ $faq->question }}</div>
						<div class="opacity-[.8]">{!! $faq->answer !!}</div>
					</div>
					@endforeach
				</div>
			</div>

			<div class="my-[2rem] border-t-[1px]"></div>
			@endif

			{{-- PAGE DESCRIPTION --}}
			@if($support && strlen(strip_tags($support->content ?? '')))
			<div class="">
				{!! $support->content !!}
			</div>
			@endif
		</div>

		<div action="{{ route('home.support') }}" method="POST" class="max-w-[360px] w-full max-[1200px]:max-w-full" id="contact-form">
			<form action="{{ route('home.support') }}" method="POST" class="p-[1.5rem] bg-[#655fff0f] rounded-[.5rem]">
				@csrf
				<div class="mb-[2rem] pb-[1.5rem] border-b-[1px] text-[.9rem] font-[600] uppercase">
					{{ __("Need any assistance ?") }}
				</div>

				@if(session('support_response'))
				<div class="my-[1.5rem] bg-[#009f8d] rounded-[.25rem] text-[#fff] p-[1rem]">{{ session('support_response') }}</div>
				@endif

				<div class="mb-[1rem]">
					<label class="mb-[.5rem] font-semibold block">{{ __('Email address') }}</label>
					<input type="email" name="email" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="..." required="">
				</div>
				<div class="mb-[1rem]">
					<label class="mb-[.5rem] font-semibold block">{{ __('Subject') }}</label>
					<input type="text" name="subject" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="..." required="">
				</div>
				<div class="mb-[1rem]">
					<label class="mb-[.5rem] font-semibold block">{{ __('Message') }}</label>
					<textarea name="message" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d] h-[200px] resize-none" placeholder="{{ __('Enter your message') }}" required=""></textarea>
				</div>
				<button class="text-[1.2rem] px-[1rem] py-[.75rem] font-[500] text-[#000] flex items-center rounded-[.25rem] h-[45px] bg-[#ffd043]">{{ __('Submit') }}</button>
			</form>
		</div>
	</div>
</div>
@endsection