@extends('front.axies.user.master')

@section('user_page')
<div class="" data-tab="collection">
	<div class="">
		<div v-if="userCollectionIsReady" class="gap-[1.5rem] grid grid-cols-4 max-[1400px]:grid-cols-3 max-[768px]:grid-cols-2 max-[650px]:grid-cols-1">
			<div v-for="item in favorites" class="overflow-hidden grid grid-cols-2 rounded-[.25rem] overflow-hidden shadow-[0_0_20px_10px_#00000005] h-[150px]">
				<div class="relative">
					<a :href="item.url" class="rounded-l-[.25rem] flex bg-center bg-cover w-full h-full" :style="'background-image:url(' + item.cover + ')'"></a>
				</div>
				<div class="p-[1rem] flex items-start justify-center relative">
					<a :href="item.url" class="block font-[500] break-all text-[.8rem]">@{{ item.name }}</a>
					<svg :data-id="item.id" class="remove-from-collection right-[.25rem] bottom-[.25rem] absolute cursor-pointer" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="m12 13.4l-2.9 2.9q-.275.275-.7.275t-.7-.275t-.275-.7t.275-.7l2.9-2.9l-2.9-2.875q-.275-.275-.275-.7t.275-.7t.7-.275t.7.275l2.9 2.9l2.875-2.9q.275-.275.7-.275t.7.275q.3.3.3.713t-.3.687L13.375 12l2.9 2.9q.275.275.275.7t-.275.7q-.3.3-.712.3t-.688-.3z"/></svg>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection