@extends('front.axies.user.master')

@section('user_page')
<div class="" data-tab="dashboard">
	<div class="grid grid-cols-4 max-[1024px]:grid-cols-3 max-[1024px]:[&>div:nth-child(n+7)]:hidden max-[768px]:grid-cols-2 max-[400px]:grid-cols-1 gap-[1rem] [&>div]:shadow-[0_0_20px_10px_#00000005] [&>div]:rounded-[.25rem] [&>div]:overflow-hidden [&>div]:flex mb-[1.5rem]">
		<div class="bg-[linear-gradient(45deg,#f5f4f5,#ffffff)]">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex border-b-[1px] border-[#e6e6e6] items-center font-[600] uppercase p-[1rem]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Orders') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $orders ?? '0' }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex border-b-[1px] border-[#e6e6e6] items-center leading-[1] font-[600] uppercase p-[1rem]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Comments') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $comments ?? '0' }}</div>
			</div>
		</div>
		<div class="bg-[linear-gradient(45deg,#f5f4f5,#ffffff)]">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex border-b-[1px] border-[#e6e6e6] items-center leading-[1] font-[600] uppercase p-[1rem]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Reviews') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $reviews ?? '0' }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex border-b-[1px] border-[#e6e6e6] items-center leading-[1] font-[600] uppercase p-[1rem]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Subscriptions') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $subscriptions ?? '0' }}</div>
			</div>
		</div>
		<div class="bg-[linear-gradient(-45deg,#f5f4f5,#ffffff)]">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex border-b-[1px] border-[#e6e6e6] items-center leading-[1] font-[600] uppercase p-[1rem]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Credits') }}</div>
				<div class="p-[1rem] h-[55px]">{{ price($credits, false) }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex border-b-[1px] border-[#e6e6e6] items-center leading-[1] font-[600] uppercase p-[1rem]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Referred users') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $referred_users ?? '0' }}</div>
			</div>
		</div>
		<div class="opacity-50">
			<div class="flex-1">
				&nbsp;
			</div>
		</div>
		<div class="opacity-50">
			<div class="flex-1">
				&nbsp;
			</div>
		</div>
	</div>

	<div class="">
		<div class="font-[600] capitalize mb-[1rem] mt-[2rem]">{{ __('Latest orders') }}</div>
		<div class="relative overflow-auto scrollbar-width-[none]">
			<table class="table w-full text-[1rem] overflow-x-auto">
				<thead class="bg-[#555270] text-[#fff]">
					<tr class="[&>th]:p-[.75rem_1rem] [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
						<th class="rounded-tl-[.25rem] text-left">{{ __('Order ID') }}</th>
						<th>{{ __('Amount') }}</th>
						<th>{{ __('items') }}</th>
						<th>{{ __('Type') }}</th>
						<th>{{ __('Date') }}</th>
						<th class="rounded-tr-[.25rem]">{{ __('Status') }}</th>
					</tr>
				</thead>
				<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
					@foreach($last_orders as $last_order)
					<tr class="[&>td]:p-[.75rem_1rem] [&>td:not(:last-child)]:border-r-[1px]">
						<td class="">{{ $last_order->reference_id }}</td>
						<td class="text-center">{{ price($last_order->amount, false) }}</td>
						<td class="text-center">{{ count(explode(',', $last_order->products_ids)) }}</td>
						<td class="text-center uppercase text-[.9rem]">{{ $last_order->type }}</td>
						<td class="text-center">{{ $last_order->created_at->format('Y-m-d H:i') }}</td>
						<td class="">
							<div class="{{ $last_order->status }} w-fit mx-auto text-center [&.paid]:bg-[rgb(5_224_127/15%)] [&.pending]:bg-[rgb(255_117_92/4%)] min-w-[80px] p-[.5rem_.75rem] pb-[.35rem] text-[.9rem] font-[600] rounded-[.25rem] [&.paid]:text-[#096d63] [&.pending]:text-[#ff755c] capitalize">{{ __($last_order->status) }}</div>
						</td>
					</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection