@extends('front.axies.user.master')

@section('user_page')
<div class="" data-tab="invoices">
	<div class="relative overflow-auto scrollbar-width-[none]">
		<table class="table w-full text-[1rem] overflow-x-auto">
			<thead class="bg-[#555270] text-[#fff]">
				<tr class="[&>th]:p-[.75rem] [&>th]:text-center [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
					<th class="rounded-tl-[.25rem]">{{ __('Reference ID') }}</th>
					<th>{{ __('Amount') }}</th>
					<th>{{ __('Date') }}</th>
					<th class="rounded-tr-[.25rem]">{{ __('Export') }}</th>
				</tr>
			</thead>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				@foreach($invoices ?? [] as $invoice)
				<tr class="[&>td]:p-[.75rem_1rem] [&>td]:text-center [&>td:not(:last-child)]:border-r-[1px]">
					<td>{{ $invoice->reference_id }}</td>
					<td>{{ price($invoice->amount, false)  }}</td>
					<td class="">{{ $invoice->created_at->format('Y-m-d H:i') }}</td>
					<td class="p-[.5rem_.75rem]">
						@if(config('app.invoice.template', 1) == 1)
						<button class="bg-[#fff] mx-auto shadow-[0_0_1px_0px_#6e7e8e] text-[#6e7e8e] font-[500] rounded-[.25rem] p-[.5rem_.75rem] flex gap-[.5rem] [&:hover>svg]:rotate-[360deg]" @click="downloadItem({{ $invoice->id }}, '#download-invoice')">
							<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" class="transition-all duration-700"><path fill="currentColor" fill-rule="evenodd" d="M2 12c0-4.714 0-7.071 1.464-8.536C4.93 2 7.286 2 12 2c4.714 0 7.071 0 8.535 1.464C22 4.93 22 7.286 22 12c0 4.714 0 7.071-1.465 8.535C19.072 22 16.714 22 12 22s-7.071 0-8.536-1.465C2 19.072 2 16.714 2 12m10-5.75a.75.75 0 0 1 .75.75v5.19l1.72-1.72a.75.75 0 1 1 1.06 1.06l-3 3a.75.75 0 0 1-1.06 0l-3-3a.75.75 0 1 1 1.06-1.06l1.72 1.72V7a.75.75 0 0 1 .75-.75m-4 10a.75.75 0 0 0 0 1.5h8a.75.75 0 0 0 0-1.5z" clip-rule="evenodd"/></svg>
							{{ __('Download') }}
						</button>
						@else
						<button class="bg-[#fff] mx-auto shadow-[0_0_1px_0px_#6e7e8e] text-[#6e7e8e] font-[500] rounded-[.25rem] p-[.5rem_.75rem] flex gap-[.5rem] [&:hover>svg]:rotate-[360deg]" @click="downloadInvoice({{ $invoice->id }}, '#download-invoice')">
							<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" class="transition-all duration-700"><path fill="currentColor" fill-rule="evenodd" d="M2 12c0-4.714 0-7.071 1.464-8.536C4.93 2 7.286 2 12 2c4.714 0 7.071 0 8.535 1.464C22 4.93 22 7.286 22 12c0 4.714 0 7.071-1.465 8.535C19.072 22 16.714 22 12 22s-7.071 0-8.536-1.465C2 19.072 2 16.714 2 12m10-5.75a.75.75 0 0 1 .75.75v5.19l1.72-1.72a.75.75 0 1 1 1.06 1.06l-3 3a.75.75 0 0 1-1.06 0l-3-3a.75.75 0 1 1 1.06-1.06l1.72 1.72V7a.75.75 0 0 1 .75-.75m-4 10a.75.75 0 0 0 0 1.5h8a.75.75 0 0 0 0-1.5z" clip-rule="evenodd"/></svg>
							{{ __('Download') }}
						</button>
						@endif
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

	<form action="{{ route('home.export_invoice') }}" class="d-none" method="post" id="download-invoice">
		@csrf
		<input type="hidden" name="itemId" v-model="itemId">
	</form>

	@if($invoices->hasPages())
	<div class="mt-[1.5rem]">
		{{ $invoices->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection