@extends('front.axies.user.master')

@section('user_page')
<form data-tab="profile" enctype="multipart/form-data" action="{{ route('user.profile') }}" method="POST">
	@csrf
	<input type="file" name="avatar" accept="*/image" class="hidden">

	<div class="[&_input]:font-[400]">
		@if(!$user->email_verified_at)
		<div class="mb-[1.5rem]">
			<button type="button" id="verify-email" class="[&.disabled]:opacity-[.5] p-[.5rem_1rem] relative overflow-hidden flex items-center gap-x-[1rem] bg-[#3c3548] text-[#fff] rounded-[.25rem]">
				<div class="absolute bg-[#ffa007] text-[#000] left-0 top-0 w-[40px] h-full flex items-center justify-center icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 56 56"><path fill="#000" d="M9.484 48.191h37.734c4.22 0 6.657-2.437 6.657-7.265V15.05c0-4.805-2.46-7.242-7.36-7.242H8.782c-4.195 0-6.656 2.414-6.656 7.242v25.875c0 4.851 2.484 7.265 7.36 7.265m15.727-19.007L7.516 11.723c.515-.211 1.124-.328 1.851-.328h37.29c.726 0 1.359.117 1.898.375L30.883 29.184c-1.008 1.007-1.899 1.453-2.836 1.453c-.938 0-1.828-.446-2.836-1.453M5.71 40.926v-26.11l13.476 13.22L5.734 41.323c-.023-.117-.023-.258-.023-.398m44.578-25.852v26.18L36.906 28.035L50.29 14.887zM9.367 44.606c-.68 0-1.242-.094-1.734-.305l14.015-13.852l1.524 1.5c1.64 1.617 3.21 2.297 4.875 2.297c1.64 0 3.234-.68 4.875-2.297l1.523-1.5l13.993 13.828c-.493.235-1.102.328-1.782.328Z"/></svg>
				</div>
				<div class="pl-[40px]">{{ __('Verify your email address') }}</div>
			</button>
		</div>

		<div class="my-[1.5rem] border-b-[1px]"></div>
		@endif

		<div class="mb-[1.5rem] gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Username') }}</label>
				<input type="text" name="name" value="{{ old('name', $user->name) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter a username') }}">
			</div>
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Affiliate name') }}</label>
				<input type="text" name="affiliate_name" value="{{ old('affiliate_name', $user->affiliate_name) }}"  class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter an affiliate name') }}">
			</div>
		</div>
		<div class="mb-[1.5rem] gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Firstname') }}</label>
				<input type="text" name="firstname" value="{{ old('firstname', $user->firstname) }}"  class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your first name') }}">
			</div>
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Lastname') }}</label>
				<input type="text" name="lastname" value="{{ old('lastname', $user->lastname) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your last name') }}">
			</div>
		</div>
		<div class="mb-[1.5rem] gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Country') }}</label>
				<input type="text" name="country" value="{{ old('country', $user->country) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your country') }}">
			</div>
			<div class="">
				<label class="mb-[.5rem] block">{{ __('City') }}</label>
				<input type="text" name="city" value="{{ old('city', $user->city) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your city') }}">
			</div>
		</div>
		<div class="mb-[1.5rem] gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Address') }}</label>
				<input type="text" name="address" value="{{ old('address', $user->address) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your address') }}">
			</div>
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Phone') }}</label>
				<input type="text" name="phone" value="{{ old('phone', $user->phone) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your phone number') }}">
			</div>
		</div>
		<div class="mb-[1.5rem] gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
			<div class="">
				<label class="mb-[.5rem] block">{{ __('ID number') }}</label>
				<input type="text" name="id_number" value="{{ old('id_number', $user->id_number) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your ID number') }}">
			</div>
			<div class="">
				<label class="mb-[.5rem] block">{{ __('Zip code') }}</label>
				<input type="text" name="zip_code" value="{{ old('zip_code', $user->zip_code) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your zip code') }}">
			</div>
		</div>
		<div class="mb-[1.5rem]">
			<label class="mb-[.5rem] block">State</label>
			<input type="text" name="state" value="{{ old('state', $user->state) }}" class="focus:outline-0 rounded-[.25rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="Enter your state">
		</div>
		<div class="mb-[1.5rem]">
			<label class="mb-[.5rem] block">{{ __('Receive notifications via email') }}</label>
			<div class="single-selection">
				<div class="relative group">
					<input type="hidden" name="receive_notifs" value="{{ old('receive_notifs', $user->receive_notifs ?? '0') }}">
					<div class="default font-[400] text-[#000] rounded-[.25rem] border-[1px] px-[.75rem] py-[0] flex items-center h-[50px] capitalize">Yes</div>
					<div class="absolute hidden pb-[.5rem] left-[0] bottom-full z-[9] w-full">
						<div class="text-[1.1rem] bg-[#fff] w-full max-h-[320px] overflow-auto rounded-[.75rem] shadow-lg dark:bg-[#39405d]">
							<a role="button" data-value="0" class="option px-[1rem] py-[.5rem] block hover:bg-[aliceblue]">{{ __('No') }}</a>
							<a role="button" data-value="1" class="option px-[1rem] py-[.5rem] block hover:bg-[aliceblue]">{{ __('Yes') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>

		@if(config('affiliate.enabled') && mb_strlen($user->affiliate_name))
		<div class="mb-[1.5rem]">
			<label class="mb-[.5rem] block {{ $user->cashout_method === "paypal_account"  ? 'active' : '' }}">{{ __('Earnings cashout method') }}</label>
			<div class="single-selection">
				<div class="relative group">
					<input type="hidden" name="cashout_method" value="{{ old('cashout_method', $user->cashout_method) }}">
					<div class="default font-[400] text-[#000] rounded-[.5rem] border-[1px] px-[.75rem] py-[0] flex items-center h-[50px] capitalize">...</div>
					<div class="absolute hidden pb-[.5rem] left-[0] bottom-full z-[9] w-full">
						<div class="text-[1.1rem] bg-[#fff] w-full max-h-[320px] overflow-auto rounded-[.75rem] shadow-lg dark:bg-[#39405d]">
							<a role="button" data-value="" class="option px-[1rem] py-[.5rem] block hover:bg-[aliceblue]">&nbsp;</a>
							<a role="button" data-value="paypal_account" class="option px-[1rem] py-[.5rem] block hover:bg-[aliceblue]">{{ __('PayPal account') }}</a>
							<a role="button" data-value="bank_account" class="option px-[1rem] py-[.5rem] block hover:bg-[aliceblue]">{{ __('Bank transfer') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="">
			@if(config('affiliate.cashout_methods.paypal_account'))
			<div class="mb-[1.5rem] hidden [&.active]:block {{ $user->cashout_method === "paypal_account"  ? 'active' : '' }}" data-payout-method="paypal_account">
				<label class="mb-[.5rem] block">{{ __('PayPal Email Address') }}</label>
				<input type="text" name="paypal_account" value="{{ old('paypal_account', $user->paypal_account) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
			</div>
			@endif

			@if(config('affiliate.cashout_methods.bank_account'))
			<div class="hidden [&.active]:block {{ $user->cashout_method === "bank_account"  ? 'active' : '' }}" data-payout-method="bank_account">
				<div class="mb-[1.5rem] gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
					<div class="">
						<label class="mb-[.5rem] block">{{ __('Bank address') }}</label>
						<input type="text" name="bank_account[bank_address]" value="{{ old('bank_account.bank_address', $user->bank_account->bank_address ?? null) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					</div>

					<div class="">
						<label class="mb-[.5rem] block">{{ __('Account holder name') }}</label>
						<input type="text" name="bank_account[holder_name]" value="{{ old('bank_account.holder_name', $user->bank_account->holder_name ?? null) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					</div>
				</div>

				<div class="mb-[1.5rem] gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
					<div class="">
						<label class="mb-[.5rem] block">{{ __('Account holder address') }}</label>
						<input type="text" name="bank_account[holder_address]" value="{{ old('bank_account.holder_address', $user->bank_account->holder_address ?? null) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					</div>

					<div class="">
						<label class="mb-[.5rem] block">{{ __('Account number') }}</label>
						<input type="text" name="bank_account[account_number]" value="{{ old('bank_account.account_number', $user->bank_account->account_number ?? null) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					</div>
				</div>

				<div class="gap-[1.5rem] grid grid-cols-2 max-[500px]:grid-cols-1">
					<div class="">
						<label class="mb-[.5rem] block">{{ __('IBAN Code') }}</label>
						<input type="text" name="bank_account[iban]" value="{{ old('bank_account.iban', $user->bank_account->iban ?? null) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					</div>

					<div class="">
						<label class="mb-[.5rem] block">{{ __('SWIFT Code') }}</label>
						<input type="text" name="bank_account[swift]" value="{{ old('bank_account.swift', $user->bank_account->swift ?? null) }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					</div>
				</div>
			</div>
			@endif
		</div>
		@endif
	</div>

	<div class="my-[1.5rem] border-t-[1px]"></div>

	<div class="">
		<button class="p-[.75rem_.75rem_.5rem] font-[600] rounded-[.35rem] bg-[#353847] text-[#fff] text-[1rem] uppercase">{{ __('Save changes') }}</button>
	</div>
</form>
@endsection