@extends('front.axies.user.master')

@section('user_page')
<div class="" data-tab="purchases">
	<div class="relative overflow-auto scrollbar-width-[none]">
		<table class="table w-full text-[1rem]">
			<thead class="bg-[#555270] text-[#fff]">
				<tr class="[&>th]:p-[.75rem_1rem] [&>th]:text-center [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
					<th class="rounded-tl-[.25rem]"><div class="">{{ __('Order ID') }}</div></th>
					<th class=""><div class="">{{ __('Item') }}</div></th>
					<th class=""><div class="">{{ __('Status') }}</div></th>
					<th class=""><div class="">{{ __('Date') }}</div></th>
					<th class="rounded-tr-[.25rem]"></th>
				</tr>
			</thead>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				@foreach($transactions as $transaction)
					@foreach($transaction->items ?? [] as $item)
					<tr class="font-[400] parent">
						<td class="uppercase font-[500] text-[.9rem] text-left p-[.75rem_1rem]">
							{{ $transaction->reference_id }}
						</td>
						<td class="capitalize p-[.75rem_1rem] text-left">
							<a href="">{{ fake()->text(rand(60, 80)) }}</a>
						</td>
						<td class="{{ $transaction->status }} p-[.75rem_1rem]">
							<div class="p-[.5rem_.75rem] text-center font-[500] rounded-[.25rem] [&.paid]:text-[#096d63] [&.paid]:bg-[#05e07f26] [&.pending]:text-[#ff755c] [&.pending]:bg-[#ff755c0a] capitalize {{ $transaction->status }}">{{ $transaction->status }}</div>
						</td>
						<td class="p-[.75rem_1rem] text-[.9rem]">{{ format_date((string)$transaction->created_at, 'Y-m-d H:i') }}</td>
						<td class="p-[.75rem_1rem]">
							@if(!isset($item->license))
							<a href="{{ $item->file }}" class="bg-[#fff] shadow-[0_0_1px_0px_#6e7e8e] text-[#6e7e8e] font-[500] rounded-[.35rem] p-[.5rem_.75rem] flex gap-[.5rem] [&:hover>svg]:rotate-[360deg]">
								<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" class="transition-all duration-700"><path fill="currentColor" fill-rule="evenodd" d="M2 12c0-4.714 0-7.071 1.464-8.536C4.93 2 7.286 2 12 2c4.714 0 7.071 0 8.535 1.464C22 4.93 22 7.286 22 12c0 4.714 0 7.071-1.465 8.535C19.072 22 16.714 22 12 22s-7.071 0-8.536-1.465C2 19.072 2 16.714 2 12m10-5.75a.75.75 0 0 1 .75.75v5.19l1.72-1.72a.75.75 0 1 1 1.06 1.06l-3 3a.75.75 0 0 1-1.06 0l-3-3a.75.75 0 1 1 1.06-1.06l1.72 1.72V7a.75.75 0 0 1 .75-.75m-4 10a.75.75 0 0 0 0 1.5h8a.75.75 0 0 0 0-1.5z" clip-rule="evenodd"/></svg>
								{{ __('Download') }}
							</a>
							@else
							<div class="group relative">
								<div href="{{ $item->file }}" class="select-none bg-[#fff] shadow-[0_0_1px_0px_#6e7e8e] text-[#6e7e8e] font-[500] rounded-[.35rem] p-[.5rem_.75rem] flex gap-[.5rem] [&:hover>svg]:rotate-[360deg]">
									<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" class="transition-all duration-700"><path fill="currentColor" fill-rule="evenodd" d="M2 12c0-4.714 0-7.071 1.464-8.536C4.93 2 7.286 2 12 2c4.714 0 7.071 0 8.535 1.464C22 4.93 22 7.286 22 12c0 4.714 0 7.071-1.465 8.535C19.072 22 16.714 22 12 22s-7.071 0-8.536-1.465C2 19.072 2 16.714 2 12m10-5.75a.75.75 0 0 1 .75.75v5.19l1.72-1.72a.75.75 0 1 1 1.06 1.06l-3 3a.75.75 0 0 1-1.06 0l-3-3a.75.75 0 1 1 1.06-1.06l1.72 1.72V7a.75.75 0 0 1 .75-.75m-4 10a.75.75 0 0 0 0 1.5h8a.75.75 0 0 0 0-1.5z" clip-rule="evenodd"/></svg>
									{{ __('Download') }}
								</div>
							    <div class="hidden absolute z-[1] bottom-[100%] right-0 group-hover:block">
							        <div class="text-[#000] text-[1rem] bg-[#fff] mb-[.5rem] shadow-[0px_10px_25px_-20px_#00000069] min-w-[200px] rounded-b-[.25rem] overflow-hidden">
							            <a href="{{ $item->file }}" class="block p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] hover:bg-[whitesmoke]">{{ __('Main file') }}</a>
							            <a href="{{ $item->license }}" class="block p-[.5rem_.75rem] pb-[.35rem] hover:bg-[whitesmoke]">{{ __('License key') }}</a>
							        </div>
							    </div>
							</div>
							@endif
						</td>
					</tr>
					@endforeach
				@endforeach
			</tbody>
		</table>
	</div>

	@if($transactions->hasPages())
	<div class="mt-[1.5rem]">
		{{ $transactions->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection