<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>{{ __('Order success') }}</title>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link rel="stylesheet" href="{{ src("assets/tendra.css") }}">
		<style>
			@php $font = "Spartan" @endphp

			html * {
				font-size: 1rem;
			}

			@foreach(array_map('basename', glob(public_path("assets/fonts/*", GLOB_ONLYDIR))) as $font_dir)
				@if($font === $font_dir)
					@foreach(array_map('basename', glob(public_path("assets/fonts/{$font_dir}/*"))) as $font_file)
					@if(stripos($font_file, 'italic'))
						@continue
					@endif

					@if(stripos($font_file, 'extralight'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 200;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'light'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 300;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'extrabold'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 800;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'semibold'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 600;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'bold'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 700;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'medium'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 500;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'regular'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 400;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'black'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 900;
					  font-style: normal;
					}
					@endif
					@endforeach
				@endif
			@endforeach
		</style>
	</head>

	<body>
		<div class="m-0 text-[1.1rem] max-w-[1600px] w-full mx-auto bg-[radial-gradient(whitesmoke,#fff)] flex items-center justify-center min-h-[100vh] p-[2rem_1.5rem]">
			<div class="max-w-[450px] w-full rounded-[.75rem] overflow-hidden m-auto bg-[#fff] border-b-[.25rem] border-[#eb6d56]">
				<div class="p-[1.5rem]">
					<div class="mb-[1rem] flex items-end">
						<svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 16 16">
							<path fill="#ffe2dc" fill-rule="" d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16" clip-rule="evenodd"/>
							<path fill="#e96d56" d="M11.854 4.854a.5.5 0 0 0-.707-.707L8 7.293L4.854 4.147a.5.5 0 1 0-.707.707L7.293 8l-3.146 3.146a.5.5 0 0 0 .707.708L8 8.707l3.147 3.147a.5.5 0 0 0 .707-.708L8.708 8z"/>
						</svg>
						<span class="font-[600] uppercase text-[1.3rem] ml-[.5rem] leading-[1]">{{ __('Payment failed') }}</span>
					</div>
					<div class="text-[1.2rem] mt-[.5rem] opacity-75">{{ __("We couldn't proceed your payment") }}</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Reference number') }}</div>
						<div class="ml-auto">{{ $transaction->reference_id }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Date') }}</div>
						<div class="ml-auto">{{ $transaction->created_at->format('Y-m-d') }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Payment method') }}</div>
						<div class="ml-auto">{{ __($transaction->processor) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Buyer email') }}</div>
						<div class="ml-auto">{{ $transaction->guest_email ?? $transaction->user->email }}</div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Amount') }}</div>
						<div class="ml-auto">{{ currency('code') }} {{ price(price:$transaction->amount, free:false, currency:false) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Payment status') }}</div>
						<div class="ml-auto"><div class="min-w-[80px] text-center p-[.25rem_.75rem] rounded-[.35rem] bg-[#ffe2dc] text-[#e96d56] font-[600]">{{ __('Failed') }}</div></div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem]">
					<a href="{{ route('home') }}" class="uppercase p-[.75rem_1rem] bg-[#3b3b3b] hover:bg-[#000] text-[#fff] font-[600] block text-center rounded-[.5rem]">{{ __('Retrun to homepage') }}</a>
				</div>
			</div>
		</div>
	</body>
</html>