<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>{{ __('Order success') }}</title>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link rel="stylesheet" href="{{ src("assets/tendra.css") }}">
		<style>
			html {
				font-size: 1rem;
			}

			{!! load_font() !!}
		</style>
	</head>
	<body>
		<div class="m-0 text-[1.1rem] max-w-[1600px] w-full mx-auto bg-[radial-gradient(whitesmoke,#fff)] flex items-center justify-center min-h-[100vh] p-[1.5rem]">
			<div class="max-w-[450px] w-full rounded-[.75rem] overflow-hidden m-auto bg-[#fff] border-b-[.25rem] border-[#6d42b9]">
				<div class="p-[1.5rem]">
					<div class="mb-[1rem] flex items-end">
						<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24">
							<path fill="#83ff967a" d="M4.083 10.894c.439-2.34.658-3.511 1.491-4.203C6.408 6 7.598 6 9.98 6h4.04c2.383 0 3.573 0 4.407.691c.833.692 1.052 1.862 1.491 4.203l.75 4c.617 3.292.926 4.938.026 6.022C19.794 22 18.12 22 14.771 22H9.23c-3.349 0-5.024 0-5.923-1.084c-.9-1.084-.591-2.73.026-6.022z"/>
							<path fill="#186d25" d="M9.75 5a2.25 2.25 0 0 1 4.5 0v1c.566 0 1.062.002 1.5.015V5a3.75 3.75 0 1 0-7.5 0v1.015C8.688 6.002 9.184 6 9.75 6zm5.836 6.969a.75.75 0 1 0-1.172-.937l-3.476 4.345L9.53 13.97a.75.75 0 1 0-1.06 1.06l2 2a.75.75 0 0 0 1.116-.062z"/>
						</svg>
						<span class="font-[600] uppercase text-[1.3rem] ml-[.5rem] leading-[1]">{{ __('Order completed') }}</span>
					</div>
					<div class="text-[1.2rem] mt-[.5rem] opacity-75">{{ __('Thank you for shopping with us') }}</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Reference number') }}</div>
						<div class="ml-auto">{{ $transaction->reference_id }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Date') }}</div>
						<div class="ml-auto">{{ $transaction->created_at->format('Y-m-d') }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Payment method') }}</div>
						<div class="ml-auto capitalize">{{ __($transaction->processor) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Buyer email') }}</div>
						<div class="ml-auto">{{ $transaction->guest_email ?? $transaction->user->email }}</div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Amount') }}</div>
						<div class="ml-auto">{{ currency('code') }} {{ price(price:$transaction->amount, free:false, currency:false) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Payment status') }}</div>
						<div class="ml-auto">
							<div class="min-w-[80px] {{ $transaction->status }} relative text-center justify-center flex gap-[.5rem] p-[.35rem_.75rem] pb-[.15rem] rounded-[.35rem] [&.pending]:bg-[#ffbf0030] [&.pending]:text-[#6f5a1d] [&.paid]:bg-[#E9F6F0] [&.paid]:text-[#129C62] font-[600] group">
								@if($transaction->status === 'pending')
								<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><g fill="currentColor"><path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/><path d="m8.93 6.588l-2.29.287l-.082.38l.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319c.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246c-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0a1 1 0 0 1 2 0"/></g></svg>
								<span class="absolute bottom-[calc(100%+1rem)] p-[.5rem_.75rem] text-left right-0 bg-[#000] text-[#fff] rounded-[.25rem] hidden group-hover:block text-[.9rem] font-[500] w-[250px]">{{ __('Your payment must be confirmed before you can download files') }}</span>
								@endif

								{{ __(mb_ucfirst($transaction->status)) }}
							</div>
						</div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem]">
					@if($transaction->type == 'product')
					<div class="font-[500] text-[#aa6100] bg-[#ffe4495e] p-[.75rem_1rem] rounded-[.5rem] mb-[1rem] leading-[1.8]">{!! __('We sent you download links to your email address :email', ['email' => '<span class="text-[#000] font-[600] opacity-75">' . ($transaction->guest_email ?? $transaction->user->email) . '</span>']) !!}</div>
					@endif

					@if($transaction->guest_email)
					<a href="{{ route('home') }}" class="uppercase p-[.75rem_1rem] border-[1px] border-[#6d42b9] text-[#6d42b9] font-[600] block text-center rounded-[.5rem]">
						{{ __('Retrun to homepage') }}
					</a>
					@else
						@if($transaction->type == 'product')
						<a href="{{ route('user.purchases') }}" class="capitalize p-[.75rem_1rem] bg-[#6d42b9] text-[#fff] font-[600] block text-center rounded-[.5rem]">{{ __('My purchases') }}</a>
						@elseif($transaction->type == 'subscription')
						<a href="{{ route('user.subscriptions') }}" class="capitalize p-[.75rem_1rem] bg-[#6d42b9] text-[#fff] font-[600] block text-center rounded-[.5rem]">{{ __('My subscriptions') }}</a>
						@else
						<a href="{{ route('user.prepaid_credits') }}" class="capitalize p-[.75rem_1rem] bg-[#6d42b9] text-[#fff] font-[600] block text-center rounded-[.5rem]">{{ __('My credits') }}</a>
						@endif
					@endif
				</div>
			</div>
		</div>
	</body>
</html>