@extends('front.tendra.master')

@section('body')
<div class="py-[.75rem] px-[1.5rem] flex items-center bg-[#493b69] text-[#fff]">
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="flex font-[500] items-center gap-x-[.5rem] text-[1rem]">
			<a href="" class="h-[30px] flex items-center gap-x-[.5rem] p-[.5rem_.65rem] pb-[.35rem] bg-[#fff] rounded-[.25rem] text-[#6d52ab] justify-center">
				<span class=""><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path fill="currentColor" d="M6.906.384a1.75 1.75 0 0 1 2.187 0l5.25 4.2c.415.332.657.835.657 1.367v7.019a1.75 1.75 0 0 1-1.75 1.75h-2.5a.75.75 0 0 1-.75-.75V8.72H6v5.25a.75.75 0 0 1-.75.75h-2.5A1.75 1.75 0 0 1 1 12.97V5.95c0-.531.242-1.034.657-1.366z"></path></svg></span>
				<span class="h-auto relative bottom-[-2px]">{{ __('Home') }}</span>
			</a>
			<span class="h-[30px] flex items-center">|</span>
			<div href="" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">{{ __('Prepaid credits') }}</div>
		</div>
	</div>
</div>


<div class="pt-[3rem] px-[1.5rem]">
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="text-center">
			<div class="text-[2.2rem] max-[768px]:text-[1.8rem] font-[600] capitalize mb-[1.5rem]">{{ __('Discover our prepaid credit plans') }}</div>
			<div class="mt-[.5rem] text-[1.2rem] opacity-75 max-w-[800px] mx-auto leading-[1.8]">
				{{ __('Save big with our prepaid credit plans! Enjoy reduced prices, instant access, no monthly fees, and full control over your spending. Top up anytime!') }}
			</div>
		</div>

		<div class="grid grid-cols-4 max-[1024px]:grid-cols-3 max-[900px]:grid-cols-2 max-[600px]:grid-cols-1 gap-[1.5rem] mx-auto text-[1rem] mt-[3rem]">
			@foreach($packs as $pack)
			<div class="relative rounded-[.5rem] p-[1.5rem] bg-[#fff] shadow-[0_0_20px_10px_#00000005]">
				<div class="font-[600] uppercase text-[1rem] text-center">{{ $pack->name }}</div>
				<div class="mt-[.75rem] text-[1.8rem] font-[600] text-center">{{ price($pack->amount) }}</div>
				<div class="mt-[.75rem] opacity-75 text-center">{{ $pack->subheading }}</div>

				<div class="mt-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<a href="{{ route('home.checkout', ['type' => 'prepaid-credits', 'id' => $pack->id]) }}" class="uppercase text-[1rem] bg-[#2e2d2a] text-[#fff] font-[600] rounded-[.5rem] p-[.75rem_1rem] block text-center">{{ __("Select") }}</a>
				</div>

				<div class="mt-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<div class="[&>div:not(:last-child)]:mb-[.75rem]">
						@foreach($pack->specs as $spec)
						<div class="flex items-center gap-[.75rem] text-[1rem]">
							<div class="w-[30px] h-[30px] p-[.5rem] rounded-[.35rem] border-[1px] border-[#ffe064] bg-[#ffe064]">
								<img src="/assets/images/checkbox-2.webp" class="w-full">
							</div>
							<div class="opacity-75 overflow-hidden">{!! $spec !!}</div>
						</div>
						@endforeach
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection