@extends('front.tendra.master')

@section('body')
<div class="py-[.75rem] px-[1.5rem] flex items-center bg-[#493b69] text-[#fff]">
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="flex font-[500] items-center gap-x-[.5rem] text-[1rem] overflow-hidden whitespace-nowrap">
			<a href="/" class="h-[30px] flex items-center gap-x-[.5rem] p-[.5rem_.65rem] pb-[.35rem] bg-[#fff] rounded-[.25rem] text-[#6d52ab] justify-center">
				<span class=""><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path fill="currentColor" d="M6.906.384a1.75 1.75 0 0 1 2.187 0l5.25 4.2c.415.332.657.835.657 1.367v7.019a1.75 1.75 0 0 1-1.75 1.75h-2.5a.75.75 0 0 1-.75-.75V8.72H6v5.25a.75.75 0 0 1-.75.75h-2.5A1.75 1.75 0 0 1 1 12.97V5.95c0-.531.242-1.034.657-1.366z"/></svg></span>
				<span class="h-auto relative bottom-[-2px]">{{ __('Home') }}</span>
			</a>
			<span class="h-[30px] flex items-center">|</span>
			<div href="" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">{{ $product->category->name }}</div>
			<span class="h-[30px] flex items-center">|</span>
			<a href="" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">{{ $product->name }}</a>
		</div>
	</div>
</div>

<div class="pt-[2.5rem] px-[1.5rem] max-[560px]:pt-[1.5rem]" id="product">
	<div class="max-w-[1200px] w-full flex items-start gap-[1.5rem] mx-auto max-[900px]:block">
		<div class="flex relative items-start gap-[1rem] w-[360px] h-[360px] bg-cover bg-center overflow-hidden bg-center rounded-[.5rem] max-[900px]:w-[450px] max-[900px]:h-[450px] max-[900px]:mx-auto max-[500px]:w-full max-[400px]:h-[350px] group" style="background-image: url('{{ src("storage/covers/{$product->cover}") }}');">
			@if($product->preview && $product->preview_type === 'video')
			<div class="absolute hidden group-hover:flex top-0 left-0 w-full h-full items-center justify-center group video" data-url="{{ $product->preview }}">
				<div class="cursor-pointer h-[calc(100%-1.5rem)] w-[calc(100%-1.5rem)] flex items-center justify-center group-hover:bg-[#0000000f] group-hover:backdrop-blur-[1px]">
					<svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" viewBox="0 0 24 24"><path fill="#fff" d="m9.5 16.5l7-4.5l-7-4.5zM12 22q-2.075 0-3.9-.788t-3.175-2.137T2.788 15.9T2 12t.788-3.9t2.137-3.175T8.1 2.788T12 2t3.9.788t3.175 2.137T21.213 8.1T22 12t-.788 3.9t-2.137 3.175t-3.175 2.138T12 22m0-2q3.35 0 5.675-2.325T20 12t-2.325-5.675T12 4T6.325 6.325T4 12t2.325 5.675T12 20m0-8"/></svg>
				</div>
			</div>
			@endif

			@if($product->preview_url)
			<a href="{{ $product->preview_url }}" class="absolute bottom-[.75rem] right-[.75rem] border-[1px] transition-all p-[.25rem_.5rem] text-[1rem] text-[#000] backdrop-blur-[5px] bg-[#fff] rounded-[.35rem] hover:font-[600]">{{ __('Preview') }}</a>
			@endif
		</div>

		<div class="flex-1 max-[900px]:mt-[2rem]">
			<a href="{{ category_url($product->category['slug']) }}" class="mb-[.75rem] table opacity-50 uppercase text-[.9rem] font-[600]">{{ $product->category['name'] }}</a>

			<div class="mb-[1.25rem] border-b-[1px] w-[40px] h-[8px] bg-[tomato] rounded-full"></div>

			<div class="block mb-[1rem] text-[1.5rem]">{{ $product->name }}</div>

			<div class="flex items-center flex-wrap gap-[2rem] mb-[1.5rem] leading-[1]">
				<div class="flex items-end gap-x-[.5rem]">
					<div class="flex items-center gap-x-[.25rem]">
						@foreach(rating((int)($product->fake_rating ?? $product->rating)) as $rating)
						<img src="/assets/images/{{ $rating }}" class="w-[25px] h-[25px]">
						@endforeach
					</div>
					<div class="">{{ (int)($product->fake_rating ?? $product->rating) }}/5</div>
				</div>

				<div class="flex items-end gap-x-[.5rem]">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linejoin="round"><path stroke-linecap="round" stroke-width="1.5" d="M12 21a9 9 0 1 0-8-4.873L3 21l4.873-1c1.236.639 2.64 1 4.127 1"/><path stroke-width="2.25" d="M7.5 12h.01v.01H7.5zm4.5 0h.01v.01H12zm4.5 0h.01v.01h-.01z"/></g></svg>
					<span class="">{{ $product->comments_count }}</span>
					<span class="opacity-75">{{ __('comments') }}</span>
				</div>

				<div class="flex items-center gap-x-[1rem]">
					<button class="p-[.25rem_.5rem] flex items-end bg-[whitesmoke] rounded-[.5rem]">
						<span class="mr-[.5rem] text-[1rem]">{{ __('Like') }}</span>
						<span class="add-to-collection" data-id="{{ $product->id }}">
							<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $product->id }}')}" width="22" height="22" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
							<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $product->id }}')}" width="22" height="22" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
						</span>
					</button>

					<button class="relative p-[.25rem_.5rem] flex items-end bg-[whitesmoke] rounded-[.5rem] copy-text" data-text="{{ url()->current() }}">
						<span class="absolute text-[.8rem] bg-[#000] text-[#fff] p-[.75rem_.5rem] pb-[.5rem] hidden rounded-[.25rem] flex items-center justify-center tooltip bottom-[calc(100%+.25rem)] left-0 whitespace-nowrap">{{ __('Link copied') }}</span>
						<span class="mr-[.5rem] text-[1rem]">{{ __('Share') }}</span>
						<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="1.5"><path d="M10.046 14c-1.506-1.512-1.37-4.1.303-5.779l4.848-4.866c1.673-1.68 4.25-1.816 5.757-.305s1.37 4.1-.303 5.78l-2.424 2.433"/><path d="M13.954 10c1.506 1.512 1.37 4.1-.303 5.779l-2.424 2.433l-2.424 2.433c-1.673 1.68-4.25 1.816-5.757.305s-1.37-4.1.303-5.78l2.424-2.433" opacity=".5"/></g></svg>
					</button>
				</div>
			</div>

			<div class="opacity-75 mb-[1rem]">
				{{ $product->short_description }}
			</div>

			@if($product->affiliate_link)
				<a href="{{ $product->affiliate_link }}" class="uppercase p-[.5rem_1rem] flex w-fit items-end gap-[.75rem] rounded-[.25rem] shadow-[0_0_0_1px_#4b376d_inset] text-[#4b376d] h-[40px] transition-all hover:bg-[#4b376d] hover:text-[#fff]" data-id="{{ $product->id }}">
					<div class="leading-[1] font-[600]">{{ __('Buy now') }}</div>
				</a>
			@elseif(!$product->for_subscriptions)
				@if($product->valid_subscription)
					<a href="{{ route('home.download', ['type' => 'file', 'order_id' => $product->transaction_id, 'user_id' => Auth::id(), 'item_id' => $product->id]) }}" class="font-[600] capitalize p-[.75rem] flex items-center justify-center w-fit rounded-[.35rem] bg-[#fff] shadow-[0_0_0_1px_#ff8849_inset] hover:shadow-[0_0_0_1.5px_#ff8849_inset] text-[#ff600c] h-[40px] transition-all">{{ __('Download') }}</a>
				@else
					@if($product->extended_price && !$product->has_promo())
					<div class="flex w-fit text-[1rem] gap-[.5rem] p-[.5rem_.75rem] rounded-[.25rem] border-[1px] mt-[1rem]">
						<input type="checkbox" id="extended-license" data-price="{{ $product->price }}" data-extended-price="{{ $product->extended_price }}" class="w-[18px] h-[18px] appearance-none border-[1px] border-[#000] rounded-[.25rem] checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.9rem] before:font-semibold" role="button" name="extended_license">
						<label for="extended-license">{{ __('Extended license') }}</label>
					</div>
					@endif

					@if(!$product->is_free || $product->extended_price)
					<div class="inline-flex items-end gap-[1rem] pt-[1rem]">
						<div class="buy-now buy-now-action cursor-pointer flex items-center {{ ($product->price <= 0 && !config('payments.enable_add_to_cart')) ? 'download' : '' }} [&.download:not(.extended)>div]:hidden [&.download:not(.extended)>a]:block [&>a:not(.extended)]:hidden capitalize p-[.5rem_1rem] rounded-[.35rem] bg-[#4d4068] text-[#fff] h-[40px] hover:bg-[#6646a8] transition-all [&[disabled]]:opacity-50" data-id="{{ $product->id }}">
							<div class="leading-[1] font-[600]">{{ __('Buy now') }}</div>
							<a href="{{ route('home.download', ['type' => 'file', 'order_id' => rand(100,9999), 'user_id' => Auth::id() ?? rand(100,9999), 'item_id' => $product->id]) }}" class="leading-[1] font-[600] download">{{ __('Download') }}</a>
						</div>

						@if(config('payments.enable_add_to_cart'))
						<button title="{{ __('Add to cart') }}" data-id="{{ $product->id }}" class="add-to-cart [&[disabled]]:opacity-50 capitalize p-[.75rem] flex items-center justify-center rounded-[.35rem] bg-[#fff] shadow-[0_0_0_1px_#ff8849_inset] hover:shadow-[0_0_0_1.5px_#ff8849_inset] text-[#ff600c] h-[40px] transition-all">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m21.052 11.5l.279-1.66c.182-1.086.273-1.628-.019-1.984c-.291-.356-.827-.356-1.898-.356H4.586c-1.071 0-1.607 0-1.898.356c-.292.356-.2.898-.019 1.984l1.204 7.18c.399 2.38.598 3.569 1.413 4.275C6.1 22 7.274 22 9.622 22H12m2-4h8m-4 4v-8m-.5-6.5a5.5 5.5 0 1 0-11 0" color="currentColor"/></svg>
						</button>
						@endif
						<div class="leading-[1] flex gap-[.5rem]" id="product-price">
							@if(!$product->extended_price && $product->has_promo())
							<div class="opacity-50">
								<sup class="text-[.9rem] relative font-[500]">
									{{ price($product->price) }}
									<div class="absolute h-full w-full flex items-center top-0 left-0"><span class="h-[2px] w-[50%] rotate-[45deg] mx-auto bg-[#000]"></span></div>
								</sup>
							</div>
							<div class="text-[1.3rem]">{{ price($product->promo_price) }}</div>
							@else
							<div class="text-[1.3rem] price">{{ price($product->price) }}</div>
							@endif
						</div>
					</div>

					@if($product->minimum_price && customPriceEnabled('products'))
					<div class="font-[500] flex items-center rounded-r-[.5rem] overflow-hidden rounded-[.35rem] bg-[#e6e7e8] max-w-[350px] mt-[1rem]">
						<div class="bg-[#ff8523] w-[50px] h-[50px] flex items-center text-[#fff] justify-center">
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 256 256"><path fill="currentColor" d="M204 168a52.06 52.06 0 0 1-52 52h-12v12a12 12 0 0 1-24 0v-12h-12a52.06 52.06 0 0 1-52-52a12 12 0 0 1 24 0a28 28 0 0 0 28 28h48a28 28 0 0 0 0-56h-40a52 52 0 0 1 0-104h4V24a12 12 0 0 1 24 0v12h4a52.06 52.06 0 0 1 52 52a12 12 0 0 1-24 0a28 28 0 0 0-28-28h-32a28 28 0 0 0 0 56h40a52.06 52.06 0 0 1 52 52"/></svg>
						</div>
						<input type="number" name="custom_price" class="[appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none w-full h-[50px] px-[1rem] border-0 focus:outline-none bg-transparent placeholder:font-[400]" placeholder="{{ __('Enter a custom price') }}">
					</div>
					@endif

					@endif
				@endif
			@else
				@if($product->valid_subscription)
					<a href="{{ route('home.download', ['type' => 'file', 'order_id' => $product->transaction_id, 'user_id' => Auth::id(), 'item_id' => $product->id]) }}" class="font-[600] capitalize p-[.75rem] flex items-center justify-center w-fit rounded-[.35rem] bg-[#fff] shadow-[0_0_0_1px_#ff8849_inset] hover:shadow-[0_0_0_1.5px_#ff8849_inset] text-[#ff600c] h-[40px] transition-all">{{ __('Download') }}</a>

				@else
				<div class="mt-[1rem] table p-[.65rem_1rem] rounded-[.35rem] uppercase text-[.9rem] font-[600] text-[#944500] bg-[#ffdfc3]">
					{{ __('Available via subscriptions only') }}
				</div>

				<div class="flex flex-wrap gap-[1rem] mt-[1rem] text-[1rem]">
					@foreach($subscriptions as $subscription)
					<a href="{{ route('home.checkout', ['type' => 'subscription', 'id' => $subscription->id]) }}" class="hover:font-[600] h-[45px] flex items-center text-center rounded-[.35rem] bg-[#fff] border-[1px]">
						<span class="h-[45px] text-[.9rem] flex items-center px-[1rem] mr-[1rem] border-r-[1px] font-[600]">{{ price($subscription->price) }}</span>
						<span class="pr-[1rem]">{{ $subscription->name }}</span>
					</a>
					@endforeach
				</div>
				@endif
			@endif
		</div>
	</div>

	<div class="max-w-[1200px] w-full mt-[2rem] mx-auto flex gap-[2rem] max-[1024px]:grid max-[1024px]:grid-cols-1">
		<div class="flex-1 font-[400] bg-[#fff] rounded-[.5rem] overflow-hidden">
			<div id="product-tabs" class="flex items-center flex-1 gap-y-[1rem] gap-x-[1rem] [&>button]:p-[1rem] [&>button]:bg-[#fafafa] [&>button]:rounded-[.5rem] [&>button]:uppercase [&>button]:font-[500] [&>button.active]:font-[600] [&>button:hover]:font-[600] [&>button]:leading-[1] [&>div]:opacity-50 [&>button.active]:text-[#ff5c3f] text-[1rem] bg-[#fff] p-[1.5rem] rounded-t-[.5rem] border-b-[1px] [&>button]:whitespace-nowrap overflow-auto scrollbar-width-[none]" id="product-menu">
				<button class="active" data-tab="overview">{{ __('Overview') }}</button>
				<div class="">|</div>
				@if(config('app.show_streaming_player') && itemHasVideo($product))
				<button class="" data-tab="stream">{{ __('Stream') }}</button>
				<div class="">|</div>
				@endif
				@if(config('app.enable_comments'))
				<button class="" data-tab="comments">{{ __('Comments') }}</button>
				<div class="">|</div>
				@endif
				@if(config('app.enable_reviews'))
				<button class="" data-tab="reviews">{{ __('Reviews') }}</button>
				<div class="">|</div>
				@endif
				@if(count($product->table_of_contents))
				<button class="" data-tab="table-of-contents">{{ __('Table of contents') }}</button>
				<div class="">|</div>
				@endif
				@isset($faq)
				<button class="" data-tab="faq">{{ __('FAQ') }}</button>
				<div class="">|</div>
				@endisset
				@isset($product->hidden_content)
				<button class="" data-tab="hidden-content">{{ __('Hidden content') }}</button>
				@endisset
			</div>

			{{-- OVERVIEW --}}
			<div class="[&:not(.active)]:hidden [&>p:not(:last-child)]:mb-[2rem] p-[1.5rem] active" data-tab="overview">
				@if($product->screenshots)
				<div id="screenshots" class="grid grid-cols-6 max-[768px]:grid-cols-5 max-[650px]:grid-cols-4 max-[560px]:grid-cols-3 max-[480px]:grid-cols-2 gap-[1rem] [&>div]:rounded-[.35rem] [&>div]:bg-cover [&>div]:bg-center mb-[1.5rem] p-[1.5rem] max-[650px]:px-0 m-[-1.5rem] bg-[#fafafa] border-b-[1px] [&>div]:cursor-pointer">
					@foreach($product->screenshots as $screenshot)
					<div data-img="{{ $screenshot }}" style="background-image:url('{{ $screenshot }}')" class="h-[125px]" loading="lazy">&nbsp;</div>
					@endforeach
				</div>
				@endif

				<div class="text-[1rem]">
					{!! $product->overview !!}
				</div>
			</div>

			{{-- STREAMING PLAYER --}}
			@if(config('app.show_streaming_player') && (auth_is_admin() || $product->purchased || $product->valid_subscription) && itemHasVideo($product))
			<div class="[&:not(.active)]:hidden [&>p:not(:last-child)]:mb-[2rem] p-[1.5rem] active" data-tab="stream">
				<div class="stream-player player bg-[#252525] pb-[55px] relative m-[-1.5rem]" data-type="video" data-ready="false" data-full="false">
					<div class="video absolute top-0 left-0 w-full h-[calc(100%-55px)] z-[1]"></div>
					<video 
						class="flex h-auto object-fit w-full"
						@if(preg_match("/^local|yandex$/i", $product->file_host))
						src="{{ route('stream_vid', ['id' => $product->id, 'temp_url' => base64_encode($product->temp_direct_url)]) }}#t=1"
						@else 
						src="{{ $product->temp_direct_url }}#t=1"
						@endif
						type="{{ itemHasVideo($product) }}"></video>
					<div class="controls flex gap-[1rem] h-[55px] flex items-center bg-[#232323] backdrop-blur-[15px] p-[.5rem_1rem] w-full absolute bottom-0 left-0 z-[2]">
						<div class="play select-none flex items-center justify-center w-[30px] h-[30px] invert cursor-pointer invert" title="{{ __('Play/Pause') }}"><img src="/assets/images/play-3.png"></div>
						<div class="wave select-none flex-1 relative overflow-hidden m-[auto_1.5rem] h-[30px] bg-[#ffffff1f] rounded-full" style="-webkit-mask-image: url(/assets/images/wave-3.png);-webkit-mask-position: center;-webkit-mask-repeat: repeat;-webkit-mask-size: contain;"
							><span class="time bg-[linear-gradient(45deg,#002941,rgba(24,255,238,.84))] rounded-[100px_0_0_100px] h-full left-0 absolute top-0 w-0 z-[9]"></span>
						</div>
						<div class="current-time select-none ml-auto flex flex-none bottom-[-2px] items-center text-[1rem] h-[30px] relative mr-[1rem] text-[#fff]" title="{{ __('Current time') }}">00:00:00</div>
						<div class="volume items-center flex-1 cursor-pointer flex h-[30px] justify-center max-w-[30px] relative group" title="{{ __('Volume') }}">
							<img class="w-[30px] select-none invert" src="/assets/images/volume.png">
							<div class="absolute bottom-[100%] w-[30px] left-0 h-[125px] hidden cursor-default group-hover:block">
								<span class="bg-[#ffffff80] rounded-full bottom-0 h-[120px] overflow-hidden absolute w-[10px] left-[10px] mb-[5px]">
									<span class="bg-[#fff] bottom-0 h-[100%] left absolute w-full"></span>
								</span>
							</div>
						</div>
						<div class="stop select-none items-center justify-center w-[30px] h-[30px] invert cursor-pointer invert" title="{{ __('Stop') }}"><img src="/assets/images/stop-2.png"></div>
						<div class="maximize select-none items-center justify-center w-[30px] h-[30px] invert cursor-pointer invert" title="{{ __('Fullscreen') }}"><img src="/assets/images/maximize.png"></div>
					</div>
				</div>
			</div>
			@endif

			{{-- COMMENTS --}}
			@if(config('app.enable_comments'))
			<div class="[&:not(.active)]:hidden text-[1.1rem] p-[1.5rem] min-h-[400px]" data-tab="comments">
				@auth
				<form action="{{ url()->full() }}?tab=comments" method="POST" class="comment-form relative overflow-hidden bg-[#F6F8FA] w-full rounded-t-0 rounded-b-[.5rem]">
					@csrf
					<input type="hidden" name="type" value="comments">
					<input type="hidden" name="edit_comment_id" :value="commentToEdit.id">
					@if(config('app.enable_subcomments'))
					<input type="hidden" name="comment_id" :value="replyTo.commentId">
					@endif
					<div v-if="replyTo.userName !== null && commentToEdit.id === null" class="bg-[#fff] pb-[.5rem]">
						<div class="flex text-[.9rem] font-[600] w-fit gap-[.5rem] p-[.25rem_.5rem] bg-[#ffcc6e63] text-[#5e3f06] rounded-[.25rem]">
							<span class="cursor-pointer" @click="resetReplyTo">✕</span>
							<span class="">@{{ replyTo.userName }}</span>
						</div>
					</div>
					<div v-if="commentToEdit.id !== null && replyTo.userName === null" class="bg-[#fff] pb-[.5rem]">
						<div class="flex text-[.9rem] font-[600] w-fit gap-[.5rem] p-[.25rem_.5rem] bg-[#ffcc6e63] text-[#5e3f06] rounded-[.25rem]">
							<span class="cursor-pointer" @click="resetEditComment">✕</span>
							<span class="">{{ __('Edit comment') }}</span>
						</div>
					</div>
					<textarea name="comment" :value="commentToEdit.content" spellcheck="false" placeholder="{{ __('Write a comment') }}" class="p-[1rem] bg-transparent outline-none w-full h-[120px] resize-none"></textarea>
					<div class="p-[1rem] flex gap-[1rem]">
						<button type="submit" class="ml-auto bg-[#ff6845] hover:bg-[#df664a] p-[.5rem_1rem_.35rem] rounded-[.35rem] text-[#fff] font-[500] text-[1rem]">{{ __('Submit') }}</button>
					</div>
				</form>
				<div class="mt-[3rem]"></div>
				@endauth

				<div class="">
					@foreach($comments as $comment)
					<div class="">
						<div class="px-[1rem]" id="C{{ $comment->id }}">
							<div class="json hidden" data-content="{{ base64_encode(json_encode(['id' => $comment->id, 'content' => $comment->body])) }}"></div>
							<div class="flex items-center gap-x-[1rem]">
								<img src="{{ src("storage/avatars/{$comment->avatar}") }}" class="w-[50px] h-[50px] rounded-[.35rem]">
								<div class="text-[1rem]">
									<div class="font-[500] mb-[.25rem]">{{ $comment->name ?? $comment->alias_name ?? $comment->fullname }}</div>
									<div class="text-[.9rem]">{{ format_date($comment->created_at, 'H:i | Y-m-d') }}</div>
								</div>
								@if((\Auth::check() && \Auth::id() === $comment->user_id) || auth_is_admin())
								<div class="ml-auto cursor-pointer group relative">
									<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="5" cy="12" r="2"/><circle cx="12" cy="12" r="2" opacity=".5"/><circle cx="19" cy="12" r="2"/></g></svg>
									<div class="group-hover:block hidden shadow-[0_10px_20px_-10px_#0000004f] z-[1] bg-[#fff] absolute top-[100%] font-[500] text-[.9rem] uppercase right-0 rounded-[.25rem]">
										@if(\Auth::id() === $comment->user_id)
										<div data-edit-comment="{{ $comment->id }}" class="edit-comment p-[.5rem_.75rem] block hover:font-[600] border-b-[1px]">{{ __('Edit') }}</div>
										@endif
										<a onclick="confirm('{{ __('Are you sure you want to delete this comment ?') }}') ? (location.href = '{{ route('home.product', ['id' => $product->id, 'slug' => $product->slug, 'type' => 'comments', 'delete_comment_id' => $comment->id]) }}') : null" class="p-[.5rem_.75rem] block hover:font-[600]">{{ __('Delete') }}</a>
									</div>
								</div>
								@endif
							</div>
							<div class="text-[1rem] opacity-75 pt-[1rem]">
								{!! nl2br($comment->body) !!}
							</div>
							<div class="saved-reactions-container">
								@if(count($comment->reactions ?? []))
								<div class="saved-reactions flex items-center saved-reactions [&>div:not(:first-child)]:ml-[-8px] flex-nowrap py-[.2rem] ml-[-2px] mt-[.75rem]" data-item_id="{{ $comment->id }}" data-item_type="comment">
									@php
										$z_indexes = array_combine(array_reverse([6,5,4,3,2,1]), [6,5,4,3,2,1]);
									@endphp
									@foreach($comment->reactions as $name => $count)
									<div class="reaction relative block border-[2px] border-[#fff] rounded-full bg-cover bg-center w-[25px] h-[25px]" data-reaction="{{ $name }}" title="{{ $count }}" style="background-image: url('{{ asset_("assets/images/reactions/{$name}.webp") }}'); z-index:{{ $z_indexes[$loop->iteration]  }}"></div>
									@endforeach
								</div>
								@endif
							</div>
							<div class="flex items-center gap-[1rem] text-[.9rem] pt-[1rem]">
								@if(config('app.enable_subcomments'))
								<div class="uppercase font-[500] text-[.9rem] pb-[.1rem] border-b-[2px] cursor-pointer" @click="setReplyTo('{{ $comment->name ?? $comment->alias_name ?? $comment->fullname }}', {{ $comment->id }})">{{ __('Reply') }}</div>
								@endif
								@if(config('app.enable_reactions_on_comments'))
								<div class="group relative">
									<svg xmlns="http://www.w3.org/2000/svg" class="" width="28" height="28" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linejoin="round"><circle cx="12" cy="12" r="9" stroke-linecap="round"/><path stroke-width="1.5" d="M9.01 9.5v.01H9V9.5zm6 0v.01H15V9.5z"/><path stroke-linecap="round" d="M15.465 14A3.999 3.999 0 0 1 12 16a3.998 3.998 0 0 1-3.465-2"/></g></svg>
									<div class="group-hover:block hidden z-[1] absolute top-[100%] pt-[.5rem] font-[500] text-[.9rem] uppercase left-0 rounded-[.25rem] w-fit">
										<div class="flex gap-[.25rem] shadow-[0_10px_20px_-10px_#0000004f] bg-[#fff] h-[40px] items-center justify-between w-[200px] px-[.5rem] rounded-[.25rem] reactions border-[1px] border-[#f6f6f6]" data-item_id="{{ $comment->id }}" data-item_type="comment">
											<a title="{{ __('Like') }}" data-reaction="like" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/like.webp');"></a>
											<a title="{{ __('Love') }}" data-reaction="love" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/love.webp');"></a>
											<a title="{{ __('Haha') }}" data-reaction="funny" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/funny.webp');"></a>
											<a title="{{ __('Wow') }}" data-reaction="wow" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/wow.webp');"></a>
											<a title="{{ __('Sad') }}" data-reaction="sad" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/sad.webp');"></a>
											<a title="{{ __('Angry') }}" data-reaction="angry" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/angry.webp');"></a>
										</div>
									</div>
								</div>
								@endif
								<div class="ml-auto cursor-pointer font-[500] copy-text" data-text="{{ url()->current() }}?tab=comments#C{{ $comment->id }}">#{{ $comment->id }}</div>
							</div>
						</div>
						@if(config('app.enable_subcomments'))
						<div class="mt-[2rem] pl-[72px] [&>div:not(:last-child)]:mb-[2rem]">
							@foreach($comment->children as $child_comment)
							<div class="px-[1rem]" id="C{{ $child_comment->id }}">
								<div class="json hidden" data-content="{{ base64_encode(json_encode(['id' => $child_comment->id, 'content' => $child_comment->body])) }}"></div>
								<div class="flex items-center gap-x-[1rem]">
									<img src="{{ src("storage/avatars/{$child_comment->avatar}") }}" class="w-[50px] h-[50px] rounded-[.35rem]">
									<div class="text-[1rem]">
										<div class="font-[500] mb-[.25rem]">{{ $child_comment->name ?? $child_comment->alias_name ?? $child_comment->fullname }}</div>
										<div class="text-[.9rem]">{{ format_date($child_comment->created_at, 'H:i | Y-m-d') }}</div>
									</div>
									@if((\Auth::check() && \Auth::id() === $child_comment->user_id) || auth_is_admin())
									<div class="ml-auto cursor-pointer group relative">
										<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="5" cy="12" r="2"/><circle cx="12" cy="12" r="2" opacity=".5"/><circle cx="19" cy="12" r="2"/></g></svg>
										<div class="group-hover:block hidden shadow-[0_10px_20px_-10px_#0000004f] z-[1] bg-[#fff] absolute top-[100%] font-[500] text-[.9rem] uppercase right-0 rounded-[.25rem]">
											@if(\Auth::id() === $child_comment->user_id)
											<div data-edit-comment="{{ $child_comment->id }}" class="edit-comment p-[.5rem_.75rem] block hover:font-[600] border-b-[1px]">{{ __('Edit') }}</div>
											@endif
											<a onclick="confirm('{{ __('Are you sure you want to delete this comment ?') }}') ? (location.href = '{{ route('home.product', ['id' => $product->id, 'slug' => $product->slug, 'type' => 'comments', 'delete_comment_id' => $child_comment->id]) }}') : null" class="p-[.5rem_.75rem] block hover:font-[600]">{{ __('Delete') }}</a>
										</div>
									</div>
									@endif
								</div>
								<div class="text-[1rem] opacity-75 pt-[1rem]">
									{!! nl2br($child_comment->body) !!}
								</div>
								<div class="saved-reactions-container">
								@if(count($child_comment->reactions ?? []))
									<div class="saved-reactions flex items-center saved-reactions [&>div:not(:first-child)]:ml-[-8px] flex-nowrap py-[.2rem] ml-[-2px] mt-[.75rem]" data-item_id="{{ $child_comment->id }}" data-item_type="comment">
										@php
											$z_indexes = array_combine(array_reverse([6,5,4,3,2,1]), [6,5,4,3,2,1]);
										@endphp
										@foreach($child_comment->reactions as $name => $count)
										<div class="reaction relative block border-[2px] border-[#fff] rounded-full bg-cover bg-center w-[25px] h-[25px]" data-reaction="{{ $name }}" title="{{ $count }}" style="background-image: url('{{ asset_("assets/images/reactions/{$name}.webp") }}'); z-index:{{ $z_indexes[$loop->iteration]  }}"></div>
										@endforeach
									</div>
									@endif
								</div>
								<div class="flex items-center gap-[1rem] text-[.9rem] pt-[1rem]">
									<div class="uppercase font-[500] text-[.9rem] pb-[.1rem] border-b-[2px] cursor-pointer" @click="setReplyTo('{{ $child_comment->name ?? $child_comment->alias_name ?? $child_comment->fullname }}', {{ $comment->id }})">{{ __('Reply') }}</div>
									
									@if(config('app.enable_reactions_on_comments'))
									<div class="group relative">
										<svg xmlns="http://www.w3.org/2000/svg" class="" width="28" height="28" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linejoin="round"><circle cx="12" cy="12" r="9" stroke-linecap="round"/><path stroke-width="1.5" d="M9.01 9.5v.01H9V9.5zm6 0v.01H15V9.5z"/><path stroke-linecap="round" d="M15.465 14A3.999 3.999 0 0 1 12 16a3.998 3.998 0 0 1-3.465-2"/></g></svg>
										<div class="group-hover:block hidden z-[1] absolute top-[100%] pt-[.5rem] font-[500] text-[.9rem] uppercase left-0 rounded-[.25rem] w-fit">
											<div class="flex gap-[.25rem] shadow-[0_10px_20px_-10px_#0000004f] bg-[#fff] h-[40px] items-center justify-between w-[200px] px-[.5rem] rounded-[.25rem] reactions border-[1px] border-[#f6f6f6]" data-item_id="{{ $child_comment->id }}" data-item_type="comment">
												<a title="{{ __('Like') }}" data-reaction="like" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/like.webp');"></a>
												<a title="{{ __('Love') }}" data-reaction="love" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/love.webp');"></a>
												<a title="{{ __('Haha') }}" data-reaction="funny" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/funny.webp');"></a>
												<a title="{{ __('Wow') }}" data-reaction="wow" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/wow.webp');"></a>
												<a title="{{ __('Sad') }}" data-reaction="sad" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/sad.webp');"></a>
												<a title="{{ __('Angry') }}" data-reaction="angry" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/angry.webp');"></a>
											</div>
										</div>
									</div>
									@endif

									<div class="ml-auto cursor-pointer font-[500] copy-text" data-text="{{ url()->current() }}?tab=comments#{{ $child_comment->id }}">#{{ $child_comment->id }}</div>
								</div>
							</div>
							@endforeach
						</div>
						@endif
					</div>
					@if(!$loop->last)
					<div class="my-[2rem] border-t-[1px]"></div>
					@endif
					@endforeach
				</div>
			</div>
			@endif

			{{-- REVIEWS --}}
			@if(config('app.enable_reviews'))
			<div class="[&:not(.active)]:hidden p-[1.5rem] min-h-[400px]" data-tab="reviews">
				@if(\Auth::check() && $product->purchased)
				<form action="{{ url()->full() }}" method="POST" class="relative overflow-hidden bg-[#F6F8FA] w-full rounded-t-0 rounded-b-[.5rem] ">
					<input type="hidden" name="type" value="reviews">
					<input type="hidden" name="rating">
					<input type="hidden" name="edit_review_id">
					<textarea name="review" spellcheck="false" placeholder="{{ __('Write a review') }}" class="p-[1rem] bg-transparent outline-none w-full h-[120px] resize-none"></textarea>
				
					<div class="p-[1rem] flex items-center gap-[1rem] border-t-[1px]">
						<div class="flex items-end gap-x-[.5rem]">
							<div class="font-[500] leading-[1]">{{ __('Rating') }}</div>
							<div class="flex items-center gap-x-[.25rem] select-none" id="user-rating">
								@foreach(rating(0) as $star)
								<div style="-webkit-mask-image: url('/assets/images/{{ $star }}'); -webkit-mask-size: cover; -webkit-mask-position: center; -webkit-mask-repeat:no-repeat" class="w-[22px] h-[22px] bg-[#cfcfcf]"></div>
								@endforeach
							</div>
						</div>
						<button class="ml-auto bg-[#ff6845] hover:bg-[#df664a] p-[.5rem_1rem_.35rem] rounded-[.35rem] text-[#fff] font-[500] text-[1rem]">{{ __('Submit') }}</button>
					</div>
				</form>
				<div class="mt-[3rem]"></div>
				@endif

				<div class="min-h-[400px]">
					@foreach($reviews ?? [] as $review)
					<div class="" id="rev-{{ $review->id }}">
						<div class="json hidden" data-content="{{ base64_encode(json_encode(['id' => $review->id, 'content' => $review->content, 'rating' => $review->rating])) }}"></div>
						<div class="px-[1rem]">
							<div class="flex items-center gap-x-[1rem]">
								<img src="{{ src("storage/avatars/{$review->avatar}") }}" class="w-[50px] h-[50px] rounded-[.35rem]">
								<div class="text-[1rem]">
									<div class="font-[500] mb-[.25rem]">{{ $review->username }}</div>
									<div class="text-[.9rem]">{{ format_date($review->created_at, 'H:i | Y-m-d') }}</div>
								</div>
								@if((\Auth::check() && \Auth::id() === $review->user_id) || auth_is_admin())
								<div class="ml-auto cursor-pointer group relative">
									<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="5" cy="12" r="2"/><circle cx="12" cy="12" r="2" opacity=".5"/><circle cx="19" cy="12" r="2"/></g></svg>
									<div class="group-hover:block hidden shadow-[0_10px_20px_-10px_#0000004f] z-[1] bg-[#fff] absolute top-[100%] font-[500] text-[.9rem] uppercase right-0 rounded-[.25rem]">
										@if(\Auth::id() === $review->user_id)
										<div data-edit-review="{{ $review->id }}" class="p-[.5rem_.75rem] block hover:font-[600] border-b-[1px]">{{ __('Edit') }}</div>
										@endif
										<a onclick="confirm('{{ __('Are you sure you want to delete this review ?') }}') ? (location.href = '{{ route('home.product', ['id' => $product->id, 'slug' => $product->slug, 'type' => 'reviews', 'delete_review_id' => $review->id]) }}') : null" class="p-[.5rem_.75rem] block hover:font-[600]">{{ __('Delete') }}</a>
									</div>
								</div>
								@endif
							</div>
							<div class="text-[1rem] opacity-75 pt-[1rem]">
								{{ $review->content }}
							</div>
							<div class="flex items-end gap-[.5rem] text-[.9rem] pt-[1rem]">
								<div class="flex items-center gap-x-[.25rem]">
									@foreach(rating($review->rating) as $star)
									<img src="/assets/images/{{ $star }}" class="w-[20px] h-[20px]">
									@endforeach
								</div>
								<div class="leading-[1] font-[500]">{{ $review->rating }}/5</div>
								<div class="cursor-pointer ml-auto" data-review-id="{{ url()->current() }}?tab=reviews#rev-{{ $review->id }}" id="rev-{{ $review->id }}">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M21 7.25h-3l.77-3.07a.75.75 0 0 0-1.46-.36l-.86 3.43H10l.77-3.07a.75.75 0 0 0-1.46-.36l-.9 3.43H5a.75.75 0 0 0 0 1.5h3l-1.63 6.5H3a.75.75 0 0 0 0 1.5h3l-.77 3.07a.75.75 0 0 0 1.46.36l.86-3.43H14l-.77 3.07a.75.75 0 0 0 1.46.36l.86-3.43H19a.75.75 0 0 0 0-1.5h-3l1.63-6.5H21a.75.75 0 0 0 0-1.5m-5 1.5l-1.63 6.5H8l1.63-6.5Z"/></svg>
								</div>
							</div>
						</div>
					</div>
					@if(!$loop->last)
					<div class="my-[2rem] border-t-[1px]"></div>
					@endif
					@endforeach
				</div>
			</div>
			@endif

			{{-- TABLE OF CONTENTS --}}
			@if(count($product->table_of_contents))
			<div class="[&:not(.active)]:hidden p-[1.5rem]" data-tab="table-of-contents">
				<div class="[&>div]:p-[.75rem_1rem]">
					@foreach($product->table_of_contents as $line)
					<div class="{{ $line['text_type'] }} [&.header]:font-[600] [&.subheader]:font-[500] [&.subheader]:opacity-75 [&.subsubheader]:pl-[2rem] [&.subsubheader]:border-l-[1px] [&.subsubheader]:ml-[1rem]">{{ $line['text'] }}</div>
					@endforeach
				</div>
			</div>
			@endif

			{{-- FAQ --}}
			@isset($faq)
			<div class="[&:not(.active)]:hidden p-[1.5rem]" data-tab="faq">
				<div class="text-[1rem]">
					@foreach($faq as $line)
					<div class="[&:not(:last-child)]:mb-[1rem] [&:not(:last-child)]:pb-[1rem] [&:not(:last-child)]:border-b-[1px]">
						<div class="font-[500] mb-[.75rem]"><span class="mr-[.5rem] font-[700]">Q.</span> {{ $line['question'] }}</div>
						<div class="font-[400]"><span class="mr-[.5rem] font-[700]">A.</span> {{ $line['answer'] }}</div>
					</div>
					@endforeach
				</div>
			</div>
			@endisset

			{{-- HIDDEN CONTENT --}}
			@isset($product->hidden_content)
			<div class="[&:not(.active)]:hidden p-[1.5rem]" data-tab="hidden-content">
				{!! $product->hidden_content !!}
			</div>
			@endisset
		</div>

		<div class="max-w-[320px] w-full font-[400] h-full max-[1024px]:max-w-full">
			<div class="p-[1.5rem] border-b-[1px] bg-[#fff] rounded-t-[.5rem]">
				<div class="p-[1rem] leading-[1] uppercase text-[1rem] font-[500] bg-[#fafafa] table rounded-[.5rem]">{{ __('Item details') }}</div>
			</div>

			<div class="p-[1.5rem] text-[1rem] bg-[#fff] rounded-b-[.5rem]">
				<div class="[&>div]:flex [&>div]:items-center [&>div:not(:last-child)]:mb-[1rem] [&>div]:justify-between [&>div]:gap-x-[1rem]">
					@if($product->authors)
					<div class="">
						<div class="font-[500]">{{ __("Authors") }}</div>
						<div class="font-[400]">{{ $product->authors }}</div>
					</div>
					@endif
					@if($product->release_date)
					<div class="">
						<div class="font-[500]">{{ __("Release date") }}</div>
						<div class="font-[400]">{{ $product->release_date }}</div>
					</div>
					@endif
					@if($product->last_update)
					<div class="">
						<div class="font-[500]">{{ __("Last update") }}</div>
						<div class="font-[400]">{{ $product->last_update }}</div>
					</div>
					@endif
					@if($product->version)
					<div class="">
						<div class="font-[500]">{{ __("Version") }}</div>
						<div class="font-[400]">{{ $product->version }}</div>
					</div>
					@endif
					@if($product->words)
					<div class="">
						<div class="font-[500]">{{ __("Words") }}</div>
						<div class="font-[400]">{{ $product->words }}</div>
					</div>
					@endif
					@if($product->label)
					<div class="">
						<div class="font-[500]">{{ __("Label") }}</div>
						<div class="font-[400]">{{ $product->label }}</div>
					</div>
					@endif
					@if($product->included_files)
					<div class="">
						<div class="font-[500]">{{ __("Included files") }}</div>
						<div class="font-[400]">{{ $product->included_files }}</div>
					</div>
					@endif
					@if($product->language)
					<div class="">
						<div class="font-[500]">{{ __("Language") }}</div>
						<div class="font-[400]">{{ $product->language }}</div>
					</div>
					@endif
					@if($product->formats)
					<div class="">
						<div class="font-[500]">{{ __("Formats") }}</div>
						<div class="font-[400]">PDF, EPUB</div>
					</div>
					@endif
					@if($product->bpm)
					<div class="">
						<div class="font-[500]">{{ __("BPM") }}</div>
						<div class="font-[400]">{{ $product->bpm }}</div>
					</div>
					@endif
					@if($product->high_resolution)
					<div class="">
						<div class="font-[500]">{{ __("High resolution") }}</div>
						<div class="font-[400]">{{ $product->high_resolution ? __('Yes') : __('No') }}</div>
					</div>
					@endif
					@if($product->compatible_browsers)
					<div class="">
						<div class="font-[500]">{{ __("Compatible browsers") }}</div>
						<div class="font-[400]">{{ $product->compatible_browsers }}</div>
					</div>
					@endif
					@if($product->compatible_os)
					<div class="">
						<div class="font-[500]">{{ __("Compatible os") }}</div>
						<div class="font-[400]">{{ $product->compatible_os }}</div>
					</div>
					@endif
					@if($product->db)
					<div class="">
						<div class="font-[500]">{{ __("Database") }}</div>
						<div class="font-[400]">{{ $product->db }}</div>
					</div>
					@endif
					@if($product->software)
					<div class="">
						<div class="font-[500]">{{ __("Software") }}</div>
						<div class="font-[400]">{{ $product->software }}</div>
					</div>
					@endif
					@if($product->bit_rate)
					<div class="">
						<div class="font-[500]">{{ __("Bit rate") }}</div>
						<div class="font-[400]">320Kb</div>
					</div>
					@endif
					@foreach($product->additional_fields ?? [] as $additional_field)
					<div class="">
						<div class="font-[500]">{{ __($additional_field->_name_) }}</div>
						<div class="font-[400]">{{ $additional_field->_value_ }}</div>
					</div>
					@endforeach
				</div>
			</div>

			@if($product->tags)
			<div class="p-[1.5rem] border-b-[1px] bg-[#fff] rounded-t-[.5rem] mt-[1.5rem]">
				<div class="p-[1rem] leading-[1] uppercase text-[1rem] font-[500] bg-[#fafafa] table rounded-[.5rem]">{{ __('Tags') }}</div>
			</div>

			<div class="p-[1.5rem] text-[1rem] bg-[#fff] rounded-b-[.5rem]">
				<div class="flex items-center flex-wrap gap-[1rem]">
					@foreach($product->tags as $tag)
					<a href="{{ route('home.products.q', ['q' => $tag]) }}" class="p-[.5rem] border-[1px] rounded-[.5rem]">{{ $tag }}</a>
					@endforeach
				</div>
			</div>
			@endif
		</div>
	</div>

	@if($similar_products->count())
	<div class="max-w-[1200px] w-full mt-[2rem] mx-auto">
		<div class="capitalize mb-[.5rem] text-[1.3rem] font-[600]">{{ __('Similar items') }}</div>
		
		<div class="mb-[1.25rem] border-b-[1px] w-[40px] h-[8px] bg-[#a73be3] rounded-full"></div>

		<div class="gap-[1.5rem] grid grid-cols-4 max-[1024px]:grid-cols-3 max-[1024px]:[&>div:nth-child(4)]:hidden max-[768px]:grid-cols-2 max-[768px]:[&>div:nth-child(4)]:block max-[500px]:grid-cols-1">
			@foreach($similar_products as $similar_product)
			<div class="overflow-hidden rounded-[.5rem] text-[1rem] p-[1rem] shadow-[0_0_20px_10px_#00000005]">
				<div class="relative m-[-1rem] mb-[1rem]">
					<a href="{{ item_url($similar_product) }}" class="flex">
						<img src="{{ src("storage/covers/{$similar_product->cover}") }}" class="">
					</a>
					<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $similar_product->id }}">
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $similar_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $similar_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
					</span>
				</div>
				<div class="">
					<div class="mb-[1rem]">
						<a href="{{ item_url($similar_product) }}" class="block h-[50px] overflow-hidden font-[600] opacity-75">{{ $similar_product->name }}</a>
					</div>
					<div class="flex items-center justify-between">
						<a href="{{ route('home.products.category', ['category_slug' => $similar_product->category['slug']]) }}" class="max-w-[50%] bg-[#FEF098] text-[#975b07] text-[.8rem] font-[600] p-[.325rem_.75rem] font-[500] rounded-full bg-[#ffe3b9] overflow-hidden text-ellipsis whitespace-nowrap" title="">{{ \Str::limit($similar_product->category['name'], 40) }}</a>
						<div class="ml-auto">
							<div class="h-[28px] w-[28px] bg-[#392d22]" style="-webkit-mask-image:url('https://api.iconify.design/uiw:star-on.svg'); -webkit-mask-position:bottom center; -webkit-mask-size:cover;-webkit-mask-repeat:no-repeat">
								<span class="bg-[#ff9900] h-[28px] block" style="width:{{ ($similar_product->rating ?? $similar_product->fake_rating ?? 0 / 5) * 100 }}%"></span>
							</div>
						</div>
					</div>
					<div class="text-[.9rem] mt-[1rem] font-[400] h-[65px] overflow-hidden">
						{{ $similar_product->short_description }}
					</div>
					<div class="flex items-end justify-between mt-[1rem] h-[40px]">
						<div class="text-[1.2rem] font-[600] mr-[1rem] leading-[1] select-none">
							@if($similar_product->has_promo())
							<span class="text-[#0a7d44]">{{ price($similar_product->promo_price) }}</span>
							@else
							{{ price($similar_product->price) }}
							@endif
						</div>
						<div data-id="{{ $product->id }}" class="cursor-pointer buy-now h-[40px] bg-[#392D22] rounded-[.5rem] text-[#fff] flex items-center px-[1rem] gap-x-[.5rem]">
							<span>{{ __('Buy now') }}</span>
							<svg xmlns="http://www.w3.org/2000/svg" class="max-[1200px]:hidden" width="22" height="22" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="m3.062 14.441l.365-2.142c.432-2.533.647-3.8 1.502-4.55C5.784 7 7.012 7 9.467 7h5.066c2.455 0 3.683 0 4.538.75s1.07 2.016 1.502 4.549l.365 2.142c.598 3.505.896 5.257-.023 6.408C19.995 22 18.295 22 14.898 22H9.102c-3.398 0-5.097 0-6.017-1.15c-.92-1.152-.62-2.904-.023-6.409"/><path d="m7.5 9l.215-3.01a4.296 4.296 0 0 1 8.57 0L16.5 9"/></g></svg>
						</div>
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>
	@endif
</div>

<div id="screenshots-slider" class="hidden fixed top-0 left-0 w-full h-[100vh] z-[10] bg-[#fffffffa] flex items-center justify-center text-[1rem]">
	<div class="absolute left-0 top-0 h-[100vh] w-[50px] flex items-center justify-center cursor-pointer prev">
		<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="m13.42 2.296l-8.047 6.94A.92.92 0 0 0 5 10q0 .472.41.797l8.01 6.907q.48.402 1.032.267q.45-.131.548-.607v-14.7a.76.76 0 0 0-.526-.628q-.574-.137-1.054.26"/></svg>
	</div>
	<img src="" class="h-full max-h-[90vh] w-auto select-none">
	<div class="absolute right-0 top-0 h-[100vh] w-[50px] flex items-center justify-center cursor-pointer next">
		<svg xmlns="http://www.w3.org/2000/svg" transform="scale(-1,1)" width="25" height="25" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="m13.42 2.296l-8.047 6.94A.92.92 0 0 0 5 10q0 .472.41.797l8.01 6.907q.48.402 1.032.267q.45-.131.548-.607v-14.7a.76.76 0 0 0-.526-.628q-.574-.137-1.054.26"/></svg>
	</div>
</div>
@endsection