@extends('front.tendra.master')

@section('body')
<div class="bg-[linear-gradient(180deg,#fff,#fff,transparent)]" id="products">
	<div class="p-[3rem] relative flex items-center flex-col justify-start bg-[#3f4a54] after:content-[''] after:h-full after:w-full after:absolute after:top-0 after:left-0 after:bg-[linear-gradient(180deg,#00000014_50%,transparent_70%)] [&>*:not(.absolute)]:relative [&>*]:z-[2]">
		<div class="top-0 left-0 w-full h-full absolute bg-bottom bg-cover bg-[url(//valexa_4.co/storage/images/tendra_top_cover.jpg)] opacity-[.2]"></div>
		<div class="text-[2.5rem] font-[700] max-w-[800px] mx-auto text-center leading-[1.8] capitalize text-[#fff]">
			{{ config('app.search_header', config('app.title')) }}
		</div>
		<form class="flex items-center rounded-[.75rem] overflow-hidden max-w-[500px] w-full mt-[2rem]" action="{{ route('home.products.q') }}" method="GET">
			<input type="search" name="q" class="w-full h-[55px] bg-[#ffffff26] px-[1rem] text-[#fff] border-0 focus:outline-none placeholder-[#cbd5e0]" placeholder="{{ __('Enter a title or some keywords') }}...">
			<button class="p-[.5rem_1.5rem] h-[55px] bg-[#68359A] text-[#fff] flex items-center font-semibold" type="submit">
				{{ __('Search') }}
			</button>
		</form>
	</div>

	<div class="px-[1.5rem] relative">
		<div class="absolute top-0 left-0 w-full h-full z-[3] bg-[rgb(0_0_0/16%)] hidden" id="filters-menu-mask"></div>

		<div class="max-w-[1200px] w-full mx-auto flex gap-[2.5rem]">
			<div class="max-w-[280px] py-[2.5rem] max-[1200px]:hidden max-[1200px]:absolute max-[1200px]:top-0 max-[1200px]:left-0 w-full max-[1200px]:h-full max-[1200px]:bg-[#fff] max-[1200px]:max-w-[320px] max-[1200px]:px-[1.5rem] max-[1200px]:z-[9]" id="product-filters">
				<div class="uppercase font-[600] text-[1.1rem] mb-[1.5rem]">{{ __('Filter options') }}</div>

				@if(intval(config('app.filter_by_included_files')))
				<div class="mb-[2.5rem]">
					<div class="font-[600] mb-[1rem]">{{ __('Included files') }}</div>

					<div class="[&>div]:mb-[.75rem] max-h-[200px] overflow-hidden scrollbar-width-[none]" id="filter-included-files">
						@foreach($included_files as $included_file)
						<div class="flex items-center gap-x-[1rem] text-[1rem]">
							<input id="{{ md5($included_file) }}" data-file-type="{{ $included_file }}" {{ isset($selected_included_files[$included_file]) ? 'checked' : '' }} name="included-files[]" value="{{ $included_file }}" type="checkbox" class="included-file w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-[.25rem] checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<label for="{{ md5($included_file) }}" class="opacity-[.8]">{{ $included_file }}</label>
						</div>
						@endforeach
					</div>
					<div class="mt-[1rem] cursor-pointer flex items-center justify-between text-[#685905] p-[.5rem_1rem] bg-[#ffdb0814] rounded-[.5rem]" id="filter-included-files-show-more">
						<span class="">{{ __("More file types") }}</span>
						<img src="/assets/images/dropdown.png" class="w-[20px]">
					</div>
				</div>
				@endif
				
				<div class="">
					<div class="font-[600] mb-[1rem]">{{ __('Categories') }}</div>
					<div class="[&>div]:mb-[.75rem] max-h-[405px] overflow-hidden scrollbar-width-[none]" id="filter-categories">
						@foreach(config('categories.category_parents') as $_category)
						<div class="flex items-center gap-x-[1rem] text-[1rem]">
							<input id="{{ md5($_category['id']) }}" data-category="{{ $_category['slug'] }}" data-route="{{ route('home.products.category', ['category_slug' => $_category['slug'], 'q' => request()->query('q')]) }}" name="category[]" {{ request()->category_slug === $_category['slug'] ? 'checked' : null }} value="{{ $_category['id'] }}" type="radio" class="category w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-full checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<label for="{{ md5($_category['id']) }}" class="opacity-[.8]">{{ $_category['name'] }}</label>
						</div>
						@endforeach
					</div>
					<div class="mt-[1rem] cursor-pointer flex items-center justify-between text-[#ff6608] p-[.5rem_1rem] bg-[#ff660814] rounded-[.5rem]" id="filter-categories-show-more">
						<span class="">{{ __("Show more") }}</span>
						<img src="/assets/images/dropdown.png" class="w-[20px]">
					</div>
				</div>

				@if(isset($category) && count(config("categories.category_children.{$category['id']}", [])) && empty(request()->query('q')))
				<div class="h-[1px] w-[30%] bg-[#d7d7d7] mb-[1.5rem] mt-[2rem]"></div>

				<div class="">					
					<div class="font-[600] mb-[1rem] flex items-start justify-between gap-[1rem]">
						<div class="mr-auto">{{ __('Subcategories') }}</div>
						<div class="" title="{{ __('Reset') }}">
							<svg xmlns="http://www.w3.org/2000/svg" class="reset-filter cursor-pointer" data-filter="subcategory" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2v2a8 8 0 1 0 5.135 1.865L15 8V2h6l-2.447 2.447A9.98 9.98 0 0 1 22 12"/></svg>
						</div>
					</div>
					<div class="[&>div]:mb-[.75rem] max-h-[405px] overflow-hidden scrollbar-width-[none]" id="filter-subcategories">
						@foreach(config("categories.category_children.{$category['id']}", []) as $subcategory)
						<div class="flex items-center gap-x-[1rem] text-[1rem]">
							<input id="{{ md5($subcategory['id']) }}" name="subcategory[]" {{ request()->subcategory_slug === $subcategory['slug'] ? 'checked' : null }} data-subcategory="{{ $subcategory['slug'] }}" value="{{ $subcategory['id'] }}" type="radio" class="subcategory w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-full checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<label for="{{ md5($subcategory['id']) }}" class="opacity-[.8]">{{ $subcategory['name'] }}</label>
						</div>
						@endforeach
					</div>
					<div class="mt-[1rem] cursor-pointer flex items-center justify-between text-[#ff6608] p-[.5rem_1rem] bg-[#ff660814] rounded-[.5rem]" id="filter-subcategories-show-more">
						<span class="">{{ __("Show more") }}</span>
						<img src="/assets/images/dropdown.png" class="w-[20px]">
					</div>
				</div>
				@endif

				<div class="h-[1px] w-[30%] bg-[#d7d7d7] my-[1.5rem]"></div>

				<div class="">
					<div class="font-[600] mb-[1rem] flex items-start justify-between gap-[1rem]">
						<div class="mr-auto">{{ __('Price range') }}</div>
						<div class="" title="{{ __('Reset') }}">
							<svg xmlns="http://www.w3.org/2000/svg" class="reset-filter cursor-pointer" data-filter="price" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2v2a8 8 0 1 0 5.135 1.865L15 8V2h6l-2.447 2.447A9.98 9.98 0 0 1 22 12"/></svg>
						</div>
					</div>
					<div class="grid grid-cols-2 gap-[1rem] [&>input]:rounded-[.5rem]">
						<input type="number" name="price[min]" value="{{ $price_range['min'] ?? '' }}" class="price focus:outline-0 border-[1px] p-[.5rem_1rem]" placeholder="{{ __('Min') }}">
						<input type="number" name="price[max]" value="{{ $price_range['max'] ?? '' }}" class="price focus:outline-0 border-[1px] p-[.5rem_1rem]" placeholder="{{ __('Max') }}">
					</div>
				</div>

				<div class="h-[1px] w-[60%] bg-[#d7d7d7] my-[1.5rem]"></div>

				<div class="">
					<div class="font-[600] mb-[1rem] flex items-start justify-between gap-[1rem]">
						<div class="mr-auto">{{ __('Rating') }}</div>
						<div class="" title="{{ __('Reset') }}">
							<svg xmlns="http://www.w3.org/2000/svg" class="reset-filter cursor-pointer" data-filter="rating" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2v2a8 8 0 1 0 5.135 1.865L15 8V2h6l-2.447 2.447A9.98 9.98 0 0 1 22 12"/></svg>
						</div>
					</div>
					<div class="[&>div:not(:last-child)]:mb-[1rem]">
						<div class="flex items-center gap-x-[1rem]">
							<input id="" type="radio" name="rating" value="5" {{ $rating == 5 ? 'checked' : null }} class="rating check-all w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-full checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<span class="flex items-center gap-x-[.25rem]">
								@foreach(rating(5) as $stars_img)
								<img src="/assets/images/{{ $stars_img }}" class="w-[25px] h-[25px]">
								@endforeach
							</span>
							<span class="ml-auto opacity-75">{{ $ratings[5] ?? 0 }}</span>
						</div>
						<div class="flex items-center gap-x-[1rem]">
							<input id="" type="radio" name="rating" value="4" {{ $rating == 4 ? 'checked' : null }} class="rating check-all w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-full checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<span class="flex items-center gap-x-[.25rem]">
								@foreach(rating(4) as $stars_img)
								<img src="/assets/images/{{ $stars_img }}" class="w-[25px] h-[25px]">
								@endforeach
							</span>
							<span class="ml-auto opacity-75">{{ $ratings[4] ?? 0 }}</span>
						</div>
						<div class="flex items-center gap-x-[1rem]">
							<input id="" type="radio" name="rating" value="3" {{ $rating == 3 ? 'checked' : null }} class="rating check-all w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-full checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<span class="flex items-center gap-x-[.25rem]">
								@foreach(rating(3) as $stars_img)
								<img src="/assets/images/{{ $stars_img }}" class="w-[25px] h-[25px]">
								@endforeach
							</span>
							<span class="ml-auto opacity-75">{{ $ratings[3] ?? 0 }}</span>
						</div>
						<div class="flex items-center gap-x-[1rem]">
							<input id="" type="radio" name="rating" value="2" {{ $rating == 2 ? 'checked' : null }} class="rating check-all w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-full checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<span class="flex items-center gap-x-[.25rem]">
								@foreach(rating(2) as $stars_img)
								<img src="/assets/images/{{ $stars_img }}" class="w-[25px] h-[25px]">
								@endforeach
							</span>
							<span class="ml-auto opacity-75">{{ $ratings[2] ?? 0 }}</span>
						</div>
						<div class="flex items-center gap-x-[1rem]">
							<input id="" type="radio" name="rating" value="1" {{ $rating == 1 ? 'checked' : null }} class="rating check-all w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-full checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<span class="flex items-center gap-x-[.25rem]">
								@foreach(rating(1) as $stars_img)
								<img src="/assets/images/{{ $stars_img }}" class="w-[25px] h-[25px]">
								@endforeach
							</span>
							<span class="ml-auto opacity-75">{{ $ratings[1] ?? 0 }}</span>
						</div>
					</div>
				</div>

				<div class="h-[1px] w-full bg-[#d7d7d7] my-[1.5rem]"></div>

				<button id="apply-products-filter" class="h-[40px] bg-[#e34d32] rounded-[.35rem] text-[#fff] flex items-center justify-center px-[1rem] w-full font-[600]">{{ __('Apply filters') }}</button>
			</div>

			<div class="flex-1 py-[2.5rem]">
				<div class="flex items-center justify-between max-[800px]:block">
					<div class="flex items-center gap-[1rem]">
						<button class="hidden max-[1200px]:flex p-[.25rem] border-[1px] border-[#ffeb00] bg-[#ffeb00] rounded-full h-[46px] w-[46px] items-center justify-center" id="filters-menu-toggler">
							<svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round"><circle cx="7" cy="7" r="3" transform="rotate(90 7 7)"/><path d="M9.5 5H18a2 2 0 0 1 2 2v0a2 2 0 0 1-2 2H9.5"/><circle cx="3" cy="3" r="3" transform="matrix(0 1 1 0 14 14)"/><path d="M14.5 15H6a2 2 0 0 0-2 2v0a2 2 0 0 0 2 2h8.5"/></g></svg>
						</button>

						<div class="font-[600] flex items-baseline text-[1.1rem] uppercase font-[600] relative">
							<span class="mr-[.35rem]">{{ $products->total() }}</span>
							<span class="first-letter:text-[tomato]">{{ __('Results') }}</span>
						</div>
					</div>

					<div class="flex items-center ml-auto gap-[1.5rem] uppercase text-[.9rem] max-[800px]:mt-[1.5rem] max-[800px]:flex-wrap">
						<a href="{{ filter_url(filter_is_selected('featured_asc') ? 'featured_desc' : 'featured_asc') }}" class="@if(filter_is_selected('featured_desc')) selected @endif group flex items-center justify-center hover:border-[#ffa827] rounded-[.25rem] bg-[#fff] gap-[.35rem]">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M3.5 6a1 1 0 0 1 1-1h15a1 1 0 1 1 0 2h-15a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h9a1 1 0 1 1 0 2h-9a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h3a1 1 0 1 1 0 2h-3a1 1 0 0 1-1-1" clip-rule="evenodd"/></svg>
							<span class="">{{ __("Featured") }}</span>
						</a>
						<a href="{{ filter_url(filter_is_selected('rating_asc') ? 'rating_desc' : 'rating_asc') }}" class="@if(filter_is_selected('rating_desc')) selected @endif group flex items-center justify-center hover:border-[#ffa827] rounded-[.25rem] bg-[#fff] gap-[.35rem]">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M3.5 6a1 1 0 0 1 1-1h15a1 1 0 1 1 0 2h-15a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h9a1 1 0 1 1 0 2h-9a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h3a1 1 0 1 1 0 2h-3a1 1 0 0 1-1-1" clip-rule="evenodd"/></svg>
							<span class="">{{ __("Rating") }}
						</a>
						<a href="{{ filter_url(filter_is_selected('price_asc') ? 'price_desc' : 'price_asc') }}" class="@if(filter_is_selected('price_desc')) selected @endif group flex items-center justify-center hover:border-[#ffa827] rounded-[.25rem] bg-[#fff] gap-[.35rem]">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M3.5 6a1 1 0 0 1 1-1h15a1 1 0 1 1 0 2h-15a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h9a1 1 0 1 1 0 2h-9a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h3a1 1 0 1 1 0 2h-3a1 1 0 0 1-1-1" clip-rule="evenodd"/></svg>
							<span class="">{{ __("Price") }}
						</a>
						<a href="{{ filter_url(filter_is_selected('newest_asc') ? 'newest_desc' : 'newest_asc') }}" class="@if(filter_is_selected('newest_desc')) selected @endif group flex items-center justify-center hover:border-[#ffa827] rounded-[.25rem] bg-[#fff] gap-[.35rem]">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M3.5 6a1 1 0 0 1 1-1h15a1 1 0 1 1 0 2h-15a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h9a1 1 0 1 1 0 2h-9a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h3a1 1 0 1 1 0 2h-3a1 1 0 0 1-1-1" clip-rule="evenodd"/></svg>
							<span class="">{{ __("Newest") }}
						</a>
						<a href="{{ filter_url(filter_is_selected('relevance_asc') ? 'relevance_desc' : 'relevance_asc') }}" class="@if(filter_is_selected('relevance_desc')) selected @endif group flex items-center justify-center hover:border-[#ffa827] rounded-[.25rem] bg-[#fff] gap-[.35rem]">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M3.5 6a1 1 0 0 1 1-1h15a1 1 0 1 1 0 2h-15a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h9a1 1 0 1 1 0 2h-9a1 1 0 0 1-1-1m6 6a1 1 0 0 1 1-1h3a1 1 0 1 1 0 2h-3a1 1 0 0 1-1-1" clip-rule="evenodd"/></svg>
							<span class="">{{ __("Best match") }}
						</a>
					</div>
				</div>

				<div class="mt-[2rem] gap-[2rem] grid grid-cols-3 max-[1200px]:grid-cols-4 max-[1024px]:grid-cols-3 max-[800px]:grid-cols-2 max-[480px]:grid-cols-1">
					@foreach($products as $product)
					<div class="overflow-hidden rounded-[.5rem] text-[1rem]">
						<div class="relative mb-[1rem]">
							<a href="{{ item_url($product) }}" class="flex">
								<img src="{{ src("/storage/covers/{$product->cover}") }}" class="rounded-[.5rem]">
							</a>
							<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $product->id }}">
								<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
								<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
							</span>
						</div>
						<div class="">
							<div class="mb-[1rem]">
								<a href="{{ item_url($product) }}" class="block h-[50px] overflow-hidden font-[600] opacity-75">{{ $product->name }}</a>
							</div>
							<div class="flex items-center justify-between">
								<a href="{{ category_url($product->category['slug']) }}" class="max-w-[50%] bg-[#FEF098] text-[#975b07] text-[.8rem] font-[600] p-[.35rem_1rem] pb-[.25rem] font-[500] rounded-full bg-[#ffe3b9] overflow-hidden text-ellipsis whitespace-nowrap" title="">{{ \Str::limit($product->category['name'], 40) }}</a>
								<div class="ml-auto">
									<div class="h-[28px] w-[28px] bg-[#392d22]" style="-webkit-mask-image:url('/assets/images/uiw_star-on.svg'); -webkit-mask-position:bottom center; -webkit-mask-size:cover;-webkit-mask-repeat:no-repeat">
										<span class="bg-[#ff9900] h-[28px] block" style="width:{{ (($product->fake_rating ?? $product->rating ?? 0)/5)*100 }}%"></span>
									</div>
								</div>
							</div>
							<div class="text-[.9rem] mt-[1rem] font-[400] h-[65px] overflow-hidden">
								{{ $product->short_description }}
							</div>
							<div class="flex items-end justify-between mt-[1rem] h-[40px] gap-x-[1rem]">
								<div class="flex gap-[.5rem] mr-1rem leading-[1]">
									@if($product->has_promo())
									<div class="text-[1.2rem] font-[600] text-[#009665]">{{ $product->promo_price }}</div>
									<sup class="line-through text-[.9rem] font-[600]">{{ $product->price }}</sup>
									@else
									<div class="text-[1.2rem] font-[600]">{{ price($product->price) }}</div>
									@endif
								</div>
								<div data-id="{{ $product->id }}" class="cursor-pointer buy-now h-[40px] bg-[#392D22] rounded-[.5rem] text-[#fff] flex items-center px-[1rem] gap-x-[.5rem]">
									<span>{{ __('Buy now') }}</span>
									<svg xmlns="http://www.w3.org/2000/svg" class="max-[560px]:hidden max-[480px]:block" width="22" height="22" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="m3.062 14.441l.365-2.142c.432-2.533.647-3.8 1.502-4.55C5.784 7 7.012 7 9.467 7h5.066c2.455 0 3.683 0 4.538.75s1.07 2.016 1.502 4.549l.365 2.142c.598 3.505.896 5.257-.023 6.408C19.995 22 18.295 22 14.898 22H9.102c-3.398 0-5.097 0-6.017-1.15c-.92-1.152-.62-2.904-.023-6.409"/><path d="m7.5 9l.215-3.01a4.296 4.296 0 0 1 8.57 0L16.5 9"/></g></svg>
								</div>
							</div>
						</div>
					</div>
					@endforeach
				</div>

				@if($products->hasPages())
				<div class="mt-[3rem]">
					@if(config('app.force_simple_pagination'))
					{{ $products->links('vendor.pagination.simple-tailwind') }}
					@else
					{{ $products->links('vendor.pagination.tailwind') }}
					@endif
				</div>
				@endif
			</div>
		</div>
	</div>
</div>
@endsection