@extends('front.tendra.user.master')

@section('user_page')
<div class="font-[600] uppercase text-[1rem] mb-[1rem]">{{ __('Collection') }}</div>

<div class="p-[2rem] bg-[#fff] rounded-[.5rem]">
	<div class="min-h-[400px]">
		<div class="gap-[1.5rem] grid grid-cols-3 max-[768px]:grid-cols-2 max-[560px]:grid-cols-1" v-if="userCollectionIsReady">
			<div v-for="item in favorites" class="overflow-hidden grid grid-cols-2 rounded-[.5rem] overflow-hidden h-[130px]">
				<div class="relative">
					<a :href="item.url" class="rounded-[.5rem] flex bg-center bg-cover w-full h-full" :style="'background-image:url(' + item.cover + ')'"></a>
					<span class="absolute p-[.25rem] bg-[#fff] rounded-[.25rem] bottom-[.5rem] right-[.5rem] group cursor-default opacity-75 remove-from-collection" :data-id="item.id">
						<svg class="ml-auto cursor-pointer [&[disabled]:opacity-50]" data-id="20" xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" d="M20.5 6h-17m6 5l.5 5m4.5-5l-.5 5"></path><path d="M6.5 6h.11a2 2 0 0 0 1.83-1.32l.034-.103l.097-.291c.083-.249.125-.373.18-.479a1.5 1.5 0 0 1 1.094-.788C9.962 3 10.093 3 10.355 3h3.29c.262 0 .393 0 .51.019a1.5 1.5 0 0 1 1.094.788c.055.106.097.23.18.479l.097.291A2 2 0 0 0 17.5 6"></path><path stroke-linecap="round" d="M18.374 15.4c-.177 2.654-.266 3.981-1.131 4.79s-2.195.81-4.856.81h-.774c-2.66 0-3.99 0-4.856-.81c-.865-.809-.953-2.136-1.13-4.79l-.46-6.9m13.666 0l-.2 3"></path></g></svg>
					</span>
				</div>
				<div class="pl-[1rem] flex items-center justify-center">
					<a :href="item.url" class="block text-[.9rem] h-[130px] overflow-hidden">@{{ item.name }}</a>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection