@extends('front.tendra.user.master')

@section('user_page')
<div class="font-[600] uppercase text-[1rem] mb-[1rem]">{{ __('Dashboard') }}</div>

<div class="p-[2rem] bg-[#fff] rounded-[.5rem]" data-tab="dashboard">
	<div class="grid grid-cols-3 max-[768px]:grid-cols-2 max-[500px]:grid-cols-1 max-[768px]:gap-[1.5rem] gap-[1rem] [&>div]:border-[1px] [&>div]:border-[#f8f8f8] [&>div]:rounded-[.35rem] [&>div]:overflow-hidden [&>div]:flex mb-[1.5rem]">
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex items-center font-[600] uppercase p-[1rem] bg-[aliceblue]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Orders') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $orders ?? '0' }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex items-center leading-[1] font-[600] uppercase p-[1rem] bg-[aliceblue]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Comments') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $comments ?? '0' }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex items-center leading-[1] font-[600] uppercase p-[1rem] bg-[aliceblue]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Reviews') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $reviews ?? '0' }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex items-center leading-[1] font-[600] uppercase p-[1rem] bg-[aliceblue]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Subscriptions') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $subscriptions ?? '0' }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex items-center leading-[1] font-[600] uppercase p-[1rem] bg-[aliceblue]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Credits') }}</div>
				<div class="p-[1rem] h-[55px]">{{ price($credits, false) }}</div>
			</div>
		</div>
		<div class="">
			<div class="flex-1">
				<div class="text-[.9rem] h-[55px] flex items-center leading-[1] font-[600] uppercase p-[1rem] bg-[aliceblue]"><span class="text-[1rem] mr-[.25rem]">◯</span> {{ __('Referred users') }}</div>
				<div class="p-[1rem] h-[55px]">{{ $referred_users ?? '0' }}</div>
			</div>
		</div>
	</div>

	<div class="">
		<div class="font-[600] capitalize mb-[1rem] mt-[2rem]">{{ __('Latest orders') }}</div>
		<div class="overflow-auto">
			<table class="table w-full text-[1rem]">
				<thead class="bg-[#f87460] text-[#fff]">
					<tr class="[&>th]:p-[.75rem_1rem] [&>th]:text-center [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
						<th class="rounded-tl-[.5rem]">{{ __('Order ID') }}</th>
						<th>{{ __('Amount') }}</th>
						<th>{{ __('Date') }}</th>
						<th class="rounded-tr-[.5rem]">{{ __('Status') }}</th>
					</tr>
				</thead>
				<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
					@foreach($last_orders as $last_order)
					<tr class="[&>td]:p-[.75rem_1rem] [&>td]:text-center [&>td:not(:last-child)]:border-r-[1px]">
						<td>{{ $last_order->reference_id }}</td>
						<td>{{ price($last_order->amount, false) }}</td>
						<td>{{ $last_order->created_at->format('Y-m-d H:i') }}</td>
						<td class="">
							<div class="{{ $last_order->status }} [&.paid]:bg-[rgb(5_224_127/15%)] [&.pending]:bg-[rgb(255_117_92/4%)] p-[.25rem] text-[.9rem] font-[600] rounded-[.35rem] [&.paid]:text-[#096d63] [&.pending]:text-[#ff755c] capitalize">{{ __($last_order->status) }}</div>
						</td>
					</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection