@extends('front.tendra.master')

@section('body')
<div class="py-[.75rem] flex items-center bg-[#493b69] text-[#fff] px-[1.5rem]">
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="flex font-[500] items-center gap-x-[.5rem] text-[1rem]">
			<a href="{{ route('home') }}" class="h-[30px] flex items-center gap-x-[.5rem] p-[.5rem_.65rem] pb-[.35rem] bg-[#fff] rounded-[.25rem] text-[#6d52ab] justify-center">
				<span class=""><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path fill="currentColor" d="M6.906.384a1.75 1.75 0 0 1 2.187 0l5.25 4.2c.415.332.657.835.657 1.367v7.019a1.75 1.75 0 0 1-1.75 1.75h-2.5a.75.75 0 0 1-.75-.75V8.72H6v5.25a.75.75 0 0 1-.75.75h-2.5A1.75 1.75 0 0 1 1 12.97V5.95c0-.531.242-1.034.657-1.366z"/></svg></span>
				<span class="h-auto relative bottom-[-2px]">{{ __('Home') }}</span>
			</a>
			<span class="h-[30px] flex items-center">|</span>
			<div href="" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">{{ $user->name }}</div>
			<span class="h-[30px] flex items-center">|</span>
			<a href="{{ route('user.profile') }}" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">{{ __('Profile') }}</a>
		</div>
	</div>
</div>

<div class="mt-[3rem] relative px-[1.5rem]">
	<div class="max-w-[1200px] flex items-start w-full mx-auto gap-[1.5rem] max-[1100px]:block overflow-hidden">
		<div id="user-menu" class="w-full max-w-[300px] max-[1100px]:absolute z-[1] max-[1100px]:max-w-[250px] max-[1100px]:left-[-250px] transition-all bg-[#fff] rounded-[.5rem] p-[1.5rem_2rem] sticky top-0">
			<div class="hidden max-[1100px]:flex absolute left-[calc(100%+1.5rem)] top-0 bg-[#544e48] text-[#fff] rounded-full">
				<div id="user-menu-toggler" class="cursor-pointer flex p-[.5rem_.75rem] menu-text rounded-[.25rem] h-[45px] w-[45px] items-center">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 16 16"><path fill="currentColor" fill-rule="evenodd" d="M1.25 3.25A.75.75 0 0 1 2 2.5h12A.75.75 0 0 1 14 4H2a.75.75 0 0 1-.75-.75m0 4.75A.75.75 0 0 1 2 7.25h12a.75.75 0 0 1 0 1.5H2A.75.75 0 0 1 1.25 8M2 12a.75.75 0 0 0 0 1.5h12a.75.75 0 0 0 0-1.5z" clip-rule="evenodd"></path></svg>
				</div>
			</div>

			<div class="[&>a.active]:bg-[#ffd54f] [&>a.active]:rounded-[.25rem] [&>a.active]:text-[#000] [&>a.active]:font-[600] [&>a:hover]:font-[600] [&>a]:flex [&>a]:items-end [&>a]:items-end [&>a]:gap-x-[.75rem] [&>a]:leading-[1] [&>a]:p-[1rem] text-[#2d2d2d] [&>a:not(:last-child)]:mb-[.25rem]">
				<a href="{{ route('user.dashboard') }}" class="{{ route_is('user.dashboard') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"><path d="M12 4v4M4 8l2.5 2.5m11 0L20 8M3 17h3m6 0l1-6m5 6h3M8.5 20.001H4A9.96 9.96 0 0 1 2 14C2 8.477 6.477 4 12 4s10 4.477 10 10c0 2.252-.744 4.33-2 6.001L15.5 20"/><path d="M12 23a3 3 0 1 0 0-6a3 3 0 0 0 0 6"/></g></svg>
					<span class="">{{ __('Dashboard') }}</span>
				</a>
				<a href="{{ route('user.profile') }}" class="{{ route_is('user.profile') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="12" cy="9" r="3"/><path stroke-linecap="round" d="M17.97 20c-.16-2.892-1.045-5-5.97-5s-5.81 2.108-5.97 5"/><path stroke-linecap="round" d="M7 3.338A9.954 9.954 0 0 1 12 2c5.523 0 10 4.477 10 10s-4.477 10-10 10S2 17.523 2 12c0-1.821.487-3.53 1.338-5"/></g></svg>
					<span class="">{{ __('Profile') }}</span>
				</a>
				<a href="{{ route('user.security') }}" class="{{ route_is('user.security') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 14 14"><g fill="none" stroke="#414141" stroke-linecap="round" stroke-linejoin="round"><rect width="10" height="8" x="2" y="5.5" rx="1"/><path d="M10.5 5.5V4a3.5 3.5 0 0 0-7 0v1.5"/><circle cx="7" cy="9.5" r=".5"/></g></svg>
					<span class="">{{ __('Security') }}</span>
				</a>
				<a href="{{ route('user.notifications') }}" class="{{ route_is('user.notifications') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 512 512"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M427.68 351.43C402 320 383.87 304 383.87 217.35C383.87 138 343.35 109.73 310 96c-4.43-1.82-8.6-6-9.95-10.55C294.2 65.54 277.8 48 256 48s-38.21 17.55-44 37.47c-1.35 4.6-5.52 8.71-9.95 10.53c-33.39 13.75-73.87 41.92-73.87 121.35C128.13 304 110 320 84.32 351.43C73.68 364.45 83 384 101.61 384h308.88c18.51 0 27.77-19.61 17.19-32.57M320 384v16a64 64 0 0 1-128 0v-16"/></svg>
					<span class="">{{ __('Notifications') }}</span>
				</a>
				<a href="{{ route('user.collection') }}" class="{{ route_is('user.collection') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 256 256"><g fill="bg-transparent"><path d="m229.06 108.79l-48.7 42l14.88 62.79a8.4 8.4 0 0 1-12.52 9.17L128 189.09l-54.72 33.65a8.4 8.4 0 0 1-12.52-9.17l14.88-62.79l-48.7-42A8.46 8.46 0 0 1 31.73 94l63.91-5.2l24.62-59.6a8.36 8.36 0 0 1 15.48 0l24.62 59.6l63.91 5.2a8.46 8.46 0 0 1 4.79 14.79" opacity="0"/><path d="M239.18 97.26A16.38 16.38 0 0 0 224.92 86l-59-4.76l-22.78-55.09a16.36 16.36 0 0 0-30.27 0L90.11 81.23L31.08 86a16.46 16.46 0 0 0-9.37 28.86l45 38.83L53 211.75a16.38 16.38 0 0 0 24.5 17.82l50.5-31.08l50.53 31.08A16.4 16.4 0 0 0 203 211.75l-13.76-58.07l45-38.83a16.43 16.43 0 0 0 4.94-17.59m-15.34 5.47l-48.7 42a8 8 0 0 0-2.56 7.91l14.88 62.8a.37.37 0 0 1-.17.48c-.18.14-.23.11-.38 0l-54.72-33.65a8 8 0 0 0-8.38 0l-54.72 33.67c-.15.09-.19.12-.38 0a.37.37 0 0 1-.17-.48l14.88-62.8a8 8 0 0 0-2.56-7.91l-48.7-42c-.12-.1-.23-.19-.13-.5s.18-.27.33-.29l63.92-5.16a8 8 0 0 0 6.72-4.94l24.62-59.61c.08-.17.11-.25.35-.25s.27.08.35.25L153 91.86a8 8 0 0 0 6.75 4.92l63.92 5.16c.15 0 .24 0 .33.29s0 .4-.16.5"/></g></svg>
					{{ __('Collection') }}
				</a>
				<a href="{{ route('user.purchases') }}" class="{{ route_is('user.purchases') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 16 16"><path fill="currentColor" d="M8 1a2 2 0 0 1 2 2v2H6V3a2 2 0 0 1 2-2m3 4V3a3 3 0 1 0-6 0v2H3.36a1.5 1.5 0 0 0-1.483 1.277L.85 13.13A2.5 2.5 0 0 0 3.322 16h9.355a2.5 2.5 0 0 0 2.473-2.87l-1.028-6.853A1.5 1.5 0 0 0 12.64 5zm-1 1v1.5a.5.5 0 0 0 1 0V6h1.639a.5.5 0 0 1 .494.426l1.028 6.851A1.5 1.5 0 0 1 12.678 15H3.322a1.5 1.5 0 0 1-1.483-1.723l1.028-6.851A.5.5 0 0 1 3.36 6H5v1.5a.5.5 0 1 0 1 0V6z"/></svg>
					{{ __('Purchases') }}
				</a>
				@if(config('app.prepaid_credits.enabled'))
				<a href="{{ route('user.prepaid_credits') }}" class="{{ route_is('user.prepaid_credits') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" fill-rule="evenodd" d="M9.944 3.25h4.112c1.838 0 3.294 0 4.433.153c1.172.158 2.121.49 2.87 1.238c.748.749 1.08 1.698 1.238 2.87c.09.673.127 1.456.142 2.363a.755.755 0 0 1 .004.23c.007.566.007 1.178.007 1.84v.112c0 1.838 0 3.294-.153 4.433c-.158 1.172-.49 2.121-1.238 2.87c-.749.748-1.698 1.08-2.87 1.238c-1.14.153-2.595.153-4.433.153H9.944c-1.838 0-3.294 0-4.433-.153c-1.172-.158-2.121-.49-2.87-1.238c-.748-.749-1.08-1.698-1.238-2.87c-.153-1.14-.153-2.595-.153-4.433v-.112c0-.662 0-1.274.007-1.84a.757.757 0 0 1 .003-.23c.016-.907.053-1.69.143-2.363c.158-1.172.49-2.121 1.238-2.87c.749-.748 1.698-1.08 2.87-1.238c1.14-.153 2.595-.153 4.433-.153m-7.192 7.5c-.002.388-.002.804-.002 1.25c0 1.907.002 3.262.14 4.29c.135 1.005.389 1.585.812 2.008c.423.423 1.003.677 2.009.812c1.028.138 2.382.14 4.289.14h4c1.907 0 3.262-.002 4.29-.14c1.005-.135 1.585-.389 2.008-.812c.423-.423.677-1.003.812-2.009c.138-1.028.14-2.382.14-4.289c0-.446 0-.862-.002-1.25zm18.472-1.5H2.776c.02-.587.054-1.094.114-1.54c.135-1.005.389-1.585.812-2.008c.423-.423 1.003-.677 2.009-.812c1.028-.138 2.382-.14 4.289-.14h4c1.907 0 3.262.002 4.29.14c1.005.135 1.585.389 2.008.812c.423.423.677 1.003.812 2.009c.06.445.094.952.114 1.539M5.25 16a.75.75 0 0 1 .75-.75h4a.75.75 0 0 1 0 1.5H6a.75.75 0 0 1-.75-.75m6.5 0a.75.75 0 0 1 .75-.75H14a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75" clip-rule="evenodd"/></svg>
					{{ __('Prepaid credits') }}
				</a>
				@endif
				@if(intval(config('app.user_coupons_page')))
				<a href="{{ route('user.coupons') }}" class="{{ route_is('user.coupons') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 14 14"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><path d="M.5 11a1 1 0 0 0 .998 1h11.004a1 1 0 0 0 .998-1V8.966a2.037 2.037 0 0 1 0-3.932V3a1 1 0 0 0-.998-1H1.498A1 1 0 0 0 .5 3v2.03a2.037 2.037 0 0 1 0 3.94zm4.02-1.5l5-5"/><path d="M5.02 5.5a.5.5 0 1 0 0-1a.5.5 0 0 0 0 1m4 4a.5.5 0 1 0 0-1a.5.5 0 0 0 0 1"/></g></svg>
					{{ __('Coupons') }}
				</a>
				@endif
				@if(config('app.subscriptions.enabled'))
				<a href="{{ route('user.subscriptions') }}" class="{{ route_is('user.subscriptions') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="1.5" d="M21.838 11.126c.18-1.912.27-2.869-.057-3.264a.992.992 0 0 0-.675-.367c-.476-.042-1.073.638-2.268 1.998c-.618.704-.927 1.055-1.271 1.11a.923.923 0 0 1-.562-.09c-.319-.16-.53-.595-.955-1.464l-2.237-4.584C13.011 2.822 12.61 2 12 2c-.61 0-1.011.822-1.813 2.465L7.95 9.049c-.424.87-.636 1.304-.955 1.464a.925.925 0 0 1-.562.09c-.344-.055-.653-.406-1.271-1.11c-1.195-1.36-1.792-2.04-2.268-1.998a.992.992 0 0 0-.675.367c-.327.395-.237 1.352-.057 3.264l.229 2.436c.378 4.012.566 6.019 1.75 7.228C5.322 22 7.094 22 10.64 22h2.719c3.545 0 5.317 0 6.5-1.21c.914-.935 1.234-2.345 1.507-4.79M9 18h6"/></svg>
					{{ __('Subscriptions') }}
				</a>
				@endif
				<a href="{{ route('user.invoices') }}" class="{{ route_is('user.invoices') ? 'active' : '' }}">
					<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 18.646V8.054c0-2.854 0-4.28.879-5.167C5.757 2 7.172 2 10 2h4c2.828 0 4.243 0 5.121.887C20 3.773 20 5.2 20 8.054v10.592c0 1.511 0 2.267-.462 2.565c-.755.486-1.922-.534-2.509-.904c-.485-.306-.727-.458-.997-.467c-.29-.01-.537.137-1.061.467l-1.911 1.205c-.516.325-.773.488-1.06.488s-.544-.163-1.06-.488l-1.91-1.205c-.486-.306-.728-.458-.997-.467c-.291-.01-.538.137-1.062.467c-.587.37-1.754 1.39-2.51.904C4 20.913 4 20.158 4 18.646M11 11H8m6-4H8" color="currentColor"/></svg>
					{{ __('Invoices') }}
				</a>
			</div>
		</div>

		<div class="flex-1">
			<div class="h-[80px] max-[1100px]:flex hidden"></div>

			<div class="max-w-[1200px] w-full mx-auto mb-[1.5rem]">
				<div class="max-w-[876px] flex items-end w-full gap-[1.5rem] border-b-[1px] pb-[1.5rem]">
					<div class="w-[150px] h-[150px] relative min-w-[150px] max-[500px]:w-[100px] max-[500px]:h-[100px] max-[400px]:hidden max-[500px]:min-w-[100px]  bg-cover bg-center rounded-[.5rem]" style="background-image: url('{{ src("storage/avatars/{$user->avatar}") }}');">
						@if($user->email_verified_at)
						<span class="absolute bg-[#fff] top-0 right-0 p-[0_0_.5rem_.5rem] rounded-[0_0_0_9999px]" title="{{ __('Email verified') }}">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="#00a762" d="m8.6 22.5l-1.9-3.2l-3.6-.8l.35-3.7L1 12l2.45-2.8l-.35-3.7l3.6-.8l1.9-3.2L12 2.95l3.4-1.45l1.9 3.2l3.6.8l-.35 3.7L23 12l-2.45 2.8l.35 3.7l-3.6.8l-1.9 3.2l-3.4-1.45zm2.35-6.95L16.6 9.9l-1.4-1.45l-4.25 4.25l-2.15-2.1L7.4 12z"/></svg>
						</span>
						@endif
					</div>
					<div class="flex-1">
						<div class="capitalize mb-[1rem] font-[600] flex items-end gap-[.5rem]">
							<div class="w-[5px] bg-[#ad72ff] h-full relative bottom-[2px] rounded-full">&nbsp;</div>
							<div class="leading-[1]">{{ $user->name }}</div>
						</div>
						<div class="text-[1rem]">
							<div class="mb-[.5rem] flex gap-[.5rem]">
								<div class="font-[600] opacity-75 max-[500px]:hidden">{{ __('Email') }} :</div>
								<div class="">{{ $user->email }}</div>
							</div>
							<div class="flex gap-[.5rem]">
								<div class="font-[600] opacity-75">{{ __('Joined on') }} :</div>
								<div class="">{{ format_date($user->created_at, 'j M, Y') }}</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="">
				@yield('user_page')
			</div>
		</div>
	</div>
</div>
@endsection