@extends('front.tendra.user.master')

@section('user_page')
<div class="font-[600] uppercase text-[1rem] mb-[1rem]">{{ __('Purchases') }}</div>

<div class="">
	@foreach($transactions as $transaction)
	<div class="relative overflow-auto [&:not(:last-child)]:mb-[1.5rem] [&:not(:last-child)]:pb-[1.5rem] p-[1.5rem] bg-[#fff] rounded-[.5rem]">
		<table class="table w-full text-[1rem] overflow-x-auto">
			<tbody>
				<tr class="">
					<td class="pb-[2rem] pr-[1.5rem]">
						<div class="flex gap-[.5rem] items-center w-fit">
							<div class="whitespace-nowrap"><span class="font-[600] text-[#fa8072]">{{ __('Ref') }}</span> {{ $transaction->reference_id }}</div>
							<div class="capitalize p-[.25rem_.5rem] pb-[.1rem] font-[600] text-[.8rem] bg-[#6d695e] rounded-[.25rem] [&.paid]:bg-[rgb(5_224_127/15%)] [&.pending]:bg-[rgb(255_117_92/4%)] [&.paid]:text-[#096d63] [&.pending]:text-[#ff755c] {{ $transaction->status }}">{{ $transaction->status }}</div>
						</div>
					</td>
					<td class="pb-[2rem]">
						<div class="block text-center whitespace-nowrap">{{ $transaction->created_at }}</div>
					</td>
				</tr>
			</tbody>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				<tr class="">
					<td class="py-[.75rem] uppercase text-[.9rem]">{{ __('Items') }}</td>
				</tr>
				@foreach($transaction->items ?? [] as $item)
				<tr class="">
					<td class="py-[.75rem] pr-[1rem]">
						<a href="{{ $item->url }}" class="flex items-center">
							<div class="w-[40px] h-[40px] rounded-[.25rem] mr-[1rem] bg-cover bg-center" style="background-image: url('{{ $item->cover ?? src("storage/covers/default.webp") }}');"></div>
							<div class="">{{ $item->name }}</div>
						</a>
					</td>
					<td class="py-[.75rem] text-right">
						@if(!isset($item->license))
						<a href="{{ $item->file }}" class="text-[.8rem] text-[#7547ff] hover:bg-[#7547ff] hover:text-[#fff] uppercase bg-[#fff] border-[1px] border-[#7547ff] inline-block p-[.5rem_.75rem] pb-[.25rem] hover:font-[600] rounded-[.25rem]">{{ __("Download") }}</a>
						@else
						<div class="group relative">
						    <div class="text-[.8rem] text-[#7547ff] hover:bg-[#7547ff] hover:text-[#fff] uppercase bg-[#fff] border-[1px] border-[#7547ff] inline-block p-[.5rem_.75rem] pb-[.25rem] hover:font-[600] rounded-[.25rem] select-none relative">
						        {{ __("Download") }}
						    </div>
						    <div class="hidden absolute z-[1] bottom-[100%] right-0 group-hover:block">
						        <div class="text-[#000] text-[1rem] bg-[#fff] mb-[.5rem] shadow-[0px_10px_25px_-20px_#00000069] min-w-[200px] rounded-b-[.25rem] overflow-hidden">
						            <a href="{{ $item->file }}" class="block p-[.5rem_.75rem] pb-[.35rem] border-b-[1px] hover:bg-[whitesmoke]">{{ __('Main file') }}</a>
						            <a href="{{ $item->license }}" class="block p-[.5rem_.75rem] pb-[.35rem] hover:bg-[whitesmoke]">{{ __('License key') }}</a>
						        </div>
						    </div>
						</div>
						@endif
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
	@endforeach

	@if($transactions->hasPages())
	<div class="mt-[1.5rem]">
		{{ $transactions->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection
