<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>{{ __('Templates') }}</title>

	<link rel="icon" href="/storage/images/icon.png">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fomantic-ui/2.9.2/semantic.min.css" integrity="sha512-n//BDM4vMPvyca4bJjZPDh7hlqsQ7hqbP9RH18GF2hTXBY5amBwM2501M0GPiwCU/v9Tor2m13GOTFjk00tkQA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

	<script src="https://code.jquery.com/jquery-3.6.3.min.js"></script>

	<style>
		.ui.container {
				min-height: 100vh;
				display: flex;
				align-items: center;
				justify-content: center;
				padding: 2rem;
		}

		.ui.cards {
				width: 100%;
				max-width: 1200px;
		}

		.ui.container .card {
				box-shadow: none !important;
				border-radius: 1rem;
				overflow: hidden;
		}

		.ui.container img {
				width: 100% !important;
				position: absolute;
				left: 0;
				top: 0;
				transition: top 5s ease 0s;
		}

		.ui.container .card .cover {
		    max-height: 90vh;
		    overflow: hidden;
		    position: relative;
		    height: 90vh;
		}

		.ui.container > .container .cards {
		    width: 100%;
		}

		.ui.fluid.container {
		    background: radial-gradient(aliceblue, aliceblue, #fff);
		}

		@media (max-width: 768px) {
			.ui.cards .card {
				margin-left: auto !important;
				margin-right: auto !important;
			}
		}

	</style>

	<script>
		'use strict';

		$(() =>
		{
			$('.card').hover(function()
			{
				let scrollHeight = $('.cover img', this)[0].scrollHeight;

				$('.cover img', this).css({'top': `-${scrollHeight - $(this)[0].clientHeight}px`})
			}, function()
			{				
				$('.cover img', this).css('top', `0`)
			})
		})
	</script>
</head>
<body>
	<div class="ui fluid container">
		<div class="ui two cards stackable doubling">
			<a class="card fluid" title="Valexa script" data-name="axies" href="https://valexa.codemayer.net/set_template?template=axies" target="_blank">
				<div class="content cover">
					<img src="/axies.jpg">
				</div>
			</a>
			<a class="card fluid" title="Valexa script" data-name="tendra" href="https://valexa.codemayer.net/set_template?template=tendra" target="_blank">
				<div class="content cover">
					<img src="/tendra.jpg">
				</div>
			</a>
			{{-- <a class="card fluid" title="Multivendor script" data-name="tendra" href="https://vagrant.standbytutor.com" target="_blank">
				<div class="content cover">
					<img src="/vagrant.jpg">
				</div>
			</a> --}}
		</div>
	</div>
</body>
</html>