<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Features for the upcoming update</title>
	<script type="application/javascript" src="/assets/jquery-3.6.0.min.js"></script>
	<style>
		body {
		  margin: 0;
		  background: #f9f9f9;
		  padding: 1.5rem;
		  box-sizing: border-box;
		}

		body * {
		  font-family: system-ui;
    	font-size: 1.1rem;
    	box-sizing: border-box;
		}

		.container {
	    height: calc(100vh - 3rem);
	    overflow: hidden;
	    max-width: 1200px;
	    width: 100%;
	    margin: auto;
	    border-radius: 0.5rem;
	    display: flex;
	    gap: 1.5rem;
		}

		form .header {
			font-weight: 700;
			margin-bottom: 1rem;
			font-size: 1.3rem;
			text-transform: uppercase;
			text-align: center;
			padding: 0.5rem 1rem;
			background: #5748b10a;
			border-radius: 0.5rem;
		}

		form button {
		    border: none;
		    padding: .5rem 1rem;
		    font-weight: 500;
		    min-width: 120px;
		    border-radius: .25rem;
		    background: #8854e5;
		    color: #fff;
		    font-size: 1.2rem;
		    height: 42px;
		    display: flex;
		    align-items: center;
		    justify-content: center;
		    cursor: pointer;
		}

		form textarea {
	    flex: 1;
	    border: 1px solid #b5b5b5;
	    padding: 0.5rem 1rem;
	    border-radius: 0.25rem;
	    resize: vertical;
	    outline: none;
	    min-height: 250px;
	    width: 100%;
		}

		form button:hover {
			background: #6f3ccb;
		}

		.field * {
		  display: block;
		}

		.field:not(:last-child) {
		  margin-bottom: 1rem;
		}

		.field label {
		  font-weight: 500;
		  margin-bottom: 0.5rem;
		  display: flex;
		}

		.field label sup {
			margin-left: .25rem;
		}
		form input {
		  border: 1px solid #b5b5b5;
		  padding: 0.5rem 1rem;
		  border-radius: 0.25rem;
		  resize: vertical;
		  min-height: 42px;
		  outline: none;
			width: 100%;
		}

		form {
			margin-bottom: 1rem;
			padding: 1.5rem;
			background: #fff;
			position: relative;
			max-width: 360px;
			width: 100%;
		}

		form .message {
	    font-size: 1rem;
	    padding: 0.5rem 1rem;
	    background: #a471ff21;
	    border-radius: 0.25rem;
	    font-weight: 500;
	    color: #4d3d6b;
	    padding-left: 56px;
	    overflow: hidden;
	    position: relative;
	    margin: 1rem 0;
		}

		form .message span {
	    position: absolute;
	    left: 0;
	    display: flex;
	    height: 100%;
	    top: 0;
	    align-items: center;
	    justify-content: center;
	    width: 40px;
	    background: #574975;
	    color: #fff;
	    font-weight: 700;
	    cursor: pointer;
		}

		.features {
			padding: 1.5rem;
			background: #fff;
			height: 100%;
			overflow: auto;
			flex: 1;
		}

		.features .item {
	    padding: 0 0 0 1.5rem;
	    position: relative;
		}

		.features .item:before {
	    content: '';
	    position: absolute;
	    left: 0;
	    top: 0;
	    width: .25rem;
	    height: 100%;
	    background: #ff7c64;
	    border-radius: 1rem;
		}

		.features .item .header {
	    margin-bottom: 1rem;
	    display: flex;
	    align-items: center;
	    justify-content: space-between;
		}

		.features .item .header .username {
	    padding: .25rem 1rem;
	    background: #fff5c1;
	    display: table;
	    border-radius: .5rem;
	    color: #000;
    	font-size: 1rem;
    	font-weight: 500;
		}

		.features .item .header .date {
	    padding: 0.25rem 1rem;
	    display: table;
	    border-radius: 0.5rem;
	    color: #6260bd;
	    border: 1px solid #6260bd;
	    font-weight: 500;
    	font-size: 1rem;
		}

		.features .item:not(:last-child) {
	        margin-bottom: 1.5rem;
		}
		
		.features .item .body {
            line-height: 1.5;
        }
	</style>

	<script>
		'use strict';

		$(() => 
		{
			$(document).on('keydown', 'input', function(e)
			{
				if(e.keyCode === 13)
				{
					e.preventDefault();
					return false;
				}
			})

			$(document).on('click', '#submit', function(e)
			{
				localStorage.setItem('userName', $('input[name="username"]').val().trim())
			})

			if(typeof localStorage.getItem('userName') === "string")
			{
				$('input[name="username"]').val(localStorage.getItem('userName').trim())
			}

			$(document).on('click', '.message span', function()
			{
				$(this).closest('.message').remove()
			})

			if($('.message').length)
			{
				setTimeout(()=>
				{
					$('.message').remove()
				}, 3000)
			}
		})
	</script>
</head>
<body>
	<div class="container">
		<div class="features">
			@foreach($list as $item)
			<div class="item">
				<div class="header">
					<div class="username">{{ $item->username }}</div>
					<div class="date">{{ $item->created_at->format('Y-m-d H:i') }}</div>
				</div>
				<div class="body">
					{!! nl2br(strip_tags($item->features)) !!}
				</div>
			</div>
			@endforeach
		</div>

		<form class="form" action="{{ route('update_features') }}" method="post">
			@csrf
			<div class="header ">Suggestions</div>

			@if($errors->any() || session('message'))
			<div class="message">
				<span>✕</span>{{ $errors->any() ? $errors->all()[0] : session('message') }}
			</div> 
			@endif

			<div class="field">
				<label>Username</label>
				<input type="text" name="username" placeholder="Username">
			</div>

			<div class="field">
				<label>Features <sup>*</sup></label>
				<textarea name="features" cols="30" rows="1" required placeholder="Enter features you want to see in the upcoming update"></textarea>
			</div>

			<button type="submit" id="submit">Submit</button>
		</form>
	</div>
</body>
</html>