/** @type {import('tailwindcss').Config} */

const plugin = require('tailwindcss/plugin');


export default {
  content: [
    "./resources/views/front/tendra/**/*.blade.php",
    "./resources/views/front/axies/**/*.blade.php",
    "./public/assets/tendra.js",
    "./public/assets/axies.js",
    "./resources/views/auth/**/*.blade.php",
    "./resources/views/vendor/pagination/tailwind.blade.php",
    "./resources/views/vendor/pagination/simple-tailwind.blade.php",
    //'./public/assets/app.js'
  ],
  darkMode: 'class',
  theme: {
    extend: {},
  },
  plugins: [
    plugin(function({ matchComponents, theme }) 
    {
      matchComponents(
        {
          "scrollbar-width": (value) => ({
            "--webkit-scrollbar-width": value,
            "--moz-scrollbar-width": value,
            "--ms-scrollbar-width": value,
            "--o-scrollbar-width": value,
            "scrollbar-width": value
          }),
        }
      )
    })
  ]
}

