<?php

@set_time_limit(1800);

define('LARAVEL_START', microtime(true));

require_once __DIR__ . '/../app/Helpers/Helpers.php';

if(!file_exists(__DIR__.'/../update/.env'))
{
	exit("Please extract the script version 4.4.0 to your website main directory / update folder (e.g. public_html/example.com/update)");
}

require_once __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';

$app->make('Illuminate\Contracts\Http\Kernel')->handle(Illuminate\Http\Request::capture());

if(env('APP_VERSION') === '4.4.0')
{
	exit("Update 4.4.0 already installed");
}

# 1. UPDATE SETTINGS
# -----------------------------------
$settings = \App\Models\Setting::first();

$props = array_keys($settings->getAttributes());

foreach($props as $prop)
{
    if(@json_decode($settings->{$prop}))
    {
        $settings->{$prop} = json_decode($settings->{$prop}, true);
    }
}

$general_settings = $settings->general;

if(!isset($general_settings['user_coupons_page']))
{
	$general_settings['filter_by_included_files'] = "0";
	$general_settings['facebook_pixel'] = "";
	$general_settings['force_simple_pagination'] = "1";
	$general_settings['user_coupons_page'] = "0";
	$general_settings['fonts'] = [
	    "ltr" => [
	        "url" => null,
	        "dir" => "Spartan"
	    ],
	    "rtl" => [
	        "url" => "https://fonts.googleapis.com/css2?family=Almarai:wght@300;400;700;800&display=swap",
	        "dir" => null
	    ]
	];

	$general_settings['js_css_code'] = [
	    "frontend" => null,
	    "backend" => null,
	];

	foreach($general_settings as $key => &$val)
	{
		if(is_object($val) || is_array($val))
		{
			$val = json_encode($val);
		}
	}

	$settings->general = $general_settings;

	$payment_settings = $settings->payments;

	$payment_settings['update_pending_transactions'] = "0";

	$settings->payments = $payment_settings;

	$settings->save();
}
# -----------------------------------


# 2. UPDATE TRANSACTIONS
# -----------------------------------
$transactions = \App\Models\Transaction::get();

foreach($transactions as $transaction)
{
    $transaction_details = [
        "items" => [],
        "subscription" => null,
        "prepaid_credit" => null,
        "processor" => null,
        "amount" => null,
        "discount" => null,
        "fee" => null,
        "tax" => null,
        "type" => null,
        "currency" => "USD",
        "exchange_rate" => 1,
        "reference_id" => null,
    ];

    $transaction_type = $transaction->items_count > 0 ? 'product' : ($transaction->is_subscription ? 'subscriptions' : 'credits');

    $transaction->details = json_decode($transaction->details, true);

    $transaction_licenses = json_decode($transaction->licenses ?? '', true);

    if(isset($transaction->details['cart']) && is_array($transaction->details['cart']))
    {
        $transaction_details['items'] = array_reduce($transaction->details['cart'] ?? [], function($carry, $item) use($transaction_licenses, $transaction)
        {
        	if(isset($item['category_name'], $item['license_id']))
        	{
	            $category = \App\Models\Category::where(['name' => $item['category_name'], 'for' => '1'])->first();
	            $license  = \App\Models\License::where('id', $item['license_id'])->first();

	            $carry[$item['id']] = [
	                "id" => $item['id'],
	                "item_id" => $item['id'],
	                "category_id" => $category->id,
	                "category_name" => $category->name,
	                "category_url" => env('APP_URL')."/items/category/{$category->slug}",
	                "url" => item_url($item),
	                "name" => $item['name'],
	                "cover" => env('APP_URL')."/storage/covers/{$item['cover']}",
	                "price" => $item['price'],
	                "extended_license" => !$license->regular ? 1 : 0,
	                "custom_price" => null,
	                "price_expiry" => null,
	                "has_promo" => 0,
	                "uuid" => null,
	                "created_at" => format_date($transaction->created_at, 'Y-m-d H:i:s'),
	                "updated_at" => format_date($transaction->updated_at, 'Y-m-d H:i:s'),
	                "delete_at" => null,
	                "license" => $transaction_licenses[$item['id']] ?? null
	            ];
	        }

            return $carry;
        }, []);

        $transaction_details['cart'] = $transaction_details['items'];

        unset($transaction_details['items']);
    }
    elseif($transaction_type === "subscription" || $transaction->is_subscription)
    {
        $transaction_details['subscription'] = \App\Models\Pricing_Table::where('id', $transaction->products_ids)->first()->toArray();
    }
    elseif($transaction_type === "credits")
    {
        $transaction_details['prepaid_credit'] = \App\Models\Prepaid_Credit::where('id', $transaction->products_ids)->first()->toArray();
    }

    $transaction_details['type']     = $transaction_type;
    $transaction_details['amount']   = $transaction->amount;
    $transaction_details['discount'] = $transaction->discount;
    $transaction_details['fee']      = @json_decode($transaction->details['fee']) ? (json_decode($transaction->details['fee'], true)['value'] ?? 0) : 0;
    $transaction_details['tax']      = @json_decode($transaction->details['tax']) ? (json_decode($transaction->details['tax'], true)['value'] ?? 0) : 0;;
    $transaction_details['amount']   = $transaction->amount;

    $transaction->details = json_encode($transaction_details);

    $transaction->save();
}
# -----------------------------------


# 3. UPDATE PRODUCTS DATABASE TABLE
# -----------------------------------
DB::unprepared(<<<SQL
	ALTER TABLE products ADD COLUMN price float NULL DEFAULT NULL;
	ALTER TABLE products ADD COLUMN extended_price float NULL DEFAULT NULL;
	ALTER TABLE products ADD COLUMN promo_price float NULL DEFAULT NULL;
	ALTER TABLE products ADD COLUMN promo_time varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL DEFAULT NULL;
	UPDATE products SET promo_time = promotional_price_time;
	ALTER TABLE products DROP COLUMN promotional_price_time;
	ALTER TABLE products ADD COLUMN rating float NULL DEFAULT NULL;
	ALTER TABLE products ADD COLUMN sales int NULL DEFAULT NULL;
	ALTER TABLE products ADD COLUMN comments int NULL DEFAULT NULL;
	ALTER TABLE products ADD COLUMN reviews int NULL DEFAULT NULL;
	ALTER TABLE products ADD COLUMN fake_rating float NULL DEFAULT NULL;
	ALTER TABLE products DROP INDEX free;
	ALTER TABLE products DROP COLUMN free;
	ALTER TABLE products ADD INDEX fake_rating(fake_rating ASC) USING BTREE;
	ALTER TABLE products ADD INDEX rating(rating ASC) USING BTREE;
SQL);

$product_licenses = \App\Models\License::get();

$regular_license  = $product_licenses->where('regular', 1)->first();
$extended_license = $product_licenses->where('regular', 0)->first();

if($regular_license->id ?? null)
{
	DB::update("UPDATE products SET price = (SELECT price FROM product_price WHERE product_price.product_id = products.id AND license_id = ? LIMIT 1)", [$regular_license->id]);
}

if($extended_license->id ?? null)
{
	DB::update("UPDATE products SET extended_price = (SELECT price FROM product_price WHERE product_price.product_id = products.id AND license_id = ? LIMIT 1)", [$extended_license->id]);
}

DB::update("UPDATE products SET promo_price = (SELECT promo_price FROM product_price WHERE product_price.product_id = products.id LIMIT 1)");
# -----------------------------------



# 3. UPDATE OTHER DATABASE TABLES
# -----------------------------------
DB::unprepared(<<<SQL
	START TRANSACTION;
	SET FOREIGN_KEY_CHECKS=0;
	ALTER TABLE affiliate_earnings MODIFY COLUMN commission_value float NOT NULL AFTER commission_percent;
	ALTER TABLE categories ADD COLUMN views int NULL DEFAULT NULL AFTER featured;
	CREATE TABLE IF NOT EXISTS category_product  (
	  category_id bigint NOT NULL,
	  product_id bigint NOT NULL,
	  featured tinyint(1) NULL DEFAULT NULL,
	  trending tinyint(1) NULL DEFAULT NULL,
	  UNIQUE INDEX category_id_product_id(category_id ASC, product_id ASC) USING BTREE
	) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_unicode_ci ROW_FORMAT = Dynamic;
	CREATE TABLE IF NOT EXISTS personal_access_tokens  (
	  id bigint UNSIGNED NOT NULL AUTO_INCREMENT,
	  tokenable_type varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
	  tokenable_id bigint UNSIGNED NOT NULL,
	  name varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
	  token varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
	  abilities text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL,
	  last_used_at timestamp NULL DEFAULT NULL,
	  created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
	  updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
	  PRIMARY KEY (id) USING BTREE,
	  UNIQUE INDEX personal_access_tokens_token_unique(token ASC) USING BTREE,
	  INDEX personal_access_tokens_tokenable_type_tokenable_id_index(tokenable_type ASC, tokenable_id ASC) USING BTREE
	) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_unicode_ci ROW_FORMAT = Dynamic;
	ALTER TABLE prepaid_credits ADD COLUMN subheading varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL DEFAULT "Lorem ipsum dolor sit amet, consectetur adipisicing elit" AFTER name;
	ALTER TABLE pricing_table ADD COLUMN subheading varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL DEFAULT "Lorem ipsum dolor sit amet, consectetur adipisicing elit" AFTER slug;
	ALTER TABLE transactions ADD COLUMN cart_id varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL DEFAULT NULL AFTER sandbox;
	ALTER TABLE transactions DROP INDEX licenses_ids;
	ALTER TABLE transactions DROP COLUMN licenses_ids;
	DROP TABLE IF EXISTS user_shopping_cart_item;
	CREATE TABLE IF NOT EXISTS user_shopping_cart_item  (
	  id bigint NOT NULL AUTO_INCREMENT,
	  item_id bigint NOT NULL,
	  category_id bigint NOT NULL,
	  category_name varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
	  category_url varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
	  url varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
	  name varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
	  summary text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL,
	  cover varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NULL DEFAULT NULL,
	  price float NOT NULL,
	  extended_license tinyint(1) NOT NULL DEFAULT 0,
	  custom_price float NULL DEFAULT NULL,
	  price_expiry int NULL DEFAULT NULL COMMENT 'expiry for promo and group buy',
	  has_promo tinyint NULL DEFAULT 0,
	  uuid varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
	  created_at datetime NULL DEFAULT CURRENT_TIMESTAMP,
	  updated_at datetime NULL DEFAULT CURRENT_TIMESTAMP,
	  delete_at datetime NULL DEFAULT NULL,
	  PRIMARY KEY (id) USING BTREE
	) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_unicode_ci ROW_FORMAT = Dynamic;
	DROP TABLE IF EXISTS licenses;
	DROP TABLE IF EXISTS product_price;
	SET FOREIGN_KEY_CHECKS=1;
	COMMIT;
SQL);
# -----------------------------------


# 4. UPDATE FILES & DIRS
# -----------------------------------
$dirs = [
	__DIR__.'/../update/app' => __DIR__.'/../app',
	__DIR__.'/../update/bootstrap' => __DIR__.'/../bootstrap',
	__DIR__.'/../update/config' => __DIR__.'/../config',
	__DIR__.'/../update/database' => __DIR__.'/../database',
	__DIR__.'/../update/public/assets' => __DIR__.'/../public/assets',
	__DIR__.'/../update/resources' => __DIR__.'/../resources',
	__DIR__.'/../update/routes' => __DIR__.'/../routes',
	__DIR__.'/../update/vendor' => __DIR__.'/../vendor',
];

foreach($dirs as $directory => $destination)
{
	if(!\File::copyDirectory($directory, $destination))
	{
		abort(403, "Failed to copy {$directory} directory to {$destination}");
	}
}

$files = [
	__DIR__.'/../update/public/index.php' => __DIR__.'/index.php',
	__DIR__.'/../update/composer.json' => __DIR__.'/../composer.json',
];

foreach($files as $path => $target)
{	
	if(!\File::copy($path, $target))
	{
		abort(403, "Failed to copy {$path} file to {$target}");
	}
}
# -----------------------------------


# 4. UPDATE SCRIPT VERSION
# -----------------------------------
update_env_var("APP_VERSION", "4.4.0");
# -----------------------------------


exit("Update installed successfully, please remove this file from '/public' folder");
