<?php

/**
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\LegalEntityManagement;

use \ArrayAccess;
use Adyen\Model\LegalEntityManagement\ObjectSerializer;

/**
 * VerificationError Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class VerificationError implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'VerificationError';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'capabilities' => 'string[]',
        'code' => 'string',
        'message' => 'string',
        'remediatingActions' => '\Adyen\Model\LegalEntityManagement\RemediatingAction[]',
        'subErrors' => '\Adyen\Model\LegalEntityManagement\VerificationErrorRecursive[]',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'capabilities' => null,
        'code' => null,
        'message' => null,
        'remediatingActions' => null,
        'subErrors' => null,
        'type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'capabilities' => false,
        'code' => false,
        'message' => false,
        'remediatingActions' => false,
        'subErrors' => false,
        'type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'capabilities' => 'capabilities',
        'code' => 'code',
        'message' => 'message',
        'remediatingActions' => 'remediatingActions',
        'subErrors' => 'subErrors',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'capabilities' => 'setCapabilities',
        'code' => 'setCode',
        'message' => 'setMessage',
        'remediatingActions' => 'setRemediatingActions',
        'subErrors' => 'setSubErrors',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'capabilities' => 'getCapabilities',
        'code' => 'getCode',
        'message' => 'getMessage',
        'remediatingActions' => 'getRemediatingActions',
        'subErrors' => 'getSubErrors',
        'type' => 'getType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CAPABILITIES_ACCEPT_EXTERNAL_FUNDING = 'acceptExternalFunding';
    public const CAPABILITIES_ACCEPT_PSP_FUNDING = 'acceptPspFunding';
    public const CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_COUNTRIES = 'acceptTransactionInRestrictedCountries';
    public const CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_COUNTRIES_COMMERCIAL = 'acceptTransactionInRestrictedCountriesCommercial';
    public const CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_COUNTRIES_CONSUMER = 'acceptTransactionInRestrictedCountriesConsumer';
    public const CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_INDUSTRIES = 'acceptTransactionInRestrictedIndustries';
    public const CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_INDUSTRIES_COMMERCIAL = 'acceptTransactionInRestrictedIndustriesCommercial';
    public const CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_INDUSTRIES_CONSUMER = 'acceptTransactionInRestrictedIndustriesConsumer';
    public const CAPABILITIES_ACQUIRING = 'acquiring';
    public const CAPABILITIES_ATM_WITHDRAWAL = 'atmWithdrawal';
    public const CAPABILITIES_ATM_WITHDRAWAL_COMMERCIAL = 'atmWithdrawalCommercial';
    public const CAPABILITIES_ATM_WITHDRAWAL_CONSUMER = 'atmWithdrawalConsumer';
    public const CAPABILITIES_ATM_WITHDRAWAL_IN_RESTRICTED_COUNTRIES = 'atmWithdrawalInRestrictedCountries';
    public const CAPABILITIES_ATM_WITHDRAWAL_IN_RESTRICTED_COUNTRIES_COMMERCIAL = 'atmWithdrawalInRestrictedCountriesCommercial';
    public const CAPABILITIES_ATM_WITHDRAWAL_IN_RESTRICTED_COUNTRIES_CONSUMER = 'atmWithdrawalInRestrictedCountriesConsumer';
    public const CAPABILITIES_AUTHORISED_PAYMENT_INSTRUMENT_USER = 'authorisedPaymentInstrumentUser';
    public const CAPABILITIES_GET_GRANT_OFFERS = 'getGrantOffers';
    public const CAPABILITIES_ISSUE_BANK_ACCOUNT = 'issueBankAccount';
    public const CAPABILITIES_ISSUE_CARD = 'issueCard';
    public const CAPABILITIES_ISSUE_CARD_COMMERCIAL = 'issueCardCommercial';
    public const CAPABILITIES_ISSUE_CARD_CONSUMER = 'issueCardConsumer';
    public const CAPABILITIES_ISSUE_CREDIT_LIMIT = 'issueCreditLimit';
    public const CAPABILITIES_LOCAL_ACCEPTANCE = 'localAcceptance';
    public const CAPABILITIES_PAYOUT = 'payout';
    public const CAPABILITIES_PAYOUT_TO_TRANSFER_INSTRUMENT = 'payoutToTransferInstrument';
    public const CAPABILITIES_PROCESSING = 'processing';
    public const CAPABILITIES_RECEIVE_FROM_BALANCE_ACCOUNT = 'receiveFromBalanceAccount';
    public const CAPABILITIES_RECEIVE_FROM_PLATFORM_PAYMENTS = 'receiveFromPlatformPayments';
    public const CAPABILITIES_RECEIVE_FROM_THIRD_PARTY = 'receiveFromThirdParty';
    public const CAPABILITIES_RECEIVE_FROM_TRANSFER_INSTRUMENT = 'receiveFromTransferInstrument';
    public const CAPABILITIES_RECEIVE_GRANTS = 'receiveGrants';
    public const CAPABILITIES_RECEIVE_PAYMENTS = 'receivePayments';
    public const CAPABILITIES_SEND_TO_BALANCE_ACCOUNT = 'sendToBalanceAccount';
    public const CAPABILITIES_SEND_TO_THIRD_PARTY = 'sendToThirdParty';
    public const CAPABILITIES_SEND_TO_TRANSFER_INSTRUMENT = 'sendToTransferInstrument';
    public const CAPABILITIES_THIRD_PARTY_FUNDING = 'thirdPartyFunding';
    public const CAPABILITIES_USE_CARD = 'useCard';
    public const CAPABILITIES_USE_CARD_COMMERCIAL = 'useCardCommercial';
    public const CAPABILITIES_USE_CARD_CONSUMER = 'useCardConsumer';
    public const CAPABILITIES_USE_CARD_IN_RESTRICTED_COUNTRIES = 'useCardInRestrictedCountries';
    public const CAPABILITIES_USE_CARD_IN_RESTRICTED_COUNTRIES_COMMERCIAL = 'useCardInRestrictedCountriesCommercial';
    public const CAPABILITIES_USE_CARD_IN_RESTRICTED_COUNTRIES_CONSUMER = 'useCardInRestrictedCountriesConsumer';
    public const CAPABILITIES_USE_CARD_IN_RESTRICTED_INDUSTRIES = 'useCardInRestrictedIndustries';
    public const CAPABILITIES_USE_CARD_IN_RESTRICTED_INDUSTRIES_COMMERCIAL = 'useCardInRestrictedIndustriesCommercial';
    public const CAPABILITIES_USE_CARD_IN_RESTRICTED_INDUSTRIES_CONSUMER = 'useCardInRestrictedIndustriesConsumer';
    public const CAPABILITIES_WITHDRAW_FROM_ATM = 'withdrawFromAtm';
    public const CAPABILITIES_WITHDRAW_FROM_ATM_COMMERCIAL = 'withdrawFromAtmCommercial';
    public const CAPABILITIES_WITHDRAW_FROM_ATM_CONSUMER = 'withdrawFromAtmConsumer';
    public const CAPABILITIES_WITHDRAW_FROM_ATM_IN_RESTRICTED_COUNTRIES = 'withdrawFromAtmInRestrictedCountries';
    public const CAPABILITIES_WITHDRAW_FROM_ATM_IN_RESTRICTED_COUNTRIES_COMMERCIAL = 'withdrawFromAtmInRestrictedCountriesCommercial';
    public const CAPABILITIES_WITHDRAW_FROM_ATM_IN_RESTRICTED_COUNTRIES_CONSUMER = 'withdrawFromAtmInRestrictedCountriesConsumer';
    public const TYPE_DATA_MISSING = 'dataMissing';
    public const TYPE_DATA_REVIEW = 'dataReview';
    public const TYPE_INVALID_INPUT = 'invalidInput';
    public const TYPE_PENDING_STATUS = 'pendingStatus';
    public const TYPE_REJECTED = 'rejected';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCapabilitiesAllowableValues()
    {
        return [
            self::CAPABILITIES_ACCEPT_EXTERNAL_FUNDING,
            self::CAPABILITIES_ACCEPT_PSP_FUNDING,
            self::CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_COUNTRIES,
            self::CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_COUNTRIES_COMMERCIAL,
            self::CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_COUNTRIES_CONSUMER,
            self::CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_INDUSTRIES,
            self::CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_INDUSTRIES_COMMERCIAL,
            self::CAPABILITIES_ACCEPT_TRANSACTION_IN_RESTRICTED_INDUSTRIES_CONSUMER,
            self::CAPABILITIES_ACQUIRING,
            self::CAPABILITIES_ATM_WITHDRAWAL,
            self::CAPABILITIES_ATM_WITHDRAWAL_COMMERCIAL,
            self::CAPABILITIES_ATM_WITHDRAWAL_CONSUMER,
            self::CAPABILITIES_ATM_WITHDRAWAL_IN_RESTRICTED_COUNTRIES,
            self::CAPABILITIES_ATM_WITHDRAWAL_IN_RESTRICTED_COUNTRIES_COMMERCIAL,
            self::CAPABILITIES_ATM_WITHDRAWAL_IN_RESTRICTED_COUNTRIES_CONSUMER,
            self::CAPABILITIES_AUTHORISED_PAYMENT_INSTRUMENT_USER,
            self::CAPABILITIES_GET_GRANT_OFFERS,
            self::CAPABILITIES_ISSUE_BANK_ACCOUNT,
            self::CAPABILITIES_ISSUE_CARD,
            self::CAPABILITIES_ISSUE_CARD_COMMERCIAL,
            self::CAPABILITIES_ISSUE_CARD_CONSUMER,
            self::CAPABILITIES_ISSUE_CREDIT_LIMIT,
            self::CAPABILITIES_LOCAL_ACCEPTANCE,
            self::CAPABILITIES_PAYOUT,
            self::CAPABILITIES_PAYOUT_TO_TRANSFER_INSTRUMENT,
            self::CAPABILITIES_PROCESSING,
            self::CAPABILITIES_RECEIVE_FROM_BALANCE_ACCOUNT,
            self::CAPABILITIES_RECEIVE_FROM_PLATFORM_PAYMENTS,
            self::CAPABILITIES_RECEIVE_FROM_THIRD_PARTY,
            self::CAPABILITIES_RECEIVE_FROM_TRANSFER_INSTRUMENT,
            self::CAPABILITIES_RECEIVE_GRANTS,
            self::CAPABILITIES_RECEIVE_PAYMENTS,
            self::CAPABILITIES_SEND_TO_BALANCE_ACCOUNT,
            self::CAPABILITIES_SEND_TO_THIRD_PARTY,
            self::CAPABILITIES_SEND_TO_TRANSFER_INSTRUMENT,
            self::CAPABILITIES_THIRD_PARTY_FUNDING,
            self::CAPABILITIES_USE_CARD,
            self::CAPABILITIES_USE_CARD_COMMERCIAL,
            self::CAPABILITIES_USE_CARD_CONSUMER,
            self::CAPABILITIES_USE_CARD_IN_RESTRICTED_COUNTRIES,
            self::CAPABILITIES_USE_CARD_IN_RESTRICTED_COUNTRIES_COMMERCIAL,
            self::CAPABILITIES_USE_CARD_IN_RESTRICTED_COUNTRIES_CONSUMER,
            self::CAPABILITIES_USE_CARD_IN_RESTRICTED_INDUSTRIES,
            self::CAPABILITIES_USE_CARD_IN_RESTRICTED_INDUSTRIES_COMMERCIAL,
            self::CAPABILITIES_USE_CARD_IN_RESTRICTED_INDUSTRIES_CONSUMER,
            self::CAPABILITIES_WITHDRAW_FROM_ATM,
            self::CAPABILITIES_WITHDRAW_FROM_ATM_COMMERCIAL,
            self::CAPABILITIES_WITHDRAW_FROM_ATM_CONSUMER,
            self::CAPABILITIES_WITHDRAW_FROM_ATM_IN_RESTRICTED_COUNTRIES,
            self::CAPABILITIES_WITHDRAW_FROM_ATM_IN_RESTRICTED_COUNTRIES_COMMERCIAL,
            self::CAPABILITIES_WITHDRAW_FROM_ATM_IN_RESTRICTED_COUNTRIES_CONSUMER,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_DATA_MISSING,
            self::TYPE_DATA_REVIEW,
            self::TYPE_INVALID_INPUT,
            self::TYPE_PENDING_STATUS,
            self::TYPE_REJECTED,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('capabilities', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('message', $data ?? [], null);
        $this->setIfExists('remediatingActions', $data ?? [], null);
        $this->setIfExists('subErrors', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets capabilities
     *
     * @return string[]|null
     */
    public function getCapabilities()
    {
        return $this->container['capabilities'];
    }

    /**
     * Sets capabilities
     *
     * @param string[]|null $capabilities Contains key-value pairs that specify the actions that the legal entity can do in your platform. The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.
     *
     * @return self
     */
    public function setCapabilities($capabilities)
    {
        $allowedValues = $this->getCapabilitiesAllowableValues();
        if (array_diff($capabilities, $allowedValues)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'capabilities', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['capabilities'] = $capabilities;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code The general error code.
     *
     * @return self
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets message
     *
     * @return string|null
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     *
     * @param string|null $message The general error message.
     *
     * @return self
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets remediatingActions
     *
     * @return \Adyen\Model\LegalEntityManagement\RemediatingAction[]|null
     */
    public function getRemediatingActions()
    {
        return $this->container['remediatingActions'];
    }

    /**
     * Sets remediatingActions
     *
     * @param \Adyen\Model\LegalEntityManagement\RemediatingAction[]|null $remediatingActions An object containing possible solutions to fix a verification error.
     *
     * @return self
     */
    public function setRemediatingActions($remediatingActions)
    {
        $this->container['remediatingActions'] = $remediatingActions;

        return $this;
    }

    /**
     * Gets subErrors
     *
     * @return \Adyen\Model\LegalEntityManagement\VerificationErrorRecursive[]|null
     */
    public function getSubErrors()
    {
        return $this->container['subErrors'];
    }

    /**
     * Sets subErrors
     *
     * @param \Adyen\Model\LegalEntityManagement\VerificationErrorRecursive[]|null $subErrors An array containing more granular information about the cause of the verification error.
     *
     * @return self
     */
    public function setSubErrors($subErrors)
    {
        $this->container['subErrors'] = $subErrors;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The type of error.  Possible values: *  **invalidInput** *  **dataMissing** *  **pendingStatus** *  **rejected** *  **dataReview**
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
