<?php

/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Management;

use \ArrayAccess;
use Adyen\Model\Management\ObjectSerializer;

/**
 * PaymentMethodSetupInfo Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentMethodSetupInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentMethodSetupInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'accel' => '\Adyen\Model\Management\AccelInfo',
        'afterpayTouch' => '\Adyen\Model\Management\AfterpayTouchInfo',
        'amex' => '\Adyen\Model\Management\AmexInfo',
        'applePay' => '\Adyen\Model\Management\ApplePayInfo',
        'bcmc' => '\Adyen\Model\Management\BcmcInfo',
        'businessLineId' => 'string',
        'cartesBancaires' => '\Adyen\Model\Management\CartesBancairesInfo',
        'clearpay' => '\Adyen\Model\Management\ClearpayInfo',
        'countries' => 'string[]',
        'cup' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'currencies' => 'string[]',
        'customRoutingFlags' => 'string[]',
        'diners' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'discover' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'eftposAustralia' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'giroPay' => '\Adyen\Model\Management\GiroPayInfo',
        'girocard' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'googlePay' => '\Adyen\Model\Management\GooglePayInfo',
        'ideal' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'interacCard' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'jcb' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'klarna' => '\Adyen\Model\Management\KlarnaInfo',
        'maestro' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'mc' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'mealVoucherFR' => '\Adyen\Model\Management\MealVoucherFRInfo',
        'nyce' => '\Adyen\Model\Management\NyceInfo',
        'payme' => '\Adyen\Model\Management\PayMeInfo',
        'paypal' => '\Adyen\Model\Management\PayPalInfo',
        'pulse' => '\Adyen\Model\Management\PulseInfo',
        'reference' => 'string',
        'shopperInteraction' => 'string',
        'sodexo' => '\Adyen\Model\Management\SodexoInfo',
        'sofort' => '\Adyen\Model\Management\SofortInfo',
        'star' => '\Adyen\Model\Management\StarInfo',
        'storeIds' => 'string[]',
        'swish' => '\Adyen\Model\Management\SwishInfo',
        'ticket' => '\Adyen\Model\Management\TicketInfo',
        'twint' => '\Adyen\Model\Management\TwintInfo',
        'type' => 'string',
        'vipps' => '\Adyen\Model\Management\VippsInfo',
        'visa' => '\Adyen\Model\Management\GenericPmWithTdiInfo',
        'wechatpay' => '\Adyen\Model\Management\WeChatPayInfo',
        'wechatpayPos' => '\Adyen\Model\Management\WeChatPayPosInfo'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'accel' => null,
        'afterpayTouch' => null,
        'amex' => null,
        'applePay' => null,
        'bcmc' => null,
        'businessLineId' => null,
        'cartesBancaires' => null,
        'clearpay' => null,
        'countries' => null,
        'cup' => null,
        'currencies' => null,
        'customRoutingFlags' => null,
        'diners' => null,
        'discover' => null,
        'eftposAustralia' => null,
        'giroPay' => null,
        'girocard' => null,
        'googlePay' => null,
        'ideal' => null,
        'interacCard' => null,
        'jcb' => null,
        'klarna' => null,
        'maestro' => null,
        'mc' => null,
        'mealVoucherFR' => null,
        'nyce' => null,
        'payme' => null,
        'paypal' => null,
        'pulse' => null,
        'reference' => null,
        'shopperInteraction' => null,
        'sodexo' => null,
        'sofort' => null,
        'star' => null,
        'storeIds' => null,
        'swish' => null,
        'ticket' => null,
        'twint' => null,
        'type' => null,
        'vipps' => null,
        'visa' => null,
        'wechatpay' => null,
        'wechatpayPos' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'accel' => false,
        'afterpayTouch' => false,
        'amex' => false,
        'applePay' => false,
        'bcmc' => false,
        'businessLineId' => false,
        'cartesBancaires' => false,
        'clearpay' => false,
        'countries' => false,
        'cup' => false,
        'currencies' => false,
        'customRoutingFlags' => false,
        'diners' => false,
        'discover' => false,
        'eftposAustralia' => false,
        'giroPay' => false,
        'girocard' => false,
        'googlePay' => false,
        'ideal' => false,
        'interacCard' => false,
        'jcb' => false,
        'klarna' => false,
        'maestro' => false,
        'mc' => false,
        'mealVoucherFR' => false,
        'nyce' => false,
        'payme' => false,
        'paypal' => false,
        'pulse' => false,
        'reference' => false,
        'shopperInteraction' => false,
        'sodexo' => false,
        'sofort' => false,
        'star' => false,
        'storeIds' => false,
        'swish' => false,
        'ticket' => false,
        'twint' => false,
        'type' => false,
        'vipps' => false,
        'visa' => false,
        'wechatpay' => false,
        'wechatpayPos' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'accel' => 'accel',
        'afterpayTouch' => 'afterpayTouch',
        'amex' => 'amex',
        'applePay' => 'applePay',
        'bcmc' => 'bcmc',
        'businessLineId' => 'businessLineId',
        'cartesBancaires' => 'cartesBancaires',
        'clearpay' => 'clearpay',
        'countries' => 'countries',
        'cup' => 'cup',
        'currencies' => 'currencies',
        'customRoutingFlags' => 'customRoutingFlags',
        'diners' => 'diners',
        'discover' => 'discover',
        'eftposAustralia' => 'eftpos_australia',
        'giroPay' => 'giroPay',
        'girocard' => 'girocard',
        'googlePay' => 'googlePay',
        'ideal' => 'ideal',
        'interacCard' => 'interac_card',
        'jcb' => 'jcb',
        'klarna' => 'klarna',
        'maestro' => 'maestro',
        'mc' => 'mc',
        'mealVoucherFR' => 'mealVoucher_FR',
        'nyce' => 'nyce',
        'payme' => 'payme',
        'paypal' => 'paypal',
        'pulse' => 'pulse',
        'reference' => 'reference',
        'shopperInteraction' => 'shopperInteraction',
        'sodexo' => 'sodexo',
        'sofort' => 'sofort',
        'star' => 'star',
        'storeIds' => 'storeIds',
        'swish' => 'swish',
        'ticket' => 'ticket',
        'twint' => 'twint',
        'type' => 'type',
        'vipps' => 'vipps',
        'visa' => 'visa',
        'wechatpay' => 'wechatpay',
        'wechatpayPos' => 'wechatpay_pos'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'accel' => 'setAccel',
        'afterpayTouch' => 'setAfterpayTouch',
        'amex' => 'setAmex',
        'applePay' => 'setApplePay',
        'bcmc' => 'setBcmc',
        'businessLineId' => 'setBusinessLineId',
        'cartesBancaires' => 'setCartesBancaires',
        'clearpay' => 'setClearpay',
        'countries' => 'setCountries',
        'cup' => 'setCup',
        'currencies' => 'setCurrencies',
        'customRoutingFlags' => 'setCustomRoutingFlags',
        'diners' => 'setDiners',
        'discover' => 'setDiscover',
        'eftposAustralia' => 'setEftposAustralia',
        'giroPay' => 'setGiroPay',
        'girocard' => 'setGirocard',
        'googlePay' => 'setGooglePay',
        'ideal' => 'setIdeal',
        'interacCard' => 'setInteracCard',
        'jcb' => 'setJcb',
        'klarna' => 'setKlarna',
        'maestro' => 'setMaestro',
        'mc' => 'setMc',
        'mealVoucherFR' => 'setMealVoucherFR',
        'nyce' => 'setNyce',
        'payme' => 'setPayme',
        'paypal' => 'setPaypal',
        'pulse' => 'setPulse',
        'reference' => 'setReference',
        'shopperInteraction' => 'setShopperInteraction',
        'sodexo' => 'setSodexo',
        'sofort' => 'setSofort',
        'star' => 'setStar',
        'storeIds' => 'setStoreIds',
        'swish' => 'setSwish',
        'ticket' => 'setTicket',
        'twint' => 'setTwint',
        'type' => 'setType',
        'vipps' => 'setVipps',
        'visa' => 'setVisa',
        'wechatpay' => 'setWechatpay',
        'wechatpayPos' => 'setWechatpayPos'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'accel' => 'getAccel',
        'afterpayTouch' => 'getAfterpayTouch',
        'amex' => 'getAmex',
        'applePay' => 'getApplePay',
        'bcmc' => 'getBcmc',
        'businessLineId' => 'getBusinessLineId',
        'cartesBancaires' => 'getCartesBancaires',
        'clearpay' => 'getClearpay',
        'countries' => 'getCountries',
        'cup' => 'getCup',
        'currencies' => 'getCurrencies',
        'customRoutingFlags' => 'getCustomRoutingFlags',
        'diners' => 'getDiners',
        'discover' => 'getDiscover',
        'eftposAustralia' => 'getEftposAustralia',
        'giroPay' => 'getGiroPay',
        'girocard' => 'getGirocard',
        'googlePay' => 'getGooglePay',
        'ideal' => 'getIdeal',
        'interacCard' => 'getInteracCard',
        'jcb' => 'getJcb',
        'klarna' => 'getKlarna',
        'maestro' => 'getMaestro',
        'mc' => 'getMc',
        'mealVoucherFR' => 'getMealVoucherFR',
        'nyce' => 'getNyce',
        'payme' => 'getPayme',
        'paypal' => 'getPaypal',
        'pulse' => 'getPulse',
        'reference' => 'getReference',
        'shopperInteraction' => 'getShopperInteraction',
        'sodexo' => 'getSodexo',
        'sofort' => 'getSofort',
        'star' => 'getStar',
        'storeIds' => 'getStoreIds',
        'swish' => 'getSwish',
        'ticket' => 'getTicket',
        'twint' => 'getTwint',
        'type' => 'getType',
        'vipps' => 'getVipps',
        'visa' => 'getVisa',
        'wechatpay' => 'getWechatpay',
        'wechatpayPos' => 'getWechatpayPos'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const SHOPPER_INTERACTION_E_COMMERCE = 'eCommerce';
    public const SHOPPER_INTERACTION_POS = 'pos';
    public const SHOPPER_INTERACTION_MOTO = 'moto';
    public const SHOPPER_INTERACTION_CONT_AUTH = 'contAuth';
    public const TYPE_ACCEL = 'accel';
    public const TYPE_AFTERPAYTOUCH = 'afterpaytouch';
    public const TYPE_ALELO = 'alelo';
    public const TYPE_ALIPAY = 'alipay';
    public const TYPE_ALIPAY_HK = 'alipay_hk';
    public const TYPE_AMEX = 'amex';
    public const TYPE_APPLEPAY = 'applepay';
    public const TYPE_BANESE_CARD = 'banese_card';
    public const TYPE_BANESE_CARD_CREDIT = 'banese_card_credit';
    public const TYPE_BANESE_CARD_DEBIT = 'banese_card_debit';
    public const TYPE_BANESE_CARD_PREPAID = 'banese_card_prepaid';
    public const TYPE_BCMC = 'bcmc';
    public const TYPE_BLIK = 'blik';
    public const TYPE_CARTEBANCAIRE = 'cartebancaire';
    public const TYPE_CLEARPAY = 'clearpay';
    public const TYPE_CLICKTOPAY = 'clicktopay';
    public const TYPE_CREDTODOS = 'credtodos';
    public const TYPE_CREDTODOS_PRIVATE_CREDIT = 'credtodos_private_credit';
    public const TYPE_CREDTODOS_PRIVATE_DEBIT = 'credtodos_private_debit';
    public const TYPE_CUP = 'cup';
    public const TYPE_DINERS = 'diners';
    public const TYPE_DIRECTDEBIT_GB = 'directdebit_GB';
    public const TYPE_DISCOVER = 'discover';
    public const TYPE_EBANKING_FI = 'ebanking_FI';
    public const TYPE_EFTPOS_AUSTRALIA = 'eftpos_australia';
    public const TYPE_ELO = 'elo';
    public const TYPE_ELOCREDIT = 'elocredit';
    public const TYPE_ELODEBIT = 'elodebit';
    public const TYPE_GIROCARD = 'girocard';
    public const TYPE_GOOGLEPAY = 'googlepay';
    public const TYPE_HIPER = 'hiper';
    public const TYPE_HIPERCARD = 'hipercard';
    public const TYPE_IDEAL = 'ideal';
    public const TYPE_INTERAC_CARD = 'interac_card';
    public const TYPE_JCB = 'jcb';
    public const TYPE_KLARNA = 'klarna';
    public const TYPE_KLARNA_ACCOUNT = 'klarna_account';
    public const TYPE_KLARNA_PAYNOW = 'klarna_paynow';
    public const TYPE_MAESTRO = 'maestro';
    public const TYPE_MBWAY = 'mbway';
    public const TYPE_MC = 'mc';
    public const TYPE_MCDEBIT = 'mcdebit';
    public const TYPE_MEAL_VOUCHER_FR = 'mealVoucher_FR';
    public const TYPE_MOBILEPAY = 'mobilepay';
    public const TYPE_MULTIBANCO = 'multibanco';
    public const TYPE_NYCE = 'nyce';
    public const TYPE_ONLINE_BANKING_PL = 'onlineBanking_PL';
    public const TYPE_PAYBYBANK = 'paybybank';
    public const TYPE_PAYME = 'payme';
    public const TYPE_PAYME_POS = 'payme_pos';
    public const TYPE_PAYNOW = 'paynow';
    public const TYPE_PAYNOW_POS = 'paynow_pos';
    public const TYPE_PAYPAL = 'paypal';
    public const TYPE_PAYSHOP = 'payshop';
    public const TYPE_PULSE = 'pulse';
    public const TYPE_SODEXO = 'sodexo';
    public const TYPE_STAR = 'star';
    public const TYPE_SWISH = 'swish';
    public const TYPE_TICKET = 'ticket';
    public const TYPE_TODO_GIFTCARD = 'todo_giftcard';
    public const TYPE_TRUSTLY = 'trustly';
    public const TYPE_TWINT = 'twint';
    public const TYPE_TWINT_POS = 'twint_pos';
    public const TYPE_UP_BRAZIL_CREDIT = 'up_brazil_credit';
    public const TYPE_VALE_REFEICAO = 'vale_refeicao';
    public const TYPE_VALE_REFEICAO_PREPAID = 'vale_refeicao_prepaid';
    public const TYPE_VIPPS = 'vipps';
    public const TYPE_VISA = 'visa';
    public const TYPE_VISADEBIT = 'visadebit';
    public const TYPE_VPAY = 'vpay';
    public const TYPE_WECHATPAY = 'wechatpay';
    public const TYPE_WECHATPAY_POS = 'wechatpay_pos';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getShopperInteractionAllowableValues()
    {
        return [
            self::SHOPPER_INTERACTION_E_COMMERCE,
            self::SHOPPER_INTERACTION_POS,
            self::SHOPPER_INTERACTION_MOTO,
            self::SHOPPER_INTERACTION_CONT_AUTH,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ACCEL,
            self::TYPE_AFTERPAYTOUCH,
            self::TYPE_ALELO,
            self::TYPE_ALIPAY,
            self::TYPE_ALIPAY_HK,
            self::TYPE_AMEX,
            self::TYPE_APPLEPAY,
            self::TYPE_BANESE_CARD,
            self::TYPE_BANESE_CARD_CREDIT,
            self::TYPE_BANESE_CARD_DEBIT,
            self::TYPE_BANESE_CARD_PREPAID,
            self::TYPE_BCMC,
            self::TYPE_BLIK,
            self::TYPE_CARTEBANCAIRE,
            self::TYPE_CLEARPAY,
            self::TYPE_CLICKTOPAY,
            self::TYPE_CREDTODOS,
            self::TYPE_CREDTODOS_PRIVATE_CREDIT,
            self::TYPE_CREDTODOS_PRIVATE_DEBIT,
            self::TYPE_CUP,
            self::TYPE_DINERS,
            self::TYPE_DIRECTDEBIT_GB,
            self::TYPE_DISCOVER,
            self::TYPE_EBANKING_FI,
            self::TYPE_EFTPOS_AUSTRALIA,
            self::TYPE_ELO,
            self::TYPE_ELOCREDIT,
            self::TYPE_ELODEBIT,
            self::TYPE_GIROCARD,
            self::TYPE_GOOGLEPAY,
            self::TYPE_HIPER,
            self::TYPE_HIPERCARD,
            self::TYPE_IDEAL,
            self::TYPE_INTERAC_CARD,
            self::TYPE_JCB,
            self::TYPE_KLARNA,
            self::TYPE_KLARNA_ACCOUNT,
            self::TYPE_KLARNA_PAYNOW,
            self::TYPE_MAESTRO,
            self::TYPE_MBWAY,
            self::TYPE_MC,
            self::TYPE_MCDEBIT,
            self::TYPE_MEAL_VOUCHER_FR,
            self::TYPE_MOBILEPAY,
            self::TYPE_MULTIBANCO,
            self::TYPE_NYCE,
            self::TYPE_ONLINE_BANKING_PL,
            self::TYPE_PAYBYBANK,
            self::TYPE_PAYME,
            self::TYPE_PAYME_POS,
            self::TYPE_PAYNOW,
            self::TYPE_PAYNOW_POS,
            self::TYPE_PAYPAL,
            self::TYPE_PAYSHOP,
            self::TYPE_PULSE,
            self::TYPE_SODEXO,
            self::TYPE_STAR,
            self::TYPE_SWISH,
            self::TYPE_TICKET,
            self::TYPE_TODO_GIFTCARD,
            self::TYPE_TRUSTLY,
            self::TYPE_TWINT,
            self::TYPE_TWINT_POS,
            self::TYPE_UP_BRAZIL_CREDIT,
            self::TYPE_VALE_REFEICAO,
            self::TYPE_VALE_REFEICAO_PREPAID,
            self::TYPE_VIPPS,
            self::TYPE_VISA,
            self::TYPE_VISADEBIT,
            self::TYPE_VPAY,
            self::TYPE_WECHATPAY,
            self::TYPE_WECHATPAY_POS,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('accel', $data ?? [], null);
        $this->setIfExists('afterpayTouch', $data ?? [], null);
        $this->setIfExists('amex', $data ?? [], null);
        $this->setIfExists('applePay', $data ?? [], null);
        $this->setIfExists('bcmc', $data ?? [], null);
        $this->setIfExists('businessLineId', $data ?? [], null);
        $this->setIfExists('cartesBancaires', $data ?? [], null);
        $this->setIfExists('clearpay', $data ?? [], null);
        $this->setIfExists('countries', $data ?? [], null);
        $this->setIfExists('cup', $data ?? [], null);
        $this->setIfExists('currencies', $data ?? [], null);
        $this->setIfExists('customRoutingFlags', $data ?? [], null);
        $this->setIfExists('diners', $data ?? [], null);
        $this->setIfExists('discover', $data ?? [], null);
        $this->setIfExists('eftposAustralia', $data ?? [], null);
        $this->setIfExists('giroPay', $data ?? [], null);
        $this->setIfExists('girocard', $data ?? [], null);
        $this->setIfExists('googlePay', $data ?? [], null);
        $this->setIfExists('ideal', $data ?? [], null);
        $this->setIfExists('interacCard', $data ?? [], null);
        $this->setIfExists('jcb', $data ?? [], null);
        $this->setIfExists('klarna', $data ?? [], null);
        $this->setIfExists('maestro', $data ?? [], null);
        $this->setIfExists('mc', $data ?? [], null);
        $this->setIfExists('mealVoucherFR', $data ?? [], null);
        $this->setIfExists('nyce', $data ?? [], null);
        $this->setIfExists('payme', $data ?? [], null);
        $this->setIfExists('paypal', $data ?? [], null);
        $this->setIfExists('pulse', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('shopperInteraction', $data ?? [], null);
        $this->setIfExists('sodexo', $data ?? [], null);
        $this->setIfExists('sofort', $data ?? [], null);
        $this->setIfExists('star', $data ?? [], null);
        $this->setIfExists('storeIds', $data ?? [], null);
        $this->setIfExists('swish', $data ?? [], null);
        $this->setIfExists('ticket', $data ?? [], null);
        $this->setIfExists('twint', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('vipps', $data ?? [], null);
        $this->setIfExists('visa', $data ?? [], null);
        $this->setIfExists('wechatpay', $data ?? [], null);
        $this->setIfExists('wechatpayPos', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getShopperInteractionAllowableValues();
        if (!is_null($this->container['shopperInteraction']) && !in_array($this->container['shopperInteraction'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'shopperInteraction', must be one of '%s'",
                $this->container['shopperInteraction'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets accel
     *
     * @return \Adyen\Model\Management\AccelInfo|null
     */
    public function getAccel()
    {
        return $this->container['accel'];
    }

    /**
     * Sets accel
     *
     * @param \Adyen\Model\Management\AccelInfo|null $accel accel
     *
     * @return self
     */
    public function setAccel($accel)
    {
        $this->container['accel'] = $accel;

        return $this;
    }

    /**
     * Gets afterpayTouch
     *
     * @return \Adyen\Model\Management\AfterpayTouchInfo|null
     */
    public function getAfterpayTouch()
    {
        return $this->container['afterpayTouch'];
    }

    /**
     * Sets afterpayTouch
     *
     * @param \Adyen\Model\Management\AfterpayTouchInfo|null $afterpayTouch afterpayTouch
     *
     * @return self
     */
    public function setAfterpayTouch($afterpayTouch)
    {
        $this->container['afterpayTouch'] = $afterpayTouch;

        return $this;
    }

    /**
     * Gets amex
     *
     * @return \Adyen\Model\Management\AmexInfo|null
     */
    public function getAmex()
    {
        return $this->container['amex'];
    }

    /**
     * Sets amex
     *
     * @param \Adyen\Model\Management\AmexInfo|null $amex amex
     *
     * @return self
     */
    public function setAmex($amex)
    {
        $this->container['amex'] = $amex;

        return $this;
    }

    /**
     * Gets applePay
     *
     * @return \Adyen\Model\Management\ApplePayInfo|null
     */
    public function getApplePay()
    {
        return $this->container['applePay'];
    }

    /**
     * Sets applePay
     *
     * @param \Adyen\Model\Management\ApplePayInfo|null $applePay applePay
     *
     * @return self
     */
    public function setApplePay($applePay)
    {
        $this->container['applePay'] = $applePay;

        return $this;
    }

    /**
     * Gets bcmc
     *
     * @return \Adyen\Model\Management\BcmcInfo|null
     */
    public function getBcmc()
    {
        return $this->container['bcmc'];
    }

    /**
     * Sets bcmc
     *
     * @param \Adyen\Model\Management\BcmcInfo|null $bcmc bcmc
     *
     * @return self
     */
    public function setBcmc($bcmc)
    {
        $this->container['bcmc'] = $bcmc;

        return $this;
    }

    /**
     * Gets businessLineId
     *
     * @return string|null
     */
    public function getBusinessLineId()
    {
        return $this->container['businessLineId'];
    }

    /**
     * Sets businessLineId
     *
     * @param string|null $businessLineId The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).
     *
     * @return self
     */
    public function setBusinessLineId($businessLineId)
    {
        $this->container['businessLineId'] = $businessLineId;

        return $this;
    }

    /**
     * Gets cartesBancaires
     *
     * @return \Adyen\Model\Management\CartesBancairesInfo|null
     */
    public function getCartesBancaires()
    {
        return $this->container['cartesBancaires'];
    }

    /**
     * Sets cartesBancaires
     *
     * @param \Adyen\Model\Management\CartesBancairesInfo|null $cartesBancaires cartesBancaires
     *
     * @return self
     */
    public function setCartesBancaires($cartesBancaires)
    {
        $this->container['cartesBancaires'] = $cartesBancaires;

        return $this;
    }

    /**
     * Gets clearpay
     *
     * @return \Adyen\Model\Management\ClearpayInfo|null
     */
    public function getClearpay()
    {
        return $this->container['clearpay'];
    }

    /**
     * Sets clearpay
     *
     * @param \Adyen\Model\Management\ClearpayInfo|null $clearpay clearpay
     *
     * @return self
     */
    public function setClearpay($clearpay)
    {
        $this->container['clearpay'] = $clearpay;

        return $this;
    }

    /**
     * Gets countries
     *
     * @return string[]|null
     */
    public function getCountries()
    {
        return $this->container['countries'];
    }

    /**
     * Sets countries
     *
     * @param string[]|null $countries The list of countries where a payment method is available. By default, all countries supported by the payment method.
     *
     * @return self
     */
    public function setCountries($countries)
    {
        $this->container['countries'] = $countries;

        return $this;
    }

    /**
     * Gets cup
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getCup()
    {
        return $this->container['cup'];
    }

    /**
     * Sets cup
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $cup cup
     *
     * @return self
     */
    public function setCup($cup)
    {
        $this->container['cup'] = $cup;

        return $this;
    }

    /**
     * Gets currencies
     *
     * @return string[]|null
     */
    public function getCurrencies()
    {
        return $this->container['currencies'];
    }

    /**
     * Sets currencies
     *
     * @param string[]|null $currencies The list of currencies that a payment method supports. By default, all currencies supported by the payment method.
     *
     * @return self
     */
    public function setCurrencies($currencies)
    {
        $this->container['currencies'] = $currencies;

        return $this;
    }

    /**
     * Gets customRoutingFlags
     *
     * @return string[]|null
     */
    public function getCustomRoutingFlags()
    {
        return $this->container['customRoutingFlags'];
    }

    /**
     * Sets customRoutingFlags
     *
     * @param string[]|null $customRoutingFlags The list of custom routing flags to route payment to the intended acquirer.
     *
     * @return self
     */
    public function setCustomRoutingFlags($customRoutingFlags)
    {
        $this->container['customRoutingFlags'] = $customRoutingFlags;

        return $this;
    }

    /**
     * Gets diners
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getDiners()
    {
        return $this->container['diners'];
    }

    /**
     * Sets diners
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $diners diners
     *
     * @return self
     */
    public function setDiners($diners)
    {
        $this->container['diners'] = $diners;

        return $this;
    }

    /**
     * Gets discover
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getDiscover()
    {
        return $this->container['discover'];
    }

    /**
     * Sets discover
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $discover discover
     *
     * @return self
     */
    public function setDiscover($discover)
    {
        $this->container['discover'] = $discover;

        return $this;
    }

    /**
     * Gets eftposAustralia
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getEftposAustralia()
    {
        return $this->container['eftposAustralia'];
    }

    /**
     * Sets eftposAustralia
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $eftposAustralia eftposAustralia
     *
     * @return self
     */
    public function setEftposAustralia($eftposAustralia)
    {
        $this->container['eftposAustralia'] = $eftposAustralia;

        return $this;
    }

    /**
     * Gets giroPay
     *
     * @return \Adyen\Model\Management\GiroPayInfo|null
     */
    public function getGiroPay()
    {
        return $this->container['giroPay'];
    }

    /**
     * Sets giroPay
     *
     * @param \Adyen\Model\Management\GiroPayInfo|null $giroPay giroPay
     *
     * @return self
     */
    public function setGiroPay($giroPay)
    {
        $this->container['giroPay'] = $giroPay;

        return $this;
    }

    /**
     * Gets girocard
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getGirocard()
    {
        return $this->container['girocard'];
    }

    /**
     * Sets girocard
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $girocard girocard
     *
     * @return self
     */
    public function setGirocard($girocard)
    {
        $this->container['girocard'] = $girocard;

        return $this;
    }

    /**
     * Gets googlePay
     *
     * @return \Adyen\Model\Management\GooglePayInfo|null
     */
    public function getGooglePay()
    {
        return $this->container['googlePay'];
    }

    /**
     * Sets googlePay
     *
     * @param \Adyen\Model\Management\GooglePayInfo|null $googlePay googlePay
     *
     * @return self
     */
    public function setGooglePay($googlePay)
    {
        $this->container['googlePay'] = $googlePay;

        return $this;
    }

    /**
     * Gets ideal
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getIdeal()
    {
        return $this->container['ideal'];
    }

    /**
     * Sets ideal
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $ideal ideal
     *
     * @return self
     */
    public function setIdeal($ideal)
    {
        $this->container['ideal'] = $ideal;

        return $this;
    }

    /**
     * Gets interacCard
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getInteracCard()
    {
        return $this->container['interacCard'];
    }

    /**
     * Sets interacCard
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $interacCard interacCard
     *
     * @return self
     */
    public function setInteracCard($interacCard)
    {
        $this->container['interacCard'] = $interacCard;

        return $this;
    }

    /**
     * Gets jcb
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getJcb()
    {
        return $this->container['jcb'];
    }

    /**
     * Sets jcb
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $jcb jcb
     *
     * @return self
     */
    public function setJcb($jcb)
    {
        $this->container['jcb'] = $jcb;

        return $this;
    }

    /**
     * Gets klarna
     *
     * @return \Adyen\Model\Management\KlarnaInfo|null
     */
    public function getKlarna()
    {
        return $this->container['klarna'];
    }

    /**
     * Sets klarna
     *
     * @param \Adyen\Model\Management\KlarnaInfo|null $klarna klarna
     *
     * @return self
     */
    public function setKlarna($klarna)
    {
        $this->container['klarna'] = $klarna;

        return $this;
    }

    /**
     * Gets maestro
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getMaestro()
    {
        return $this->container['maestro'];
    }

    /**
     * Sets maestro
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $maestro maestro
     *
     * @return self
     */
    public function setMaestro($maestro)
    {
        $this->container['maestro'] = $maestro;

        return $this;
    }

    /**
     * Gets mc
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getMc()
    {
        return $this->container['mc'];
    }

    /**
     * Sets mc
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $mc mc
     *
     * @return self
     */
    public function setMc($mc)
    {
        $this->container['mc'] = $mc;

        return $this;
    }

    /**
     * Gets mealVoucherFR
     *
     * @return \Adyen\Model\Management\MealVoucherFRInfo|null
     */
    public function getMealVoucherFR()
    {
        return $this->container['mealVoucherFR'];
    }

    /**
     * Sets mealVoucherFR
     *
     * @param \Adyen\Model\Management\MealVoucherFRInfo|null $mealVoucherFR mealVoucherFR
     *
     * @return self
     */
    public function setMealVoucherFR($mealVoucherFR)
    {
        $this->container['mealVoucherFR'] = $mealVoucherFR;

        return $this;
    }

    /**
     * Gets nyce
     *
     * @return \Adyen\Model\Management\NyceInfo|null
     */
    public function getNyce()
    {
        return $this->container['nyce'];
    }

    /**
     * Sets nyce
     *
     * @param \Adyen\Model\Management\NyceInfo|null $nyce nyce
     *
     * @return self
     */
    public function setNyce($nyce)
    {
        $this->container['nyce'] = $nyce;

        return $this;
    }

    /**
     * Gets payme
     *
     * @return \Adyen\Model\Management\PayMeInfo|null
     */
    public function getPayme()
    {
        return $this->container['payme'];
    }

    /**
     * Sets payme
     *
     * @param \Adyen\Model\Management\PayMeInfo|null $payme payme
     *
     * @return self
     */
    public function setPayme($payme)
    {
        $this->container['payme'] = $payme;

        return $this;
    }

    /**
     * Gets paypal
     *
     * @return \Adyen\Model\Management\PayPalInfo|null
     */
    public function getPaypal()
    {
        return $this->container['paypal'];
    }

    /**
     * Sets paypal
     *
     * @param \Adyen\Model\Management\PayPalInfo|null $paypal paypal
     *
     * @return self
     */
    public function setPaypal($paypal)
    {
        $this->container['paypal'] = $paypal;

        return $this;
    }

    /**
     * Gets pulse
     *
     * @return \Adyen\Model\Management\PulseInfo|null
     */
    public function getPulse()
    {
        return $this->container['pulse'];
    }

    /**
     * Sets pulse
     *
     * @param \Adyen\Model\Management\PulseInfo|null $pulse pulse
     *
     * @return self
     */
    public function setPulse($pulse)
    {
        $this->container['pulse'] = $pulse;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets shopperInteraction
     *
     * @return string|null
     */
    public function getShopperInteraction()
    {
        return $this->container['shopperInteraction'];
    }

    /**
     * Sets shopperInteraction
     *
     * @param string|null $shopperInteraction The sales channel. Required if the merchant account does not have a sales channel. When you provide this field, it overrides the default sales channel set on the merchant account.  Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**.
     *
     * @return self
     */
    public function setShopperInteraction($shopperInteraction)
    {
        $allowedValues = $this->getShopperInteractionAllowableValues();
        if (!in_array($shopperInteraction, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'shopperInteraction', must be one of '%s'",
                    $shopperInteraction,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['shopperInteraction'] = $shopperInteraction;

        return $this;
    }

    /**
     * Gets sodexo
     *
     * @return \Adyen\Model\Management\SodexoInfo|null
     */
    public function getSodexo()
    {
        return $this->container['sodexo'];
    }

    /**
     * Sets sodexo
     *
     * @param \Adyen\Model\Management\SodexoInfo|null $sodexo sodexo
     *
     * @return self
     */
    public function setSodexo($sodexo)
    {
        $this->container['sodexo'] = $sodexo;

        return $this;
    }

    /**
     * Gets sofort
     *
     * @return \Adyen\Model\Management\SofortInfo|null
     */
    public function getSofort()
    {
        return $this->container['sofort'];
    }

    /**
     * Sets sofort
     *
     * @param \Adyen\Model\Management\SofortInfo|null $sofort sofort
     *
     * @return self
     */
    public function setSofort($sofort)
    {
        $this->container['sofort'] = $sofort;

        return $this;
    }

    /**
     * Gets star
     *
     * @return \Adyen\Model\Management\StarInfo|null
     */
    public function getStar()
    {
        return $this->container['star'];
    }

    /**
     * Sets star
     *
     * @param \Adyen\Model\Management\StarInfo|null $star star
     *
     * @return self
     */
    public function setStar($star)
    {
        $this->container['star'] = $star;

        return $this;
    }

    /**
     * Gets storeIds
     *
     * @return string[]|null
     */
    public function getStoreIds()
    {
        return $this->container['storeIds'];
    }

    /**
     * Sets storeIds
     *
     * @param string[]|null $storeIds The unique identifier of the store for which to configure the payment method, if any.
     *
     * @return self
     */
    public function setStoreIds($storeIds)
    {
        $this->container['storeIds'] = $storeIds;

        return $this;
    }

    /**
     * Gets swish
     *
     * @return \Adyen\Model\Management\SwishInfo|null
     */
    public function getSwish()
    {
        return $this->container['swish'];
    }

    /**
     * Sets swish
     *
     * @param \Adyen\Model\Management\SwishInfo|null $swish swish
     *
     * @return self
     */
    public function setSwish($swish)
    {
        $this->container['swish'] = $swish;

        return $this;
    }

    /**
     * Gets ticket
     *
     * @return \Adyen\Model\Management\TicketInfo|null
     */
    public function getTicket()
    {
        return $this->container['ticket'];
    }

    /**
     * Sets ticket
     *
     * @param \Adyen\Model\Management\TicketInfo|null $ticket ticket
     *
     * @return self
     */
    public function setTicket($ticket)
    {
        $this->container['ticket'] = $ticket;

        return $this;
    }

    /**
     * Gets twint
     *
     * @return \Adyen\Model\Management\TwintInfo|null
     */
    public function getTwint()
    {
        return $this->container['twint'];
    }

    /**
     * Sets twint
     *
     * @param \Adyen\Model\Management\TwintInfo|null $twint twint
     *
     * @return self
     */
    public function setTwint($twint)
    {
        $this->container['twint'] = $twint;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets vipps
     *
     * @return \Adyen\Model\Management\VippsInfo|null
     */
    public function getVipps()
    {
        return $this->container['vipps'];
    }

    /**
     * Sets vipps
     *
     * @param \Adyen\Model\Management\VippsInfo|null $vipps vipps
     *
     * @return self
     */
    public function setVipps($vipps)
    {
        $this->container['vipps'] = $vipps;

        return $this;
    }

    /**
     * Gets visa
     *
     * @return \Adyen\Model\Management\GenericPmWithTdiInfo|null
     */
    public function getVisa()
    {
        return $this->container['visa'];
    }

    /**
     * Sets visa
     *
     * @param \Adyen\Model\Management\GenericPmWithTdiInfo|null $visa visa
     *
     * @return self
     */
    public function setVisa($visa)
    {
        $this->container['visa'] = $visa;

        return $this;
    }

    /**
     * Gets wechatpay
     *
     * @return \Adyen\Model\Management\WeChatPayInfo|null
     */
    public function getWechatpay()
    {
        return $this->container['wechatpay'];
    }

    /**
     * Sets wechatpay
     *
     * @param \Adyen\Model\Management\WeChatPayInfo|null $wechatpay wechatpay
     *
     * @return self
     */
    public function setWechatpay($wechatpay)
    {
        $this->container['wechatpay'] = $wechatpay;

        return $this;
    }

    /**
     * Gets wechatpayPos
     *
     * @return \Adyen\Model\Management\WeChatPayPosInfo|null
     */
    public function getWechatpayPos()
    {
        return $this->container['wechatpayPos'];
    }

    /**
     * Sets wechatpayPos
     *
     * @param \Adyen\Model\Management\WeChatPayPosInfo|null $wechatpayPos wechatpayPos
     *
     * @return self
     */
    public function setWechatpayPos($wechatpayPos)
    {
        $this->container['wechatpayPos'] = $wechatpayPos;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
