<?php

/**
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Payout;

use \ArrayAccess;
use Adyen\Model\Payout\ObjectSerializer;

/**
 * PayoutResponse Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PayoutResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PayoutResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'additionalData' => 'array<string,string>',
        'authCode' => 'string',
        'dccAmount' => '\Adyen\Model\Payout\Amount',
        'dccSignature' => 'string',
        'fraudResult' => '\Adyen\Model\Payout\FraudResult',
        'issuerUrl' => 'string',
        'md' => 'string',
        'paRequest' => 'string',
        'pspReference' => 'string',
        'refusalReason' => 'string',
        'resultCode' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'additionalData' => null,
        'authCode' => null,
        'dccAmount' => null,
        'dccSignature' => null,
        'fraudResult' => null,
        'issuerUrl' => null,
        'md' => null,
        'paRequest' => null,
        'pspReference' => null,
        'refusalReason' => null,
        'resultCode' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'additionalData' => false,
        'authCode' => false,
        'dccAmount' => false,
        'dccSignature' => false,
        'fraudResult' => false,
        'issuerUrl' => false,
        'md' => false,
        'paRequest' => false,
        'pspReference' => false,
        'refusalReason' => false,
        'resultCode' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'additionalData' => 'additionalData',
        'authCode' => 'authCode',
        'dccAmount' => 'dccAmount',
        'dccSignature' => 'dccSignature',
        'fraudResult' => 'fraudResult',
        'issuerUrl' => 'issuerUrl',
        'md' => 'md',
        'paRequest' => 'paRequest',
        'pspReference' => 'pspReference',
        'refusalReason' => 'refusalReason',
        'resultCode' => 'resultCode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'additionalData' => 'setAdditionalData',
        'authCode' => 'setAuthCode',
        'dccAmount' => 'setDccAmount',
        'dccSignature' => 'setDccSignature',
        'fraudResult' => 'setFraudResult',
        'issuerUrl' => 'setIssuerUrl',
        'md' => 'setMd',
        'paRequest' => 'setPaRequest',
        'pspReference' => 'setPspReference',
        'refusalReason' => 'setRefusalReason',
        'resultCode' => 'setResultCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'additionalData' => 'getAdditionalData',
        'authCode' => 'getAuthCode',
        'dccAmount' => 'getDccAmount',
        'dccSignature' => 'getDccSignature',
        'fraudResult' => 'getFraudResult',
        'issuerUrl' => 'getIssuerUrl',
        'md' => 'getMd',
        'paRequest' => 'getPaRequest',
        'pspReference' => 'getPspReference',
        'refusalReason' => 'getRefusalReason',
        'resultCode' => 'getResultCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const RESULT_CODE_AUTHENTICATION_FINISHED = 'AuthenticationFinished';
    public const RESULT_CODE_AUTHENTICATION_NOT_REQUIRED = 'AuthenticationNotRequired';
    public const RESULT_CODE_AUTHORISED = 'Authorised';
    public const RESULT_CODE_CANCELLED = 'Cancelled';
    public const RESULT_CODE_CHALLENGE_SHOPPER = 'ChallengeShopper';
    public const RESULT_CODE_ERROR = 'Error';
    public const RESULT_CODE_IDENTIFY_SHOPPER = 'IdentifyShopper';
    public const RESULT_CODE_PARTIALLY_AUTHORISED = 'PartiallyAuthorised';
    public const RESULT_CODE_PENDING = 'Pending';
    public const RESULT_CODE_PRESENT_TO_SHOPPER = 'PresentToShopper';
    public const RESULT_CODE_RECEIVED = 'Received';
    public const RESULT_CODE_REDIRECT_SHOPPER = 'RedirectShopper';
    public const RESULT_CODE_REFUSED = 'Refused';
    public const RESULT_CODE_SUCCESS = 'Success';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getResultCodeAllowableValues()
    {
        return [
            self::RESULT_CODE_AUTHENTICATION_FINISHED,
            self::RESULT_CODE_AUTHENTICATION_NOT_REQUIRED,
            self::RESULT_CODE_AUTHORISED,
            self::RESULT_CODE_CANCELLED,
            self::RESULT_CODE_CHALLENGE_SHOPPER,
            self::RESULT_CODE_ERROR,
            self::RESULT_CODE_IDENTIFY_SHOPPER,
            self::RESULT_CODE_PARTIALLY_AUTHORISED,
            self::RESULT_CODE_PENDING,
            self::RESULT_CODE_PRESENT_TO_SHOPPER,
            self::RESULT_CODE_RECEIVED,
            self::RESULT_CODE_REDIRECT_SHOPPER,
            self::RESULT_CODE_REFUSED,
            self::RESULT_CODE_SUCCESS,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('additionalData', $data ?? [], null);
        $this->setIfExists('authCode', $data ?? [], null);
        $this->setIfExists('dccAmount', $data ?? [], null);
        $this->setIfExists('dccSignature', $data ?? [], null);
        $this->setIfExists('fraudResult', $data ?? [], null);
        $this->setIfExists('issuerUrl', $data ?? [], null);
        $this->setIfExists('md', $data ?? [], null);
        $this->setIfExists('paRequest', $data ?? [], null);
        $this->setIfExists('pspReference', $data ?? [], null);
        $this->setIfExists('refusalReason', $data ?? [], null);
        $this->setIfExists('resultCode', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getResultCodeAllowableValues();
        if (!is_null($this->container['resultCode']) && !in_array($this->container['resultCode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'resultCode', must be one of '%s'",
                $this->container['resultCode'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets additionalData
     *
     * @return array<string,string>|null
     */
    public function getAdditionalData()
    {
        return $this->container['additionalData'];
    }

    /**
     * Sets additionalData
     *
     * @param array<string,string>|null $additionalData Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.
     *
     * @return self
     */
    public function setAdditionalData($additionalData)
    {
        $this->container['additionalData'] = $additionalData;

        return $this;
    }

    /**
     * Gets authCode
     *
     * @return string|null
     */
    public function getAuthCode()
    {
        return $this->container['authCode'];
    }

    /**
     * Sets authCode
     *
     * @param string|null $authCode Authorisation code: * When the payment is authorised successfully, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.
     *
     * @return self
     */
    public function setAuthCode($authCode)
    {
        $this->container['authCode'] = $authCode;

        return $this;
    }

    /**
     * Gets dccAmount
     *
     * @return \Adyen\Model\Payout\Amount|null
     */
    public function getDccAmount()
    {
        return $this->container['dccAmount'];
    }

    /**
     * Sets dccAmount
     *
     * @param \Adyen\Model\Payout\Amount|null $dccAmount dccAmount
     *
     * @return self
     */
    public function setDccAmount($dccAmount)
    {
        $this->container['dccAmount'] = $dccAmount;

        return $this;
    }

    /**
     * Gets dccSignature
     *
     * @return string|null
     */
    public function getDccSignature()
    {
        return $this->container['dccSignature'];
    }

    /**
     * Sets dccSignature
     *
     * @param string|null $dccSignature Cryptographic signature used to verify `dccQuote`. > This value only applies if you have implemented Dynamic Currency Conversion. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
     *
     * @return self
     */
    public function setDccSignature($dccSignature)
    {
        $this->container['dccSignature'] = $dccSignature;

        return $this;
    }

    /**
     * Gets fraudResult
     *
     * @return \Adyen\Model\Payout\FraudResult|null
     */
    public function getFraudResult()
    {
        return $this->container['fraudResult'];
    }

    /**
     * Sets fraudResult
     *
     * @param \Adyen\Model\Payout\FraudResult|null $fraudResult fraudResult
     *
     * @return self
     */
    public function setFraudResult($fraudResult)
    {
        $this->container['fraudResult'] = $fraudResult;

        return $this;
    }

    /**
     * Gets issuerUrl
     *
     * @return string|null
     */
    public function getIssuerUrl()
    {
        return $this->container['issuerUrl'];
    }

    /**
     * Sets issuerUrl
     *
     * @param string|null $issuerUrl The URL to direct the shopper to. > In case of SecurePlus, do not redirect a shopper to this URL.
     *
     * @return self
     */
    public function setIssuerUrl($issuerUrl)
    {
        $this->container['issuerUrl'] = $issuerUrl;

        return $this;
    }

    /**
     * Gets md
     *
     * @return string|null
     */
    public function getMd()
    {
        return $this->container['md'];
    }

    /**
     * Sets md
     *
     * @param string|null $md The payment session.
     *
     * @return self
     */
    public function setMd($md)
    {
        $this->container['md'] = $md;

        return $this;
    }

    /**
     * Gets paRequest
     *
     * @return string|null
     */
    public function getPaRequest()
    {
        return $this->container['paRequest'];
    }

    /**
     * Sets paRequest
     *
     * @param string|null $paRequest The 3D request data for the issuer.  If the value is **CUPSecurePlus-CollectSMSVerificationCode**, collect an SMS code from the shopper and pass it in the `/authorise3D` request. For more information, see [3D Secure](https://docs.adyen.com/classic-integration/3d-secure).
     *
     * @return self
     */
    public function setPaRequest($paRequest)
    {
        $this->container['paRequest'] = $paRequest;

        return $this;
    }

    /**
     * Gets pspReference
     *
     * @return string|null
     */
    public function getPspReference()
    {
        return $this->container['pspReference'];
    }

    /**
     * Sets pspReference
     *
     * @param string|null $pspReference Adyen's 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.
     *
     * @return self
     */
    public function setPspReference($pspReference)
    {
        $this->container['pspReference'] = $pspReference;

        return $this;
    }

    /**
     * Gets refusalReason
     *
     * @return string|null
     */
    public function getRefusalReason()
    {
        return $this->container['refusalReason'];
    }

    /**
     * Sets refusalReason
     *
     * @param string|null $refusalReason If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).
     *
     * @return self
     */
    public function setRefusalReason($refusalReason)
    {
        $this->container['refusalReason'] = $refusalReason;

        return $this;
    }

    /**
     * Gets resultCode
     *
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->container['resultCode'];
    }

    /**
     * Sets resultCode
     *
     * @param string|null $resultCode The result of the payment. For more information, see [Result codes](https://docs.adyen.com/online-payments/payment-result-codes).  Possible values:  * **AuthenticationFinished** – The payment has been successfully authenticated with 3D Secure 2. Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** – The transaction does not require 3D Secure authentication. Returned for [standalone authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). * **Authorised** – The payment was successfully authorised. This state serves as an indicator to proceed with the delivery of goods and services. This is a final state. * **Cancelled** – Indicates the payment has been cancelled (either by the shopper or the merchant) before processing was completed. This is a final state. * **ChallengeShopper** – The issuer requires further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Error** – There was an error when the payment was being processed. The reason is given in the `refusalReason` field. This is a final state. * **IdentifyShopper** – The issuer requires the shopper's device fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** – The payment has been authorised for a partial amount. This happens for card payments when the merchant supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** – Indicates that it is not possible to obtain the final status of the payment. This can happen if the systems providing final status information for the payment are unavailable, or if the shopper needs to take further action to complete the payment. * **PresentToShopper** – Indicates that the response contains additional information that you need to present to a shopper, so that they can use it to complete a payment. * **Received** – Indicates the payment has successfully been received by Adyen, and will be processed. This is the initial state for all payments. * **RedirectShopper** – Indicates the shopper should be redirected to an external web page or app to complete the authorisation. * **Refused** – Indicates the payment was refused. The reason is given in the `refusalReason` field. This is a final state.
     *
     * @return self
     */
    public function setResultCode($resultCode)
    {
        $allowedValues = $this->getResultCodeAllowableValues();
        if (!in_array($resultCode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'resultCode', must be one of '%s'",
                    $resultCode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['resultCode'] = $resultCode;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
