<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class CardOrdersApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * CardOrdersApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Get card order items
    *
    * @param string $id
    * @param array|null $requestOptions ['queryParams' => ['offset'=> int, 'limit'=> int]]
    * @return \Adyen\Model\BalancePlatform\PaginatedGetCardOrderItemResponse
    * @throws AdyenException
    */
    public function getCardOrderItems(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaginatedGetCardOrderItemResponse
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/cardorders/{id}/items");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaginatedGetCardOrderItemResponse::class);
    }

    /**
    * Get a list of card orders
    *
    * @param array|null $requestOptions ['queryParams' => ['id'=> string, 'cardManufacturingProfileId'=> string, 'status'=> string, 'txVariantCode'=> string, 'createdSince'=> \DateTime, 'createdUntil'=> \DateTime, 'lockedSince'=> \DateTime, 'lockedUntil'=> \DateTime, 'serviceCenter'=> string, 'offset'=> int, 'limit'=> int]]
    * @return \Adyen\Model\BalancePlatform\PaginatedGetCardOrderResponse
    * @throws AdyenException
    */
    public function listCardOrders(array $requestOptions = null): \Adyen\Model\BalancePlatform\PaginatedGetCardOrderResponse
    {
        $endpoint = $this->baseURL . "/cardorders";
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaginatedGetCardOrderResponse::class);
    }
}
