<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class NetworkTokensApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * NetworkTokensApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Get a network token
    *
    * @param string $networkTokenId
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\GetNetworkTokenResponse
    * @throws AdyenException
    */
    public function getNetworkToken(string $networkTokenId, array $requestOptions = null): \Adyen\Model\BalancePlatform\GetNetworkTokenResponse
    {
        $endpoint = $this->baseURL . str_replace(['{networkTokenId}'], [$networkTokenId], "/networkTokens/{networkTokenId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\GetNetworkTokenResponse::class);
    }

    /**
    * Update a network token
    *
    * @param string $networkTokenId
    * @param \Adyen\Model\BalancePlatform\UpdateNetworkTokenRequest $updateNetworkTokenRequest
    * @param array|null $requestOptions

    * @throws AdyenException
    */
    public function updateNetworkToken(string $networkTokenId, \Adyen\Model\BalancePlatform\UpdateNetworkTokenRequest $updateNetworkTokenRequest, array $requestOptions = null)
    {
        $endpoint = $this->baseURL . str_replace(['{networkTokenId}'], [$networkTokenId], "/networkTokens/{networkTokenId}");
        $this->requestHttp($endpoint, strtolower('PATCH'), (array) $updateNetworkTokenRequest->jsonSerialize(), $requestOptions);
    }
}
