<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class PaymentInstrumentGroupsApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * PaymentInstrumentGroupsApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Create a payment instrument group
    *
    * @param \Adyen\Model\BalancePlatform\PaymentInstrumentGroupInfo $paymentInstrumentGroupInfo
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\PaymentInstrumentGroup
    * @throws AdyenException
    */
    public function createPaymentInstrumentGroup(\Adyen\Model\BalancePlatform\PaymentInstrumentGroupInfo $paymentInstrumentGroupInfo, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaymentInstrumentGroup
    {
        $endpoint = $this->baseURL . "/paymentInstrumentGroups";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $paymentInstrumentGroupInfo->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaymentInstrumentGroup::class);
    }

    /**
    * Get all transaction rules for a payment instrument group
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\TransactionRulesResponse
    * @throws AdyenException
    */
    public function getAllTransactionRulesForPaymentInstrumentGroup(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\TransactionRulesResponse
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/paymentInstrumentGroups/{id}/transactionRules");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\TransactionRulesResponse::class);
    }

    /**
    * Get a payment instrument group
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\PaymentInstrumentGroup
    * @throws AdyenException
    */
    public function getPaymentInstrumentGroup(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaymentInstrumentGroup
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/paymentInstrumentGroups/{id}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaymentInstrumentGroup::class);
    }
}
