<?php
/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Management;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Management\ObjectSerializer;

class AccountMerchantLevelApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * AccountMerchantLevelApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://management-test.adyen.com/v3");
    }

    /**
    * Create a merchant account
    *
    * @param \Adyen\Model\Management\CreateMerchantRequest $createMerchantRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\CreateMerchantResponse
    * @throws AdyenException
    */
    public function createMerchantAccount(\Adyen\Model\Management\CreateMerchantRequest $createMerchantRequest, array $requestOptions = null): \Adyen\Model\Management\CreateMerchantResponse
    {
        $endpoint = $this->baseURL . "/merchants";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $createMerchantRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\CreateMerchantResponse::class);
    }

    /**
    * Get a merchant account
    *
    * @param string $merchantId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Merchant
    * @throws AdyenException
    */
    public function getMerchantAccount(string $merchantId, array $requestOptions = null): \Adyen\Model\Management\Merchant
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Merchant::class);
    }

    /**
    * Get a list of merchant accounts
    *
    * @param array|null $requestOptions ['queryParams' => ['pageNumber'=> int, 'pageSize'=> int]]
    * @return \Adyen\Model\Management\ListMerchantResponse
    * @throws AdyenException
    */
    public function listMerchantAccounts(array $requestOptions = null): \Adyen\Model\Management\ListMerchantResponse
    {
        $endpoint = $this->baseURL . "/merchants";
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ListMerchantResponse::class);
    }

    /**
    * Request to activate a merchant account
    *
    * @param string $merchantId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\RequestActivationResponse
    * @throws AdyenException
    */
    public function requestToActivateMerchantAccount(string $merchantId, array $requestOptions = null): \Adyen\Model\Management\RequestActivationResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/activate");
        $response = $this->requestHttp($endpoint, strtolower('POST'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\RequestActivationResponse::class);
    }
}
