<?php
/**
 * Management API
 *
 * The version of the OpenAPI document: 3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Management;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Management\ObjectSerializer;

class AccountStoreLevelApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * AccountStoreLevelApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://management-test.adyen.com/v3");
    }

    /**
    * Create a store
    *
    * @param \Adyen\Model\Management\StoreCreationWithMerchantCodeRequest $storeCreationWithMerchantCodeRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Store
    * @throws AdyenException
    */
    public function createStore(\Adyen\Model\Management\StoreCreationWithMerchantCodeRequest $storeCreationWithMerchantCodeRequest, array $requestOptions = null): \Adyen\Model\Management\Store
    {
        $endpoint = $this->baseURL . "/stores";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $storeCreationWithMerchantCodeRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Store::class);
    }

    /**
    * Create a store
    *
    * @param string $merchantId
    * @param \Adyen\Model\Management\StoreCreationRequest $storeCreationRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Store
    * @throws AdyenException
    */
    public function createStoreByMerchantId(string $merchantId, \Adyen\Model\Management\StoreCreationRequest $storeCreationRequest, array $requestOptions = null): \Adyen\Model\Management\Store
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/stores");
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $storeCreationRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Store::class);
    }

    /**
    * Get a store
    *
    * @param string $merchantId
    * @param string $storeId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Store
    * @throws AdyenException
    */
    public function getStore(string $merchantId, string $storeId, array $requestOptions = null): \Adyen\Model\Management\Store
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{storeId}'], [$merchantId, $storeId], "/merchants/{merchantId}/stores/{storeId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Store::class);
    }

    /**
    * Get a store
    *
    * @param string $storeId
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Store
    * @throws AdyenException
    */
    public function getStoreById(string $storeId, array $requestOptions = null): \Adyen\Model\Management\Store
    {
        $endpoint = $this->baseURL . str_replace(['{storeId}'], [$storeId], "/stores/{storeId}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Store::class);
    }

    /**
    * Get a list of stores
    *
    * @param array|null $requestOptions ['queryParams' => ['pageNumber'=> int, 'pageSize'=> int, 'reference'=> string, 'merchantId'=> string]]
    * @return \Adyen\Model\Management\ListStoresResponse
    * @throws AdyenException
    */
    public function listStores(array $requestOptions = null): \Adyen\Model\Management\ListStoresResponse
    {
        $endpoint = $this->baseURL . "/stores";
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ListStoresResponse::class);
    }

    /**
    * Get a list of stores
    *
    * @param string $merchantId
    * @param array|null $requestOptions ['queryParams' => ['pageNumber'=> int, 'pageSize'=> int, 'reference'=> string]]
    * @return \Adyen\Model\Management\ListStoresResponse
    * @throws AdyenException
    */
    public function listStoresByMerchantId(string $merchantId, array $requestOptions = null): \Adyen\Model\Management\ListStoresResponse
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}'], [$merchantId], "/merchants/{merchantId}/stores");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\ListStoresResponse::class);
    }

    /**
    * Update a store
    *
    * @param string $merchantId
    * @param string $storeId
    * @param \Adyen\Model\Management\UpdateStoreRequest $updateStoreRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Store
    * @throws AdyenException
    */
    public function updateStore(string $merchantId, string $storeId, \Adyen\Model\Management\UpdateStoreRequest $updateStoreRequest, array $requestOptions = null): \Adyen\Model\Management\Store
    {
        $endpoint = $this->baseURL . str_replace(['{merchantId}', '{storeId}'], [$merchantId, $storeId], "/merchants/{merchantId}/stores/{storeId}");
        $response = $this->requestHttp($endpoint, strtolower('PATCH'), (array) $updateStoreRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Store::class);
    }

    /**
    * Update a store
    *
    * @param string $storeId
    * @param \Adyen\Model\Management\UpdateStoreRequest $updateStoreRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Management\Store
    * @throws AdyenException
    */
    public function updateStoreById(string $storeId, \Adyen\Model\Management\UpdateStoreRequest $updateStoreRequest, array $requestOptions = null): \Adyen\Model\Management\Store
    {
        $endpoint = $this->baseURL . str_replace(['{storeId}'], [$storeId], "/stores/{storeId}");
        $response = $this->requestHttp($endpoint, strtolower('PATCH'), (array) $updateStoreRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Management\Store::class);
    }
}
