<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\{ User, Affiliate_Earning };

class AdminHasPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $locked_routes        = json_decode(file_get_contents(base_path("locked_routes.json")), true, 512, JSON_UNESCAPED_SLASHES);
        $current_route_action = \Route::currentRouteAction();

        foreach($locked_routes as $locked_route)
        {
          if(($locked_route['controller'] === $current_route_action) && request()->isMethod($locked_route['method']) && $request->user()->role !== "superadmin")
          {
            abort(403, __("Action not allowed in demo version"));
          }
        }
 
        return $next($request);
    }
}
