<?php

	namespace App\Libraries;

	use Illuminate\Support\Facades\{ DB, Cache, Session, Auth };
  use Illuminate\Http\Request;
  use App\Models\{ Transaction };
  use GuzzleHttp\{ Client };

	class Skrill 
	{
		public $name = 'skrill';
		public $status_url;
		public $return_url;
		public $cancel_url;
		public $supported_currencies = ['EUR' , 'TWD', 'USD', 'THB', 'GBP', 'CZK', 'HKD', 'HUF', 'SGD', 'BGN', 'JPY', 'PLN', 'CAD', 'ISK', 'AUD', 'INR', 'CHF', 'KRW', 'DKK', 'ZAR', 'SEK', 'RON', 'NOK', 'HRK', 'ILS', 'JOD', 'MYR', 'OMR', 'NZD', 'RSD', 'TRY', 'TND', 'AED', 'MAD', 'QAR', 'SAR'];
		public $payment_methods = ['WLT', 'NTL', 'PSC', 'PCH', 'ACC', 'VSA', 'MSC', 'VSE', 'MAE', 'GCB', 'DNK', 'PSP', 'CSI', 'ACH', 'GCI', 'IDL', 'PWY', 'GLU', 'ALI', 'ADB', 'AOB', 'ACI'];
		public $currency_code;
		public $exchange_rate = 1;
		public $decimals;
		public $details  = [];
		public $error_msg;
		public static $response = "default";



		public function __construct()
		{
	      exists_or_abort(config("payments_gateways.{$this->name}"), __(":payment_proc is not enabled", ["payment_proc" =>  ucfirst($this->name)]));

	      $this->api_key  		 = config("payments_gateways.{$this->name}.api_key");
	      $this->currency_code = config("payments.currency_code");
	      $this->decimals 		 = config("payments.currencies.{$this->currency_code}.decimals", 2);

	      prepare_currency($this);

	      if($method_types = array_filter(explode(",", config("payments_gateways.{$this->name}.methods"))))
	      {
	      		$this->payment_methods = array_intersect($this->payment_methods, $method_types);
	      }
	      
	      $this->details = [
		        'items' => [],
		        'total_amount' => 0,
		        'currency' => $this->currency_code,
		        'exchange_rate' => $this->exchange_rate,
		        'custom_amount' => null,
		        'reference' => generate_transaction_ref(),
		        'transaction_id' => null,
		        'order_id' => null,
	      ];

	      $this->status_url = route('home.checkout.webhook', ['processor' => $this->name, 'ref' => $this->details['reference']]);
				$this->return_url = route('home.checkout.order_completed', ['processor' => $this->name, 'ref' => $this->details['reference']]);
	      $this->cancel_url = route('home');
		}



		public function checkout_session_id(float $amount)
		{
				$amount = format_amount($amount * $this->exchange_rate, false, $this->decimals);

				$this->details['total_amount'] = $amount;

				$payload = [
					  "pay_to_email" => config("payments_gateways.{$this->name}.merchant_account"),
					  "prepare_only" => 1,
					  "status_url" => $this->status_url,
					  "return_url" => $this->return_url,
					  "return_url_text" => "Return",
					  "return_url_target" => "1",
					  "cancel_url" => $this->cancel_url,
					  "cancel_url_target" => "1",
					  "dynamic_descriptor" => "Descriptor",
					  "merchant_fields" => "user_id",
					  "user_id" => uuid6(),
					  "language" => "EN",
					  "logo_url" => asset("storage/images/".config('app.logo')),
					  "amount" => $amount,
					  "currency" => $this->currency_code,
					  "amount1_description" => __("Purchase from :app_name", ["app_name" => mb_ucfirst(config("app.name"))]),
					  "detail1_description" => "ID : ",
					  "detail1_text" => $this->details['reference'],
					  "submit_id" => "Submit",
					  "Pay" => "Pay",
					  "payment_methods" => implode(',', $this->payment_methods)
				];

				$client = new Client([
	          "verify" => false,
	          "http_errors" => false,
	          "headers" => [
	          		"Accept-Language" => "en_US",
	          ]
	      ]);

	      $response = $client->request("POST", "https://pay.skrill.com", ["form_params" => $payload]);

	      if(stripos($response->getStatusCode(), '20') === false)
	      {
	          $this->error_msg = ["user_message" => (string)$response->getBody()];

	          return;
	      }

				if(json_decode((string)$response->getBody(), true))
				{
						$this->error_msg = ["user_message" => (string)$response->getBody()];

						return;
				}

				// SID
				return (string)$response->getBody();
		}



		public function init_payment(float $amount)
    {
	      $sid = $this->checkout_session_id($amount);

	      if($this->error_msg)
	      {
	        	return $this->error_msg;
	      }

	      $this->details['transaction_id'] = $sid;

	      return "https://pay.skrill.com/app?sid={$sid}";
    }




    public function complete_payment(Request $request)
    {
	      if(stripos($request->processor, $this->name) !== false && $request->ref !== null)
	      {
		        $transaction_id = $request->ref;

		        $transaction =  Transaction::where(['processor' => $this->name])
		                        ->where(function($builder) use($transaction_id)
		                        {
			                          $builder->where(['transaction_id' => $transaction_id])
			                                  ->orWhere(['order_id' => $transaction_id])
			                                  ->orWhere(['reference_id' => $transaction_id]);
		                        })
		                        ->first();

		        if(!$transaction)
		        {
			          return [
				            'status' => false, 
				            'user_message' => __('Missing transaction database record [:transaction_id].', ['transaction_id' => $transaction_id])
			          ];
		        }

		        if($transaction->status !== 'paid')
		        {
			          $transaction->status = 'pending';
			          $transaction->save();
		        }

	        	return ['status' => true, 'user_message' => null, 'transaction' => $transaction];
	      }

      	return ['status' => false, 'user_message' => __('Something wrong happened.')];
    }



    public function handle_webhook_notif(Request $request)
    {
	      $response = ['status' => 0, 'transaction' => null, 'valid' => 0];

	      if(stripos($request->processor, $this->name) !== false)
	      {
		        $status['valid'] = 1;
		        
		        $merchant_id     = $request->input('merchant_id');
			      $transaction_id  = $request->input('transaction_id');
			      $secret_word     = strtoupper(md5(config("payments_gateways.{$this->name}.mqiapi_secret_word")));
			      $mb_amount       = $request->input('mb_amount');
			      $mb_currency     = $request->input('mb_currency');
			      $status          = $request->input('status');

			      $digest = strtoupper(md5($merchant_id . $transaction_id . $secret_word . $mb_amount . $mb_currency . $status));

		        if($digest === $request->input('md5sig') && $status === "2")
		        {
		          $order_id = $request->get('ref');

		          $transaction =  Transaction::where(function($query) use($order_id)
		                          {
		                            $query->where('order_id', $order_id)
		                                  ->orWhere('transaction_id', $order_id)
		                                  ->orWhere('reference_id', $order_id);
		                          })
		                          ->where(['processor' => $this->name, 'status' => 'pending'])
		                          ->first();

		          if($transaction)
		          {
		            $transaction->status = 'paid';
		            $transaction->confirmed = 1;
		            $transaction->transaction_id = $transaction_id;

		            $transaction->save();

		            $response['status'] = 1;
		            $response['transaction'] = $transaction;
		          }
		        }
	      }

	      return $response;
    }

	}