<?php

	namespace App\Libraries;

	use YouCan\Pay\YouCanPay;
	use Illuminate\Support\Facades\{ DB, Session, Cache, Validator, Auth };
	use Illuminate\Http\Request;
	use App\Models\{ Transaction };

	class YCPay
	{
		public $name = "youcanpay";
		public $return_url;
		public $cancel_url;
		public $supported_currencies = ["MAD"];
		public $currency_code;
		public $exchange_rate = 1;
		public $decimals;
		public $details  = [];
		public $error_msg;
		public static $response = "default";


		public function __construct()
		{
				exists_or_abort(config("payments_gateways.{$this->name}.enabled"), __(":payment_proc is not enabled", ["payment_proc" =>  $this->name]));

				$this->currency_code = config("payments.currency_code");
				$this->decimals 		 = config("payments.currencies.{$this->currency_code}.decimals");

				prepare_currency($this);

	      $this->details = [
		      	"items" => [],
			      "amount" => 0,
			      "currency" => $this->currency_code,
			      "exchange_rate" => $this->exchange_rate,
			      "custom_amount" => null,
			      "reference" => generate_transaction_ref(),
			      "transaction_id" => null,
			      "order_id" => null,
		    ];

		    $this->return_url = route("home.checkout.order_completed", ['processor' => $this->name, 'ref' => $this->details['reference']]);
				$this->cancel_url = route('home');
		}



		public function create_order(float $amount)
		{
				$this->details['total_amount'] = $amount;

	      $amount = (int)ceil(format_amount($amount * $this->exchange_rate, false, $this->decimals) * pow(10, $this->decimals));
	      
	      YouCanPay::setIsSandboxMode(config('payments.gateways.youcanpay.mode') == 'sandbox');

	      $youCanPay = YouCanPay::instance()->useKeys(config('payments.gateways.youcanpay.private_key'), config('payments.gateways.youcanpay.public_key'));

	      $user_info = [];

	      $metadata = [
	      		"reference" => $this->details['reference']
	      ];

	      $token = $youCanPay->token->create(
	          $this->details['reference'],
	          $amount,
	          $this->currency_code,
	          request()->ip(),
	          $this->return_url,
	          $this->cancel_url,
	          $user_info,
	          $metadata
	      );

	      return $token->getPaymentURL(config('app.locale', 'en'));
		}



		public function init_payment(float $amount)
		{
	      if($this->error_msg)
	      {
	        	return $this->error_msg;
	      }

	      $payment_url = $this->create_order($amount) ?? abort(404);

	      return $payment_url;
		}



		public function complete_payment(Request $request)
		{
				if(stripos($request->processor, $this->name) !== false && $request->ref)
	      {
	      		$transaction_id = $request->ref;

		      	$transaction = 	Transaction::where(['processor' => $this->name])
										      	->where(function($builder) use($transaction_id)
										    		{
											    			$builder->where(['transaction_id' => $transaction_id])
											    							->orWhere(['order_id' => $transaction_id])
											    							->orWhere(['reference_id' => $transaction_id]);
										    		})
										    		->first();

		      	if(!$transaction)
		      	{
			      		return [
				      			'status' 			 => false, 
				      			'user_message' => __('Missing transaction database record [:transaction_id].', ['transaction_id' => $transaction_id])
			      		];
		      	}

		        $transaction->status = 'pending';
		        $transaction->save();
		      
		        return ['status' => true, 'user_message' => null, 'transaction' => $transaction];
	      }

	      return ['status' => false, 'user_message' => __('Something wrong happened.')];
		}



		public function handle_webhook_notif(Request $request)
		{
				$response = ['status' => 0, 'transaction' => null, 'valid' => 0];

				$signature = $request->header('X-Youcanpay-Signature');

				if($signature && (stripos($request->header('User-Agent'), 'YouCanPay/1.0') !== false))
				{
						$status['valid'] = 1;
						
		        $youcanPay = YouCanPay::instance()->useKeys(config('payments.gateways.youcanpay.private_key'), 
		        																						config('payments.gateways.youcanpay.public_key'));

		        if($result = $youcanPay->verifyWebhookSignature($signature, $request->post()))
		        {
			        	if($request->input('payload.transaction.status') == 1)
			        	{
				        		$order_id = $request->input('payload.transaction.order_id');

				        		$transaction = 	Transaction::where(function($query) use($order_id)
												        		{
												        			$query->where('order_id', $order_id)
												        						->orWhere('transaction_id', $order_id)
												        						->orWhere('reference_id', $order_id);
												        		})
												        		->where(['processor' => $this->name, 'status' => 'pending'])
												        		->first();

										if($transaction)
										{
												$transaction->status = 'paid';
												$transaction->confirmed = 1;

												$transaction->save();

												$response['status'] = 1;
												$response['transaction'] = $transaction;
										}
			        	}
		        }
				}

				return $response;
		}

}