<?php

return [
	"name" => "Offline payment",
	"class" => "Offlinepayment",
	"slug" => "offlinepayment",
	"fields" => [ 
		"enabled" => [
			"type" => "toggler", 
			"validation" => "nullable|in:on", 
			"value" => ""
		],
		"icon" => [
      "type" => "hidden", 
      "validation" => "nullable|string", 
      "value" => "/assets/images/payment/offlinepayment_icon.png",
    ],
    "description" => [
			"type" => "hidden", 
			"validation" => "nullable|string", 
			"value" => "Bank transfer, Cash, Check, ACH credit transfer, SEPA credit transfer",
		],
		"order" => [
			"type" => "hidden", 
			"validation" => "nullable|numeric", 
			"value" => null,
		],
		"instructions" => [
			"type" => "html_editor", 
			"validation" => "nullable|string|required_with:gateways.offlinepayment.enabled", 
			"value" => null
		],
		"fee" => [
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"minimum" => [  // The minimum amount to pay to "Pay what you want"
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"auto_exchange_to" => [ // Auto-exchange Currency to This currency when using multiple currencies
			"type" => "string", 
			"validation" => "nullable|string|max:3", 
			"value" => null
		]
	],
	"form" => [
    "inputs" => [],
    "note" => [
      "html" => <<<BTN
        <div class="offline-payment">[OFFLINE_INSTRUCTIONS]</div>
       BTN,
      'replace' =>   [
        ["search" => "[OFFLINE_INSTRUCTIONS]", "src" => "config", "value" => "payments_gateways.offlinepayment.instructions"],
      ]
    ],
    "checkout_buttons" => []
  ],
	"methods_icons" => [],
	"assets" => [],
	"guest_checkout" => 1,
	"async" => 0,
	"supports_recurrent" => 0,
	"payment_link" => 0,
];
