<?php

return [
	"name" => "Paystack",
	"url" => "https://paystack.com/",
	"class" => "Paystack",
	"slug" => "paystack",
	"fields" => [
		"enabled" => [
			"type" => "toggler", 
			"validation" => "nullable|in:on", 
			"value" => ""
		],
		"icon" => [
      "type" => "hidden", 
      "validation" => "nullable|string", 
      "value" => "/assets/images/payment/paystack_icon.png",
    ],
    "description" => [
			"type" => "hidden", 
			"validation" => "nullable|string", 
			"value" => "Cards, Mobile money, QR codes, Bank transfer, USSD",
		],
		"order" => [
			"type" => "hidden", 
			"validation" => "nullable|numeric", 
			"value" => null,
		],
		"public_key" => [
			"type" => "string", 
			"validation" => "nullable|string|max:255|required_with:gateways.paystack.enabled", 
			"value" => null
		],
		"secret_key" => [
			"type" => "string", 
			"validation" => "nullable|string|max:255|required_with:gateways.paystack.enabled", 
			"value" => null
		],
		"channels" => [
			"type" => "dropdown", 
			"validation" => "nullable|string|required_with:gateways.paystack.enabled", 
			"value" => null,
			"multiple" => 1,
			"options" => [
				"card" => "Card",
				"bank" => "Bank",
				"ussd" => "USSD",
				"qr" => "QR",
				"mobile_money" => "Mobile money",
				"bank_transfer" => "Bank transfer"
			]
		],
		"fee" => [
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"minimum" => [  // The minimum amount to pay to "Pay what you want"
			"type" => "string", 
			"validation" => "nullable|numeric|gte:0|max:255", 
			"value" => null
		],
		"auto_exchange_to" => [ // Auto-exchange Currency to This currency when using multiple currencies
			"type" => "string", 
			"validation" => "nullable|string|max:3", 
			"value" => null
		]
	],
	"form" => [
    "inputs" => [],
    "note" => [],
    "checkout_buttons" => []
  ],
	"methods_icons" => [
		"mastercard-curved-64px.png" => null,
		"visa-curved-64px.png" => null,
		"american-express-curved-64px.png" => null,
		"discover-curved-64px.png" => null,
	],
	"assets" => [],
	"guest_checkout" => 0,
	"async" => 0,
	"supports_recurrent" => 0,
	"webhook_responses" => ["success" => "[accepted]", "failed" => "404 Not Found"],
	"payment_link" => 1,
];