START TRANSACTION;

CREATE TABLE IF NOT EXISTS `affiliate_earnings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `referrer_id` bigint NOT NULL,
  `referee_id` bigint NOT NULL,
  `transaction_id` bigint NOT NULL,
  `commission_percent` bigint NOT NULL,
  `commission_value` float NOT NULL,
  `paid` tinyint(1) NOT NULL DEFAULT '0',
  `amount` float NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `referrer_id` (`referrer_id`) USING BTREE,
  KEY `referee_id` (`referee_id`) USING BTREE,
  KEY `transaction_id` (`transaction_id`) USING BTREE,
  KEY `paid` (`paid`) USING BTREE,
  KEY `created_at` (`created_at`) USING BTREE,
  KEY `updated_at` (`updated_at`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `cache` (
  `key` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb3_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `cache_locks` (
  `key` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `cashouts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `earning_ids` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `user_id` bigint NOT NULL,
  `amount` float NOT NULL DEFAULT '0',
  `method` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `payout_batch_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `details` text COLLATE utf8mb3_unicode_ci,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ROW_FORMAT=DYNAMIC;

CREATE TABLE IF NOT EXISTS `categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `icon` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `parent` int DEFAULT NULL,
  `range` int DEFAULT '1',
  `for` tinyint(1) DEFAULT '1' COMMENT '0 for posts / 1 for products',
  `featured` tinyint(1) DEFAULT '0',
  `views` int DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`parent`,`slug`,`for`),
  KEY `range` (`range`),
  KEY `for` (`for`),
  KEY `parent` (`parent`),
  KEY `slug` (`slug`),
  KEY `featured` (`featured`),
  FULLTEXT KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `category_product` (
  `category_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `featured` tinyint(1) DEFAULT NULL,
  `trending` tinyint(1) DEFAULT NULL,
  UNIQUE KEY `category_id_product_id` (`category_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `comments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` int NOT NULL,
  `body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` int DEFAULT NULL,
  `approved` tinyint(1) DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  `read_by_admin` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `product_id` (`product_id`),
  KEY `approved` (`approved`),
  KEY `parent` (`parent`),
  KEY `read_by_admin` (`read_by_admin`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `value` float NOT NULL,
  `is_percentage` tinyint(1) DEFAULT '0',
  `users_ids` text COLLATE utf8mb3_unicode_ci,
  `starts_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `used_by` text COLLATE utf8mb3_unicode_ci,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  `products_ids` text COLLATE utf8mb3_unicode_ci,
  `subscriptions_ids` mediumtext COLLATE utf8mb3_unicode_ci,
  `once` tinyint(1) DEFAULT '0',
  `for` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT 'products',
  `regular_license_only` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `value` (`value`),
  KEY `starts_at` (`starts_at`),
  KEY `expires_at` (`expires_at`),
  KEY `updated_at` (`updated_at`),
  KEY `deleted_at` (`deleted_at`),
  KEY `once` (`once`) USING BTREE,
  KEY `for` (`for`) USING BTREE,
  KEY `regular_license_only` (`regular_license_only`) USING BTREE,
  FULLTEXT KEY `users_ids` (`users_ids`),
  FULLTEXT KEY `used_by` (`used_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `custom_routes` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `view` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `method` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT 'get',
  `csrf_protection` tinyint(1) DEFAULT '0',
  `views` bigint DEFAULT '0',
  `active` tinyint(1) DEFAULT '1',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `method` (`method`),
  KEY `updated_at` (`updated_at`),
  KEY `created_at` (`created_at`),
  KEY `slug` (`slug`),
  KEY `active` (`active`),
  KEY `views` (`views`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `faqs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `answer` longtext COLLATE utf8mb3_unicode_ci NOT NULL,
  `active` tinyint(1) DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `updated_at` (`updated_at`),
  KEY `active` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `key_s` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `code` mediumtext COLLATE utf8mb3_unicode_ci,
  `user_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `product_id` bigint DEFAULT NULL,
  `purchased_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_at` (`created_at`) USING BTREE,
  KEY `updated_at` (`updated_at`) USING BTREE,
  KEY `purchased_at` (`purchased_at`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `newsletter_subscribers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deletet_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `users_ids` longtext COLLATE utf8mb3_unicode_ci NOT NULL,
  `for` tinyint(1) DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `deleted_at` (`deleted_at`),
  KEY `product_id` (`product_id`),
  KEY `for` (`for`),
  FULLTEXT KEY `users_ids` (`users_ids`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `short_description` text COLLATE utf8mb3_unicode_ci,
  `content` longtext COLLATE utf8mb3_unicode_ci NOT NULL,
  `tags` text COLLATE utf8mb3_unicode_ci,
  `views` int DEFAULT '0',
  `deletable` tinyint(1) DEFAULT '1',
  `active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `slug` (`slug`),
  KEY `updated_at` (`updated_at`),
  KEY `active` (`active`),
  KEY `views` (`views`),
  KEY `deletable` (`deletable`),
  FULLTEXT KEY `description` (`name`,`slug`,`short_description`,`content`,`tags`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `payment_links` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT '0',
  `processor` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `user_id` bigint NOT NULL,
  `content` longtext COLLATE utf8mb3_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `short_link` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  `reference` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  `amount` float DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `short_link` (`short_link`) USING BTREE,
  KEY `name` (`name`) USING BTREE,
  KEY `created_at` (`created_at`) USING BTREE,
  KEY `updated_at` (`updated_at`) USING BTREE,
  KEY `deleted_at` (`deleted_at`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `processor` (`processor`) USING BTREE,
  KEY `reference` (`reference`) USING BTREE,
  KEY `amount` (`amount`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb3_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb3_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `posts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `short_description` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb3_unicode_ci NOT NULL,
  `cover` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `tags` text COLLATE utf8mb3_unicode_ci,
  `active` tinyint(1) DEFAULT '1',
  `views` int DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  `category` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`id`,`name`,`slug`),
  KEY `updated_at` (`updated_at`),
  KEY `active` (`active`),
  KEY `views` (`views`),
  KEY `slug` (`slug`),
  KEY `category` (`category`),
  FULLTEXT KEY `search` (`name`,`short_description`,`content`,`tags`),
  FULLTEXT KEY `tags` (`tags`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `prepaid_credits` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `subheading` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `amount` float NOT NULL DEFAULT '0',
  `specs` text COLLATE utf8mb3_unicode_ci,
  `popular` tinyint(1) DEFAULT '0',
  `order` tinyint DEFAULT '0',
  `discount` float DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `popular` (`popular`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `amount` (`amount`),
  KEY `order` (`order`),
  KEY `discount` (`discount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `pricing_table` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `subheading` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `products` longtext COLLATE utf8mb3_unicode_ci,
  `categories` longtext COLLATE utf8mb3_unicode_ci,
  `price` float DEFAULT '0',
  `description` text COLLATE utf8mb3_unicode_ci,
  `specifications` text COLLATE utf8mb3_unicode_ci,
  `days` int DEFAULT '0',
  `limit_downloads` int DEFAULT '0',
  `color` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `limit_downloads_per_day` int DEFAULT '0',
  `limit_downloads_same_item` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT '0',
  `position` int DEFAULT '0',
  `popular` tinyint(1) DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `slug` (`slug`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `limit_downloads_per_day` (`limit_downloads_per_day`) USING BTREE,
  KEY `limit_downloads` (`limit_downloads`) USING BTREE,
  KEY `price` (`price`) USING BTREE,
  KEY `days` (`days`) USING BTREE,
  KEY `position` (`position`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `short_description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `overview` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `price` float DEFAULT NULL,
  `extended_price` float DEFAULT NULL,
  `promo_price` float DEFAULT NULL,
  `promo_time` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `notes` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `rating` float DEFAULT NULL,
  `sales` int DEFAULT NULL,
  `comments` int DEFAULT NULL,
  `reviews` int DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  `category` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `subcategories` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `cover` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `screenshots` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `version` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `release_date` date DEFAULT NULL,
  `last_update` date DEFAULT NULL,
  `included_files` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `tags` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `software` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `db` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `compatible_browsers` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `compatible_os` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `high_resolution` tinyint(1) DEFAULT '0',
  `documentation` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `file_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `file_size` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `file_host` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT 'local',
  `file_extension` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `featured` tinyint(1) DEFAULT '0',
  `trending` tinyint(1) DEFAULT '0',
  `views` int DEFAULT '0',
  `faq` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `promotional_price_time` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `stock` int DEFAULT NULL,
  `hidden_content` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `enable_license` tinyint(1) DEFAULT NULL,
  `direct_download_link` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `newest` tinyint(1) DEFAULT '0',
  `for_subscriptions` tinyint(1) DEFAULT '0',
  `bpm` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `bit_rate` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `table_of_contents` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `pages` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `words` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `language` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `formats` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `authors` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview_url` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `label` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `additional_fields` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `country_city` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview_extension` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `minimum_price` float DEFAULT NULL,
  `fake_sales` bigint DEFAULT NULL,
  `fake_rating` float DEFAULT NULL,
  `fake_comments` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `fake_reviews` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `affiliate_link` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `permalink` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tmp_direct_link` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `group_buy_price` float DEFAULT NULL,
  `group_buy_min_buyers` int DEFAULT NULL,
  `group_buy_expiry` int DEFAULT NULL,
  `meta_tags` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permalink` (`permalink`),
  KEY `category` (`category`),
  KEY `subcategories` (`subcategories`),
  KEY `documentation` (`documentation`),
  KEY `release_date` (`release_date`),
  KEY `created_at` (`created_at`),
  KEY `deleted_at` (`deleted_at`),
  KEY `updated_at` (`updated_at`),
  KEY `active` (`active`),
  KEY `file_name` (`file_name`),
  KEY `file_host` (`file_host`),
  KEY `featured` (`featured`),
  KEY `trending` (`trending`),
  KEY `promotional_price_time` (`promotional_price_time`) USING BTREE,
  KEY `stock` (`stock`) USING BTREE,
  KEY `enable_license` (`enable_license`) USING BTREE,
  KEY `views` (`views`) USING BTREE,
  KEY `for_subscriptions` (`for_subscriptions`) USING BTREE,
  KEY `pages` (`pages`) USING BTREE,
  KEY `words` (`words`) USING BTREE,
  KEY `language` (`language`) USING BTREE,
  KEY `formats` (`formats`) USING BTREE,
  KEY `authors` (`authors`) USING BTREE,
  KEY `bpm` (`bpm`) USING BTREE,
  KEY `bit_rate` (`bit_rate`) USING BTREE,
  KEY `country_city` (`country_city`) USING BTREE,
  KEY `newest` (`newest`) USING BTREE,
  KEY `minimum_price` (`minimum_price`),
  KEY `fake_sales` (`fake_sales`),
  KEY `fake_rating` (`fake_rating`),
  KEY `rating` (`rating`),
  FULLTEXT KEY `name_slug_short_description` (`name`,`slug`,`short_description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `reactions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `product_id` bigint NOT NULL,
  `item_type` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'comment',
  `item_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `item_type_item_id_user_id` (`item_type`,`item_id`,`user_id`) USING BTREE,
  KEY `type` (`item_type`) USING BTREE,
  KEY `created_at` (`created_at`) USING BTREE,
  KEY `deleted_at` (`deleted_at`) USING BTREE,
  KEY `updated_at` (`updated_at`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `reviews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` int NOT NULL,
  `rating` float DEFAULT '0',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `approved` tinyint(1) DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  `read_by_admin` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_product` (`user_id`,`product_id`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `deleted_at` (`deleted_at`),
  KEY `product_id` (`product_id`),
  KEY `approved` (`approved`),
  KEY `read_by_admin` (`read_by_admin`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `searches` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `keywords` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `user_id` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `created_at` (`created_at`) USING BTREE,
  KEY `updated_at` (`updated_at`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `keywords` (`keywords`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `sessions` (
  `id` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb3_unicode_ci,
  `payload` longtext COLLATE utf8mb3_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `general` longtext COLLATE utf8mb3_unicode_ci,
  `mailer` longtext COLLATE utf8mb3_unicode_ci,
  `payments` longtext COLLATE utf8mb3_unicode_ci,
  `search_engines` longtext COLLATE utf8mb3_unicode_ci,
  `adverts` longtext COLLATE utf8mb3_unicode_ci,
  `files_host` longtext COLLATE utf8mb3_unicode_ci,
  `social_login` longtext COLLATE utf8mb3_unicode_ci,
  `chat` longtext COLLATE utf8mb3_unicode_ci,
  `captcha` longtext COLLATE utf8mb3_unicode_ci,
  `database` longtext COLLATE utf8mb3_unicode_ci,
  `affiliate` longtext COLLATE utf8mb3_unicode_ci,
  `maintenance` longtext COLLATE utf8mb3_unicode_ci,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `statistics` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `traffic` longtext COLLATE utf8mb3_unicode_ci,
  `browsers` longtext COLLATE utf8mb3_unicode_ci,
  `devices` longtext COLLATE utf8mb3_unicode_ci,
  `oss` longtext COLLATE utf8mb3_unicode_ci,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `subscription_same_item_downloads` (
  `subscription_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `downloads` bigint NOT NULL,
  UNIQUE KEY `sub_unique` (`subscription_id`,`product_id`) USING BTREE,
  KEY `subscription_id` (`subscription_id`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `downloads` (`downloads`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `support` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email_id` int NOT NULL,
  `subject` text COLLATE utf8mb3_unicode_ci,
  `message` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `read` tinyint(1) DEFAULT '0',
  `parent` tinyint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `read_by_admin` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `updated_at` (`updated_at`),
  KEY `read` (`read`),
  KEY `parent` (`parent`),
  KEY `read_by_admin` (`read_by_admin`) USING BTREE,
  FULLTEXT KEY `search` (`subject`,`message`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `support_email` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `temp_direct_urls` (
  `product_id` bigint DEFAULT NULL,
  `host` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `url` text COLLATE utf8mb3_unicode_ci,
  `expiry` int DEFAULT NULL,
  UNIQUE KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `processor` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `products_ids` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `user_id` int DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  `reference_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `order_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `amount` float NOT NULL,
  `discount` float DEFAULT NULL,
  `refunded` tinyint(1) DEFAULT '0',
  `refund` float DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `items_count` int NOT NULL,
  `is_subscription` tinyint(1) DEFAULT '0',
  `guest_token` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `guest_email` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT 'paid',
  `confirmed` tinyint(1) DEFAULT '1',
  `exchange_rate` float DEFAULT NULL,
  `details` longtext COLLATE utf8mb3_unicode_ci,
  `licenses` longtext COLLATE utf8mb3_unicode_ci,
  `custom_amount` float DEFAULT NULL,
  `payment_url` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `read_by_admin` tinyint(1) DEFAULT '0',
  `referrer_id` bigint DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sandbox` tinyint(1) DEFAULT NULL,
  `cart_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `processor_transaction_id` (`processor`,`transaction_id`) USING BTREE,
  KEY `products_ids` (`products_ids`),
  KEY `coupon_id` (`coupon_id`),
  KEY `refunded` (`refunded`),
  KEY `refund` (`refund`),
  KEY `processor` (`processor`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `deleted_at` (`deleted_at`),
  KEY `amount` (`amount`),
  KEY `user_id` (`user_id`),
  KEY `search` (`processor`,`order_id`,`transaction_id`,`amount`,`reference_id`),
  KEY `items_count` (`items_count`),
  KEY `is_subscription` (`is_subscription`),
  KEY `guest_token` (`guest_token`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `exchange_rate` (`exchange_rate`) USING BTREE,
  KEY `confirmed` (`confirmed`) USING BTREE,
  KEY `reference_id` (`reference_id`) USING BTREE,
  KEY `payment_url` (`payment_url`) USING BTREE,
  KEY `custom_amount` (`custom_amount`) USING BTREE,
  KEY `read_by_admin` (`read_by_admin`) USING BTREE,
  KEY `referrer_id` (`referrer_id`) USING BTREE,
  KEY `sandbox` (`sandbox`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `transaction_note` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `content` text COLLATE utf8mb3_unicode_ci,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `user_id` (`user_id`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `update_features` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `features` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `affiliate_name` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `email_verified_at` date DEFAULT NULL,
  `firstname` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `lastname` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `avatar` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `role` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'user',
  `remember_token` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `provider_id` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `provider` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `id_number` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `zip_code` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `blocked` tinyint(1) DEFAULT '0',
  `receive_notifs` tinyint(1) DEFAULT '1',
  `cashout_method` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `paypal_account` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `bank_account` text COLLATE utf8mb3_unicode_ci,
  `prepaid_credits` float DEFAULT NULL,
  `affiliate_credits` float DEFAULT NULL,
  `credits_sources` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `two_factor_auth` tinyint(1) DEFAULT '0',
  `two_factor_auth_expiry` int DEFAULT NULL,
  `two_factor_auth_secret` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `two_factor_auth_ip` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `user` (`name`,`email`),
  KEY `name` (`name`),
  KEY `updated_at` (`updated_at`),
  KEY `verified` (`email_verified_at`),
  KEY `role` (`role`),
  KEY `created_at` (`created_at`),
  KEY `blocked` (`blocked`) USING BTREE,
  KEY `receive_notifs` (`receive_notifs`) USING BTREE,
  KEY `affiliate_name` (`affiliate_name`) USING BTREE,
  KEY `cashout_method` (`cashout_method`) USING BTREE,
  KEY `paypal_account` (`paypal_account`) USING BTREE,
  KEY `credits` (`prepaid_credits`) USING BTREE,
  KEY `affiliate_credits` (`affiliate_credits`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `user_prepaid_credits` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `prepaid_credits_id` bigint NOT NULL,
  `transaction_id` bigint NOT NULL,
  `user_id` bigint NOT NULL,
  `credits` float NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `prepaid_credits_id` (`prepaid_credits_id`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `user_shopping_cart_item` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `item_id` bigint NOT NULL,
  `category_id` bigint NOT NULL,
  `category_name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `category_url` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `summary` text COLLATE utf8mb3_unicode_ci,
  `cover` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `price` float NOT NULL,
  `extended_license` tinyint(1) NOT NULL DEFAULT (0),
  `custom_price` float DEFAULT NULL,
  `price_expiry` int DEFAULT NULL COMMENT 'expiry for promo and group buy',
  `has_promo` tinyint DEFAULT '0',
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime DEFAULT (now()),
  `updated_at` datetime DEFAULT (now()),
  `delete_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `user_subscription` (
  `id` int NOT NULL AUTO_INCREMENT,
  `subscription_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `starts_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `ends_at` datetime DEFAULT NULL,
  `downloads` int DEFAULT '0',
  `transaction_id` bigint DEFAULT '0',
  `daily_downloads` int DEFAULT '0',
  `daily_downloads_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscription_id` (`subscription_id`),
  KEY `user_id` (`user_id`),
  KEY `starts_at` (`starts_at`),
  KEY `downloads` (`downloads`),
  KEY `transaction_id` (`transaction_id`) USING BTREE,
  KEY `daily_downloads` (`daily_downloads`) USING BTREE,
  KEY `daily_downloads_date` (`daily_downloads_date`) USING BTREE,
  KEY `ends_at` (`ends_at`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `_categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `icon` text COLLATE utf8mb3_unicode_ci,
  `description` text COLLATE utf8mb3_unicode_ci,
  `parent` int DEFAULT NULL,
  `range` int DEFAULT '1',
  `for` tinyint(1) DEFAULT '1' COMMENT '0 for posts / 1 for products',
  `featured` tinyint(1) DEFAULT '0',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`parent`,`slug`,`for`),
  KEY `range` (`range`),
  KEY `for` (`for`),
  KEY `parent` (`parent`),
  KEY `slug` (`slug`),
  KEY `featured` (`featured`),
  FULLTEXT KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

CREATE TABLE IF NOT EXISTS `_products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `short_description` text COLLATE utf8mb3_unicode_ci,
  `overview` longtext COLLATE utf8mb3_unicode_ci,
  `price` float DEFAULT NULL,
  `extended_price` float DEFAULT NULL,
  `promo_price` float DEFAULT NULL,
  `promo_time` int DEFAULT NULL,
  `notes` text COLLATE utf8mb3_unicode_ci,
  `rating` float DEFAULT NULL,
  `sales` int DEFAULT NULL,
  `comments` int DEFAULT NULL,
  `reviews` int DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  `category` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `subcategories` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `cover` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `screenshots` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `release_date` date DEFAULT NULL,
  `last_update` date DEFAULT NULL,
  `included_files` text COLLATE utf8mb3_unicode_ci,
  `tags` text COLLATE utf8mb3_unicode_ci,
  `software` text COLLATE utf8mb3_unicode_ci,
  `db` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `compatible_browsers` text COLLATE utf8mb3_unicode_ci,
  `compatible_os` text COLLATE utf8mb3_unicode_ci,
  `high_resolution` tinyint(1) DEFAULT '0',
  `documentation` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `file_name` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview` text COLLATE utf8mb3_unicode_ci,
  `file_size` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `file_host` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT 'local',
  `file_extension` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `free` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `featured` tinyint(1) DEFAULT '0',
  `trending` tinyint(1) DEFAULT '0',
  `views` int DEFAULT '0',
  `faq` text COLLATE utf8mb3_unicode_ci,
  `promotional_price_time` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `stock` int DEFAULT NULL,
  `hidden_content` longtext COLLATE utf8mb3_unicode_ci,
  `enable_license` tinyint(1) DEFAULT NULL,
  `direct_download_link` text COLLATE utf8mb3_unicode_ci,
  `newest` tinyint(1) DEFAULT '0',
  `for_subscriptions` tinyint(1) DEFAULT '0',
  `bpm` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `bit_rate` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `table_of_contents` longtext COLLATE utf8mb3_unicode_ci,
  `pages` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `words` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `language` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `formats` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `authors` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview_url` text COLLATE utf8mb3_unicode_ci,
  `label` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `additional_fields` longtext COLLATE utf8mb3_unicode_ci,
  `country_city` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview_type` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `preview_extension` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `minimum_price` float DEFAULT NULL,
  `fake_sales` bigint DEFAULT NULL,
  `fake_comments` longtext COLLATE utf8mb3_unicode_ci,
  `fake_reviews` longtext COLLATE utf8mb3_unicode_ci,
  `affiliate_link` text COLLATE utf8mb3_unicode_ci,
  `permalink` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tmp_direct_link` text COLLATE utf8mb3_unicode_ci,
  `group_buy_price` float DEFAULT NULL,
  `group_buy_min_buyers` int DEFAULT NULL,
  `group_buy_expiry` int DEFAULT NULL,
  `meta_tags` text COLLATE utf8mb3_unicode_ci,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permalink` (`permalink`),
  KEY `category` (`category`),
  KEY `subcategories` (`subcategories`),
  KEY `documentation` (`documentation`),
  KEY `release_date` (`release_date`),
  KEY `created_at` (`created_at`),
  KEY `deleted_at` (`deleted_at`),
  KEY `updated_at` (`updated_at`),
  KEY `active` (`active`),
  KEY `file_name` (`file_name`),
  KEY `file_host` (`file_host`),
  KEY `featured` (`featured`),
  KEY `trending` (`trending`),
  KEY `free` (`free`),
  KEY `promotional_price_time` (`promotional_price_time`) USING BTREE,
  KEY `stock` (`stock`) USING BTREE,
  KEY `enable_license` (`enable_license`) USING BTREE,
  KEY `views` (`views`) USING BTREE,
  KEY `for_subscriptions` (`for_subscriptions`) USING BTREE,
  KEY `pages` (`pages`) USING BTREE,
  KEY `words` (`words`) USING BTREE,
  KEY `language` (`language`) USING BTREE,
  KEY `formats` (`formats`) USING BTREE,
  KEY `authors` (`authors`) USING BTREE,
  KEY `bpm` (`bpm`) USING BTREE,
  KEY `bit_rate` (`bit_rate`) USING BTREE,
  KEY `country_city` (`country_city`) USING BTREE,
  KEY `newest` (`newest`) USING BTREE,
  KEY `minimum_price` (`minimum_price`),
  KEY `fake_sales` (`fake_sales`),
  FULLTEXT KEY `name_slug_short_description` (`name`,`slug`,`short_description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT IGNORE INTO `settings` (`id`, `general`, `mailer`, `payments`, `search_engines`, `adverts`, `files_host`, `social_login`, `chat`, `captcha`, `database`, `affiliate`, `maintenance`, `created_at`, `updated_at`, `deleted_at`) VALUES
  (1, '{"name":"Valexa","title":"Valexa - PHP Script For Selling Digital Products","description":"Valexa, a single vendor php script for selling digital products, software, graphics, audios, videos, fonts, icons, templates and any downloadable items.","filter_by_included_files":"0","email":"support@codemayer.net","keywords":"digital downloads php script, shopping cart php script, ecommerce php script, paypal php script, stripe php script, digital store php script, gpl store php script, gpl licence php script, paypal digital download","items_per_page":"12","favicon":"favicon.svg","logo":"tendra_logo.svg","search_cover":"search_cover.png","env":"production","debug":"0","timezone":"Europe\\/Amsterdam","facebook":"#","twitter":"#","pinterest":"#","youtube":"#","tumblr":"#","search_header":"Templates, PHP Scripts, Graphics and Codes starting from $2","search_subheader":null,"cover":"cover.png","blog":{"enabled":"1","title":"Valexa - PHP Script For Selling Digital Products","description":"Valexa, a single vendor php script for selling digital products, software, graphics, audios, videos, fonts, icons, templates and any downloadable items.","disqus":"1"},"blog_cover":"blog_cover.jpg","fb_app_id":null,"langs":"fr,en,tr,ar","template":"tendra","fonts":{"ltr":{"url":null,"dir":"Spartan"},"rtl":{"url":"https:\\/\\/fonts.googleapis.com\\/css2?family=Almarai:wght@300;400;700;800&display=swap","dir":null}},"subscriptions":"{\\"enabled\\":\\"1\\",\\"accumulative\\":\\"1\\"}","watermark":null,"users_notif":"Lorem ipsum dolor sit amet consectetur adipisicing elit. Odio, nisi maiores praesentium delectus animi.","valexa_top_cover":null,"tendra_top_cover":"tendra_top_cover.jpg","purchase_code":"...","tendra_top_cover_mask":null,"maintenance_mode":"1","maintenance_time":"2021-01-20 12:00:00","maintenance":"{\\"enabled\\":\\"0\\",\\"exception\\":\\"127.0.0.1, 127.1.5.99\\",\\"expires_at\\":\\"2025-03-25 15:30:00\\",\\"auto_disable\\":\\"1\\",\\"title\\":\\"Under maintenance\\",\\"header\\":\\"Our website is under maintenance\\",\\"subheader\\":\\"We are adding more features, stay tuned\\",\\"text\\":\\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\\",\\"bg_color\\":\\"#042f86\\"}","email_verification":"1","auto_approve":"{\\"support\\":\\"1\\",\\"reviews\\":\\"1\\"}","admin_notifications":"{\\"comments\\":\\"1\\",\\"reviews\\":\\"1\\",\\"sales\\":\\"1\\"}","default_product_type":"-","default_top_cover":null,"homepage_items":"null","products_by_country_city":"0","recently_viewed_items":"1","cookie_text":"<p>We use cookies to understand how you use our website and to improve your experience. This includes personalizing content and advertising. To learn more, please click <a href=\\"https:\\/\\/tendra.codemayer.tech\\/page\\/privacy-policy\\" target=\\"_blank\\"><b style=\\"color: rgb(49, 24, 115);\\">Here<\\/b><\\/a>. By continuing to use our website, you accept our use of cookies, Privacy policy and terms &amp; conditions.<br><\\/p>","cookie":"{\\"text\\":\\"We use cookies to understand how you use our website and to improve your experience. This includes personalizing content and advertising. To learn more, please click Here. By continuing to use our website, you accept our use of cookies, Privacy policy and terms &amp; conditions.\\",\\"background\\":\\"#2a2e3ceb\\",\\"color\\":\\"#ffffff\\",\\"button_bg\\":\\"#ff6718\\"}","masonry_layout":null,"randomize_homepage_items":"0","direct_download_links":null,"pricing_cover":null,"template_color":"dark","html_editor":"tinymce","can_delete_own_comments":"1","show_rating":"product_page,product_card","show_sales":"product_page","registration_fields":"name,email,password,password_confirmation","required_registration_fields":"email,password,password_confirmation","show_streaming_player":"1","enable_comments":"1","enable_reviews":"1","enable_reactions_on_comments":"1","enable_subcomments":"1","realtime_views":"{\\"website\\":{\\"enabled\\":\\"0\\",\\"fake\\":\\"1\\",\\"range\\":\\"15,30\\"},\\"product\\":{\\"enabled\\":\\"0\\",\\"fake\\":\\"1\\",\\"range\\":\\"50,60\\"},\\"refresh\\":\\"30\\"}","counters":"products,categories,online_users,affiliate_earnings,orders","fake_profiles":{"17415c4d59a82f5b4fae2d0089194181":{"name":"\\u9093\\u9e4f","avatar":"17415c4d59a82f5b4fae2d0089194181.webp","country":"china"},"74b71b819650fa7b7b67ff09950c6c9a":{"name":"\\u6751\\u5c71 \\u821e","avatar":"74b71b819650fa7b7b67ff09950c6c9a.webp","country":"japan"},"1299cb41207c611c88fb3bc00a5d9e70":{"name":"Srta. Ta\\u00eds Jasmin Sep\\u00falveda Sobrinho","avatar":"1299cb41207c611c88fb3bc00a5d9e70.webp","country":"japan"},"20a749a135b7a21eb02764a6cd3c2b90":{"name":"Srta. Violeta M\\u00e1rquez L\\u00f3pez","avatar":"20a749a135b7a21eb02764a6cd3c2b90.webp","country":"japan"},"fba9397810cbabc03d881856c485ce2e":{"name":"Giovana Bezerra Jr.","avatar":"fba9397810cbabc03d881856c485ce2e.webp","country":"japan"},"6819a46b32b166add7b903adf7ae0297":{"name":"Karol\\u00edna H\\u00fdblov\\u00e1","avatar":"6819a46b32b166add7b903adf7ae0297.webp","country":"czech-republic"},"2aabb0b1b686c2f8c178e4077c81e8c5":{"name":"Irma Sundqvist","avatar":"2aabb0b1b686c2f8c178e4077c81e8c5.webp","country":"sweden"},"9e52c7be4b39473bb7ed8ca1c337be85":{"name":"Brigitte du De Oliveira","avatar":"9e52c7be4b39473bb7ed8ca1c337be85.webp","country":"sweden"},"4bccdc2fb3e48646fb8d11fb67d07072":{"name":"Juliette Urbain","avatar":"4bccdc2fb3e48646fb8d11fb67d07072.webp","country":"sweden"},"ca149de3018925fd68b0b8400bed0a99":{"name":"\\u0406\\u0440\\u0438\\u043d\\u0430 \\u0422\\u0430\\u0440\\u0430\\u0441\\u043e\\u0432\\u0438\\u0447 \\u0422\\u0430\\u0440\\u0430\\u0449\\u0443\\u043a","avatar":"ca149de3018925fd68b0b8400bed0a99.webp","country":"sweden"},"5010138e2a152a5c2d8a24c155a25159":{"name":"Zena Collier","avatar":"5010138e2a152a5c2d8a24c155a25159.webp","country":"sweden"},"a6fb15a7743961c191c9ccd6e81b71b8":{"name":"\\u0418\\u0441\\u0430\\u049b\\u044b\\u0437\\u044b \\u0424\\u0438\\u0440\\u0443\\u0437\\u0430","avatar":"a6fb15a7743961c191c9ccd6e81b71b8.webp","country":"sweden"},"62388b48349fa76650de03fc38aa558f":{"name":"Nadine Schulz B.A.","avatar":"62388b48349fa76650de03fc38aa558f.webp","country":"sweden"},"7f21d5ca6becc11bb5bbbb4ae3ad831d":{"name":"\\u041a\\u0440\\u0430\\u0432\\u0447\\u0435\\u043d\\u043a\\u043e \\u0422\\u0430\\u043c\\u0430\\u0440\\u0430 \\u041e\\u043b\\u0435\\u043a\\u0441\\u0430\\u043d\\u0434\\u0440\\u043e\\u0432\\u0438\\u0447","avatar":"7f21d5ca6becc11bb5bbbb4ae3ad831d.webp","country":"sweden"},"2d0c5907121d7a1edbafee8eace25d3c":{"name":"Bojana \\u0160trukelj","avatar":"2d0c5907121d7a1edbafee8eace25d3c.webp","country":"sweden"},"b55bad7c4828ce777ea607ed0d09ed59":{"name":"Marie De Smedt","avatar":"b55bad7c4828ce777ea607ed0d09ed59.webp","country":"sweden"},"edb598bd6fb89e5fb09b1bfad1bce1ab":{"name":"Elisa Aryani","avatar":"edb598bd6fb89e5fb09b1bfad1bce1ab.webp","country":"indonesian-indonesia"},"b8a6fa85a07484b68cb84da40157efe2":{"name":"Padma Lestari M.M.","avatar":"b8a6fa85a07484b68cb84da40157efe2.webp","country":"indonesian-indonesia"},"fe1cfcae705122aedf4de56667b19c4b":{"name":"Hesti Puspasari M.Farm","avatar":"fe1cfcae705122aedf4de56667b19c4b.webp","country":"indonesian-indonesia"},"1223b3915f665d178bcad1143b01b842":{"name":"Genta Suartini S.I.Kom","avatar":"1223b3915f665d178bcad1143b01b842.webp","country":"indonesian-indonesia"},"28a9196a288dbff27641724c12b65289":{"name":"Bella Handayani","avatar":"28a9196a288dbff27641724c12b65289.webp","country":"indonesian-indonesia"},"56ce01461b1d5773e998d0dcb9b355c6":{"name":"Irma Mayasari","avatar":"56ce01461b1d5773e998d0dcb9b355c6.webp","country":"indonesian-indonesia"},"721115be6e01baef41ddf770df71aa58":{"name":"Ulva Agustina S.H.","avatar":"721115be6e01baef41ddf770df71aa58.webp","country":"indonesian-indonesia"},"91cc164b959a169fa25f717556752509":{"name":"Ratih Haryanti","avatar":"91cc164b959a169fa25f717556752509.webp","country":"indonesian-indonesia"},"190ee052f19f2ee6848b7d688064c5f3":{"name":"Keisha Usada","avatar":"190ee052f19f2ee6848b7d688064c5f3.webp","country":"indonesian-indonesia"},"1933b00e117fa26a2c75227ddb94ade3":{"name":"Zelda Mayasari","avatar":"1933b00e117fa26a2c75227ddb94ade3.webp","country":"indonesian-indonesia"},"b0a81c359383a5b256234dc5365d3d71":{"name":"Evandro Grego","avatar":"b0a81c359383a5b256234dc5365d3d71.webp","country":"brazil"},"362c9ec175135e71e53bf82d2d329048":{"name":"Ignacio Lara","avatar":"362c9ec175135e71e53bf82d2d329048.webp","country":"brazil"},"1ee80f9c9f0cc2e1e23dac45e1bd7866":{"name":"\\u039c\\u03b7\\u03bd\\u03ac\\u03c2 \\u03a0\\u03b1\\u03bd\\u03c4\\u03b1\\u03b6\\u03ae\\u03c2","avatar":"1ee80f9c9f0cc2e1e23dac45e1bd7866.webp","country":"brazil"},"0a00e87eaf30969d807a7893ba25a9b8":{"name":"\\u4e2d\\u5cf6 \\u6dbc\\u5e73","avatar":"0a00e87eaf30969d807a7893ba25a9b8.webp","country":"brazil"},"cba00239fe52e6a2709bd90352b5e765":{"name":"Bruce Venter","avatar":"cba00239fe52e6a2709bd90352b5e765.webp","country":"brazil"},"07e1bb36b77111631bf53efe484eb66b":{"name":"H\\u00e1leygur Val \\u00dei\\u00f0randisd\\u00f3ttir","avatar":"07e1bb36b77111631bf53efe484eb66b.webp","country":"brazil"},"414ef33e84136d1a04eb49ed9a35059a":{"name":"\\u0627\\u0644\\u062f\\u0643\\u062a\\u0648\\u0631 \\u064a\\u0639\\u0642\\u0648\\u0628 \\u0627\\u0644\\u0645\\u0628\\u064a\\u0636\\u064a\\u0646","avatar":"414ef33e84136d1a04eb49ed9a35059a.webp","country":"brazil"},"6c93bfc1cb3882b8aa0e073c40d446a6":{"name":"\\u0421\\u0442\\u0430\\u043c\\u0435\\u043d\\u043a\\u043e \\u040b\\u043e\\u0440\\u0438\\u045b","avatar":"6c93bfc1cb3882b8aa0e073c40d446a6.webp","country":"brazil"},"235ee0dcb2da48259e69ef8f1757638a":{"name":"Dr. Angel Coronado Hijo","avatar":"235ee0dcb2da48259e69ef8f1757638a.webp","country":"brazil"},"f5eaadec50b0e6639b2f7ffdf33ff90c":{"name":"\\u9b91\\u4fe1\\u5b9c","avatar":"f5eaadec50b0e6639b2f7ffdf33ff90c.webp","country":"brazil"},"6cd8df74cc12ca818852f2cb4b4bfa0d":{"name":"\\u0645\\u064a\\u0644\\u0627\\u062f \\u0627\\u0644\\u0633\\u062d\\u064a\\u0645\\u0627\\u062a","avatar":"6cd8df74cc12ca818852f2cb4b4bfa0d.webp","country":"arabic-jordan"},"876b9bba8474e56729e000dffc525f3e":{"name":"\\u0639\\u0632\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0627\\u062c\\u062f\\u0629","avatar":"876b9bba8474e56729e000dffc525f3e.webp","country":"arabic-jordan"},"6817da8449e1e632d5db178d15681b3c":{"name":"\\u0639\\u0628\\u062f\\u0627\\u0644\\u0628\\u0627\\u0633\\u0637 \\u0627\\u0644\\u0635\\u0645\\u0627\\u062f\\u064a","avatar":"6817da8449e1e632d5db178d15681b3c.webp","country":"arabic-jordan"},"c1be4c2ece86e3ac9d803412d12ae022":{"name":"\\u0627\\u0644\\u062f\\u0643\\u062a\\u0648\\u0631 \\u062c\\u0627\\u0633\\u0631 \\u0627\\u0644\\u0631\\u064a\\u0645\\u0627\\u0648\\u064a","avatar":"c1be4c2ece86e3ac9d803412d12ae022.webp","country":"arabic-jordan"},"4b9073e598bc7affba3f632f07213f69":{"name":"\\u0645\\u062c\\u0627\\u0647\\u062f \\u0627\\u0644\\u0633\\u0639\\u062f","avatar":"4b9073e598bc7affba3f632f07213f69.webp","country":"arabic-jordan"},"096efe485ab46fa668b24f098484808f":{"name":"\\u0631\\u0645\\u0627\\u062d \\u0639\\u062c\\u0644\\u0648\\u0646","avatar":"096efe485ab46fa668b24f098484808f.webp","country":"arabic-jordan"},"8d9ba4a110ebf4dfe7f7229bc1793b1b":{"name":"\\u0639\\u0628\\u062f\\u0627\\u0644\\u0648\\u0647\\u0627\\u0628 \\u0627\\u0644\\u062d\\u0648\\u0631\\u0627\\u0646\\u064a","avatar":"8d9ba4a110ebf4dfe7f7229bc1793b1b.webp","country":"arabic-jordan"},"7f25fe51ecda99f2b47087ec2a31612a":{"name":"\\u0637\\u0647 \\u0627\\u0644\\u0641\\u0627\\u062e\\u0648\\u0631\\u064a","avatar":"7f25fe51ecda99f2b47087ec2a31612a.webp","country":"arabic-jordan"},"99e83a1210b8b11a0080f2ef884e02bd":{"name":"\\u0645\\u0644\\u0647\\u0645 \\u0639\\u0646\\u0627\\u0633\\u0648\\u0629","avatar":"99e83a1210b8b11a0080f2ef884e02bd.webp","country":"arabic-jordan"},"c64371e892be82288d7333d086e7ed4a":{"name":"\\u0627\\u0644\\u0623\\u0633\\u062a\\u0627\\u0630 \\u0631\\u064a\\u0645\\u0648\\u0646 \\u0627\\u0644\\u0645\\u0633\\u0627\\u0639\\u064a\\u062f","avatar":"c64371e892be82288d7333d086e7ed4a.webp","country":"arabic-jordan"},"b4a917003d30616845e7c70131752998":{"name":"Raynor Samson","avatar":"b4a917003d30616845e7c70131752998.webp","country":null},"cb6eb7197db9f5add44f169cca01d345":{"name":"Ratke Bertram","avatar":"cb6eb7197db9f5add44f169cca01d345.webp","country":null},"010c0312fb81a9de6356086306e94538":{"name":"Kris Eloy","avatar":"010c0312fb81a9de6356086306e94538.webp","country":null},"6c54c9b29a9ba0a3ebe85848441ef9cf":{"name":"Hane Afton","avatar":"6c54c9b29a9ba0a3ebe85848441ef9cf.webp","country":null},"32f038cc5bd227551463fb594678e9fe":{"name":"Cassin Melvina","avatar":"32f038cc5bd227551463fb594678e9fe.webp","country":null},"876f58f1d7952ad7b4a8aa68f50a9bd8":{"name":"Jacobi Vladimir","avatar":"876f58f1d7952ad7b4a8aa68f50a9bd8.webp","country":null},"8534458306c11d0897bc38f448f31dd8":{"name":"Cummings Haley","avatar":"8534458306c11d0897bc38f448f31dd8.webp","country":null},"6b78b2f3fd1a0edfddc24d94fd3b43dc":{"name":"McLaughlin Lucas","avatar":"6b78b2f3fd1a0edfddc24d94fd3b43dc.webp","country":null},"e4397ccd7cb4d9e3a5f8cae7b55a781f":{"name":"Auer Murl","avatar":"e4397ccd7cb4d9e3a5f8cae7b55a781f.webp","country":null},"fc8a954d71f4c8a4414617928335e1e6":{"name":"Powlowski Elliot","avatar":"fc8a954d71f4c8a4414617928335e1e6.webp","country":null}},"fake_purchases":"{\\"enabled\\":\\"0\\",\\"pages\\":\\"product,home,products,checkout\\",\\"interval\\":\\"10,60\\"}","prepaid_credits":"{\\"enabled\\":\\"1\\",\\"expires_in\\":null}","js_css_code":"{\\"frontend\\":null,\\"backend\\":null}","permalink_url_identifer":"p","invoice":"{\\"template\\":\\"1\\",\\"tos\\":\\"Lorem ipsum dolor sit amet consectetur, adipisicing elit. Deleniti eaque omnis quod, rerum magnam, corrupti, modi veritatis necessitatibus commodi, minus sunt? Error porro velit qui, commodi expedita, consectetur? Illum, ex.\\"}","fullwide":"0","enable_upload_links":"0","enable_blade_cache":"1","enable_data_cache":"0","categories_on_homepage":"1","fake_counters":"0","color_cursor":"0","authorized_bots":null,"user_views_per_minute":"60","axies_top_cover":null,"force_download":"1","allow_download_in_test_mode":"1","available_via_subscriptions_only_message":"This item is available via subscriptions only","authentication_required_to_download_free_items":"0","generate_download_links_for_missing_files":"1","show_add_to_cart_button_on_the_product_card":"1","show_badges_on_the_product_card":"1","product_card_cover_mask":null,"tiktok":"#","report_errors":"1","email_verification_required":"0","default_lang":"en","facebook_pixel":null,"two_factor_authentication":"0","two_factor_authentication_expiry":"0","force_simple_pagination":"1","user_coupons_page":"0"}', '{"mail":{"username":"codemayer@gmail.com","password":"wqccvnasiswrlhgy","host":"smtp.gmail.com","port":"465","encryption":"tls","reply_to":null,"forward_to":"","use_queue":"0","from":{"name":"Valexa","address":"codemayer@gmail.com"}}}', '{"gateways":{"payhere":{"name":"payhere","enabled":"on","icon":"\\/assets\\/images\\/payment\\/payhere_icon.png","description":"Visa, MasterCard, American Express, Discover, Diners Club, Genie, Frimi, eZcash, mCash, Sampath Vishwa","order":"1","mode":"sandbox","merchant_secret":"NDIxNjg0NDY1MzE1NjM1NTMwODM3NjY5MDAzNTQyMDMyMTI4MTEz","merchant_id":"1228434","fee":"3","minimum":"15","auto_exchange_to":null},"paypal":{"name":"paypal","enabled":"on","icon":"\\/assets\\/images\\/payment\\/paypal_icon.png","description":"PayPal balance, Bank account, PayPal Credit, Debit\\/Credit cards, Rewards balance","order":"2","mode":"sandbox","client_id":"ASdYuRsTZ-S5UuB9yDgmAHu-uJOWkqAwuV0gpT1KEIig9cmgSRz0xJUAVykpdI-j7ILR6bUgqxwFCGPk","secret_id":"EAaiUmR0iRDq1olF5KZQdTkXdKVn6Bn2t3-tLJcDwd8wIiufri_aqLxfj2PorJLTAnHUQ2Ld6VupKzUN","fee":"3","minimum":null,"auto_exchange_to":null},"offlinepayment":{"name":"offlinepayment","enabled":"on","icon":"\\/assets\\/images\\/payment\\/offlinepayment_icon.png","description":"Bank transfer, Cash, Check, ACH credit transfer, SEPA credit transfer","order":"3","instructions":"<p><strong>Bank code :<\\/strong> 654987 Account Number: 7654852321<\\/p>\\r\\n<p><strong>IBAN :<\\/strong> 97752784819916461767I4<\\/p>\\r\\n<p>Please add your order number to your payment description.<\\/p>","fee":"5","minimum":"79","auto_exchange_to":null},"credits":{"name":"credits","enabled":"on","icon":"\\/assets\\/images\\/payment\\/credits_icon.png","description":"Pay with your available credits.","order":"4","fee":"0","minimum":null,"auto_exchange_to":null},"razorpay":{"name":"razorpay","enabled":"on","icon":"\\/assets\\/images\\/payment\\/razorpay_icon.png","description":"Debit or Credit Card, Netbanking, Bank Transfer, EMI, UPI","order":"5","client_id":"rzp_test_YcD8vXJrPt3pxA","secret_id":"3Ea5BOGUgCEpSBkuSh1OKvf2","webhook_secret":"CX1f%&V7>2t(q0yW","fee":"2","minimum":"12","auto_exchange_to":null},"paymongo":{"name":"paymongo","enabled":"on","icon":"\\/assets\\/images\\/payment\\/paymongo_icon.png","description":"Visa \\/ Mastercard, GCash, GrabPay, Maya, BPI, UBP, ...","order":"7","mode":"sandbox","public_key":"pk_test_iXKqafemX5YcGR5taAHBv7tT","secret_key":"sk_test_v4mvpgoz1qS1n9PCSBbnQzkw","method":"card","fee":"3","minimum":null,"auto_exchange_to":null},"mollie":{"name":"mollie","enabled":"on","icon":"\\/assets\\/images\\/payment\\/mollie_icon.png","description":"PayPal, SEPA, iDEAL, VISA, Klarna, MasterCard, Przelewy24, EPS, Sepa Direct Debit, Maestro ...","order":"8","mode":"sandbox","api_key":"test_fNK8e6VURh9sqmuEGfS6vEzbzbF6st","profile_id":"pfl_yRhaN65CXs","method":"creditcard,directdebit","fee":"3","minimum":null,"auto_exchange_to":null},"skrill":{"name":"skrill","enabled":"on","icon":"\\/assets\\/images\\/payment\\/skrill_icon.png","description":"iDEAL, Maestro, Neteller, Skrill Digital Wallet, Credit or Debit Card","order":"9","mode":"sandbox","merchant_account":"demoqco@sun-fish.com","mqiapi_secret_word":"skrill","mqiapi_password":"skrill123","methods":"ACC","fee":"5","minimum":null,"auto_exchange_to":null},"youcanpay":{"name":"youcanpay","enabled":"on","icon":"\\/assets\\/images\\/payment\\/youcanpay_icon.ico","description":"Debit or Credit Cards","order":"10","mode":"sandbox","public_key":"pub_sandbox_d40016fd-8503-40eb-961e-1d332","private_key":"pri_sandbox_159eb0f6-71c1-44b2-a14a-2ffab","fee":"4","minimum":null,"auto_exchange_to":"MAD"},"tazapay":{"name":"tazapay","icon":"\\/assets\\/images\\/payment\\/tazapay_icon.JPG","description":"PayPal, SEPA, iDEAL, VISA, Klarna, MasterCard, Przelewy24, EPS, Sepa Direct Debit, Maestro ...","order":"11","mode":"sandbox","public_key":null,"api_key":null,"secret_key":null,"method":null,"fee":null,"minimum":null,"auto_exchange_to":null},"sslcommerz":{"name":"sslcommerz","enabled":"on","icon":"\\/assets\\/images\\/payment\\/sslcommerz_icon.png","description":"Credit \\/ Debit Cards, Mobile Banking, Internet Banking, E-Wallets, Easy Monthly Installments","order":"12","mode":"sandbox","store_id":"codem613bb607ea725","store_passwd":"codem613bb607ea725@ssl","use_ipn":"1","fee":"5","minimum":null,"auto_exchange_to":null},"stripe":{"name":"stripe","enabled":"on","icon":"\\/assets\\/images\\/payment\\/stripe_icon.png","description":"Card, Ideal, Giropay, FPX, EPS, Alipay, P24, Bancontact","order":"13","mode":"sandbox","client_id":"pk_test_AXJnsLZeYQLe5L2qzA8FI94o00HCMh14t5","secret_id":"sk_test_WlDtXCea4H8cKRFk7bgzW3xq00hcfmF73r","methods":"card","fee":"5","minimum":"10","auto_exchange_to":null},"paystack":{"name":"paystack","enabled":"on","icon":"\\/assets\\/images\\/payment\\/paystack_icon.png","description":"Cards, Mobile money, QR codes, Bank transfer, USSD","order":"14","public_key":"pk_test_762f08f728fbd0191221a7b1a06ac10b6017be24","secret_key":"sk_test_f525daf950659e2c2cac6dfec9b3bf1fdc4b76b9","channels":"ussd,bank,card,bank_transfer,qr,mobile_money","fee":"15","minimum":"5","auto_exchange_to":"NGN"},"paymentwall":{"name":"paymentwall","enabled":"on","icon":"\\/assets\\/images\\/payment\\/paymentwall_icon.png","description":"Visa, MasterCard, American Express, Discover, Diners Club, Genie, Frimi, eZcash, mCash, Sampath Vishwa","order":"15","mode":"sandbox","project_key":"7cecc2cd0afbf06ab02bd80c2c02a04f","secret_key":"2b248184d50275c8a029195ebdeecc3f","fee":"3","minimum":"18","auto_exchange_to":null},"omise":{"name":"omise","enabled":"on","icon":"\\/assets\\/images\\/payment\\/omise_icon.png","description":"Credit\\/Debit card, Installment payments, Internet Banking, PromptPay, TrueMoney Wallet, Rabbit Line Pay, PayNow, OCBC Pay Anyone, Alipay, WeChat Pay, Bill payment, Pay-easy, FPX","order":"16","mode":"sandbox","public_key":"pkey_test_5tkhbr0shz1czgwojdz","secret_key":"skey_test_5tkhc9f3puagru3ql1s","fee":"5","minimum":"55","auto_exchange_to":null},"midtrans":{"name":"midtrans","enabled":"on","icon":"\\/assets\\/images\\/payment\\/midtrans_icon.png","description":"Credit \\/ Debit card, Danamon online, CIMB clicks, BCA klikpay, Mandiri, Alfamart, Permata va ...","order":"17","mode":"sandbox","client_key":"SB-Mid-client-00bey5wDW4gegw2v","server_key":"SB-Mid-server-Of11wIF_KhZ0db20jSIF2iqI","merchant_id":"G397932390","methods":"credit_card,danamon_online,bca_klikpay,mandiri_clickpay,bri_epay,bca_klikbca","fee":"5","minimum":"10","auto_exchange_to":null},"iyzico":{"name":"iyzico","enabled":"on","icon":"\\/assets\\/images\\/payment\\/iyzico_icon.png","description":"MasterCard, MasterCard Debit, American Express, Visa Electron, Visa Debit ...","order":"18","mode":"sandbox","client_id":"sandbox-Z4STxfm3iwuGpAcxlChyEYg2xUKCgzkE","secret_id":"sandbox-zN3RR9gg2kVg2KbmD9ixhOz67EtWBKy3","fee":"5","minimum":null,"auto_exchange_to":null},"instamojo":{"name":"instamojo","enabled":"on","icon":"\\/assets\\/images\\/payment\\/instamojo_icon.png","description":"Bank transfer, Debit\\/ Credit Cards, Netbanking, Wallets, UPI, EMI","order":"19","mode":"sandbox","private_salt":"8f1c7b5c2ddd4930a55866fb48a4359a","client_id":"test_w2olHRJKuXK0T6iwis5TFKY8REO8tEcLhpi","secret_id":"test_OMMWYdTJlxNdYBw9eEcwnYSMuUkfMWD06TG2zTLF6RCYhd0w4dFccRQi4v2CbNaQCEDviUvSYpzfhb1nwxoEt9gfwIpbie618HN28miQzFInBcr5HrtanPnpyu3","fee":"5","minimum":"60","auto_exchange_to":"INR"},"flutterwave":{"name":"flutterwave","enabled":"on","icon":"\\/assets\\/images\\/payment\\/flutterwave_icon.png","description":"Credit\\/Debit card, Bank transfer, Mobile money, M-Pesa, QR payment, USSD, Barter","order":"20","mode":"sandbox","public_key":"FLWPUBK_TEST-935855b5bd668dbda1b04eb09fb70b6b-X","secret_key":"FLWSECK_TEST-7f19b573e405f594a56d0a6510d00881-X","encryption_key":"FLWSECK_TEST859ffbb2b244","secret_hash":"codemayer_test_hash","methods":"banktransfer,mpesa,mobilemoneyrwanda,card,ussd,credit,account,barter,qr,mobilemoneyuganda","fee":"2","minimum":"55","auto_exchange_to":null},"coingate":{"name":"coingate","enabled":"on","icon":"\\/assets\\/images\\/payment\\/coingate_icon.png","description":"BTC, ETH, USDT, LTC","order":"21","mode":"sandbox","auth_token":"3JaWv7vyvY9EBkTL7bKBtyP6-c1uEQTahuE3gNg2","receive_currency":"USD","fee":"2","minimum":"30","auto_exchange_to":null},"authorizenet":{"name":"authorizenet","enabled":"on","icon":"\\/assets\\/images\\/payment\\/authorizenet_icon.png","description":"Debit cards, Credit cards, Apple Pay, PayPal ...","order":"22","mode":"sandbox","api_login_id":"8a9zESU6T","client_key":"6FePq5r35rJ67V9zwK593vTbeTY88JmCQBg93E5aDmFa72XFjNeK4NfkQjcgjagH","transaction_key":"2E5qz6x428LQA683","signature_key":"4C2B52AAC7F4327AF5D9BCB092599EB391471568C2B64AE825C81FBB26FF316D121D4D5715B1919C8F331D61428C797D9E132917AFDD41A430C740197DB5081F","fee":"5","minimum":null,"auto_exchange_to":null},"adyen":{"name":"adyen","enabled":"on","icon":"\\/assets\\/images\\/payment\\/adyen_icon.png","description":"Klarna, iDEAL, Oney, Amazon Pay, Alipay, Visa, American Express (AMEX), Cartes Bancaires, Diners, ...","order":"23","mode":"sandbox","api_key":"AQEuhmfxKYvHbRVAw0m\\/n3Q5qf3Va4RJCJ5LQWBEniv5IP9E\\/Y+W5tcf2p7vi12KzhDBXVsNvuR83LVYjEgiTGAH-YxSTZToyzLv50LqS38rAhNePdvFORy52RXZbqHYXRsM=-V,39@I$y<Z{{gbtN","client_key":"test_OJFPB6WNCJF2BMA76S7V4PIVMUGYZVE4","merchant_account":"Codemayer832ECOM","hmac_key":"1D0F437B4DCECC845418004F492E41C5E06906D867ABEF41BC30D79EB0ECEA72","fee":"5","minimum":"10","auto_exchange_to":null}},"tos":"1","tos_url":"\\/page\\/terms-and-conditions","vat":"20","buyer_note":"1","currency_code":"USD","currency_symbol":"$","currency_position":"left","exchange_rate":1,"currencies":"eur,usd,inr,idr,gbp,btc,ltc,try,ngn,mad,USD","allow_foreign_currencies":"1","exchanger":"pro_api_coinmarketcap_com","currencyscoop_api_key":null,"exchangeratesapi_io_key":null,"coinmarketcap_api_key":"63a2ac91-9f20-44c6-809b-bd22547e6a2f","guest_checkout":"1","pay_what_you_want":{"enabled":"1","for":"products"},"currency_by_country":"0","enable_add_to_cart":"1","show_prices_in_k_format":"0","delete_pending_orders":"500","exchangers":{"pro_api_coinmarketcap_com":{"api_key":"63a2ac91-9f20-44c6-809b-bd22547e6a2f"},"api_exchangeratesapi_io":{"api_key":null},"api_currencyscoop_com":{"api_key":null},"api_exchangerate_host":{"api_key":null},"api_coingate_com":{"api_key":null}},"enable_webhooks":"0","update_pending_transactions":"0"}', '{"google":null,"bing":null,"yandex":null,"google_analytics":null,"robots":"follow, index","main_locale":"en","json_ld":"1","site_verification":null,"analytics_code":null,"indexnow_key":null}', '{"responsive_ad":null,"auto_ad":null,"ad_728x90":null,"ad_468x60":null,"ad_300x250":null,"ad_320x100":null,"popup_ad":null}', '{"google_drive":{"enabled":"on","folder_id":null,"api_key":"AIzaSyB7UAC_LXTNvtyhxOSwoTsKq94cuoeX_qg","client_id":"734923401117-dfb7mo82qv89csqq6n0lsd6kdbglbh2v.apps.googleusercontent.com","secret_id":"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","chunk_size":"4","refresh_token":"1\\/\\/03z0SQ_KqoUDxCgYIARAAGAMSNwF-L9Ir5qhB9GkOrKeiJ2vq0dOeGirPOajE01Fjk3FihVrLHpzfqHnKkKCOFETWw_RLpsRyQ60","connected_email":"foxtinez@gmail.com","id_token":"eyJhbGciOiJSUzI1NiIsImtpZCI6IjE4MzkyM2M4Y2ZlYzEwZjkyY2IwMTNkMDZlMWU3Y2RkNzg3NGFlYTUiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJhenAiOiI3MzQ5MjM0MDExMTctZGZiN21vODJxdjg5Y3NxcTZuMGxzZDZrZGJnbGJoMnYuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJhdWQiOiI3MzQ5MjM0MDExMTctZGZiN21vODJxdjg5Y3NxcTZuMGxzZDZrZGJnbGJoMnYuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJzdWIiOiIxMTM1NDE2NjA0NTI1NDQ3OTQzMTQiLCJlbWFpbCI6ImZveHRpbmV6QGdtYWlsLmNvbSIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJhdF9oYXNoIjoiSXVPTjlpOHlvUmVWVFZKdXhhNWlZUSIsImlhdCI6MTY3MDEwOTk3NCwiZXhwIjoxNjcwMTEzNTc0fQ.gwONEufoP-YDHdFH0s6PhggCGRcx65301sh4PTpDGtFmA4rGUqL1jYMaxvT7ayowXiDwKK2A_l-ljbKXzLfj8jzJ0k9Z6lxJ0YTuPX7VgWiYK0VD5L7GabHAuDjImyaTYXBLaHrJXoOduuZkCo4VX-UI3huMtML2L-cADcxPvhf0duF4qvQufUDAiTl8MEkloQaps9lymJ1zU7u_6jfUCbG-YBBqTx5KUi0_kFbhPEKNs32yVGbKHtejcJTTtdaHI2lQj3qrvsMtIdU6gyE6cEVs2R0rmcLDe2B3dmwjWWOkkxI1XfKeBsawLqQL0Q41PiyhX5UL19v8aPnnHkoYlA"},"google_cloud_storage":{"enabled":"on","project_id":"optical-empire-373721","private_key_id":"c31139dc426cb36ff83e120d045ff3f28df20ff7","private_key":"-----BEGIN PRIVATE KEY-----\\r\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCqzWJY6Qjuxvpp\\r\\n\\/pkaF3FfF0jcMfyzFr+2X9W3w8yQOeHbx\\/NDm8BmsVAnK1KuSgKwheLYmz7Dmb\\/H\\r\\nDNiLBKQthTaOq5YTKrF65Oty5cdOYVo+wTg+udnGES4Gd2ZQ4oUFuXY39ZC1FeGb\\r\\nfg1Wf\\/96kog64OU1r+8UiWq73DkxsQAoTgV8yZOEAKtZE6KkSuVtJ6KgaqZ8d9Zu\\r\\n3Z8HUIohL2b2LB00y310U6fUg3khmxiqYU51NAbi5cDw39CwddcZOU\\/jpCeUgY2B\\r\\nwGIeow8jwmn8lF\\/FEVE7DKkVd+LzlLwq80WaQGkYYPXzj5difYUU1TK9CUFqv3E+\\r\\nra7\\/\\/f2FAgMBAAECggEADCUWfSP00qWrYKYN1OEd2pkZQS78vO89Koad97cgcJDt\\r\\nEmehUIleoO6yuFZIRsRUdKDQhH5ldBsWm9y5+QiXc\\/Uo7\\/Qbc7lxbT+hzkWwak5Z\\r\\n0GSEz1D\\/vymxkBwlVlMFCmcplMkNRRMNO7U21ZO8YsbQkP80zSB5a4hp4nnCR1ok\\r\\nsJtFNEXiQZHTmnZARDSOOZLPImZKrhEDwnPowPgkz11Le18pd6PsI8SdEhJred\\/N\\r\\nAqC50dM4Pk1WBuQ3jMpmzHETSzFTstX3XtO7CmPDNtNSrs+vDmdCGlGKQy3BhRMW\\r\\nkspWm2o\\/2yef2s12qq275Ad8zSzYw4h3G6w+LeVtAQKBgQDpw46ayFLhq1R\\/+5iC\\r\\npJHo77tKI3N4dtLsyehHCaVnVt3snVgLAaWjpQfBLTsLWh5rJSbXN3ZXL085kGJC\\r\\nlnY7tjg0\\/s6yZEbQglTl4byAbIdRZwjtK4zGwLPGb3bnT3fEw36k54KCL2mhIck9\\r\\nAvWPWc2e\\/Z\\/bz4bcgx\\/LGHM7UQKBgQC7DKIXcpdMIrihWdz68n4ueWk6+euxoMyV\\r\\n86T2KD\\/NxugQnT4pHmpsLN2LUBK6A4Q12NrabLVxNgc9F2mk5kB0HcrX25IOx4pi\\r\\nM1QXCjSynICr6gP70vaPOcM1c66KibXtMVlNigraFns7MitalckVDpDe3PyEkbRe\\r\\n410Bc8Jp9QKBgQC6ZT1zfCJiYTwKpPJR0amqxGVh02zCdHTxbHmzEyT5hpGEl13Z\\r\\nwOFz4CaTyV4YSi6RHtmeqFHLaSTR8Kf5EoKKUFz3HOpx4nV400Og3eNxv5gSt4at\\r\\nnpks7gErTDvSa1JD6eI02Yj+B5JBcnBFHvPw7xl\\/Ghr6qbqOYFvclM1lUQKBgQCL\\r\\ncWKRalsCZkwP9Wc5KXgJ+3cIgXJFLKP4EffjjqPqKyOr5x2FF+isllHe3qXnSGHS\\r\\npsSY2zv0lxuUXpTiWsioB+HFRCpBnF480RkaSAB7OxLtlnq7zE0E\\/0HY4lG3c+xN\\r\\nVGHH3WYzqVjbC46obEvIx+AWVNZnmhvGNWeLgpnn1QKBgH80gD8UhWc3C\\/Ntqk8q\\r\\n324TmZa96FP2m5RqQx4EqrrapmT7QonIf1YeXCsG3kUzt2va8paPGgEMbIVsiDfy\\r\\nDOBKsUHur30DQdVG6oW1whjITkMyxWjXxSpsaUI8dDkPke\\/45YpZxCi0jj0aMqpu\\r\\npSaWQPLrbeR8Xg0ieLrYYC5t\\r\\n-----END PRIVATE KEY-----","client_email":"codemayer-g-cloud-storage@optical-empire-373721.iam.gserviceaccount.com","client_id":"109109952105179918115","auth_provider_x509_cert_url":"https:\\/\\/www.googleapis.com\\/oauth2\\/v1\\/certs","client_x509_cert_url":"https:\\/\\/www.googleapis.com\\/robot\\/v1\\/metadata\\/x509\\/codemayer-g-cloud-storage%40optical-empire-373721.iam.gserviceaccount.com","bucket":"codemayer_bucket"},"dropbox":{"enabled":"on","folder_path":null,"app_key":"o9jmkxhczo0mbrf","app_secret":"8t59sbe5jixni49","access_token":"eRNkeuN80CAAAAAAAAAAqrc600QFVfltBPt7MAdnYUdvpsZxeJnZ6CKkegRhkgkD","current_account":"parrazolle@gmail.com"},"yandex":{"enabled":"on","folder_path":null,"client_id":"33a2e872da8041c1a41dbf3e7f65eed1","secret_id":"edf397ee57af4d23bbecb5dd1ac5be71","refresh_token":"1:IaM2NZAwgqabeqrQ:4mmLDuLDSA5d3duoT7C4Z87ag1vhMuPWrZE428MczhbKH30VagPaRlpOsi7aw-InmD9ti1NiaGbmzw:cL7yAYojziRncCAZ66SDtg"},"amazon_s3":{"enabled":"on","access_key_id":"AKIAJYNE22P7DA4QB2RQ","secret_key":"7tYF4z5SHE5kP0v5j53fOj2TbyvjyNdEw5\\/zykAg","bucket":"codemayer-b1","region":"us-west-2","version":"latest"},"wasabi":{"enabled":"on","access_key":"1IOKPKRE7BIBOPCCDGYA","secret_key":"OiNtQAvEchJJeltyqS1H6q3bQwHybe2nCmzbIO54","bucket":"pbrlibrary","region":"eu-central-1","version":"latest"},"working_with":"files","remote_files":{"headers":null,"body":null}}', '{"google":{"enabled":"on","client_id":"30268572239-su1lc674seogegglqvjvnqepbhiejl1a.apps.googleusercontent.com","secret_id":"_qmTgTogRuVopoxWQTVztESb","redirect":"https:\\/\\/tendra.co\\/login\\/google\\/callback"},"github":{"client_id":"30128f98a4b99dbe1cd6","secret_id":null,"redirect":"https:\\/\\/tendra.co\\/login\\/github\\/callback"},"linkedin":{"client_id":"865vva3d5se729","secret_id":null,"redirect":"https:\\/\\/tendra.co\\/login\\/linkedin\\/callback"},"facebook":{"enabled":"on","client_id":"402929701510943","secret_id":"c435d23809a24c2b366cc7845056738a","redirect":"https:\\/\\/tendra.co\\/login\\/facebook\\/callback"},"vkontakte":{"enabled":"on","client_id":"51536037","secret_id":"DKAROeQ6xRP44GRj7Ms0","redirect":"https:\\/\\/tendra.co\\/login\\/vkontakte\\/callback"},"twitter":{"enabled":"on","client_id":"BN63vI2uYoDOSAu2nFdKMNDL3","secret_id":"iV5h3slEOtPf5WMavIpjTQmPR0A5flc3e7fQi0pWmAVFiejcy6","redirect":"https:\\/\\/tendra.co\\/login\\/twitter\\/callback"},"dribbble":{"enabled":"on","client_id":"a14074b532aa2259d518adaecbb5bb87d4b2dbd91721cdc815dd4c4067f6b6b6","secret_id":"c57943f0a2874867c0e9dcfa8b67b7cb84ef54a6f2eea65861897d82939386de","redirect":"https:\\/\\/tendra.co\\/login\\/dribbble\\/callback"},"tiktok":{"enabled":"on","client_id":"awadf6jmztsmalt2","secret_id":"c9c0b64fdd806f2008d2c17089ce2016","redirect":"https:\\/\\/tendra.co\\/login\\/tiktok\\/callback"},"reddit":{"enabled":"on","client_id":"pIQvyZ621ZGG4WvNxyRsLw","secret_id":"ChTOXN468bRXLuYrO68Q-iuqW-r4-Q","redirect":"https:\\/\\/tendra.co\\/login\\/reddit\\/callback"}}', '{"code":null}', '{"enable_on":"register,contact,login","google":{"secret":"6Ldi8qwaAAAAAP2Br_oYOtIt9z7trkORbbUFjn72","sitekey":"6Ldi8qwaAAAAAJOury0P02CyGp3pvVsnLDGM6-TM","attributes":{"data-theme":"light","data-size":"normal"},"options":{"timeout":"30"}},"mewebstudio":{"length":"4","math":false,"width":"150","height":"40","quality":"90"}}', '{"host":"127.0.0.1","database":"tendra","username":"root","password":"13982679","charset":"utf8","collation":"utf8_unicode_ci","port":"3306","sort_buffer_size":"5","sql_mode":"STRICT_TRANS_TABLES","timezone":"+00:00"}', '{"enabled":"1","commission":"10","expire":"30","cashout_methods":"paypal_account,bank_account","minimum_cashout":{"paypal":"10","bank_transfer":"50"},"cashout_description":"<p>All earnings will be transferred to your account based on the selected method, whether via PayPal or Bank transfer.<\\/p><ul><li>The minimum amount to&nbsp;<span style=\\"font-size: 1.14286rem;\\">cash out via<\\/span><span style=\\"font-size: 1.14286rem;\\">&nbsp;PayPal&nbsp; : USD 50.00<\\/span><\\/li><li>The minimum amount to&nbsp;<span style=\\"font-size: 1.14286rem;\\">cash out via<\\/span><span style=\\"font-size: 1.14286rem;\\">&nbsp;bank transfer : USD 240.00<\\/span><\\/li><\\/ul><p><span style=\\"font-size: 1.14286rem;\\">Earnings are paid automatically be the end of each month, as long as, your balance has the minimum amount.<\\/span><\\/p><p><span style=\\"font-size: 1.14286rem;\\">Your earnings, in case of an&nbsp;<\\/span><span style=\\"font-size: 16px;\\">insufficiency, will be reported to the next month.<\\/span><\\/p>"}', '{"enabled":"0","exception":"127.0.0.1","expires_at":"2023-03-02T19:53","auto_disable":"1","title":"Under maintenance","header":"Our website is under maintenance","subheader":"We are adding more features, stay tuned","text":"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.","bg_color":"#4d24bc"}', '2020-01-17 16:06:00', '2025-03-11 18:18:15', NULL);

COMMIT;