@extends('admin.master')

@section('title', __('Edit - :name pack', ['name' => $prepaid_credits->name]))

@section('additional_head_tags')

@if(config('app.html_editor') == 'summernote')
<link href="{{ asset_('assets/admin/summernote-lite-0.8.12.css') }}" rel="stylesheet">
<script src="{{ asset_('assets/admin/summernote-lite-0.8.12.js') }}"></script>
@else
<script src="{{ asset_('assets/tinymce_5.9.2/js/jquery.tinymce.min.js') }}"></script>
<script src="{{ asset_('assets/tinymce_5.9.2/js/tinymce.min.js') }}"></script>
@endif

@endsection


@section('content')
<form class="ui large form p-1" method="post" action="{{ route('prepaid_credits.update', ['id' => $prepaid_credits->id]) }}">
	@csrf

	<div class="field">
		<button class="ui icon labeled large circular button" type="submit">
		  <i class="save outline icon"></i>
		  {{ __('Save') }}
		</button>
		<a class="ui icon labeled large circular button" href="{{ route('prepaid_credits') }}">
			<i class="times icon"></i>
			{{ __('Cancel') }}
		</a>
	</div>
	
	@if($errors->any())
      @foreach ($errors->all() as $error)
         <div class="ui negative fluid small message">
         	<i class="times icon close"></i>
         	{{ $error }}
         </div>
      @endforeach
	@endif

	<div class="ui fluid divider"></div>

	<div class="one column grid" id="prepaid_credits">
		<div class="column">
			<div class="field">
				<label>{{ __('Name') }}</label>
				<input type="text" name="name" placeholder="..." value="{{ old('name', $prepaid_credits->name) }}" autofocus required>
			</div>
			<div class="field">
				<label>{{ __('Subheading') }}</label>
				<input type="text" name="subheading" placeholder="..." value="{{ old('subheading', $prepaid_credits->subheading) }}">
			</div>
			<div class="field">
				<label>{{ __('Amount') }}</label>
				<input type="number" name="amount" placeholder="..." value="{{ old('amount', $prepaid_credits->amount) }}" required>
			</div>
			<div class="field">
				<label>{{ __('Discount on products') }} <sup>({{ __('Percentage') }})</sup></label>
				<input type="number" name="discount" placeholder="..." value="{{ old('discount', $prepaid_credits->discount ?? 0) }}">
			</div>
			<div class="field">
				<label>{{ __('Popular') }}</label>
				<div class="ui selection floating dropdown">
					<input type="hidden" name="popular" value="{{ old('popular', $prepaid_credits->popular) }}">
					<div class="text">...</div>
					<div class="menu">
						<a class="item" data-value="">-</a>
						<a class="item" data-value="1">{{ __('Yes') }}</a>
						<a class="item" data-value="0">{{ __('No') }}</a>
					</div>
				</div>
			</div>
			<div class="field">
				<label>{{ __('Specifications') }}</label>
				<textarea name="specs" rows="10">{{ old('specs', $prepaid_credits->specs) }}</textarea>
			</div>
		</div>
	</div>
</form>
@endsection