<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fomantic-ui@2.9.2/dist/semantic.min.css">
  <link rel="stylesheet" href="/doc_assets/app.css">

  <script src="https://code.jquery.com/jquery-3.6.3.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/fomantic-ui@2.9.2/dist/semantic.min.js"></script>
  
  <script src="/doc_assets/app.js"></script>

  <title>@yield("title")</title>
</head>
<body>
  <div class="ui fluid container">
    <div class="topnav">
      <div class="ui secondary menu fluid">
        <a href="/" class="item header">vAlexa</a>

        <div class="right menu">
          <a href="https://valexa.codemayer.net" class="item">Homepage</a>
          <a href="https://codecanyon.net/checkout/from_item/25390404?license=regular&support=bundle_6month" class="item">Purchase</a>
          <a href="https://codecanyon.net/user/codemayer#contact" class="item">Support</a>
        </div>
      </div>
    </div>

    <div class="columns">
      <div class="column left">
        <div class="menu">
          <div class="item">
            <a href="/doc/" class="header">Getting started</a>
            <div class="items">
              <a href="/doc/#description" class="item">Description</a>
              <a href="/doc/#requirements" class="item">Requirements</a>
              <a href="/doc/#payment-gateways" class="item">Payment gateways</a>
              <a href="/doc/#file-storage-services" class="item">File storage services</a>
              <a href="/doc/#installation" class="item">Installation</a>
              <a href="/doc/#support" class="item">Support</a>
            </div>
          </div>

          <div class="item">
            <a href="/doc/configuration" class="header">Configuration</a>
            <div class="items">
              <a href="/doc/configuration#general-settings" class="item">General</a>
              <a href="/doc/configuration#mailer-settings" class="item">Mailer</a>
              <a href="/doc/configuration#payments-settings" class="item">Payments</a>
              <a href="/doc/configuration#file-storage-settings" class="item">File Storage</a>
              <a href="/doc/configuration#affiliate-settings" class="item">Affiliate</a>
              <a href="/doc/configuration#social-login-settings" class="item">Social login</a>
              <a href="/doc/configuration#search-engines-settings" class="item">Search engines</a>
              <a href="/doc/configuration#chat-service-settings" class="item">Chat service</a>
              <a href="/doc/configuration#translation-settings" class="item">Translation</a>
              <a href="/doc/configuration#database-settings" class="item">Database</a>
              <a href="/doc/configuration#cache-settings" class="item">Cache</a>
              <a href="/doc/configuration#maintenance-settings" class="item">Maintenance</a>
              <a href="/doc/configuration#bulk-upload-settings" class="item">Bulk upload</a>
            </div>
          </div>

          <div class="item">
            <a href="/doc/products" class="header">Products</a>
            <div class="items">
              <a href="/doc/products#create-edit" class="item">Create & Edit</a>
              <a href="/doc/products#fake-reviews" class="item">Fake reviews</a>
              <a href="/doc/products#fake-comments" class="item">Fake comments</a>
              <a href="/doc/products#permalink" class="item">Permalink</a>
              <a href="/doc/products#affiliate-link" class="item">Affiliate link</a>
              <a href="/doc/products#enable-license" class="item">Enable license</a>
              <a href="/doc/products#available-via-subscription-only" class="item">Available via subscription only</a>
              <a href="/doc/products#hidden-content" class="item">Hidden content</a>
              <a href="/doc/products#pricing-promo" class="item">Pricing & Promo</a>
              <a href="/doc/products#table-of-contents" class="item">Table of contents</a>
            </div>
          </div>

          <div class="item">
            <a href="/doc/pricing_table" class="header">Pricing table</a>
            <div class="items">
              <a href="/doc/pricing_table#create" class="item">Create & Edit</a>
              <a href="/doc/pricing_table#specifications" class="item">Specifications</a>
              <a href="/doc/pricing_table#duration" class="item">Duration</a>
              <a href="/doc/pricing_table#limit-downloads" class="item">Limit downloads</a>
              <a href="/doc/pricing_table#products" class="item">Products</a>
              <a href="/doc/pricing_table#category-of-products" class="item">Category of products</a>
              <a href="/doc/pricing_table#position" class="item">Position</a>
            </div>
          </div>

          <div class="item">
            <a href="/doc/prepaid_credits" class="header">Prepaid credits</a>
            <div class="items">
              <a href="/doc/prepaid_credits#description" class="item">Description</a>
              <a href="/doc/prepaid_credits#specifications" class="item">Specifications</a>
              <a href="/doc/prepaid_credits#duration" class="item">Duration</a>
            </div>
          </div>
        </div>
      </div>

      <div class="column right" id="body">
        @yield("page")
      </div>
    </div>
  </div>  
</body>
</html>