@extends("doc.master")

@section("page")
<div class="content" id="general">
  <div class="header">
    <div class="main">Configuration</div>
    <div class="sub">
      How to proceed with the website general settings, like the title, description, changing the logo, selecting templates, how to configure one or multiple payment gateways (PayPal, Stipe, ...), configuring Amazon S3 and other file storage services, setting up the mailer to send and receive email message ... etc.
    </div>
  </div>

  <div class="sections">
    <div class="section" id="general-settings">
      <div class="header"><a href="#general-settings">#</a>General</div>
      <div class="subheader">Admin > Settings > General</div>
      <div class="description">
        <p>In the general settings page you can configure the following points :</p>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i><span>General :</span> Website title, name, descriptions, number of items to show per page, timezone, keyswords, permalink, main website email address, caching website data</div>
          <div class="item"><i class="circle outline icon"></i><span>Blog :</span>Enabling the blog, description and title, Disqus comments</div>
          <div class="item"><i class="circle outline icon"></i><span>Subscriptions :</span>Enabling subscriptions, ...</div>
          <div class="item"><i class="circle outline icon"></i><span>Products :</span>Allow downloading files with test purchases, show add to cart button on the product card, show ratings, show sales, show video streaming player on the single product page, ... etc</div>
          <div class="item"><i class="circle outline icon"></i><span>Prepaid credits :</span>Enable prepaid credits or E-wallet system, specifying an expiration time for credits.</div>
          <div class="item"><i class="circle outline icon"></i><span>Users & Authentication :</span>Specifying the registration form fields and which ones are required, making the email verification required or not.</div>
          <div class="item"><i class="circle outline icon"></i><span>Cookies :</span>Customizing the cookie popup, editing the cookie message.</div>
          <div class="item"><i class="circle outline icon"></i><span>Languages :</span>Enable / Disable languages</div>
          <div class="item"><i class="circle outline icon"></i><span>Fonts :</span>Use different fonts, from googSle fonts or local fonts</div>
          <div class="item"><i class="circle outline icon"></i><span>Templates :</span>Change the template, loading custom CSS and Javascript code</div>
          <div class="item"><i class="circle outline icon"></i><span>Social :</span>Enter URLs to your social accounts</div>
          <div class="item"><i class="circle outline icon"></i><span>Favicon, Logo, Cover, Watermark :</span>Change the website logo, favicon and cover, use a watermark for product covers</div>
          <div class="item"><i class="circle outline icon"></i><span>Notifications :</span>Enable / Disable receiving emaim notifications on new comments, reviews and sales.</div>
          <div class="item"><i class="circle outline icon"></i><span>Reviews and comments :</span>Enabling comments and reviews, auto approving comments and reviews, editing own reviews, deleteing own comments, ... etc.</div>
          <div class="item"><i class="circle outline icon"></i><span>Debugging :</span>Enabling / Disable debug mode for the website</div>
          <div class="item"><i class="circle outline icon"></i><span>Realtime views :</span>Enable / disable realtime views with an additional fake mode option, set a range of views for fake mode, ...etc.</div>
          <div class="item"><i class="circle outline icon"></i><span>Fake purchases :</span>Enabling / Disable fake purchases popup, select in which page to show the popup, generate fake profiles for fake purchases, specify when to the show the pop.</div>
          <div class="item"><i class="circle outline icon"></i><span>Facebook pixel :</span>Enter a facebook pixel code to load on the website.</div>
          <div class="item"><i class="circle outline icon"></i><span>Traffic security :</span>Select which web crawlers and bots to authorize accessing your website, limit the number of views per minutes for each user.</div>
          <div class="item"><i class="circle outline icon"></i><span>Other :</span>Select the invoice template, show a color cursor on the website instead of the default one, select an HTML editor (Summernote or TinyMCE), Show counters on the website (users, orders, products ...).</div>
          
        </div>    
      </div>

      <div class="ui four doubling cards">
        <div class="card">
          <div class="image">
            <img src="/doc_assets/general-settings-1.webp" alt="">
          </div>  
        </div>
        <div class="card">
          <div class="image">
            <img src="/doc_assets/general-settings-2.webp" alt="">
          </div>  
        </div>
        <div class="card">
          <div class="image">
            <img src="/doc_assets/general-settings-3.webp" alt="">
          </div>  
        </div>
        <div class="card">
          <div class="image">
            <img src="/doc_assets/general-settings-4.webp" alt="">
          </div>  
        </div>
      </div>
    </div>

    <div class="section" id="mailer-settings">
      <div class="header"><a href="#mailer-settings">#</a>Mailer (SMTP)</div>
      <div class="subheader">Admin > Settings > Mailer</div>
      <div class="description">
        <p>Configuring the mailer to send and receive email messages</p>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create an email account on your server</div>
          <div class="item"><i class="circle outline icon"></i>Enter your email account address in "User" field and the password in the "Password" field</div>
          <div class="item"><i class="circle outline icon"></i>Enter your sever host address in "Host" field</div>
          <div class="item"><i class="circle outline icon"></i>For the port and encryption, you can either use port "465" with "tls" encryption for a secure connection or port 587 with "tls" encryption for a none secure connection. If "tls" encryption doesn't work with port "465", try changing it to "ssl"</div>
          <div class="item"><i class="circle outline icon"></i>Enter a "reply to" email address, it'll be used as the email address to which users reply to when they respond to your messages.</div>
          <div class="item"><i class="circle outline icon"></i>Enter a "forward to" email address, all email messages sent to your server account address will be forwarded to this "forward to" address.</div>
          <div class="item"><i class="circle outline icon"></i>Turning on "Queue emails messages" requires creating a cron job to proceed email message on the background, this avoid users waiting for your server to send email messages.</div>
          <div class="item"><i class="circle outline icon"></i>You can check if the mailer credentials you entered are correct by clicking on "Check connection" button.</div>
        </div>

        <div class="ui four doubling cards">
          <div class="card">
            <div class="image">
              <img src="/doc_assets/mailer-settings.webp" alt="">
            </div>  
          </div>
        </div>
      </div>
    </div>

    <div class="section" id="payment-gateways-settings">
      <div class="header"><a href="#payment-gateways-settings">#</a>Payment gateways</div>
      <div class="subheader">Admin > Settings > Payments</div>
      <div class="description">
        <p>Configuring and enabling payment gateways, authorizing multiple currencies, enable / disable "Add to cart", allow / disallow guest checkout, enabling currency exchanger service ... etc.</p>
        <div class="header" id="paypal">PayPal</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a PayPal business account</div>
          <div class="item"><i class="circle outline icon"></i>Login to <a href="https://developer.paypal.com/" target="_blank">PayPal Developer Dashboard</a></div>
          <div class="item"><i class="circle outline icon"></i>On the top menu, click on "Apps & Credentials" and then click again on "Create App" blue button</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name for your application</div>
          <div class="item"><i class="circle outline icon"></i>For "App Type", select "Merchant - Accept payments as a merchant (seller)"</div>
          <div class="item"><i class="circle outline icon"></i>Select a sandbox account to use for testing payments / purchases, if you don't have one yet, you can create one from the top menu > Testing tools > Sandbox accounts, click on "Create account" blue button and select and an account type "Merchant" or "Personal", select a country and then click on "Create"</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Create app" to terminate</div>
          <div class="item"><i class="circle outline icon"></i>On the next page, Copy the Client ID and Secret ID (click on Show to see it) and paste them to your website PayPal config page</div>
          <div class="item"><i class="circle outline icon"></i>For "App feature options" and "Webhook", leave everything as it is</div>
          <div class="item"><i class="circle outline icon"></i>Each mode (Test and Live) has its own credentials, when you change the mode, copy/paste the corresponding credentials to your website PayPal config again.</div>
        </div>

        <div class="ui four doubling cards">
          <div class="card">
            <div class="image">
              <img src="/doc_assets/payment-settings-paypal-1.webp" alt="">
            </div>  
          </div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="flutterwave">FlutterWave</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i><a href="https://dashboard.flutterwave.com/signup" target="_blank">Create</a> a FlutterWave account and <a href="https://dashboard.flutterwave.com/login">login</a> to it</div>
          <div class="item"><i class="circle outline icon"></i>You can get your Public key and Secret key from the left menu "Settings / API"</div>
          <div class="item"><i class="circle outline icon"></i>Click on the Webhooks tab in the same page</div>
          <div class="item"><i class="circle outline icon"></i>In the webhook "URL" field enter : https://example.com/checkout/webhook (where example.com is your domain name)</div>
          <div class="item"><i class="circle outline icon"></i>In the webhook "Secret hash" field enter any random string of characters (like a pasword)</div>
          <div class="item"><i class="circle outline icon"></i>Check the first two checkboxes ["Receive Webhook response in JSON format" and "Enable Webhook retries"]</div>
          <div class="item"><i class="circle outline icon"></i>Copy the "Secret hash" to your website / admin / settings / payments / flutterwave config with the public and secret key.</div>
          <div class="item"><i class="circle outline icon"></i>You will need to add a bank account on the "Bank Accounts" tab to be able to process payment via bank transfer and other bank related methods other than cards especially on test mode.</div>
          <div class="item"><i class="circle outline icon"></i>You can switch modes [Live/Test] from flutterwave admin dashboard / left menu.</div>
          <div class="item"><i class="circle outline icon"></i>Test cards : https://developer.flutterwave.com/docs/test-cards</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="sslcommerz">SslCommerz</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a sandbox SslCommerz account from <a href="https://developer.sslcommerz.com/registration/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>You will receive your sanbox login credential via email</div>
          <div class="item"><i class="circle outline icon"></i>Login to your sanbox account from <a href="https://sandbox.sslcommerz.com/manage">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Copy the Store id and the Store password to their corresponding fields in your website / admin / settings / payments / sslcommerz</div>
          <div class="item"><i class="circle outline icon"></i>Test cards : https://developer.sslcommerz.com/doc/v4/#payment-process-environment</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="stripe">Stripe</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a Stripe account</div>
          <div class="item"><i class="circle outline icon"></i>Login to your Stripe account dashboard</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "Developers" and then "API Keys"</div>
          <div class="item"><i class="circle outline icon"></i>You will have a "Publishable key" which is the Client ID in your website and a "Secret key" which is the Secret ID in your website. Those two keys or IDs are for testing only (paypal sandbox equivalent mode).</div>
          <div class="item"><i class="circle outline icon"></i>In order to get Keys/IDs for non-testing mode (Live mode) you wil need to fill in the form Here and submit it to stripe for review.</div>
          <div class="item"><i class="circle outline icon"></i>Test cards can be found <a href="https://stripe.com/docs/testing#cards">Here</a></div>
          <div class="item"><strong>Changing stripe store name and widget color / logo</strong></div>
          <div class="item"><i class="circle outline icon"></i>Login to your stripe account</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "settings", then, select "Account information"</div>
          <div class="item"><i class="circle outline icon"></i>In "Public business information / Public business name" enter your new business (store) name</div>
          <div class="item"><i class="circle outline icon"></i>You can edit the other fields too, 'support email', 'Statement descriptor', 'Business website' ...</div>
          <div class="item"><i class="circle outline icon"></i>For wiget color and logo, back to the previous page and select "Branding" (Public business information / Branding)</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="razorpay">Razorpay</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a Razorpay account</div>
          <div class="item"><i class="circle outline icon"></i>Login to your Razorpay account dashboard</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "Settings" and then "API Keys"</div>
          <div class="item"><i class="circle outline icon"></i>Copy the "Key Id" and "Key Secret" (you may need to click on "Generate Test key" blue button to get the necessary keys).</div>
          <div class="item"><i class="circle outline icon"></i>Copy/paste those IDs in your website Razorpay settings fields, enable Razorpay and save the changes.</div>
          <div class="item"><i class="circle outline icon"></i>In order to get Keys/IDs for non-testing mode (Live mode) you wil need to fill in the form Here and submit it to Razorpay for review.</div>
          <div class="item"><i class="circle outline icon"></i>Test cards can be found <a href="https://razorpay.com/docs/payment-gateway/test-card-details/">Here</a></div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="skrill">Skrill</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>PDF documentation offered by skrill : https://www.skrill.com/fileadmin/content/pdf/Skrill_Quick_Checkout_Guide.pdf</div>
          <div class="item"><i class="circle outline icon"></i>Test merchant and test cards are in page 20 of Skrill_Quick_Checkout_Guide.pdf documentation.</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="iyzico">Iyzico</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a sandbox Iyzico account <a href="https://sandbox-merchant.iyzipay.com/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Login to your sandbox Iyzico account dashboard</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "Settings" and then on "Merchant Settings"</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Show detail" for "API Key" and "Secret Key"</div>
          <div class="item"><i class="circle outline icon"></i>Copy/paste those IDs in your website Iyzico settings fields ("API Key" to "Key ID" and "Secret Key" to "Key Secret"), enable Iyzico and save the changes.</div>
          <div class="item"><i class="circle outline icon"></i>In order to get Keys/IDs for non-testing mode (Live mode) you wil need to create a non-sandbox account <a href="https://www.iyzico.com/en/business/signup/">Here</a>, activate your account via the received email and follow the required steps for applying to a business account.</div>
          <div class="item"><i class="circle outline icon"></i>Test cards can be found Here</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="coingate">CoinGate</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a sanbox CoinGate account <a href="https://sandbox.coingate.com/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Connect to your Coingate account</div>
          <div class="item"><i class="circle outline icon"></i>Create and App and get an Auth token following the instructions <a href="https://support.coingate.com/en/42/how-can-i-create-coingate-api-credentials">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste your Auth token in your website >> Administration >> Settings >> Payments >> Coingate >> Auth Token</div>
          <div class="item"><i class="circle outline icon"></i>Enter the currency (Code of 3 chars, e.g. USD) to which you want to exchange the received currency.</div>
          <div class="item"><i class="circle outline icon"></i>To get an Auth token for live mode, create a non-sandbox account <a href="https://coingate.com/">here</a>, and follow the same previous steps. You may be prompted to provide more details about your activity.</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="midtrans">Midtrans</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a Midtrans account <a href="https://midtrans.com//">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Connect to your Midtrans sandbox account <a href="https://dashboard.sandbox.midtrans.com/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>On the left menu click on "Settings" >> "Configuration".</div>
          <div class="item"><i class="circle outline icon"></i>For "Finish Redirect URL*" enter https://example.com/checkout/payment/order_completed/midtrans (where example.com is your domain name. Https ot Http depends on whether you have an ssl certificate or not.)</div>
          <div class="item"><i class="circle outline icon"></i>For "Unfinish Redirect URL*" enter https://example.com/checkout</div>
          <div class="item"><i class="circle outline icon"></i>For "Error Redirect URL*" enter https://example.com</div>
          <div class="item"><i class="circle outline icon"></i>Save the changes</div>
          <div class="item"><i class="circle outline icon"></i>Get your Client Key, Server Key and Merchant ID from "Settings" >> "Access Keys"</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste them in your website >> Administration >> Settings >> Payments >> Midtrans</div>
          <div class="item"><i class="circle outline icon"></i>You can edit your Midtrans payment form preferences form Settings >> Snap Preferences</div>
          <div class="item"><i class="circle outline icon"></i>To switch to live mode, select "Production environment" in your Midtrans dashboard, and then follow the registration steps <a href="https://passport.midtrans.com/authenticate">Here</a></div>
          <div class="item"><i class="circle outline icon"></i><a href="https://docs.midtrans.com/en/technical-reference/sandbox-test">Test payments</a></div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="paystack">Paystack</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a Paystack account <a href="https://paystack.com/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Connect to your Paystack account</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "Settings" and then on "API Keys & Webhooks" tab. (no need to enter a 'Callback URL' and a 'Webhook URL')</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste your "Test Secret Key" and "Test Public Key" in your website >> Administration >> Settings >> Payments >> Paystack.</div>
          <div class="item"><i class="circle outline icon"></i>Once done with testing, you can activate your account following the instrcutions in <a href="https://dashboard.paystack.com/#/get-started/activate">This page</a></div>
          <div class="item"><i class="circle outline icon"></i><a href="https://paystack.com/docs/payments/test-payments/#bank-accounts">Test payments</a></div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="adyen">Adyen</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a Adyen account <a href="https://adyen.com/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Connect to your Adyen test account <a href="https://ca-live.adyen.com/ca/ca/login.shtml">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>To generate API credentials, follow the instructions in <a href="https://docs.adyen.com/development-resources/api-credentials#generate-your-api-key">This page</a></div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste your "API key", "Client key" and "Merchant account" in your website >> Administration >> Settings >> Payments >> Adyen</div>
          <div class="item"><i class="circle outline icon"></i>Test cards can be found <a href="https://docs.adyen.com/development-resources/test-cards/test-card-numbers">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>To activate live mode, connect to your Adyen test account and click on "Apply for live"</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="instamojo">Instamojo</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a business Instamojo test account <a href="https://test.instamojo.com/accounts/register/?ref=login">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>Connect to your Instamojo test account <a href="https://test.instamojo.com/accounts/login/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>On the left menu click on "API & Plugins"</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste your "Private API Key", "Private Auth Token" and "Private Salt" in your website >> Administration >> Settings >> Payments >> Instamojo</div>
          <div class="item"><i class="circle outline icon"></i>To switch to live mode, create a business Instamojo non-test account and proceed as before.</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="youcanpay">YoucanPay</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create an account from <a href="https://youcanpay.com/">this page</a></div>
          <div class="item"><i class="circle outline icon"></i>Login to your <a href="https://youcanpay.com/dashboard">dashboard</a></div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "settings"</div>
          <div class="item"><i class="circle outline icon"></i>On the profile page, scroll down and click on "API keys"</div>
          <div class="item"><i class="circle outline icon"></i>You'll have the API keys for two modes, Test mode and Live mode, copy the keys to your website Youcan pay settings (Admin > Settings > Payments > YouCanPay), select the appropriate mode and save the chagnes</div>
          <div class="item"><i class="circle outline icon"></i>On Your YoucanPay dashboard / profile page, do not specify the "Success URL" and "Error URL", just leave them empty.</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Webhooks" and again on "Add webhook"</div>
          <div class="item"><i class="circle outline icon"></i>On "Webhook url" field enter "https://www.example.com/payment_webhook" where example.com is your domain name</div>
          <div class="item"><i class="circle outline icon"></i>You can toggle Sandbox mode depending on which mode you're using</div>
          <div class="item"><i class="circle outline icon"></i>For "Events" list, select "Paid transactions" and click on "Add webhook" to finish the creation.</div>
          <div class="item"><i class="circle outline icon"></i>You may need to <a href="https://youcanpay.com/settings/verify-identity">Verify your identity</a> later when you decide to use Live mode.</div>
          <div class="item"><i class="circle outline icon"></i><a href="https://youcanpay.com/docs#section_testing_and_test_cards">Test cards</a> https://youcanpay.com/docs#section_testing_and_test_cards</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="offline-payments">Offline payments</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Enter your bank account details</div>
          <div class="item"><strong>How it works</strong></div>
          <div class="item"><i class="circle outline icon"></i>The buyer completes his/her offline purchase</div>
          <div class="item"><i class="circle outline icon"></i>His/her purchase is marked as pending</div>
          <div class="item"><i class="circle outline icon"></i>He/she transfers the purchase amount to your bank account</div>
          <div class="item"><i class="circle outline icon"></i>You validate the transfer in your bank account</div>
          <div class="item"><i class="circle outline icon"></i>You mark the payment status as paid in your website > Administration > Transactions. If the transfer is not done, the buyer won't get access to the purchased items as long as you don't mark the payment or transactions as "Paid".</div>
        </div>
        
        <div class="ui hidden divider"></div>

        <div class="header" id="other-payment-configs">Other payment configs</div>
        <div class="ui card fluid">
          <div class="content">
            <p><strong>-</strong> Each payment service has an otpion to specify a minium amount to pay if a buyer decides to use "Pay what you want" rather than the default price.</p>
            <p><strong>-</strong> You can drag and drop the payment cards to change the order payment services will be shown with for buyers.</p>
            <p><strong>-</strong> By specifying an "Auto exchange to" currency, to force the payment gateway using this currency instead of the user seleted one.</p>
            <p><strong>-</strong> The <strong>Credits payment service</strong> is used with <strong>Prepaid credits</strong> feature, to allow users purchsing with their <strong>E-wallet</strong>.</p>
          </div>
        </div>

        <div class="ui two doubling stackable cards">
          <div class="fluid card">
            <div class="content header">VAT (Tax)</div>
            <div class="content body">
              You can specify a VAT (Value Added Tax) to apply on your sales. (Put 0 if not applicable)
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Fee</div>
            <div class="content body">
              You can set a fee for each payment method independently. (Put 0 if not applicable)
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Main currency (Code & Symbol)</div>
            <div class="content body">
              A currency code (ISO format "GBP, USD, CAD ...") and a symbol if there is any (the "currency code" is mandatory).
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Currency position</div>
            <div class="content body">
              The place where to show the currency with the price, left or right.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Allow foreign currencies</div>
            <div class="content body">
              Whether to accept receving payments in foreign currencies or not. This implies the use of a Currency exchanger API if enabled.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Currencies</div>
            <div class="content body">
              A selection of currencies in which users can see the prices of your products, and optionally, purchase with if "Allow foreign currencies" is enabled.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Currency exchange API</div>
            <div class="content body">
              <p>Select an API to use for the exchange rates.</p>
              <p>You can specify an exchange rate manually for each currency based on the main one, in "config/payments.php", in currencies array, change null value for exchange_rate to your custom one and save the changes, this way the exchange rate will be obtained from config/payments.php file and not the API.</p>
              <p><strong>Note :</strong> "api.coingate.com", "api.exchangerate.host" and "api.exchangeratesapi.io" are free, while you must get an API key for "api.currencyscoop.com".</p>
              <p>To get an API key for "api.currencyscoop.com", register to one of the pricing plans <a href="https://currencyscoop.com/#pricing">Here</a>, you will find your API KEY in your account page.</p>
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Allow guest checkout</div>
            <div class="content body">
              <p>This allows users to purchase items without beeing connected, after they complete their purchases, they will be given an access token to gain access to the purchased items.</p>
              <p>Allowing guest checkout, makes an option available in the footer of your website (your website's users/visitors/buyers interface), this option is called "Guest section", a page where users can enter a guest access token to get a list of purchased items.</p>
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Currency position</div>
            <div class="content body">
              The place where to show the currency with the price, left or right.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Require agreement to the market TOS</div>
            <div class="content body">
              Make accepting TOS required to checkout
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">TOS page URL</div>
            <div class="content body">
              A url path to the page of checkout TOS
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Allow buyers to add notes on orders</div>
            <div class="content body">
              Allow buyer writing notes before proceeding to the payment, this may be used to allow users asking for other attached services or customizations.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Enable "Pay What You Want"</div>
            <div class="content body">
              Offer an option for buyers to pay a different price than the product or subscription regular price.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Change user currency based on his country</div>
            <div class="content body">
              Select a default currency based on the user location / country
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Enable add to cart</div>
            <div class="content body">
              Enable / Disable "Add to cart", With this option disabled, the "Shopping cart" icon will be removed from the menu.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Show prices in K format</div>
            <div class="content body">
              Show prices in multiple of 1000, this can useful for currencies like crypto or IDR to avoid showing a long number.
            </div>
          </div>

          <div class="fluid card">
            <div class="content header">Delete pending orders in x hours</div>
            <div class="content body">
              Auto delete orders with a "Pending" status if the status doesn't change to "paid" after x hours.
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="section" id="file-storage-settings">
      <div class="header"><a href="#file-storage-settings">#</a>File storage services</div>
      <div class="subheader">Admin > Settings > Storage</div>
      <div class="description">
        <p>Configuring Google cloud storage, Dropbox, Amazon S3, Wasabi, Yandex disk and Google drive.</p>
        <p>You can use your local server storage without opting for any external storage service.</p>

        <div class="header" id="amazon-s3">Amazon S3</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create an Amazon aws account from this page https://aws.amazon.com/s3/</div>
          <div class="item"><i class="circle outline icon"></i><a href="https://console.aws.amazon.com/console/home?nc2=h_ct&src=header-signin">Login</a> to your aws account as root user</div>
          <div class="item"><i class="circle outline icon"></i>Click on your profile name at the top right corner, and select "Security credentials"</div>
          <div class="item"><i class="circle outline icon"></i>Scroll down to "Access keys" and click on "Create access key"</div>
          <div class="item"><i class="circle outline icon"></i>Check "Continue to create access key?" box and click on "Create acces key" orange button</div>
          <div class="item"><i class="circle outline icon"></i>Copy the "Access key" and "Secret access key" to your website amazon s3 settings</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Done" orange button (You can download the csv file as a backup to use later)</div>
          <div class="item"><i class="circle outline icon"></i>On the top menu, left corner, click on "Services" and select "Storage" > "S3"</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Create bucket" orange button</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name for your bucket and select and AWS Region, leave the other fields and options unchanged, scroll down and click on "Create bucket"</div>
          <div class="item"><i class="circle outline icon"></i>Copy the bucket name and AWS region (us-west-2 or other region) to your website amazon s3 settings</div>
          <div class="item"><i class="circle outline icon"></i>On your website amazon s3 settings, click on "Check connection" to make sure the config is correct.</div>
          <div class="item"><i class="circle outline icon"></i>Enable amazon S3 and save the changes</div>
          <div class="item"><i class="circle outline icon"></i>Back to amazon S3 / buckets page, click on the bucket name you've just created and upload your files</div>
        </div>

        <div class="ui four doubling cards">
          <div class="card">
            <div class="image">
              <img src="/doc_assets/amazon-s3-1.webp" alt="">
            </div>  
          </div>
          <div class="card">
            <div class="image">
              <img src="/doc_assets/amazon-s3-2.webp" alt="">
            </div>  
          </div>
          <div class="card">
            <div class="image">
              <img src="/doc_assets/amazon-s3-3.webp" alt="">
            </div>  
          </div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="google-cloud-storage">Google Cloud Storage</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Connect to <a href="https://console.cloud.google.com/">Console Cloud Google</a>with your prefered gmail account</div>
          <div class="item"><i class="circle outline icon"></i>On the "Quick access" section, open "APIs & Services" in a new tab</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, select "Credentials"</div>
          <div class="item"><i class="circle outline icon"></i>On the top menu, click on "+ Credentials" and select "Service account"</div>
          <div class="item"><i class="circle outline icon"></i>On "Service account details", enter a name for the service account (any name), the account id will be auto-generated (no need to change it), a description for the service account (any description)</div>
          <div class="item"><i class="circle outline icon"></i>Click on Continue</div>
          <div class="item"><i class="circle outline icon"></i>On the "Role" list, select "Owner" and click on Continue</div>
          <div class="item"><i class="circle outline icon"></i>For "Grant users access to this service account", leave everything empty and click on "Done"</div>
          <div class="item"><i class="circle outline icon"></i>Once back to the Credntials page again, scroll down to "Service Accounts and click on "Edit service account" icon for the account you've just created</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Keys" on the top menu</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Add key" and then on "Create new key", for "Key type" select JSON</div>
          <div class="item"><i class="circle outline icon"></i>Back to your website Admin > settings > storage > Google cloud storage, click on "Config file" and select the file that was auto-downloaded from google console page</div>
          <div class="item"><i class="circle outline icon"></i>keep "Google cloud storage" disabled on your website and save the changes</div>
          <div class="item"><i class="circle outline icon"></i>Back to google credentials page and click on "Create" to close the popup</div>
          <div class="item"><i class="circle outline icon"></i>On the first google page "https://console.cloud.google.com/", click on "Create a storage bucket"</div>
          <div class="item"><i class="circle outline icon"></i>Sign up for a free trial and complete the registration</div>
          <div class="item"><i class="circle outline icon"></i>Once you complete the registration and create a bucket, copy the bucket name to your website Admin > settings > storage > Google cloud storage > Bucket field, and click on "Test connection", if you get a "success" message, click on "save" to finish with Google cloud storage settings.</div>
        </div>

        <div class="ui four doubling cards">
          <div class="card">
            <div class="image">
              <img src="/doc_assets/google-cloud-storage-1.webp" alt="">
            </div>  
          </div>
          <div class="card">
            <div class="image">
              <img src="/doc_assets/google-cloud-storage-2.webp" alt="">
            </div>  
          </div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="wasabi">Wasabi</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create an account <a href="https://wasabi.com/sign-up/">here</a></div>
          <div class="item"><i class="circle outline icon"></i>Connect to your account https://console.wasabisys.com/#/login</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Create bucket" blue button</div>
          <div class="item"><i class="circle outline icon"></i>Give your bucket a name</div>
          <div class="item"><i class="circle outline icon"></i>Select a region</div>
          <div class="item"><i class="circle outline icon"></i>Click on next, next and on 'Create bucket'</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste the bucket name and the region name to your website Wasabi settings</div>
          <div class="item"><i class="circle outline icon"></i>Back to Wasabi, on the left menu, click on 'Access keys'</div>
          <div class="item"><i class="circle outline icon"></i>Click on 'CREATE NEW ACCESS KEY' blue button</div>
          <div class="item"><i class="circle outline icon"></i>Select 'root user' and click on 'Create'</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste the Access Key and Secret Key to your website wasabi settings</div>
          <div class="item"><i class="circle outline icon"></i>In your website wasabi settings, click on 'Test connection' to check if the entered data is ok, you will get a 'success' response if the connection is established, otherwise, you'll get an error message.</div>
          <div class="item"><i class="circle outline icon"></i>Enable Wasabi and save the changes.</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="yandex-disk">Yandex disk</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Login to Yandex Disk https://disk.yandex.com/</div>
          <div class="item"><i class="circle outline icon"></i>Access https://oauth.yandex.ru/</div>
          <div class="item"><i class="circle outline icon"></i>Click on 'Register a new app'</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name for your application</div>
          <div class="item"><i class="circle outline icon"></i>A brief description for your application</div>
          <div class="item"><i class="circle outline icon"></i>An Icon for your application</div>
          <div class="item"><i class="circle outline icon"></i>A Link to your website</div>
          <div class="item"><i class="circle outline icon"></i>In 'Platform' select 'Web services'</div>
          <div class="item"><i class="circle outline icon"></i>In 'Callback URI #1:' enter https://example.com/admin/settings/files_host (where example.com is your domain name)</div>
          <div class="item"><i class="circle outline icon"></i>You can add multiple callbacks, like with www and without www ...</div>
          <div class="item"><i class="circle outline icon"></i>In 'Access*' click on 'Yandex.Disc REST API' and check all the choices</div>
          <div class="item"><i class="circle outline icon"></i>Scroll down to the bottom of the page and click on 'Create an app'</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste the ID and the password to your website yandex disk settings</div>
          <div class="item"><i class="circle outline icon"></i>Save the changes</div>
          <div class="item"><i class="circle outline icon"></i>In your website yandex disk settings, click on 'Connect account' to connect one of your yandex disk account to your website.</div>
          <div class="item"><i class="circle outline icon"></i>Once the connection is done, a refresh token will be put in 'Refresh token' automatically.</div>
          <div class="item"><i class="circle outline icon"></i>Enable Yandex disk and save the changes again</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="google-drive">Google drive</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Login to <a href="https://console.developers.google.com/">Google Console API</a> with your prefered gmail acccount</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Select a project" at the top left corner and select or create a new project in the popup window</div>
          <div class="item"><i class="circle outline icon"></i>At the top bar, click on "+ ENABLE APIS AND SERVICES"</div>
          <div class="item"><i class="circle outline icon"></i>Search for "Google Drive API", select it and then click on "ENABLE" (the blue button)</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "Credentials" and then on '+ CREATE CREDENTIALS' and select 'API key'</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste the API key in the popup to your website admin > settings > storage > Google Drive config and close the popup window.</div>
          <div class="item"><i class="circle outline icon"></i>Again, on "Credentials" page, click on "+ CREATE CREDENTIALS" and select "OAuth Client ID"</div>
          <div class="item"><i class="circle outline icon"></i>In "Application type" select "Web application"</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name for your application</div>
          <div class="item"><i class="circle outline icon"></i>Click on "ADD URI" for "Authorized JavaScript origins" and enter your website url with www and without wwww (https://example.com and https://www.example.com)</div>
          <div class="item"><i class="circle outline icon"></i>In "Authorized redirect URIs" click on "ADD URI" and enter "https://example.com/gd_callback" and "https://example.com/login/google/callback" with www and without www (change example.com to your domain name or subdomain)</div>
          <div class="item"><i class="circle outline icon"></i>At the bottom of the page, click on "Create"</div>
          <div class="item"><i class="circle outline icon"></i>Download the JSON file as a backup from the popup window</div>
          <div class="item"><i class="circle outline icon"></i>Copy the "Client ID" and the "Client secret" to your website google drive settings and click on "Ok" to close the credentials popup window.</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "OAuth consent screen"</div>
          <div class="item"><i class="circle outline icon"></i>In "App Domain", enter your website homepage url, the url for your website Privacy policy page, the url for your website terms and conditions page</div>
          <div class="item"><i class="circle outline icon"></i>In "Authorized domains", enter your website domain name, like "example.com" and another with "www.example.com"</div>
          <div class="item"><i class="circle outline icon"></i>In "Developer contact information", enter an email address to use as developer email (User support email and Developer email can be the same)</div>
          <div class="item"><i class="circle outline icon"></i>Save and continue</div>
          <div class="item"><i class="circle outline icon"></i>In "Scopes" step, leave everything unchanged and click again on "Save and continue"</div>
          <div class="item"><i class="circle outline icon"></i>In "Optional info" step, again leave everything unchanged and click on "Save and continue"</div>
          <div class="item"><i class="circle outline icon"></i>In "Summary", scroll down and click on "Back to dashboard"</div>
          <div class="item"><i class="circle outline icon"></i>In "Auth consent screen" page, click on "PUBLISH APP" and "Confirm"</div>
          <div class="item"><i class="circle outline icon"></i>Back to your website admin > settings > storage > google drive, keep Google drive disabled and save the changes</div>
          <div class="item"><i class="circle outline icon"></i>Once the changes are saved, connect your Google drive account by clicking on "Connect" button.</div>
          <div class="item"><i class="circle outline icon"></i>Note : When you try to connect your gmail account, you may get a "This app isn't verified" warning message, just click on "Advanced" (a grey underlined text) and click on "Go to ... (unsafe)"</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Allow" to give your "Google Console APP" the authorisation to use your google drive (see, edit, create and delete files in your google drive) and again click on "Allow"</div>
          <div class="item"><i class="circle outline icon"></i>You can connect with a different gmail account whenever you want, if you want to use files from another google drive.</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="dropbox">Dropbox</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Login to your Dropbox developers <a href="https://www.dropbox.com/developers/apps/">Here</a> with your prefered email</div>
          <div class="item"><i class="circle outline icon"></i>Once in, click on "Create app"</div>
          <div class="item"><i class="circle outline icon"></i>Select "Dropbox API"</div>
          <div class="item"><i class="circle outline icon"></i>Select whether you want to get files only from the app folder or all dropbox.</div>
          <div class="item"><i class="circle outline icon"></i>Give a name to your application, it's going to be your App folder's name, so, if you've choosen "App Folder" above, your requests to dropbox will be limited to this folder, else, to your whole dropbox.</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Create app"</div>
          <div class="item"><i class="circle outline icon"></i>Once done, your App Key and APP Secret will be on the given page, copy/pase them into their respective fields in your website / settings / file hosts / dropbox, and save the changes (Update)</div>
          <div class="item"><i class="circle outline icon"></i>For the "Redirect URIs", put "https://www.example.com/admin/settings/files_host" and click on "Add" (https is required)</div>
          <div class="item"><i class="circle outline icon"></i>If you want this app this be uesd by different accounts, click on "Enable additional user" at the top of the page, by that, your app will be allowed to be used by 500 users (accounts) as max.</div>
          <div class="item"><i class="circle outline icon"></i>Back to you website /settings / file hosts / dropbox, click on "Connect", connect with the dropbox accont you want to use, click on "Continue" and then "Allow", you will be redirected to your website with an "access token" place in its place for dropbox.</div>
          <div class="item"><i class="circle outline icon"></i>Enable Dropbox if you want, save the change and that's it.</div>
        </div>
      </div>

      <div class="ui hidden divider"></div>

      <p><strong>Important :</strong> For all file storage services, you need to upload the files directly to the storage service, not from your website</p>

      <div class="ui four cards">
        <div class="card">
          <div class="image">
            <img src="/doc_assets/fetching-files.webp">
          </div>  
        </div>
      </div>
    </div>

    <div class="section" id="affiliate-settings">
      <div class="header"><a href="#affiliate-settings">#</a>Affiliate</div>
      <div class="subheader">Admin > Settings > Affiliate</div>
      <div class="description">
        Configuring affiliate program, commission rate, cashout methods, minumum cashout amount ... etc.
      </div>

      <div class="ui four doubling cards">
        <div class="card">
          <div class="image">
            <img src="/doc_assets/affiliate-1.webp" alt="">
          </div>  
        </div>
      </div>
    </div>

    <div class="section" id="social-login-settings">
      <div class="header"><a href="#social-login-settings">#</a>Social login</div>
      <div class="subheader">Admin > Settings > Social login</div>
      <div class="description">
        <p>Allow users connection using their social accounts, Dribbble, VKontakte, Google, Linkedin, Github ... etc.</p>

        <div class="header" id="dribbble">Dribbble</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Connect to https://developer.dribbble.com/ and click on "Register your application"</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name and description for the application, enter your website url (https://www.example.com)</div>
          <div class="item"><i class="circle outline icon"></i>For "Callback url" enter https://www.example.com/login/dribbble/callback (change example.com to your domain name)</div>
          <div class="item"><i class="circle outline icon"></i>Accept the Dribbble API Terms & Guidelines and click on "Register application"</div>
          <div class="item"><i class="circle outline icon"></i>Copy and client id and client secret to your website / admin / settings / social login / dribbble settings</div>
          <div class="item"><i class="circle outline icon"></i>Enable Dribbble and save the changes</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="google">Google</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Copy the "Client id" and "client secret" from google drive settings if you already configured google drive</div>
          <p>If you didn't configure google drive, please proceed with the folowing steps :</p>
          <div class="item"><i class="circle outline icon"></i>Login to <a href="https://console.developers.google.com/">Google Console API</a> with your prefered gmail acccount</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Select a project" at the top left corner and select or create a new project in the popup window</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "Credentials" and then on '+ CREATE CREDENTIALS' and select 'OAuth Client ID'</div>
          <div class="item"><i class="circle outline icon"></i>In "Application type" select "Web application"</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name for your application</div>
          <div class="item"><i class="circle outline icon"></i>Click on "ADD URI" for "Authorized JavaScript origins" and enter your website url with www and without wwww (https://example.com and https://www.example.com)</div>
          <div class="item"><i class="circle outline icon"></i>In "Authorized redirect URIs" click on "ADD URI" and enter "https://example.com/login/google/callback" with www and without www (change example.com to your domain name or subdomain)</div>
          <div class="item"><i class="circle outline icon"></i>At the bottom of the page, click on "Create"</div>
          <div class="item"><i class="circle outline icon"></i>Download the JSON file as a backup from the popup window</div>
          <div class="item"><i class="circle outline icon"></i>Copy the "Client ID" and the "Client secret" to your website google drive settings and click on "Ok" to close the credentials popup window.</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "OAuth consent screen"</div>
          <div class="item"><i class="circle outline icon"></i>In "App Domain", enter your website homepage url, the url for your website Privacy policy page, the url for your website terms and conditions page</div>
          <div class="item"><i class="circle outline icon"></i>In "Authorized domains", enter your website domain name, like "example.com" and another with "www.example.com"</div>
          <div class="item"><i class="circle outline icon"></i>In "Developer contact information", enter an email address to use as developer email (User support email and Developer email can be the same)</div>
          <div class="item"><i class="circle outline icon"></i>Save and continue</div>
          <div class="item"><i class="circle outline icon"></i>In "Scopes" step, leave everything unchanged and click again on "Save and continue"</div>
          <div class="item"><i class="circle outline icon"></i>In "Optional info" step, again leave everything unchanged and click on "Save and continue"</div>
          <div class="item"><i class="circle outline icon"></i>In "Summary", scroll down and click on "Back to dashboard"</div>
          <div class="item"><i class="circle outline icon"></i>In "Auth consent screen" page, click on "PUBLISH APP" and "Confirm"</div>
          <div class="item"><i class="circle outline icon"></i>Back to your website admin > settings > social login > google and save the changes</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="linkedin">Linkedin</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a Linkedin account (if you don't have one)</div>
          <div class="item"><i class="circle outline icon"></i>Login to <a href="https://www.linkedin.com/developers/">Linkedin developpers</a></div>
          <div class="item"><i class="circle outline icon"></i>On "My Apps" dropdown menu, select "Create app"</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name for your app, a company name</div>
          <div class="item"><i class="circle outline icon"></i>In "Privacy policy", enter the url to your website privacy policy page</div>
          <div class="item"><i class="circle outline icon"></i>Upload a logo for your linkedin app</div>
          <div class="item"><i class="circle outline icon"></i>For "Products" leave everything as is</div>
          <div class="item"><i class="circle outline icon"></i>Accept the "Legal terms" and hit "Create" button</div>
          <div class="item"><i class="circle outline icon"></i>Once done, from the previous dropdown menu (My Apps), select the App you've just created</div>
          <div class="item"><i class="circle outline icon"></i>Select "Auth" on the top menu, scroll down to "Redirect URLs:" and enter "https://example.com/login/linkedin/callback"</div>
          <div class="item"><i class="circle outline icon"></i>At the top of the same page, you have your Client ID and Secret ID shown as 'Client Secret' for your Linkedin app</div>
          <div class="item"><i class="circle outline icon"></i>Copy/Paste those IDs to their respective fields in your website / settings / social login / Linkedin</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="github">Github</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a github account (if you don't have one)</div>
          <div class="item"><i class="circle outline icon"></i>Login to your github account</div>
          <div class="item"><i class="circle outline icon"></i>On the profile dropdown menu, select "Settings"</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, select "Developers settings" (the last option in the menu)</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "OAuth Apps" and then "New OAuth App"</div>
          <div class="item"><i class="circle outline icon"></i>Enter a name for yout application and a description</div>
          <div class="item"><i class="circle outline icon"></i>For "Homepage URL" enter your website url</div>
          <div class="item"><i class="circle outline icon"></i>For "Authorization callback URL" enter "https://www.example.com/login/github/callback" (change example.com to your domain name), once finished, click on "Register application"</div>
          <div class="item"><i class="circle outline icon"></i>Click on the application you've just created, you'll see your Client ID and Secret ID, (you can upload a logo for your github application if you want to)</div>
          <div class="item"><i class="circle outline icon"></i>Copy/paste the Client ID and Secret ID to their respective fields in your website (settings / social login / github)</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="vkontacte">VKontacte</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a VK account (if you don't have one)</div>
          <div class="item"><i class="circle outline icon"></i>Login to VK Dev <a href="https://vk.com/dev">here</a></div>
          <div class="item"><i class="circle outline icon"></i>At the top menu, click on "My Apps"</div>
          <div class="item"><i class="circle outline icon"></i>Click on "Create app"</div>
          <div class="item"><i class="circle outline icon"></i>Give your app a title</div>
          <div class="item"><i class="circle outline icon"></i>On "Platform" select "Website"</div>
          <div class="item"><i class="circle outline icon"></i>In "Website address" and "Base domain" entre respectively "https://www.example.com", "example.com" (change example.com to your domain name)</div>
          <div class="item"><i class="circle outline icon"></i>Thereafter, click on "Connect website"</div>
          <div class="item"><i class="circle outline icon"></i>In "Terms and Conditions" enter the url to your website terms and conditions page</div>
          <div class="item"><i class="circle outline icon"></i>In "Privacy Policy" enter the url to your website privacy policy page</div>
          <div class="item"><i class="circle outline icon"></i>In "Screenshots" Upload an image for your application if you want to</div>
          <div class="item"><i class="circle outline icon"></i>On the left menu, click on "Settings"</div>
          <div class="item"><i class="circle outline icon"></i>Scroll down to "Authorized redirect URI" end enter "https://www.example.com/login/vkontakte/callback" (change example.com to your domain name)</div>
          <div class="item"><i class="circle outline icon"></i>In "Website focus" select your website activity</div>
          <div class="item"><i class="circle outline icon"></i>The "App ID" at the top serves as "Client ID" and "Secure key" as "Secret ID" for your VKontacte login settings</div>
          <div class="item"><i class="circle outline icon"></i>That's it, don't forget to enable it and save the changes.</div>
        </div>

        <div class="ui hidden divider"></div>

        <div class="header" id="facebook">Facebook</div>
        <div class="list">
          <div class="item"><i class="circle outline icon"></i>Create a Facebook account (if you don't have one)</div>
          <div class="item"><i class="circle outline icon"></i>Login to Facebook Developers <a href="https://developers.facebook.com/">Here</a></div>
          <div class="item"><i class="circle outline icon"></i>From "My Apps" dropdown menu, select "Create App"</div>
          <div class="item"><i class="circle outline icon"></i>Give a name to your App and a contact email and then click on "Create App ID"</div>
          <div class="item"><i class="circle outline icon"></i>In "Add a Product" click on "Set up" for "Facebook Login" product</div>
          <div class="item"><i class="circle outline icon"></i>In the left menu, under "Facebook Login" click on "Settings"</div>
          <div class="item"><i class="circle outline icon"></i>In "Valid OAuth Redirect URIs" put "https://example.com/login/facebook/callback" (change example.com to your domain name)</div>
          <div class="item"><i class="circle outline icon"></i>In the left menu, click on "Settings" and then "Basic"</div>
          <div class="item"><i class="circle outline icon"></i>In "App Domains" enter your domain name with and without www. (without https)</div>
          <div class="item"><i class="circle outline icon"></i>In "Privacy Policy URL" enter the url to your website privacy policy page</div>
          <div class="item"><i class="circle outline icon"></i>In "Terms of Service URL" enter the url to your website terms and conditions page</div>
          <div class="item"><i class="circle outline icon"></i>In "Category" select which category your website's activity belongs to</div>
          <div class="item"><i class="circle outline icon"></i>The Client ID and Secret ID are at the top of the page (Settings / Basic), copy/paste them to their places in your website / settings / social login / facebook</div>
        </div>
      </div>
    </div>

    <div class="section" id="search-engines-settings">
      <div class="header"><a href="#search-engines-settings">#</a>Search engines</div>
      <div class="subheader">Admin > Settings > Search engines</div>
      <div class="description">
        <p>Index Now API, site verification codes, Analytics codes, JSON+LD</p>

        <div class="list">
          <div class="item">
            <i class="circle icon"></i>
            By default, the website loads the necessary meta tags for SEO, you can enable or disable showing JSON+LD format in addition to meta tags.
          </div>
          <div class="item">
            <i class="circle icon"></i>
            All site codes, from google, yandex, bing ... can be entered in "Site verification" field (paste the full HTML code as given by the search engine)
          </div>
          <div class="item">
            <i class="circle icon"></i>
            All analytics codes, from google, yandex, bing ... can be entered in "Analytics code" field (paste the full HTML code as given by the search engine)
          </div>
          <div class="item">
            <i class="circle icon"></i>
            You can obtain an Index now API key from https://www.bing.com/indexnow#generateApiKey
          </div>
        </div>
      </div>
    </div>

    <div class="section" id="chat-settings">
      <div class="header"><a href="#chat-settings">#</a>Chat</div>
      <div class="subheader">Admin > Settings > Chat</div>
      <div class="description">
        <p>Chat services like Tawk, Crisp, Getgist ... etc.</p>

        <div class="list">
          <div class="item">
            <i class="circle icon"></i>
            Copy the code provided by the chat service to your website Admin / Settings / Chat / "Chat service" field and enable it
          </div>
        </div>
      </div>
    </div>

    <div class="section" id="captcha-settings">
      <div class="header"><a href="#captcha-settings">#</a>Captcha</div>
      <div class="subheader">Admin > Settings > Captcha</div>
      <div class="description">
        <p>Google reCaptcha and Mewebstudio captcha.</p>

        <div class="header">Google reCaptcha</div>
        <div class="list">
          <div class="item"><i class="circle icon"></i>Connect to Google reCaptcha with one of your google accounts</div>
          <div class="item"><i class="circle icon"></i>Enter a label</div>
          <div class="item"><i class="circle icon"></i>Select reCAPTCHA v2 and then "I'm not a robot" Checkbox</div>
          <div class="item"><i class="circle icon"></i>Accept the reCAPTCHA Terms of Service</div>
          <div class="item"><i class="circle icon"></i>Click on Submit</div>
          <div class="item"><i class="circle icon"></i>Copy/Paste the site and secret keys to your website > admin > settigns > catpcha > google recatpcha</div>
        </div>
      </div>
    </div>

    <div class="section" id="translations-settings">
      <div class="header"><a href="#translations-settings">#</a>Translations</div>
      <div class="subheader">Admin > Settings > Translations</div>
      <div class="description">
        <p>Add more language translations to your website</p>

        <div class="list">
          <div class="item"><i class="circle icon"></i>Select a language</div>
          <div class="item"><i class="circle icon"></i>Translate the value on the left side to your language on the right side without changing or translating the red parameters.</div>
          <div class="item"><i class="circle icon"></i>If a text is missing, you can add it from the form at the bottom of the page.</div>
          <div class="item"><i class="circle icon"></i>Once you finish the translation for all the texts, save the changes</div>
          <div class="item"><i class="circle icon"></i>Open Settings >> General and add the newly translated language to your website supported languages. It's also possible to have only one language.</div>
        </div>
      </div>
    </div>

    <div class="section" id="database-settings">
      <div class="header"><a href="#database-settings">#</a>Database</div>
      <div class="subheader">Admin > Settings > Database</div>
      <div class="description">
        <p>Adjusting the database configuration</p>

        <p><strong>Important :</strong> Generally, you won't need to change anything in this page, except the timezone or running some database queries for testing.</p>

        <div class="list">
          <div class="item"><i class="circle icon"></i>To execute a database query: you need to specify the query type first, whether it'll be executed to update, delete, insert, select some records or it's for something else (statement)</div>
        </div>
      </div>
    </div>

    <div class="section" id="cache-settings">
      <div class="header"><a href="#cache-settings">#</a>Cache</div>
      <div class="subheader">Admin > Settings > Cache</div>
      <div class="description">
        <p>Clearing cached template files, tokens, user sessions and other cached data.</p>

        <div class="list">
          <div class="item"><i class="circle icon"></i>You will probably need to clear the views cache if you're editing template files</div>
          <div class="item"><i class="circle icon"></i>You may need to clear the cached tokens to regenerate them for some payment gateways and file storage services</div>
        </div>
      </div>
    </div>

    <div class="section" id="maintenance-settings">
      <div class="header"><a href="#maintenance-settings">#</a>Maintenance</div>
      <div class="subheader">Admin > Settings > Maintenance</div>
      <div class="description">
        <p>Enable / Disable maintenance with IP acception, expiration time.</p>

        <div class="list">
          <div class="item"><i class="circle icon"></i>in "IP address to exempt", you can enter your IP address to keep having access to your website for a customization or debugging.</div>
          <div class="item"><i class="circle icon"></i>You can enable "Auto disable" option to turn off maintnance mode automatically once the expiration time is reached</div>
        </div>
      </div>
    </div>

    <div class="section" id="maintenance-settings">
      <div class="header"><a href="#maintenance-settings">#</a>Maintenance</div>
      <div class="subheader">Admin > Settings > Maintenance</div>
      <div class="description">
        <p>Enable / Disable maintenance with IP acception, expiration time.</p>

        <div class="list">
          <div class="item"><i class="circle icon"></i>in "IP address to exempt", you can enter your IP address to keep having access to your website for a customization or debugging.</div>
          <div class="item"><i class="circle icon"></i>You can enable "Auto disable" option to turn off maintnance mode automatically once the expiration time is reached</div>
        </div>
      </div>
    </div>

    <div class="section" id="bulk-upload-settings">
      <div class="header"><a href="#bulk-upload-settings">#</a>Bulk upload</div>
      <div class="subheader">Admin > Settings > Bulk upload</div>
      <div class="description">
        <p>Upload products in bulk.</p>
        <p><strong>Important :</strong> We recommend testing bulk upload locally first if you intend updating an existing website which already have products.</p>
        <div class="list">
          <div class="item"><i class="circle icon"></i>Click on "CSV data file" and select a CSV file containning your products data</div>
          <div class="item"><i class="circle icon"></i>Click on "Cover" and select all covers of your products (the covers names must be the same as the one stored in the CSV file)</div>
          <div class="item"><i class="circle icon"></i>The main files are optional, if available, proceed the same way as with covers</div>
          <div class="item"><i class="circle icon"></i>Once the CSV data file is selected, the dropdown lists will have titles found in the CSV data file</div>
          <div class="item"><i class="circle icon"></i>Attach each column/header on your CSV to the appropriate column in vAlexa script (example, if you have a column named "Summary" in your csv, this column is named "Short description" in our script, if you have a column named "Description" the script has this column named  "Overview" ... etc), so you select "summary" for "short description" and "description" for "overview" ... etc.</div>
          <div class="item"><i class="circle icon"></i>Once done with the columns adjustments, submit the form.</div>
        </div>
      </div>
    </div>

  </div>
</div>

<div class="map">
  <div class="content">
    <div class="header">On this page</div>
    <div class="items">
      <a href="/doc/configuration#general-settings" class="item">General</a>
      <a href="/doc/configuration#mailer-settings" class="item">Mailer</a>
      <a href="/doc/configuration#payments-settings" class="item">Payments</a>
      <a href="/doc/configuration#file-storage-settings" class="item">File Storage</a>
      <a href="/doc/configuration#affiliate-settings" class="item">Affiliate</a>
      <a href="/doc/configuration#social-login-settings" class="item">Social login</a>
      <a href="/doc/configuration#search-engines-settings" class="item">Search engines</a>
      <a href="/doc/configuration#chat-service-settings" class="item">Chat service</a>
      <a href="/doc/configuration#translation-settings" class="item">Translation</a>
      <a href="/doc/configuration#database-settings" class="item">Database</a>
      <a href="/doc/configuration#cache-settings" class="item">Cache</a>
      <a href="/doc/configuration#maintenance-settings" class="item">Maintenance</a>
      <a href="/doc/configuration#bulk-upload-settings" class="item">Bulk upload</a>
    </div>
  </div>
</div>
@endsection