@extends("doc.master")

@section("page")
<div class="content" id="getting-started">
  <div class="header">
    <div class="main">Getting started</div>
    <div class="sub">
      vAlexa is a multi-lang and multi-currency single vendor php script for selling digital products and digital downloads. With valexa script, you can sell audios, videos, ebooks, graphics, scripts, images and much more.
    </div>
  </div>

  <div class="sections">
    <div class="section" id="description">
      <div class="header"><a href="">#</a>Overview</div>
      <div class="description">
        <p>vAlexa PHP script can be used to sell digital products like ebooks, html templates, scripts, graphics, fonts, audios, videos, CD keys, premium accounts, premium content ... etc.</p>
        <p>It supports many payment gateways, PayPal, Stripe, RazorPay, YoucanPay, Coingate, Instamojo, offline payment and much more.</p>
      </div>
    </div>

    <div class="section" id="requirements">
      <div class="header"><a href="">#</a>Requirements</div>
        <div class="description">
          <div class="list">
            <div class="item"><i class="circle outline icon"></i>PHP >= 8.0</div>
            <div class="item"><i class="circle outline icon"></i>Mysql >= 8.0</div>
            <div class="item"><i class="circle outline icon"></i>OpenSSL</div>
            <div class="item"><i class="circle outline icon"></i>BCMath PHP Extension</div>
            <div class="item"><i class="circle outline icon"></i>MySQLi</div>
            <div class="item"><i class="circle outline icon"></i>PDO</div>
            <div class="item"><i class="circle outline icon"></i>Mbstring</div>
            <div class="item"><i class="circle outline icon"></i>Tokenizer</div>
            <div class="item"><i class="circle outline icon"></i>XML</div>
            <div class="item"><i class="circle outline icon"></i>Ctype</div>
            <div class="item"><i class="circle outline icon"></i>JSON</div>
            <div class="item"><i class="circle outline icon"></i>Intl</div>
            <div class="item"><i class="circle outline icon"></i>cURL</div>
            <div class="item"><i class="circle outline icon"></i>Fileinfo</div>
            <div class="item"><i class="circle outline icon"></i>PCRE PHP Extension</div>
          </div>
        </div>
    </div>

    <div class="section" id="payment-gateways">
      <div class="header"><a href="">#</a>Supported payment gateways</div>
      <div class="description">
        <div class="list-btns">
          <div class="item">SslCommerz</div>
          <div class="item">Stripe</div>
          <div class="item">SpankPay</div>
          <div class="item">Skrill</div>
          <div class="item">RazorPay</div>
          <div class="item">PayStack</div>
          <div class="item">PayPal</div>
          <div class="item">PaymentWall</div>
          <div class="item">Payhere</div>
          <div class="item">Omise</div>
          <div class="item">Midtrans</div>
          <div class="item">Iyzico</div>
          <div class="item">Instamojo</div>
          <div class="item">Flutterave</div>
          <div class="item">Coingate</div>
          <div class="item">Authorize Net</div>
          <div class="item">Adyen</div>
          <div class="item">YoucanPay</div>
          <div class="item">Offline Payment</div>
          <div class="item">E-Wallet</div>
        </div>
      </div>
    </div>

    <div class="section" id="file-storage-services">
      <div class="header"><a href="">#</a>Supported file storage services</div>
      <div class="description">
        <div class="list-btns">
          <div class="item">Amazon S3</div>
          <div class="item">Wasabi</div>
          <div class="item">Google Cloud Storage</div>
          <div class="item">Yandex Disk</div>
          <div class="item">Dropbox</div>
          <div class="item">Google Drive</div>
          <div class="item">Local server</div>
        </div>
      </div>
    </div>

    <div class="section" id="installation">
      <div class="header"><a href="">#</a>Installation</div>
      <div class="description">
        <div class="list">
          <div class="item">
            <i class="circle outline icon"></i>
            Upload and extract the zip file to your server > domain name directory
          </div>
          <div class="item">
            <i class="circle outline icon"></i>
            Change the document root for your domain name to make it pointing to the public folder of the script (example.com/public)
          </div>
          <div class="item">
            <i class="circle outline icon"></i>
            Open your website from the address bar, you'll be redirected to the installation page automatically.
          </div>
          <div class="item">
            <i class="circle outline icon"></i>
            Make sure your server meets the requirements before proceeding to the installation
          </div>
          <div class="item">
            <i class="circle outline icon"></i>
            Go through the installation steps and click on "submit" to terminate the installation (Do not forget to enter the [purchase code] or you can enter it later from general setting page)
          </div>
          <div class="item">
            <i class="circle outline icon"></i>
            Go through the installation steps and click on "submit" to terminate the installation
          </div>
        </div>
      </div>
    </div>

    <div class="section" id="support">
      <div class="header"><a href="">#</a>Support</div>
      <div class="description">
        You can contact us via contact@codemayer.net if you need any assistance with the installation.
      </div>
    </div>
  </div>
</div>

<div class="map">
  <div class="content">
    <div class="header">On this page</div>
    <div class="items">
      <a href="#description" class="item">Description</a>
      <a href="#requirements" class="item">Requirements</a>
      <a href="#payment-gateways" class="item">Payment gateways</a>
      <a href="#file-storage-services" class="item">File storage services</a>
      <a href="#installation" class="item">Installation</a>
      <a href="#support" class="item">Support</a>
    </div>
  </div>
</div>
@endsection