@extends("doc.master")

@section("page")
<div class="content" id="pricing-table">
  <div class="header">
    <div class="main">Pricing table</div>
    <div class="sub">
      Create & edit subsription plans, limiting total downloads and per day, attached specifc products to each plan, create subscriptions based on product categories, ... etc.
    </div>
  </div>

  <div class="sections">
    <div class="section" id="create">
      <div class="header"><a href="#create">#</a>Creating pricing table</div>
      <div class="subheader">Admin > Pricing table</div>
      <div class="description">
        <p>Create & edit subsription plans, limiting total downloads and per day, attached specifc products to each plan, create subscriptions based on product categories, ... etc. </p>
      </div>
    </div>

    <div class="section" id="specifcations">
      <div class="header"><a href="#specifcations">#</a>Specifcations</div>
      <div class="description">
        <p>Specifications of subscriptions should be the same for all subscriptions, you can toggle the checkbox to activate/deactivate a spec for a plan</p>
        <p>You can more specifications with the yellow "+" button and to delete a specification, just clear the text and unckeck the circle box.</p>
      </div>
    </div>

    <div class="section" id="duration">
      <div class="header"><a href="#duration">#</a>Duration</div>
      <div class="description">
        <p>All subscriptions durations must be assigned in days and a title to have a user friendly name for the plan (like "30" for the number of days and "Month" or "1 Month" for the title of the plan)</p>
      </div>
    </div>

    <div class="section" id="limit-downloads">
      <div class="header"><a href="#limit-downloads">#</a>Limit downloads</div>
      <div class="description">
        <p>Downloads can be limited in totality, like authorizing subscribers to have 100 downloads for a 30 days (1 month) subscription</p>
        <p>The limit can be reduced to days too, like allowing 5 downloads per day in addition to the total one</p>
        <p>Another option is to limit downloads for the same product during the full subscription time (Downloads of the same item during the subscription)</p>
      </div>
    </div>

    <div class="section" id="products">
      <div class="header"><a href="#products">#</a>Products</div>
      <div class="description">
        <p>You can create subscriptions by products, like making product A, B and C accessible with plan 1 and product D,E F accessible with plan 2 ... etc.</p>
      </div>
    </div>

    <div class="section" id="category-of-products">
      <div class="header"><a href="#category-of-products">#</a>Category of products</div>
      <div class="description">
        <p>Another easier way to create subscription by products is to select a category of products for each plan, this way you won't need to select products one by one for each plan.</p>
      </div>
    </div>

    <div class="section" id="position">
      <div class="header"><a href="#position">#</a>Position</div>
      <div class="description">
        <p>This the order how subscription plans will be shown on the website for users.</p>
      </div>
    </div>

    <div class="section" id="mark-as-popular">
      <div class="header"><a href="#mark-as-popular">#</a>Mark as popular</div>
      <div class="description">
        <p>This add a badge "Popular" to the plan having this option enabled</p>
      </div>
    </div>

    
  </div>
</div>

<div class="map">
  <div class="content">
    <div class="header">On this page</div>
    <div class="items">
      <a href="/doc/pricing_table#create" class="item">Create & Edit</a>
      <a href="/doc/pricing_table#specifications" class="item">Specifications</a>
      <a href="/doc/pricing_table#duration" class="item">Duration</a>
      <a href="/doc/pricing_table#limit-downloads" class="item">Limit downloads</a>
      <a href="/doc/pricing_table#products" class="item">Products</a>
      <a href="/doc/pricing_table#category-of-products" class="item">Category of products</a>
      <a href="/doc/pricing_table#position" class="item">Position</a>
    </div>
  </div>
</div>
@endsection