@extends('front.axies.master')

@section('body')
<div class="p-[1.5rem] flex py-[1rem] gap-[1rem] text-center bg-[#f9f9f9] border-y-[1px] border-y-[#ededed]">
	<div class="single-selection mr-[1rem]">
		<div class="relative group">
			<input type="hidden" name="category" value="{{ request()->category ?? '' }}">
			<div class="default flex items-center gap-[.5rem] font-[600] h-[45px] p-[.5rem_1rem] rounded-[.5rem] bg-[#fff] capitalize">{{ __('Categories') }}</div>
			<div class="absolute hidden pt-[.5rem] left-[0] top-full z-[9] w-full">
				<div class="bg-[#fff] min-w-[250px] overflow-auto rounded-[.75rem] shadow-lg dark:bg-[#39405d]">
					@foreach(config('categories.posts', []) as $post_category)
					<a role="button" href="{{ route('home.blog.category', ['category' => $post_category['slug']]) }}" data-value="{{ $post_category['slug'] }}" class="option px-[1rem] py-[.75rem] block hover:bg-[aliceblue] text-left whitespace-nowrap">{{ $post_category['name'] }}</a>
					@endforeach
					<a role="button" href="{{ route('home.blog') }}" data-value="" class="option px-[1rem] py-[.75rem] block hover:bg-[aliceblue] text-left whitespace-nowrap">{{ __('All') }}</a>
				</div>
			</div>
		</div>
	</div>

	<form method="GET" action="{{ route('home.blog') }}" class="flex items-center justify-center ml-auto rounded-[.5rem] overflow-hidden max-w-[450px] flex-1 border-[1px] border-[#ededed]">
		<input type="search" name="q" value="{{ request()->query('q') }}" class="w-full h-[45px] px-[1rem] border-0 focus:outline-none placeholder-[#cbd5e0]" placeholder="Enter a title or some keywords...">
		<button class="p-[.5rem_1.5rem] h-[45px] bg-[#6f5dff] text-[#fff] flex items-center font-semibold" type="submit">
			{{ __('Search') }}
		</button>
	</form>
</div>

<div class="p-[1.5rem] min-h-[400px]">
	<div class="">
		@if($posts->count())
		<div class="grid grid-cols-4 gap-[1.5rem]">
			@foreach($posts as $post)
			<div class="">
				<a href="{{ route('home.post', ['slug' => $post->slug]) }}" class="flex mb-[1rem]">
					<img src="{{ src("storage/posts/{$post->cover}") }}" class="rounded-[1rem]">
				</a>
				@isset($post->category_slug)
				<a href="{{ route('home.blog.category', ['category' => $post->category_slug]) }}" class="uppercase text-[.8rem] table mb-[1rem] bg-[#fff7bf] font-[600] text-[#4e4715] p-[.35rem_.75rem] pb-[.25rem] rounded-full">{{ fake()->text(15) }}</a>
				@endisset
				<a href="{{ route('home.post', ['slug' => $post->slug]) }}" class="font-[600] mb-[.75rem] block h-[44px] overflow-hidden">{{ $post->name }}</a>
				<div class="opacity-75 text-[.9rem] mb-[.75rem] h-[44px] overflow-hidden">{{ limit($post->short_description, 80) }}</div>
				<div class="flex items-end justify-between gap-[1rem]">
					<div class="">
						{{ $post->created_at->format('j M, Y') }}
					</div>
					<a href="{{ route('home.post', ['slug' => $post->slug]) }}" class="block uppercase p-[.5rem_.5rem] pb-[.35rem] ml-auto border-[1px] rounded-[.5rem] bg-[#6f5dff] text-[#fff] text-[.8rem]">
						<svg xmlns="http://www.w3.org/2000/svg" transform="rotate(90)" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M17 7H9q-.425 0-.712-.288T8 6t.288-.712T9 5h9q.425 0 .713.288T19 6v9q0 .425-.288.713T18 16t-.712-.288T17 15zm-5 5H4q-.425 0-.712-.288T3 11t.288-.712T4 10h9q.425 0 .713.288T14 11v9q0 .425-.288.713T13 21t-.712-.288T12 20z"/></svg>
					</a>
				</div>
			</div>
			@endforeach
		</div>

		@if($posts->hasPages())
		<div class="mt-[3rem]">
		{{ $posts->links('vendor.pagination.tailwind') }}
		</div>
		@endif
		@else
		{{ __('0 Results found') }}
		@endif
	</div>
</div>
@endsection