@extends('front.axies.master')

@section('head_tags')
<meta name="robots" content="noindex, nofollow">

<link rel="stylesheet" href="/assets/slick/slick.css">
<link rel="stylesheet" href="/assets/slick/slick-theme.css">

<script src="/assets/slick/slick.min.js"></script>

<script>
	'use strict';

	$(() =>
	{
		$('#payment-methods').slick({
			infinite: false,
			slidesToShow: 1,
			slidesToScroll: 1,
			nextArrow: $('#payment-methods-nav button.next'),
			prevArrow: $('#payment-methods-nav button.prev'),
		})
	})

	const checkoutConfig = @json($checkout_config);
</script>

@if(config("payment_gateways.{$payment_gateway['name']}.assets"))
@foreach(config("payment_gateways.{$payment_gateway['name']}.assets", []) as $asset)
	@if($asset["type"] == "js")
		<script type="text/javascript" charset="utf-8" 
						@if($asset["replace"] ?? null)
						src="{{ str_replace_adv($asset["src"], $asset["replace"]) }}" 
						@else
						src="{{ $asset["src"] }}"
						@endif
		{{ $asset["defer"] ? "defer" : "" }}></script>
	@elseif($asset["type"] == "css")
		<link rel="stylesheet" href="{{ $asset["src"] }}">
	@elseif($asset["type"] == "js_init")
		<script type="text/javascript" charset="utf-8" {{ $asset["defer"] ? "defer" : "" }}>
			"use strict";
			@if($asset["replace"] ?? null)
				{!! str_replace_adv($asset["code"], $asset["replace"]) !!}
			@else
				{!! $asset["code"] !!}
			@endif
		</script>
	@endif
@endforeach
@endif
@endsection


@section('body')
<div class="uppercase p-[1rem_1.5rem] mt-0 border-y-[1px] border-[#fafafa] bg-[linear-gradient(45deg,#fcfcfc,#f9f9f9,#fcfcfc)] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem]">
	<a href="/" class="">{{ __('Home') }}</a>
	<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
	<a href="" class="">{{ __('Checkout') }}</a>
	<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
	<div class="">{{ __('Products') }}</div>
</div>

<div class="p-[1.5rem]">
	<div class="flex max-[850px]:grid max-[850px]:grid-cols-1">
		<div class="flex-1 p-[1.5rem] bg-[#fcfcfc] rounded-l-[.25rem]">
			@if($type === 'items') {{-- items --}}
			<div class="[&>div:not(:last-child)]:mb-[1.5rem]">
				@foreach($cart_items as $cart_item)
				<div class="flex gap-[1rem] justify-between">
					<a href="" class="bg-cover bg-center rounded-[.25rem] w-[110px] h-[110px] min-w-[110px] max-[650px]:hidden" style="background-image: url('{{ $cart_item['cover'] }}');"></a>
					<div class="flex-1 flex items-start gap-[1rem] justify-between">
						<div class="flex-1 flex flex-col h-full">
							<a href="{{ $cart_item['url'] }}" class="block mb-[.5rem] overflow-hidden" title="{{ $cart_item['name'] }}">{{ limit($cart_item['name'], 40) }}</a>
							@isset($cart_item['summary'])
							<div class="mb-[.5rem] text-[.8rem] h-[40px] overflow-hidden opacity-60">{{ limit($cart_item['summary'] ?? '', 120) }}</div>
							@endisset
							<a href="{{ $cart_item['category_url'] }}" class="mt-auto w-fit text-[.7rem] uppercase font-[600] p-[.4rem_.5rem] pb-[.25rem] bg-[#000] text-[#fff] rounded-[.25rem]">
								{{ $cart_item['category_name'] }}
							</a>
						</div>

						<div class="w-[120px] min-w-[120px] flex flex-col h-full">
							<div class="flex items-center gap-[.5rem] justify-end">
								<svg class="cursor-pointer remove-from-cart" data-id="{{ $cart_item['id'] }}" xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" d="M20.5 6h-17m6 5l.5 5m4.5-5l-.5 5"/><path d="M6.5 6h.11a2 2 0 0 0 1.83-1.32l.034-.103l.097-.291c.083-.249.125-.373.18-.479a1.5 1.5 0 0 1 1.094-.788C9.962 3 10.093 3 10.355 3h3.29c.262 0 .393 0 .51.019a1.5 1.5 0 0 1 1.094.788c.055.106.097.23.18.479l.097.291A2 2 0 0 0 17.5 6"/><path stroke-linecap="round" d="M18.374 15.4c-.177 2.654-.266 3.981-1.131 4.79s-2.195.81-4.856.81h-.774c-2.66 0-3.99 0-4.856-.81c-.865-.809-.953-2.136-1.13-4.79l-.46-6.9m13.666 0l-.2 3"/></g></svg>
								<svg class="cursor-pointer add-to-collection" data-id="{{ $cart_item['id'] }}" xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 24 24"><path fill="currentColor" d="m11 21l-3.175-2.85q-1.8-1.625-3.088-2.9t-2.125-2.4t-1.225-2.175T1 8.475q0-2.35 1.575-3.912T6.5 3q1.3 0 2.475.55T11 5.1q.85-1 2.025-1.55T15.5 3q2.025 0 3.4 1.138T20.775 7H18.65q-.45-1-1.325-1.5T15.5 5q-1.275 0-2.2.688T11.575 7.5h-1.15Q9.65 6.375 8.662 5.688T6.5 5q-1.425 0-2.463.988T3 8.474q0 .825.35 1.675t1.25 1.963t2.45 2.6T11 18.3q.65-.575 1.525-1.325t1.4-1.25l.225.225l.488.488l.487.487l.225.225q-.55.5-1.4 1.238t-1.5 1.312zm7-4v-3h-3v-2h3V9h2v3h3v2h-3v3z"/></svg>
							</div>
							<div class="mt-auto table ml-auto leading-[1] font-[600]">{{ price($cart_item['price']) }}</div>
						</div>
					</div>
				</div>
				@if(!$loop->last)
				<div class="border-b-[1px] border-[#f2f2f4] my-[1.5rem]"></div>
				@endif
				@endforeach
			</div> 
			
			@elseif($type === "subscription") {{-- subscription --}}
			<div class="bg-[#fff] p-[1.5rem] rounded-[.25rem] shadow-[0_0_1px_0_#00000047] relative">
				<div class="bg-[#000] rounded-[.25rem] text-[#fff] p-[.75rem_1rem] pb-[.5rem] text-[.9rem] font-[600] uppercase table">{{ __('Pricing plan') }}</div>

				<div class="h-[1px] my-[1.5rem] w-full border-t-[1px]">&nbsp;</div>

				<div class="pb-[1.5rem]">
					<div class="mb-[.75rem] uppercase font-[600] text-[1.1rem]">{{ $subscription->name }}</div>
					@if($subscription->description)
					<div class="opacity-75">{{ $subscription->description }}</div>
					@endif
				</div>
				<div class="flex items-end gap-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<div class="flex-1 [&>div:not(:last-child)]:mb-[.75rem]">
						@if(strip_tags($subscription->description))
						{!! $subscription->description !!}
						@elseif($subscription->specifications)
						@foreach($subscription->specifications ?? [] as $specification)
					    <div class="flex items-start gap-[.5rem]">
					    	@if($specification->included)
					        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
					            <path fill="#ff9e62" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10s10-4.48 10-10S17.52 2 12 2m0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8"></path>
					            <circle cx="12" cy="12" r="5" fill="#ff9e62"></circle>
					        </svg>
					        @else
					        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
					            <path fill="currentColor" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10s10-4.48 10-10S17.52 2 12 2m0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8"></path>
					        </svg>
					        @endif
					        <div class="flex-1">
					            {{ $specification->text }}
					        </div>
					    </div>
					    @endforeach
					    @endif
					</div>
					<div class="">
						<div class="ml-auto leading-[1] font-[600]">{{ price($subscription->price) }} / {{ __($subscription->title) }}</div>
					</div>
				</div>
			</div>

			@else

			{{-- Prepaid credits --}}
			<div class="bg-[#fff] p-[1.5rem] pt-[1.75rem] rounded-[.25rem] shadow-[0_0_1px_0_#00000047] relative">
				<div class="bg-[#000] rounded-[.25rem] text-[#fff] p-[.75rem_1rem] pb-[.5rem] text-[.9rem] font-[600] uppercase table">{{ __('Prepaid credit') }}</div>

				<div class="h-[1px] my-[1.5rem] w-full border-t-[1px]">&nbsp;</div>
				<div class="pb-[1.5rem]">
					<div class="mb-[.75rem] uppercase font-[600] text-[1.1rem]">{{ $prepaid_credit->name }}</div>
					<div class="opacity-75">{{ $prepaid_credit->label }}</div>
				</div>

				<div class="flex items-end gap-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<div class="flex-1 [&>div:not(:last-child)]:mb-[1rem]">
						@foreach($prepaid_credit->specs as $spec)
						<div class="flex items-center gap-[.75rem] text-[1rem]">
							<div class="w-[30px] h-[30px] p-[.5rem] rounded-[.35rem] border-[1px] border-[#ffe064] bg-[#ffe064]">
								<img src="/assets/images/checkbox-2.webp" class="w-full">
							</div>
							<div class="opacity-75 overflow-hidden">{{ $spec }}</div>
						</div>
						@endforeach
					</div>
				</div>
			</div>
			@endif
		</div>

		<div class="max-w-[380px] max-[850px]:max-w-[100%] overflow-x-hidden w-full p-[2rem_1.5rem] relative bg-[#6356b5] text-[#fff] rounded-r-[.25rem]">
			<div class="relative mb-[2.5rem]">
				<table class="table table-auto w-full capitalize bg-[#00000038] rounded-t-[.25rem] border-b-[.25rem] border-[#deef70]">
					<tbody>
						<tr class="border-b-[1px] border-[#a175cb]">
							<td class="p-[.75rem_1rem] border-r-[1px] border-[#a175cb] font-[600]">{{ __('Initial amount') }}</td>
							<td class="p-[.75rem_1rem] text-right">{{ price($total_amount, 0) }}</td>
						</tr>
						<tr class="border-b-[1px] border-[#a175cb]">
							<td class="p-[.75rem_1rem] border-r-[1px] border-[#a175cb] font-[600]">{{ __('Purchase fee') }}</td>
							<td class="p-[.75rem_1rem] text-right">{{ price($fee, 0) }}</td>
						</tr>
						<tr class="border-b-[1px] border-[#a175cb]">
							<td class="p-[.75rem_1rem] border-r-[1px] border-[#a175cb] font-[600]">{{ __('Discount') }}</td>
							<td class="p-[.75rem_1rem] text-right">{{ ($discount ? '- ' : '') . price($discount, 0) }}</td>
						</tr>
						<tr class="border-b-[1px] border-[#a175cb]">
							<td class="p-[.75rem_1rem] border-r-[1px] border-[#a175cb] font-[600]">{{ __('Tax') }}</td>
							<td class="p-[.75rem_1rem] text-right">{{ price($tax, 0) }}</td>
						</tr>
						<tr>
							<td class="p-[.75rem_1rem] border-r-[1px] border-[#a175cb] font-[600]">{{ __('Due amount') }}</td>
							<td class="p-[.75rem_1rem] text-right">{{ price($due_amount, 0) }}</td>
						</tr>
					</tbody>
				</table>
			</div>

			@if($type !== "prepaid-credits")
			<div class="relative mb-[2.5rem]">
				<div class="mb-[.5rem] text-[1.1rem]">{{ __('Do you have a coupon ?') }}</div>
				<div id="coupon" class="text-[#000] flex items-center bg-[#fff] rounded-[.25rem] overflow-hidden max-w-[400px] w-full relative">
					<input type="text" name="coupon" value="{{ $coupon->code ?? null }}" class="outline-0 bg-transparent h-[50px] px-[.75rem] flex-1 pr-[50px]" placeholder="{{ __('Enter coupon code') }}">
					<button class="h-[50px] w-[50px] absolute right-0 top-0 h-[50px] w-[50px] flex items-center justify-center">
						<svg class="mx-auto" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 15 16"><path fill="#ff9b39" d="M12.49 7.14L3.44 2.27c-.76-.41-1.64.3-1.4 1.13l1.24 4.34q.075.27 0 .54l-1.24 4.34c-.24.83.64 1.54 1.4 1.13l9.05-4.87a.98.98 0 0 0 0-1.72Z"></path></svg>
					</button>
				</div>
			</div>
			@endif

			@if($due_amount > 0)
			<div class="relative">
				<div class="mb-[1rem] flex items-center justify-between">
					<div class="text-[1.1rem]">{{ __('Payment method') }}</div>
					@if(count($payment_processors) >= 2)
					<div id="payment-methods-nav" class="max-w-[80px] grid grid-cols-2 gap-[.75rem]">
						<button class="cursor-pointer prev">
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" d="m7 12l5-5v3h4v4h-4v3zm15 0a10 10 0 0 1-10 10A10 10 0 0 1 2 12A10 10 0 0 1 12 2a10 10 0 0 1 10 10m-2 0a8 8 0 0 0-8-8a8 8 0 0 0-8 8a8 8 0 0 0 8 8a8 8 0 0 0 8-8"/></svg>
						</button>
						<button class="cursor-pointer next">
							<svg xmlns="http://www.w3.org/2000/svg" class="cursor-pointer" transform="scale(-1,1)" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" d="m7 12l5-5v3h4v4h-4v3zm15 0a10 10 0 0 1-10 10A10 10 0 0 1 2 12A10 10 0 0 1 12 2a10 10 0 0 1 10 10m-2 0a8 8 0 0 0-8-8a8 8 0 0 0-8 8a8 8 0 0 0 8 8a8 8 0 0 0 8-8"/></svg>
						</button>
					</div>
					@endif
				</div>
				<div id="payment-methods" class="">
					@foreach($payment_processors as $k => $payment_processor)
						@isset($payment_processor['enabled'])
							@if($type === "prepaid-credits" && $payment_processor['name'] === 'credits')
								@continue;
							@endif
							<div class="">
								<div class="default text-[#fff] relative rounded-t-[.25rem] cursor-pointer bg-[#3a3269] border-b-[.25rem] border-[#deef70] p-[.75rem] [&.selected]:border-[#ff7e00] font-semibold flex items-center min-h-[100px] capitalize method {{ ($payment_gateway && $payment_gateway['name']  === $payment_processor['name']) ? 'selected' : '' }}">
									<input id="gateway-{{ $k }}" name="gateway" value="{{ $payment_processor['name'] }}" type="radio" class="hidden" role="button" {{ ($payment_gateway && $payment_gateway['name']  === $payment_processor['name']) ? 'checked' : '' }}>
									<div class="flex items-center gap-[1rem]">
										<img src="{{ $payment_processor['icon'] }}" class="w-[50px] h-[50px] rounded-full bg-transparent">
										<div class="">
											<div class="uppercase first-letter:text-[#ffb178]">{{ $payment_processor['name'] }}</div>
											<div class="mb-[.75rem] mt-[.5rem] h-[3px] w-[25px] rounded-full bg-[#ff776d]"></div>
											<div class="text-[.9rem]">{{ limit($payment_processor['description'], 60) }}</div>
										</div>
									</div>
								</div>
							</div>
						@endisset
					@endforeach
				</div>
			</div>
			@endif

			@if($payment_gateway || $due_amount <= 0)
			<div class="mb-[2.5rem]"></div>

			<form action="{{ route('home.checkout.payment') }}" method="POST" id="checkout-form" @if(config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons")) class="has-checkout-button" data-checkout-button="{{ config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons.0.id") }}" @endif>
				@csrf

				<input type="hidden" name="checkout_config" value="{{ encrypt(json_encode($checkout_params), false) }}">
				<input type="hidden" name="cart_id" :value="cartUuid">

				@if(config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons"))
					@foreach(config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons", []) as $checkout_button)
						@if($checkout_button["replace"] ?? null)
						{!! str_replace_adv($checkout_button["html"], $checkout_button["replace"]) !!}
						@else
						{!! $checkout_button["html"] !!}
						@endif
					@endforeach
				@endif

				@if(config("payment_gateways.{$payment_gateway['name']}.form.inputs"))
				<div class="grid grid-cols-2 gap-[1rem] mb-[1.5rem]">
					@foreach(config("payment_gateways.{$payment_gateway['name']}.form.inputs", []) as $input_name => $input_config)
					@php
						$input_attrs = implode(' ', $input_config['attributes'] ?? []);

						if($input_config['replace'])
						{
							$input_config['value'] = str_replace_adv($input_config['value'], $input_config['replace']);
						}
					@endphp
					<div class="{{ $input_config['type'] === 'hidden' ? 'hidden' : '' }}">
						<label class="mb-[.5rem] block">{{ __($input_config['label']) }}</label>
						<input {{ $input_attrs }} type="{{ $input_config['type'] }}" name="{{ $input_name }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="..." value="{{ $input_config['value'] }}">
					</div>
					@endforeach
				</div>
				@endif

				@if(config('payments.guest_checkout') && !\Auth::check())
				<div class="mb-[1.5rem]">
					<div class="text-[1.1rem] uppercase font-[600]">{{ __('Email address') }}</div>
					<input type="email" name="guest_email" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					<small class="flex gap-[.5rem] mt-[.25rem]">
						<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><g fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M11.958 7.563v6.166"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 17.139h-.009"/><rect width="18.5" height="18.5" x="2.75" y="2.75" stroke-width="1.5" rx="6"/></g></svg>
						{{ __('An email address to receive download links') }}
					</small>
				</div>
				@endif

				@if(config("payment_gateways.{$payment_gateway['name']}.form.note") && request()->query('type') === 'items')
				<div class="mb-[2.5rem] p-[1rem] bg-[whitesmoke] rounded-[.25rem]">
					{!! nl2br(str_replace_adv(config("payment_gateways.{$payment_gateway['name']}.form.note.html"), config("payment_gateways.{$payment_gateway['name']}.form.note.replace"))) !!}
				</div>
				@endif
				
				@if(config('payments.buyer_note') && count($cart_items))
				<div class="mb-[1.5rem]">
					<div class="text-[1.1rem] uppercase font-[600]">{{ __('Notes') }} <sup>({{ __('Optional') }})</sup></div>
					<textarea name="notes" id="checkout_notes" class="focus:outline-0 rounded-[.5rem] w-full p-[1rem] border-[1px] text-[#3d3d3d]"></textarea>
				</div>
				@endif

				@if(config('payments.tos'))
				<div class="flex mb-[1rem] text-[1rem] gap-[.5rem]">
					<input type="checkbox" id="tos" class="w-[18px] h-[18px] appearance-none border-[1px] border-[#fff] rounded-[.25rem] checked:bg-[#3a3269] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.9rem] before:font-semibold" role="button" name="tos">
					<label for="tos">{{ __("I agree to the") }} <a href="" class="font-[600]">{{ __('Terms and conditions') }}</a></label>
				</div>
				@endif

				<button type="submit" class="cursor-pointer table min-w-[150px] text-center p-[.75rem_1rem] pb-[.5rem] bg-[#ffda36] text-[#000] uppercase font-[600] rounded-[.35rem]">{{ __('Checkout') }}</a>
			</form>
			@endif
		</div>
	</div>
</div>
@endsection